/*
 * Decompiled with CFR 0.152.
 */
package noticecast.accesscontrol;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CMVersion
implements Serializable {
    public static final BigInteger DEFAULT_VALUE = new BigInteger("-1");
    private BigInteger m_version = DEFAULT_VALUE;

    public CMVersion() {
    }

    public CMVersion(BigInteger version) {
        this.m_version = version;
    }

    public CMVersion(int version) {
        this.m_version = new BigInteger(String.valueOf(version));
    }

    public int getVersion() {
        return this.m_version.intValue();
    }

    public BigInteger getBigVersion() {
        return this.m_version;
    }

    public boolean isLessThan(CMVersion version) {
        return this.m_version.compareTo(version.getBigVersion()) < 0;
    }

    public boolean equals(Object another) {
        boolean equals = another instanceof CMVersion;
        if (equals) {
            CMVersion theOther = (CMVersion)another;
            equals = theOther.getVersion() == this.getVersion();
        }
        return equals;
    }

    public void setIntoStatement(PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index, this.m_version.intValue());
    }
}

