/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier;

import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import noticecast.datatier.IJDBCListValueGetter;
import noticecast.datatier.IJDBCListValueSetter;
import noticecast.datatier.IJDBCValueGetter;
import noticecast.datatier.IJDBCValueSetter;

public final class JDBCExecute {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection conn, String sqlStr) throws SQLException {
        int rows = -1;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            rows = stmt.executeUpdate(sqlStr);
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)stmt);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeQuery(Connection conn, String sqlStr, IJDBCValueGetter getter) throws SQLException {
        Object result = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                stmt.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
            }
            rs = stmt.executeQuery(sqlStr);
            result = getter.getObject(rs);
        }
        catch (Throwable throwable) {
            SqlResourceCloser.closeResources(rs, (Statement)stmt);
            throw throwable;
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)stmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection conn, String sqlStr, IJDBCValueSetter setter) throws SQLException {
        int rows = -1;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sqlStr);
            if (setter.setValues(ps)) {
                rows = ps.executeUpdate();
            }
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeQuery(Connection conn, String sqlStr, IJDBCValueSetter setter, IJDBCValueGetter getter) throws SQLException {
        Object result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sqlStr);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                ps.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
            }
            if (setter.setValues(ps)) {
                rs = ps.executeQuery();
                result = getter.getObject(rs);
            }
        }
        catch (Throwable throwable) {
            SqlResourceCloser.closeResources(rs, (Statement)ps);
            throw throwable;
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeQuery(Connection conn, String sqlStr, IJDBCListValueSetter setter, IJDBCListValueGetter getter, Object[] values) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sqlStr);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                ps.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
            }
            for (int counter = 0; counter < values.length; ++counter) {
                if (!setter.setValues(ps, values[counter])) continue;
                rs = ps.executeQuery();
                getter.getObject(rs, values[counter]);
                rs.close();
                rs = null;
            }
        }
        finally {
            SqlResourceCloser.closeResources(rs, (Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeQuery(Connection conn, String sqlStr, IJDBCListValueSetter setter, IJDBCListValueGetter getter, Iterator values) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sqlStr);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                ps.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
            }
            Object oneValue = null;
            while (values.hasNext()) {
                oneValue = values.next();
                if (!setter.setValues(ps, oneValue)) continue;
                rs = ps.executeQuery();
                getter.getObject(rs, oneValue);
                rs.close();
                rs = null;
            }
        }
        finally {
            SqlResourceCloser.closeResources(rs, (Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection conn, String sqlStr, IJDBCListValueSetter setter, Collection collection) throws SQLException {
        int rows = -1;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sqlStr);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!setter.setValues(ps, iterator.next())) continue;
                rows = ps.executeUpdate();
            }
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
        return rows;
    }
}

