/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.accesscontrol;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import noticecast.accesscontrol.CMVersion;
import noticecast.datatier.DTException;
import noticecast.datatier.NCObjectNotFoundException;
import noticecast.datatier.accesscontrol.IJDBCDhObjectCat;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.debug.Debug;
import noticecast.exceptions.LogictierException;
import noticecast.exceptions.NCException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.NCObjectTypeException;
import noticecast.logictier.base.INCBaseObject;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.base.NCFeatherWeightImpl;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.NCObjectUpdateImpl;

public final class JDBCDhObjectCatImpl
implements IJDBCDhObjectCat {
    public static final String T_OBJECTCAT = "NC_OBJECTCATALOGUE ";
    public static final String C_OBJECT_ID = "PK_OID";
    private static final String C_NAME = "NAME";
    private static final String C_DESCRIPTION = "DESCRIPTION";
    private static final String C_TYPE = "TYPE";
    private static final String C_SUBTYPE = "SUBTYPE";
    private static final String C_MODCOUNT = "MODCOUNT";
    private static final String C_CM_VERSION = "CM_VERSION";
    private static final String K_SELECT = "SELECT ";
    private static final String K_FROM = " FROM ";
    private static final String K_WHERE = " WHERE ";
    private static final String K_INSERT = "INSERT INTO ";
    private static final String K_VALUES = "VALUES (";
    private static final String K_UPDATE = "UPDATE ";
    private static final String K_SET = " SET ";
    private static final String K_DELETE = "DELETE FROM ";
    private static final String K_LIKE = " LIKE ";
    private static final String K_AND = " AND ";
    private final transient String m_getObjectListSql = "SELECT PK_OID,NAME,DESCRIPTION,TYPE FROM NC_OBJECTCATALOGUE  WHERE (TYPE = ? OR SUBTYPE = ?) AND NAME = ?";

    @Override
    public int store(Connection conn, INCObjectUpdate objUpdate, Principal user) throws DTException {
        int stamp;
        String sql = "UPDATE NC_OBJECTCATALOGUE  SET NAME =  ?, DESCRIPTION =  ?, CM_VERSION =  ? WHERE PK_OID = ?";
        int rowsAffected = -1;
        PreparedStatement ps = null;
        NCObjectId object_id = null;
        try {
            ps = conn.prepareStatement(sql);
            INCBaseObject object = objUpdate.getObject();
            object_id = object.getNCObjectId();
            if (object_id == null) {
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{"null", T_OBJECTCAT});
            }
            String s_name = object.getName();
            String s_desc = object.getDescription();
            ps.setString(1, s_name);
            ps.setString(2, s_desc);
            object.getCMVersion().setIntoStatement(ps, 3);
            NCObjectIdUtil.instance().setIntoStatement(object_id, 4, ps);
            stamp = objUpdate.getStamp();
            rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{objUpdate.getObjectType().toString(), T_OBJECTCAT});
                throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{objUpdate.getObjectType(), T_OBJECTCAT});
            }
        }
        catch (SQLException sqle) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.UNKNOWN.toString(), T_OBJECTCAT});
            throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.UNKNOWN, T_OBJECTCAT});
        }
        finally {
            this.closeSQLResources(ps, null, null);
        }
        return stamp++;
    }

    @Override
    public int incrementCognosStampByOid(Connection conn, NCObjectId oid, int stamp) throws NCObjectNotFoundException {
        String sql = "UPDATE NC_OBJECTCATALOGUE  SET MODCOUNT = MODCOUNT + 1  WHERE (PK_OID= ? AND MODCOUNT= ?)";
        PreparedStatement ps = null;
        int rowsAffected = -1;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            ps.setInt(2, stamp);
            rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw new NCObjectNotFoundException("NCObjectId", NCObjectIdUtil.instance().getSqlString(oid), null);
            }
        }
        catch (SQLException sqle) {
            throw new NCObjectNotFoundException("NCObjectId", NCObjectIdUtil.instance().getSqlString(oid), null);
        }
        finally {
            this.closeSQLResources(ps, null, null);
        }
        return ++stamp;
    }

    @Override
    public void storeNew(Connection conn, INCBaseObjectConsumer object, NCObjectType type, NCObjectType subType, Principal user) throws DTException {
        PreparedStatement ps = null;
        String sql = "INSERT INTO NC_OBJECTCATALOGUE (PK_OID, NAME, DESCRIPTION, TYPE, SUBTYPE, MODCOUNT,CM_VERSION) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try {
            ps = conn.prepareStatement(sql);
            NCObjectId object_id = object.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(object_id, 1, ps);
            String s_name = object.getName();
            ps.setString(2, s_name);
            String s_desc = object.getDescription();
            ps.setString(3, s_desc);
            NCObjectType.setValue(ps, 4, type);
            NCObjectType.setValue(ps, 5, subType);
            ps.setInt(6, 1);
            object.getCMVersion().setIntoStatement(ps, 7);
            int modifiedRows = ps.executeUpdate();
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(Integer.toString(modifiedRows) + " rows are inserted into object catalog");
        }
        catch (SQLException sqle) {
            throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{type, T_OBJECTCAT});
        }
        finally {
            this.closeSQLResources(ps, null, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public INCObjectUpdate findByOid(Connection conn, NCObjectId oid) throws DTException {
        Object obj_upd = null;
        String sql = "SELECT PK_OID,NAME,DESCRIPTION,TYPE,MODCOUNT,CM_VERSION FROM NC_OBJECTCATALOGUE  WHERE PK_OID =?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        INCFeatherWeight feather = null;
        NCObjectUpdateImpl upd_obj = null;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                feather = this.makeFeatherweight(rs);
                NCObjectType obj_type = feather.getNCObjectType();
                int modcount = rs.getInt(C_MODCOUNT);
                upd_obj = new NCObjectUpdateImpl((INCBaseObject)((Object)feather), obj_type, modcount);
                this.closeSQLResources(ps, rs, null);
                return upd_obj;
            }
            throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, T_OBJECTCAT});
        }
        catch (SQLException sqle) {
            try {
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid.toString(), T_OBJECTCAT});
                catch (LogictierException lte) {
                    throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid.toString(), T_OBJECTCAT});
                }
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator findByName(Connection conn, String name) throws DTException {
        String sql = "SELECT PK_OID,NAME,DESCRIPTION,TYPE,MODCOUNT,CM_VERSION FROM NC_OBJECTCATALOGUE  WHERE NAME LIKE = ?";
        ArrayList<NCObjectUpdateImpl> object_list = new ArrayList<NCObjectUpdateImpl>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, name);
            rs = ps.executeQuery();
            INCFeatherWeight feather = null;
            NCObjectUpdateImpl upd_obj = null;
            while (true) {
                if (!rs.next()) {
                    this.closeSQLResources(ps, rs, null);
                    return object_list.iterator();
                }
                feather = this.makeFeatherweight(rs);
                NCObjectType obj_type = feather.getNCObjectType();
                int modcount = rs.getInt(C_MODCOUNT);
                upd_obj = new NCObjectUpdateImpl((INCBaseObject)((Object)feather), obj_type, modcount);
                object_list.add(upd_obj);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_BY_NAME_ERROR, new Object[]{name, T_OBJECTCAT});
                catch (LogictierException re) {
                    throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_BY_NAME_ERROR, new Object[]{name, T_OBJECTCAT});
                }
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator findByDescription(Connection conn, String description) throws DTException {
        String sql = "SELECT PK_OID,NAME,DESCRIPTION,TYPE,MODCOUNT,CM_VERSION FROM NC_OBJECTCATALOGUE  WHERE DESCRIPTION LIKE = ?";
        ArrayList<NCObjectUpdateImpl> object_list = new ArrayList<NCObjectUpdateImpl>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, description);
            rs = ps.executeQuery();
            INCFeatherWeight feather = null;
            NCObjectUpdateImpl upd_obj = null;
            while (true) {
                if (!rs.next()) {
                    this.closeSQLResources(ps, rs, null);
                    return object_list.iterator();
                }
                feather = this.makeFeatherweight(rs);
                NCObjectType obj_type = feather.getNCObjectType();
                int modcount = rs.getInt(C_MODCOUNT);
                upd_obj = new NCObjectUpdateImpl((INCBaseObject)((Object)feather), obj_type, modcount);
                object_list.add(upd_obj);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_BY_DESC_ERROR, new Object[]{description, T_OBJECTCAT});
                catch (LogictierException re) {
                    throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_BY_DESC_ERROR, new Object[]{description, T_OBJECTCAT});
                }
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
    }

    @Override
    public INCBaseObjectConsumer findCopyByOid(Connection conn, NCObjectId oid) throws DTException {
        String sql = "SELECT PK_OID,NAME,DESCRIPTION,TYPE,MODCOUNT,CM_VERSION FROM NC_OBJECTCATALOGUE  WHERE PK_OID= ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        INCFeatherWeight feather = null;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            while (rs.next()) {
                feather = this.makeFeatherweight(rs);
            }
            this.closeSQLResources(ps, rs, null);
        }
        catch (SQLException sqle) {
            try {
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, T_OBJECTCAT});
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
        return feather;
    }

    @Override
    public int findCognosStampByOid(Connection conn, NCObjectId oid) throws NCObjectNotFoundException {
        String sql = "SELECT MODCOUNT FROM NC_OBJECTCATALOGUE  WHERE PK_OID= ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        int stamp = -1;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            while (rs.next()) {
                stamp = rs.getInt(C_MODCOUNT);
            }
            this.closeSQLResources(ps, rs, null);
        }
        catch (SQLException sqle) {
            try {
                throw new NCObjectNotFoundException("modCount", NCObjectIdUtil.instance().getSqlString(oid), null);
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
        return stamp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator findCopyByName(Connection conn, String name) throws DTException {
        String sql = "SELECT PK_OID, NAME, DESCRIPTION, TYPE, CM_VERSION FROM NC_OBJECTCATALOGUE   WHERE  NAME  LIKE  =?";
        ArrayList<NCObjectUpdateImpl> object_list = new ArrayList<NCObjectUpdateImpl>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, name);
            rs = ps.executeQuery();
            INCFeatherWeight feather = null;
            NCObjectUpdateImpl upd_obj = null;
            while (true) {
                if (!rs.next()) {
                    this.closeSQLResources(ps, rs, null);
                    return object_list.iterator();
                }
                feather = this.makeFeatherweight(rs);
                NCObjectType obj_type = feather.getNCObjectType();
                int modcount = rs.getInt(C_MODCOUNT);
                upd_obj = new NCObjectUpdateImpl((INCBaseObject)((Object)feather), obj_type, modcount);
                object_list.add(upd_obj);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_BY_NAME_ERROR, new Object[]{name, T_OBJECTCAT});
                catch (LogictierException re) {
                    throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_BY_NAME_ERROR, new Object[]{name, T_OBJECTCAT});
                }
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
    }

    @Override
    public void delete(Connection conn, NCObjectId object_id, Principal user) throws DTException {
        String sql = "DELETE FROM NC_OBJECTCATALOGUE  WHERE PK_OID = ?";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(object_id, 1, ps);
            int rows_deleted = 0;
            rows_deleted = ps.executeUpdate();
            if (rows_deleted < 1) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{object_id.toString(), T_OBJECTCAT});
            }
        }
        catch (SQLException sqle) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{object_id.toString(), T_OBJECTCAT});
            throw new DTException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{object_id, T_OBJECTCAT});
        }
        finally {
            this.closeSQLResources(ps, null, null);
        }
    }

    @Override
    public Iterator getObjectList(Connection conn, NCObjectType obj_type, HelperOption helper_option) throws DTException {
        String sql = this.getObjectListSQLStatement();
        sql = sql + (obj_type.equals(helper_option.getNCObjectType()) ? K_AND + helper_option.getOptionString() : "");
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<INCFeatherWeight> object_list = new ArrayList<INCFeatherWeight>();
        try {
            ps = conn.prepareStatement(sql);
            NCObjectType.setValue(ps, 1, obj_type);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                ps.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
            }
            rs = ps.executeQuery();
            INCFeatherWeight feather = null;
            while (rs.next()) {
                feather = this.makeFeatherweight(rs);
                if (feather == null) continue;
                object_list.add(feather);
            }
            this.closeSQLResources(ps, rs, null);
        }
        catch (SQLException sqle) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, (Object[])new String[]{obj_type.toString(), T_OBJECTCAT});
                throw new DTException(I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, new Object[]{obj_type, T_OBJECTCAT});
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
        return object_list.iterator();
    }

    private String getObjectListSQLStatement() {
        String sql = "SELECT NC_OBJECTCATALOGUE.* FROM NC_OBJECTCATALOGUE WHERE  NC_OBJECTCATALOGUE.TYPE = ? ";
        return sql;
    }

    private INCFeatherWeight makeFeatherweight(ResultSet rs) throws DTException {
        NCFeatherWeightImpl feather = null;
        NCObjectId object_id = null;
        try {
            object_id = NCObjectIdUtil.instance().createObjectId(rs, C_OBJECT_ID);
            String s_name = rs.getString(C_NAME);
            String s_desc = rs.getString(C_DESCRIPTION);
            String s_type = rs.getString(C_TYPE);
            int version = rs.getInt(C_CM_VERSION);
            NCObjectType obj_type = NCObjectType.valueOf(s_type);
            feather = new NCFeatherWeightImpl(obj_type, object_id, s_name, s_desc, new CMVersion(version));
        }
        catch (SQLException sqle) {
            String id = object_id != null ? object_id.toString() : "null";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{id, T_OBJECTCAT});
            throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{id, T_OBJECTCAT});
        }
        catch (NCObjectTypeException ncote) {
            String id = object_id != null ? object_id.toString() : "null";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{id, T_OBJECTCAT});
            throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{id, T_OBJECTCAT});
        }
        catch (NCException nce) {
            String id = object_id != null ? object_id.toString() : "null";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{id, T_OBJECTCAT});
            throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{id, T_OBJECTCAT});
        }
        return feather;
    }

    private void closeSQLResources(Statement ps, ResultSet rs, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
        }
    }

    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(Connection conn, HelperOption option) throws DTException {
        return new INCObjectUpdate[0];
    }

    @Override
    public INCFeatherWeight[] getObjectList(Connection conn, NCObjectType type, String name) throws DTException {
        INCFeatherWeight[] result = new INCFeatherWeight[]{};
        ArrayList<INCFeatherWeight> theList = new ArrayList<INCFeatherWeight>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("SELECT PK_OID,NAME,DESCRIPTION,TYPE FROM NC_OBJECTCATALOGUE  WHERE (TYPE = ? OR SUBTYPE = ?) AND NAME = ?");
            NCObjectType.setValue(ps, 1, type);
            NCObjectType.setValue(ps, 2, type);
            ps.setString(3, name);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                ps.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
            }
            rs = ps.executeQuery();
            INCFeatherWeight oneObj = null;
            while (rs.next()) {
                oneObj = this.makeFeatherweight(rs);
                if (oneObj == null) continue;
                theList.add(oneObj);
            }
            this.closeSQLResources(ps, rs, null);
        }
        catch (SQLException ex) {
            try {
                if (Debug.debug) {
                    ex.printStackTrace(System.err);
                }
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, (Object[])new String[]{type.toString()});
                throw new DTException(I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, new Object[]{type});
            }
            catch (Throwable throwable) {
                this.closeSQLResources(ps, rs, null);
                throw throwable;
            }
        }
        result = theList.toArray(result);
        return result;
    }
}

