/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.base;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import noticecast.datatier.DTException;
import noticecast.datatier.NCObjectNotFoundException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.NCObjectTypeMapping;
import noticecast.logictier.base.INCBaseObjectConsumer;

public final class ObjectTypeHelper {
    private Map m_classesNamesMap = new HashMap(40);
    private Map m_objectTypesMap = new HashMap(40);

    public ObjectTypeHelper() {
        this.populateMaps();
    }

    public NCObjectType getObjectType(INCBaseObjectConsumer ncObject) throws DTException {
        Map namesMap = this.getClassNamesMap();
        Class<?> ncClass = ncObject.getClass();
        String className = ncClass.getName();
        NCObjectType type = null;
        if (namesMap.containsKey(className)) {
            type = (NCObjectType)namesMap.get(className);
        }
        type = this.checkObjectType(type);
        return type;
    }

    public String getRemoteClassName(NCObjectType objectType) {
        String result = null;
        IClassNames classNames = (IClassNames)this.getObjectTypesMap().get(objectType);
        if (classNames != null) {
            result = classNames.getRemoteName();
        }
        return result;
    }

    public String getLocalClassName(NCObjectType objectType) {
        String result = null;
        IClassNames classNames = (IClassNames)this.getObjectTypesMap().get(objectType);
        if (classNames != null) {
            result = classNames.getLocalName();
        }
        return result;
    }

    public NCObjectType[] getObjectTypes(Connection connection, NCObjectId objId) throws NCObjectNotFoundException {
        NCObjectType[] result;
        block13: {
            result = new NCObjectType[]{NCObjectType.UNKNOWN, NCObjectType.UNKNOWN};
            if (objId == null) {
                return result;
            }
            String sqlStr = "SELECT SUBTYPE, TYPE FROM NC_OBJECTCATALOGUE WHERE PK_OID = " + NCObjectIdUtil.instance().getSqlString(objId);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = connection.createStatement();
                stmt.setMaxRows(1);
                rs = stmt.executeQuery(sqlStr);
                if (rs.next()) {
                    result[0] = NCObjectType.valueOf(rs, 1);
                    result[1] = NCObjectType.valueOf(rs, 2);
                    break block13;
                }
                throw new NCObjectNotFoundException(NCObjectType.UNKNOWN.toString(), objId.toString(), null);
            }
            catch (SQLException ex) {
                throw new NCObjectNotFoundException(NCObjectType.UNKNOWN.toString(), objId.toString(), ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
                }
            }
        }
        return result;
    }

    private Map getClassNamesMap() {
        return this.m_classesNamesMap;
    }

    private Map getObjectTypesMap() {
        return this.m_objectTypesMap;
    }

    private void populateMaps() {
        this.m_classesNamesMap.clear();
        this.m_objectTypesMap.clear();
        NCObjectTypeMapping tm = NCObjectTypeMapping.instance();
        NCObjectType[] types = tm.getTypes();
        NCObjectType objectType = null;
        String localName = null;
        String remoteName = null;
        ClassNamesImpl classNames = null;
        for (int counter = 0; counter < types.length; ++counter) {
            objectType = types[counter];
            if (objectType == null) continue;
            localName = tm.getLocalClassName(objectType);
            if (localName != null && localName.length() > 0) {
                this.m_classesNamesMap.put(localName, objectType);
            }
            classNames = new ClassNamesImpl(localName, remoteName);
            this.m_objectTypesMap.put(objectType, classNames);
        }
    }

    private NCObjectType checkObjectType(NCObjectType type) {
        if (type.equals(NCObjectType.YEARLY_SCHEDULE) || type.equals(NCObjectType.MONTHLY_SCHEDULE) || type.equals(NCObjectType.WEEKLY_SCHEDULE) || type.equals(NCObjectType.DAILY_SCHEDULE) || type.equals(NCObjectType.FIXED_INTERVAL_SCHEDULE)) {
            type = NCObjectType.SCHEDULE;
        }
        return type;
    }

    class ClassNamesImpl
    implements IClassNames {
        private String m_localName = null;
        private String m_remoteName = null;

        ClassNamesImpl(String localName, String remoteName) {
            this.m_localName = localName;
            this.m_remoteName = remoteName;
        }

        @Override
        public String getLocalName() {
            return this.m_localName;
        }

        @Override
        public String getRemoteName() {
            return this.m_remoteName;
        }
    }

    static interface IClassNames {
        public String getLocalName();

        public String getRemoteName();
    }
}

