/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.guid;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.SQLParserUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import noticecast.datatier.DTException;
import noticecast.datatier.SQLRepositoryException;
import noticecast.datatier.guid.IJDBCGuid;
import noticecast.datatier.guid.JDBCGuidConnectionException;
import noticecast.datatier.guid.NoNCObjectFoundForGuid;
import noticecast.logictier.NCObjectType;

public class JDBCGuidImpl
implements IJDBCGuid {
    private static final String T_NEWSITEMS_NCOBJECTS = "R_NEWSITEMS_NCOBJECTS";
    private static final String F_FK_NCID = "FK_NCID";
    private static final String F_NID = "NID";
    private static final String F_TYPE = "TYPE";
    private static final String SELECT_CLAUSE = "SELECT NID, FK_NCID, TYPE FROM R_NEWSITEMS_NCOBJECTS";
    private static final String DELETE_BY_GUID = "DELETE FROM R_NEWSITEMS_NCOBJECTS WHERE NID = ?";
    private static final String SELECT_GUID_BY_NCOBJECTID = "SELECT NID FROM R_NEWSITEMS_NCOBJECTS WHERE FK_NCID = ?";
    private static final String SELECT_GUID_BY_NCOBJECTID_AND_NCOBJECTTYPE = "SELECT NID FROM R_NEWSITEMS_NCOBJECTS WHERE FK_NCID = ? AND TYPE = ?";
    private static final String SELECT_NCOBJECTID_BY_GUID = "SELECT FK_NCID FROM R_NEWSITEMS_NCOBJECTS WHERE NID = ?";
    private static final String INSERT_STATEMENT = "INSERT INTO R_NEWSITEMS_NCOBJECTS (NID, FK_NCID, TYPE) VALUES (?,?,?)";

    @Override
    public NCObjectId getNCObjectId(Connection connection, String guid) throws DTException {
        NCObjectId result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(SELECT_NCOBJECTID_BY_GUID);
            ps.setString(1, guid);
            rs = ps.executeQuery();
            if (!rs.next()) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_NO_LINK_ERROR, (Object[])new String[]{guid});
                throw new NoNCObjectFoundForGuid(I18NCode.GUID_NO_LINK_ERROR, new Object[]{guid});
            }
            result = NCObjectIdUtil.instance().createObjectId(rs, 1);
            this.releaseResources(rs, ps);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{guid.toString(), T_NEWSITEMS_NCOBJECTS});
                throw new SQLRepositoryException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{guid, T_NEWSITEMS_NCOBJECTS});
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, ps);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public NCObjectId getNCObjectId(String guid) throws DTException {
        JDBCConnection conn = null;
        NCObjectId id = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            id = this.getNCObjectId((Connection)conn, guid);
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_NEW_LINK);
            throw new JDBCGuidConnectionException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_NEW_LINK);
        }
        finally {
            if (conn != null) {
                try {
                    NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                }
                catch (SQLException sQLException) {}
            }
        }
        return id;
    }

    @Override
    public String getGuid(Connection connection, NCObjectId ncId) throws DTException {
        String guid = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(SELECT_GUID_BY_NCOBJECTID);
            NCObjectIdUtil.instance().setIntoStatement(ncId, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                guid = rs.getString(F_NID);
            }
            this.releaseResources(rs, ps);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_CREATE_ERROR, (Object[])new String[]{ncId.toString()});
                throw new SQLRepositoryException(I18NCode.GUID_CREATE_ERROR, new Object[]{ncId});
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, ps);
                throw throwable;
            }
        }
        return guid;
    }

    @Override
    public String getGuid(Connection connection, NCObjectId ncId, NCObjectType type) throws DTException {
        String guid = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(SELECT_GUID_BY_NCOBJECTID_AND_NCOBJECTTYPE);
            NCObjectIdUtil.instance().setIntoStatement(ncId, 1, ps);
            NCObjectType.setValue(ps, 2, type);
            rs = ps.executeQuery();
            if (rs.next()) {
                guid = rs.getString(F_NID);
            }
            this.releaseResources(rs, ps);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GUID_CREATE_ERROR, (Object[])new String[]{ncId.toString()});
                throw new SQLRepositoryException(I18NCode.GUID_CREATE_ERROR, new Object[]{ncId});
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, ps);
                throw throwable;
            }
        }
        return guid;
    }

    @Override
    public String getGuid(NCObjectId ncId) throws DTException {
        JDBCConnection conn = null;
        String guid = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            guid = this.getGuid((Connection)conn, ncId);
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, (Object[])new String[]{e.getMessage() + ""});
            throw new JDBCGuidConnectionException(I18NCode.GUID_CREATE_ERROR, new Object[]{ncId});
        }
        finally {
            if (conn != null) {
                try {
                    NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                }
                catch (SQLException sQLException) {}
            }
        }
        return guid;
    }

    @Override
    public String getGuid(NCObjectId ncId, NCObjectType type) throws DTException {
        JDBCConnection conn = null;
        String guid = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            guid = this.getGuid((Connection)conn, ncId, type);
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, (Object[])new String[]{e.getMessage() + ""});
            throw new JDBCGuidConnectionException(I18NCode.GUID_CREATE_ERROR, new Object[]{ncId});
        }
        finally {
            if (conn != null) {
                try {
                    NCConnection.instance().getConnectionFactory().releaseConnection(conn);
                }
                catch (SQLException sQLException) {}
            }
        }
        return guid;
    }

    @Override
    public void storeNew(Connection connection, String guid, NCObjectId ncId, NCObjectType type) throws DTException {
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(INSERT_STATEMENT);
            ps.setString(1, guid);
            NCObjectIdUtil.instance().setIntoStatement(ncId, 2, ps);
            NCObjectType.setValue(ps, 3, type);
            int n = ps.executeUpdate();
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK.toString(), T_NEWSITEMS_NCOBJECTS});
            throw new SQLRepositoryException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK, T_NEWSITEMS_NCOBJECTS});
        }
        finally {
            this.releaseResources(null, ps);
        }
    }

    @Override
    public void deleteGuid(Connection connection, String guid) throws DTException {
        int rowCount = 0;
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(DELETE_BY_GUID);
            ps.setString(1, guid);
            rowCount = ps.executeUpdate();
            if (rowCount != 1) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{guid, T_NEWSITEMS_NCOBJECTS});
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{guid, T_NEWSITEMS_NCOBJECTS});
            throw new SQLRepositoryException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{guid, T_NEWSITEMS_NCOBJECTS});
        }
        finally {
            this.releaseResources(null, ps);
        }
    }

    @Override
    public NCObjectId[] getNCObjectIds(Connection connection, String[] guids) throws DTException {
        NCObjectId[] ncObjectIds = new NCObjectId[guids.length];
        boolean quoteStrings = true;
        String[] inClauses = SQLParserUtils.createInClauses((String)F_NID, (String[])guids, (boolean)quoteStrings);
        Statement stmt = null;
        ResultSet rs = null;
        String sqlStatementString = null;
        String guid = null;
        NCObjectId id = null;
        HashMap<String, NCObjectId> guidToNcObjectIdMap = new HashMap<String, NCObjectId>();
        try {
            int i;
            for (i = 0; i < inClauses.length; ++i) {
                sqlStatementString = "SELECT NID, FK_NCID, TYPE FROM R_NEWSITEMS_NCOBJECTS WHERE " + inClauses[i];
                stmt = connection.createStatement();
                rs = stmt.executeQuery(sqlStatementString);
                while (rs.next()) {
                    guid = rs.getString(F_NID);
                    id = NCObjectIdUtil.instance().createObjectId(rs, F_FK_NCID);
                    guidToNcObjectIdMap.put(guid, id);
                }
            }
            for (i = 0; i < guids.length; ++i) {
                ncObjectIds[i] = (NCObjectId)guidToNcObjectIdMap.get(guids[i]);
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, (Object[])new String[]{NCObjectType.TASK.toString(), T_NEWSITEMS_NCOBJECTS});
            throw new SQLRepositoryException(I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, new Object[]{NCObjectType.TASK, T_NEWSITEMS_NCOBJECTS});
        }
        finally {
            this.releaseResources(rs, stmt);
        }
        return ncObjectIds;
    }

    private void releaseResources(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
        }
    }
}

