/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.message;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import noticecast.datatier.DTException;
import noticecast.datatier.MiscUtil;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.message.IJDBCDhJDBCMessageStruct;
import noticecast.datatier.message.MessageRowConstructor;
import noticecast.datatier.message.SortableElement;
import noticecast.debug.Debug;
import noticecast.exceptions.LogictierException;
import noticecast.exceptions.NCException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.NCFeatherWeightImpl;
import noticecast.logictier.message.IMessageLine;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.IRecipientLink;
import noticecast.logictier.message.MessageLineType;
import noticecast.logictier.message.MessageStructImpl;
import noticecast.logictier.message.RecipientLinkImpl;
import noticecast.logictier.message.TextMessageLine;
import noticecast.logictier.message.URLMessageLine;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.IPersistManager;
import noticecast.persist.NCObjectUpdateImpl;
import noticecast.services.IRepositoryServices;
import noticecast.services.RepositoryServicesImpl;

public class JDBCDhJDBCMessageStruct
implements IJDBCDhJDBCMessageStruct {
    private final String t_objcat = "NC_OBJECTCATALOGUE";
    private final String f_objcat_pk_oid = "PK_OID";
    private final String f_objcat_name = "NAME";
    private final String f_objcat_description = "DESCRIPTION";
    private final String f_ncmessageline = "NC_MESSAGELINE";
    private final String f_ncmessagelineelement = "NC_MESSAGELINE_ELEMENT";
    private final String f_ncmessagestruct = "NC_MESSAGESTRUCT";
    private final String f_line_no = "LINE_NO";
    private final String f_line_type = "LINE_TYPE";
    private final String f_fk_messagestructid = "FK_MESSAGESTRUCT_ID";
    private final String f_recipient_adder_id = "ADDED_BY_RECIP_ID";
    private final String f_recipient_date_added = "DATE_ADDED";
    private final String f_element_number = "ELEMENT_NUMBER";
    private final String f_text = "TEXT";
    private final String f_pk_id = "PK_MS_ID";
    private final String f_subject = "SUBJECT";
    private final String f_from = "SOURCE";
    private final String f_contact = "CONTACT";
    private final String f_channel_type = "CHANNEL_TYPE";
    private final String f_modcount = "MODCOUNT";
    private final String f_credential = "CREDENTIAL";
    private final String f_fk_dynamicrecipient_id = "FK_DYNREC_ID";
    private final String f_fk_recipient_id = "FK_RECIPIENT_ID";
    private final String f_avoid_duplication = "AVOID_DUPLICATION";
    private final String f_r_msgstruct_recipient = "R_MSGSTRUCT_RECIPIENT_DELIVINF";
    private final String f_fk_bie_topic = "FK_BIE_TOPIC_ID";
    private final String f_link = ".";
    private String storeold = "UPDATE NC_MESSAGESTRUCT SET  SOURCE = ?, SUBJECT =?, CHANNEL_TYPE =?, CONTACT =?, FK_DYNREC_ID =?, AVOID_DUPLICATION=?, CREDENTIAL=?, MODCOUNT = MODCOUNT+ 1 WHERE PK_MS_ID = ?  AND MODCOUNT=? ";
    private String store_existing = "UPDATE NC_MESSAGESTRUCT SET  SOURCE = ?, SUBJECT =?, CHANNEL_TYPE =?, CONTACT =?, FK_DYNREC_ID =?, AVOID_DUPLICATION=?, CREDENTIAL=? WHERE PK_MS_ID = ? ";
    private String check_exists = "SELECT 1 FROM NC_MESSAGESTRUCT WHERE PK_MS_ID = ? ";
    private String storenew = "INSERT INTO NC_MESSAGESTRUCT (PK_MS_ID,SOURCE,SUBJECT,CHANNEL_TYPE,CONTACT,FK_DYNREC_ID,MODCOUNT,AVOID_DUPLICATION, CREDENTIAL) VALUES (?,?,?,?,?,?,?,?,?)";
    private String store_message_line = "INSERT INTO NC_MESSAGELINE (FK_MESSAGESTRUCT_ID,LINE_NO,LINE_TYPE) VALUES (?,?,?)";
    private String store_message_element = "INSERT INTO NC_MESSAGELINE_ELEMENT (FK_MESSAGESTRUCT_ID,LINE_NO,ELEMENT_NUMBER,TEXT,FK_BIE_TOPIC_ID) VALUES (?,?,?,?,?)";
    private String select_message = "SELECT PK_MS_ID , SOURCE , SUBJECT , CHANNEL_TYPE , CONTACT , FK_DYNREC_ID , MODCOUNT , AVOID_DUPLICATION , CREDENTIAL FROM NC_MESSAGESTRUCT WHERE PK_MS_ID= ?";
    private String load_recipient_links = "SELECT NC_OBJECTCATALOGUE.PK_OID,NC_OBJECTCATALOGUE.NAME, NC_OBJECTCATALOGUE.DESCRIPTION, R_MSGSTRUCT_RECIPIENT_DELIVINF.FK_RECIPIENT_ID, R_MSGSTRUCT_RECIPIENT_DELIVINF.ADDED_BY_RECIP_ID, R_MSGSTRUCT_RECIPIENT_DELIVINF.DATE_ADDED FROM NC_OBJECTCATALOGUE, R_MSGSTRUCT_RECIPIENT_DELIVINF WHERE NC_OBJECTCATALOGUE.PK_OID=R_MSGSTRUCT_RECIPIENT_DELIVINF.FK_RECIPIENT_ID AND FK_MESSAGESTRUCT_ID =?";
    private String store_recipient_links = "INSERT INTO R_MSGSTRUCT_RECIPIENT_DELIVINF (FK_MESSAGESTRUCT_ID,FK_RECIPIENT_ID,ADDED_BY_RECIP_ID,DATE_ADDED) VALUES (?,?,?,?)";
    private String delete_recipient_links = "DELETE FROM R_MSGSTRUCT_RECIPIENT_DELIVINF WHERE FK_MESSAGESTRUCT_ID= ?";
    private String delete_message = "DELETE FROM NC_MESSAGESTRUCT WHERE PK_MS_ID=?";
    private String delete_lines = "DELETE FROM NC_MESSAGELINE WHERE FK_MESSAGESTRUCT_ID= ?";
    private String delete_elements = "DELETE FROM NC_MESSAGELINE_ELEMENT WHERE FK_MESSAGESTRUCT_ID= ?";
    private String line_element_statement = "SELECT NC_MESSAGELINE_ELEMENT.LINE_NO , NC_MESSAGELINE_ELEMENT.FK_MESSAGESTRUCT_ID , NC_MESSAGELINE_ELEMENT.TEXT , NC_MESSAGELINE_ELEMENT.FK_BIE_TOPIC_ID , NC_MESSAGELINE_ELEMENT.ELEMENT_NUMBER , NC_MESSAGELINE.LINE_TYPE FROM NC_MESSAGESTRUCT , NC_MESSAGELINE , NC_MESSAGELINE_ELEMENT WHERE NC_MESSAGELINE_ELEMENT.LINE_NO = NC_MESSAGELINE.LINE_NO AND NC_MESSAGELINE_ELEMENT.FK_MESSAGESTRUCT_ID = NC_MESSAGELINE.FK_MESSAGESTRUCT_ID AND NC_MESSAGESTRUCT.PK_MS_ID = NC_MESSAGELINE.FK_MESSAGESTRUCT_ID AND NC_MESSAGESTRUCT.PK_MS_ID = ?";

    @Override
    public void store(Connection connection, INCObjectUpdate objUpdate, Principal user) throws DTException {
        IMessageStruct message = null;
        PreparedStatement ps = null;
        NCObjectId messageID = null;
        String errMsg = "";
        boolean has_dyn_recipients = true;
        try {
            message = (IMessageStruct)objUpdate.getObject();
            messageID = message.getNCObjectId();
            int modcount = objUpdate.getStamp();
            ps = connection.prepareStatement(this.storeold);
            String from = message.getFrom();
            String subject = message.getSubject();
            int channelTypeIndex = message.getChannelType().getIndex();
            String contact = message.getContact();
            String credential = message.getCredential();
            ps.setString(1, from);
            ps.setString(2, subject);
            ps.setInt(3, channelTypeIndex);
            ps.setString(4, contact);
            NCObjectIdUtil.instance().setIntoStatement(null, 5, ps);
            int useMsgDupe = MiscUtil.getInt(message.isAvoidMessageDuplication());
            ps.setInt(6, useMsgDupe);
            ps.setString(7, credential);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 8, ps);
            ps.setInt(9, modcount);
            int n = ps.executeUpdate();
            this.closeResources(ps, null);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_UPDATING_THE_MSG, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_UPDATING_THE_MSG);
            }
            catch (Throwable throwable) {
                this.closeResources(ps, null);
                throw throwable;
            }
        }
        this.storeStaticRecipientLinks(message, connection);
        this.purgeLinesElements(messageID, connection);
        this.storeMessageLines(message.getMessageLines(), connection, messageID);
    }

    @Override
    public void delete(Connection conn, NCObjectId object_id, Principal user) throws DTException {
        this.purgeLinesElements(object_id, conn);
        this.purgeRecipientLinks(object_id, conn);
        this.purgeMessageStruct(conn, object_id);
    }

    @Override
    public void storeExistingMessageStruct(Connection connection, IMessageStruct message) throws DTException {
        PreparedStatement ps = null;
        NCObjectId messageID = message.getNCObjectId();
        this.storeStaticRecipientLinks(message, connection);
        try {
            ps = connection.prepareStatement(this.store_existing);
            String from = message.getFrom();
            String subject = message.getSubject();
            int channelTypeIndex = message.getChannelType().getIndex();
            String contact = message.getContact();
            String credential = message.getCredential();
            ps.setString(1, from);
            ps.setString(2, subject);
            ps.setInt(3, channelTypeIndex);
            ps.setString(4, contact);
            NCObjectIdUtil.instance().setIntoStatement(null, 5, ps);
            int useMsgDupe = MiscUtil.getInt(message.isAvoidMessageDuplication());
            ps.setInt(6, useMsgDupe);
            ps.setString(7, credential);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 8, ps);
            int n = ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_STORING_EXISTING_MSG_STRUCT, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_STORING_EXISTING_MSG_STRUCT);
        }
        finally {
            this.closeResources(ps, null);
        }
        this.purgeLinesElements(messageID, connection);
        this.storeMessageLines(message.getMessageLines(), connection, messageID);
    }

    @Override
    public boolean checkExistsMessageStruct(Connection connection, IMessageStruct message) throws DTException {
        boolean exists = false;
        String errMsg = "";
        PreparedStatement ps = null;
        ResultSet rs = null;
        NCObjectId messageID = message.getNCObjectId();
        try {
            ps = connection.prepareStatement(this.check_exists);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            boolean bl = exists;
            this.closeResources(ps, rs);
            return bl;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_TO_CHECK_FOR_EXISTING_MSG_STRUCT, (Map)ap);
                throw new DTException(I18NCode.MSG_UNABLE_TO_CHECK_FOR_EXISTING_MSG_STRUCT);
            }
            catch (Throwable throwable) {
                this.closeResources(ps, rs);
                throw throwable;
            }
        }
    }

    @Override
    public void storeNew(Connection connection, INCBaseObjectConsumer object, Principal user) throws DTException {
        IMessageStruct msgstruct = (IMessageStruct)object;
        String errMsg = "";
        PreparedStatement ps = null;
        NCObjectId messageId = null;
        try {
            ps = connection.prepareStatement(this.storenew);
            messageId = object.getNCObjectId();
            String from = msgstruct.getFrom();
            String subject = msgstruct.getSubject();
            int channelTypeIndex = msgstruct.getChannelType().getIndex();
            String contact = msgstruct.getContact();
            String credential = msgstruct.getCredential();
            NCObjectIdUtil.instance().setIntoStatement(messageId, 1, ps);
            ps.setString(2, from);
            ps.setString(3, subject);
            ps.setInt(4, channelTypeIndex);
            ps.setString(5, contact);
            NCObjectIdUtil.instance().setIntoStatement(null, 6, ps);
            ps.setInt(7, 1);
            int useMsgDupe = MiscUtil.getInt(msgstruct.isAvoidMessageDuplication());
            ps.setInt(8, useMsgDupe);
            ps.setString(9, credential);
            ps.executeUpdate();
            if (msgstruct.isStatic()) {
                this.storeStaticRecipientLinks(msgstruct, connection);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_A_NEW_MESSAGE, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_A_NEW_MESSAGE);
        }
        finally {
            this.closeResources(ps, null);
        }
        Vector msglines = msgstruct.getMessageLines();
        this.storeMessageLines(msglines, connection, messageId);
    }

    @Override
    public INCObjectUpdate findByOid(Connection connection, NCObjectId oid, Principal principal) throws DTException {
        return this.loadMessageStruct(oid, connection);
    }

    @Override
    public Iterator findByName(Connection conn, String name) throws DTException {
        return null;
    }

    @Override
    public Iterator findByDescription(Connection conn, String description) throws DTException {
        return null;
    }

    @Override
    public INCBaseObjectConsumer findCopyByOid(Connection connection, NCObjectId oid, Principal principal) throws DTException {
        Object message = null;
        INCObjectUpdate update = this.loadMessageStruct(oid, connection);
        return (IMessageStruct)update.getObject();
    }

    @Override
    public Iterator findCopyByName(Connection conn, String objectName) throws DTException {
        return null;
    }

    public void deleteMessageStruct(Connection connection, NCObjectId id) throws DTException {
        this.delete(connection, id, null);
    }

    private void storeMessageLines(Collection lines, Connection connection, NCObjectId messageID) throws DTException {
        PreparedStatement linePs = null;
        PreparedStatement elementsPs = null;
        String errMsg = "";
        try {
            int row_number = 0;
            Iterator linelist = lines.iterator();
            linePs = connection.prepareStatement(this.store_message_line);
            elementsPs = connection.prepareStatement(this.store_message_element);
            while (linelist.hasNext()) {
                IMessageLine line = (IMessageLine)linelist.next();
                MessageLineType lineType = null;
                if (line instanceof TextMessageLine) {
                    lineType = MessageLineType.TEXT_TYPE;
                } else if (line instanceof URLMessageLine) {
                    lineType = MessageLineType.URL_TYPE;
                }
                this.storeMessageLine(lineType, row_number, messageID, linePs);
                Vector elements = line.getMessageElements();
                this.storeMessageElements(row_number, messageID, elements, elementsPs);
                ++row_number;
            }
            this.closeResources(linePs, null);
            this.closeResources(elementsPs, null);
        }
        catch (SQLException ex) {
            try {
                if (Debug.debug) {
                    ex.printStackTrace(System.err);
                }
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_ATTEMPTING_TO_STORE_MSG_LINES, (Object[])new String[]{messageID.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_ATTEMPTING_TO_STORE_MSG_LINES, new Object[]{messageID});
            }
            catch (Throwable throwable) {
                this.closeResources(linePs, null);
                this.closeResources(elementsPs, null);
                throw throwable;
            }
        }
    }

    private INCObjectUpdate loadMessageStruct(NCObjectId oid, Connection connection) throws DTException {
        IMessageStruct message = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        NCObjectId object_id = null;
        String from = "";
        String subject = "";
        boolean dupeBool = false;
        int channelTypeIndex = -999;
        String contact = "";
        int modcount = -999;
        String credential = "";
        NCObjectId dyn_rec_id = null;
        boolean is_static_rec = false;
        String errMsg = "";
        try {
            ps = connection.prepareStatement(this.select_message);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                object_id = NCObjectIdUtil.instance().createObjectId(rs, "PK_MS_ID");
                from = rs.getString("SOURCE");
                subject = rs.getString("SUBJECT");
                channelTypeIndex = rs.getInt("CHANNEL_TYPE");
                contact = rs.getString("CONTACT");
                dyn_rec_id = NCObjectIdUtil.instance().createObjectId(rs, "FK_DYNREC_ID");
                if (dyn_rec_id == null) {
                    is_static_rec = true;
                }
            } else {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_MESSAGE_STRUCT_NOTFOUND, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_MESSAGE_STRUCT_NOTFOUND, new Object[]{oid});
            }
            modcount = rs.getInt("MODCOUNT");
            int dupe = rs.getInt("AVOID_DUPLICATION");
            dupeBool = MiscUtil.getBoolean(dupe);
            credential = rs.getString("CREDENTIAL");
            this.closeResources(ps, rs);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_RETRIEVING_MSG_STRUCT, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_RETRIEVING_MSG_STRUCT);
            }
            catch (Throwable throwable) {
                this.closeResources(ps, rs);
                throw throwable;
            }
        }
        message = this.buildMessageStruct(connection, object_id, from, subject, contact, channelTypeIndex, dyn_rec_id, is_static_rec, dupeBool, credential);
        NCObjectUpdateImpl update = null;
        try {
            update = new NCObjectUpdateImpl(message, NCObjectType.MESSAGE_STRUCT, modcount);
        }
        catch (LogictierException ex1) {
            throw new DTException(I18NCode.MSG_MESSAGE_STRUCT_NOTFOUND, new Object[]{oid}, ex1);
        }
        return update;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRecipientLink[] getStaticRecipientLinks(NCObjectId messageID, Connection connection) throws DTException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String errMsg = "";
        ArrayList<RecipientLinkImpl> list = new ArrayList<RecipientLinkImpl>();
        try {
            ps = connection.prepareStatement(this.load_recipient_links);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            rs = ps.executeQuery();
            boolean flag = false;
            NCObjectId recipient_id = null;
            NCObjectId adderId = null;
            while (true) {
                if (!rs.next()) {
                    this.closeResources(ps, rs);
                    return list.toArray(new IRecipientLink[0]);
                }
                recipient_id = NCObjectIdUtil.instance().createObjectId(rs, "FK_RECIPIENT_ID");
                adderId = NCObjectIdUtil.instance().createObjectId(rs, "ADDED_BY_RECIP_ID");
                long addedDateLong = rs.getLong("DATE_ADDED");
                Date addedDate = new Date(addedDateLong);
                String name = rs.getString("NAME");
                String desc = rs.getString("DESCRIPTION");
                NCFeatherWeightImpl fw = new NCFeatherWeightImpl(NCObjectType.RECIPIENT, recipient_id, name, desc);
                RecipientLinkImpl link = new RecipientLinkImpl(fw, addedDate, adderId);
                list.add(link);
            }
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_EXCEPTION_WHEN_LOADING_STATIC_RECIPIENTS, (Map)ap);
                throw new DTException(I18NCode.MSG_EXCEPTION_WHEN_LOADING_STATIC_RECIPIENTS);
                catch (NCException ex2) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_EXCEPTION_WHEN_LOADING_STATIC_RECIPIENTS, (Map)ap);
                    throw new DTException(I18NCode.MSG_EXCEPTION_WHEN_LOADING_STATIC_RECIPIENTS, ex2);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(ps, rs);
                throw throwable;
            }
        }
    }

    private void loadStaticRecipientLinks(IMessageStruct message, Connection connection) throws DTException {
        IRecipientLink[] links = this.getStaticRecipientLinks(message.getNCObjectId(), connection);
        for (int i = 0; i < links.length; ++i) {
            message.addRecipientLink(links[i]);
        }
    }

    private Collection loadMessageLines(Connection connection, NCObjectId messageID) throws DTException {
        if (Debug.debug) {
            System.out.println(this.line_element_statement);
        }
        MessageRowConstructor constructor = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean row_count = false;
        String errMsg = "";
        TreeSet<Integer> rows = new TreeSet<Integer>();
        ArrayList<IMessageLine> builtrows = new ArrayList<IMessageLine>();
        try {
            ps = connection.prepareStatement(this.line_element_statement);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            rs = ps.executeQuery();
            constructor = new MessageRowConstructor();
            while (rs.next()) {
                Integer row_number = new Integer(rs.getInt(1));
                rows.add(row_number);
                NCObjectIdUtil.instance().createObjectId(rs, 2);
                String element = JDBCConnectionProperties.instance((String)"SDS").getTokenWriter().readToken(rs, 3);
                NCObjectId bie_topic_id = NCObjectIdUtil.instance().createObjectId(rs, 4);
                Integer element_index = new Integer(rs.getInt(5));
                int lineTypeInt = rs.getInt(6);
                MessageLineType lineType = MessageLineType.getType(lineTypeInt);
                constructor.addElement(lineType, row_number, element_index, element);
            }
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_FAILED_SQL, new Object[]{this.line_element_statement, ex.getMessage()});
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_LOADING_MESSAGE_LINES);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_LOADING_MESSAGE_LINES);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, (Statement)ps);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        int line_no = 0;
        Iterator list = rows.iterator();
        while (list.hasNext()) {
            list.next();
            Integer I_line_no = new Integer(line_no);
            Collection elements = constructor.getSortedElements(I_line_no);
            Iterator elementlist = elements.iterator();
            IMessageLine line = null;
            MessageLineType messageLineType = constructor.getMessageLineType(I_line_no);
            if (messageLineType.equals(MessageLineType.TEXT_TYPE)) {
                line = new TextMessageLine();
            } else if (messageLineType.equals(MessageLineType.URL_TYPE)) {
                line = new URLMessageLine();
            }
            while (elementlist.hasNext()) {
                SortableElement element = (SortableElement)elementlist.next();
                line.addMessageElement(element.getElement());
            }
            builtrows.add(line);
            ++line_no;
        }
        return builtrows;
    }

    private void storeStaticRecipientLinks(IMessageStruct message, Connection connection) throws DTException {
        String errMsg = "";
        this.purgeRecipientLinks(message.getNCObjectId(), connection);
        IRecipientLink[] recipLinks = message.getRecipientLinks();
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(this.store_recipient_links);
            for (int i = 0; i < recipLinks.length; ++i) {
                this.storeRecipientLink(ps, message, recipLinks[i]);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_STATIC_RECIPIENTS, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_STATIC_RECIPIENTS);
        }
        finally {
            this.closeResources(ps, null);
        }
    }

    private void storeRecipientLink(PreparedStatement ps, IMessageStruct message, IRecipientLink recipientLink) throws SQLException {
        NCObjectId messagestructId = message.getNCObjectId();
        NCObjectId recipientId = recipientLink.getRecipientId();
        NCObjectId recipAdderId = recipientLink.getRecipientAdderId();
        long recipientAddDate = recipientLink.getLinkedDate().getTime();
        NCObjectIdUtil.instance().setIntoStatement(messagestructId, 1, ps);
        NCObjectIdUtil.instance().setIntoStatement(recipientId, 2, ps);
        NCObjectIdUtil.instance().setIntoStatement(recipAdderId, 3, ps);
        ps.setLong(4, recipientAddDate);
        int insertedRows = ps.executeUpdate();
    }

    private void storeMessageLine(MessageLineType lineType, int rownumber, NCObjectId messageID, PreparedStatement ps) throws DTException {
        int i = 0;
        try {
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            ps.setInt(2, rownumber);
            ps.setInt(3, lineType.getIndex());
            i = ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_MESSAGE_LINES, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_MESSAGE_LINES);
        }
        if (Debug.checkConstraints && i < 1) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_MESSAGE_STRUCT_LINES_HAVE_NOT_BEEN_STORED, (Map)ap);
            throw new DTException(I18NCode.MSG_MESSAGE_STRUCT_LINES_HAVE_NOT_BEEN_STORED);
        }
    }

    private void storeMessageElements(int rownumber, NCObjectId messageID, Collection elements, PreparedStatement ps) throws DTException {
        Iterator list = elements.iterator();
        int i = 0;
        boolean flag = false;
        NCObjectId bieTopicId = null;
        try {
            while (list.hasNext()) {
                Object element = list.next();
                String text = element.toString();
                this.storeElement(rownumber, ++i, text, bieTopicId, messageID, ps);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_MESSAGE_ELEMENTS, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_STORING_MESSAGE_ELEMENTS);
        }
    }

    private void storeElement(int rownumber, int elementNumber, String text, NCObjectId bieTopicId, NCObjectId messageID, PreparedStatement ps) throws SQLException {
        NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
        ps.setInt(2, rownumber);
        ps.setInt(3, elementNumber);
        if (bieTopicId != null) {
            ps.setNull(4, 12);
            NCObjectIdUtil.instance().setIntoStatement(bieTopicId, 5, ps);
        } else {
            JDBCConnectionProperties.instance((String)"SDS").getTokenWriter().writeToken(ps, 4, text);
            NCObjectIdUtil.instance().setIntoStatement(null, 5, ps);
        }
        int i = ps.executeUpdate();
        if (i < 1) {
            // empty if block
        }
    }

    private void purgeRecipientLinks(NCObjectId messageID, Connection connection) throws DTException {
        String errMsg = "";
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(this.delete_recipient_links);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_PURGING_RECIPIENT_LINKS, (Object[])new String[]{messageID.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_PURGING_RECIPIENT_LINKS);
        }
        finally {
            this.closeResources(ps, null);
        }
    }

    private void purgeMessageStruct(Connection connection, NCObjectId id) throws DTException {
        String errMsg = "";
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(this.delete_message);
            NCObjectIdUtil.instance().setIntoStatement(id, 1, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_PURGING_THE_MESSAGE, (Object[])new String[]{id.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_PURGING_THE_MESSAGE);
        }
        finally {
            this.closeResources(ps, null);
        }
    }

    private void purgeLinesElements(NCObjectId messageID, Connection connection) throws DTException {
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(this.delete_elements);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            ps.executeUpdate();
            ps.close();
            ps = null;
            ps = connection.prepareStatement(this.delete_lines);
            NCObjectIdUtil.instance().setIntoStatement(messageID, 1, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_PURGING_MESSAGE_LINES, (Object[])new String[]{messageID.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_WHEN_PURGING_MESSAGE_LINES);
        }
        finally {
            this.closeResources(ps, null);
        }
    }

    private IPersistManager getPersistManager() {
        IRepositoryServices service = RepositoryServicesImpl.instance();
        return service.getPersistManager();
    }

    private void closeResources(Statement st, ResultSet rs) {
        String errMsg = "";
        try {
            if (null != rs) {
                rs.close();
                rs = null;
            }
            if (null != st) {
                st.close();
                st = null;
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_WHEN_CLOSING_RESOURCES, (Map)ap);
        }
    }

    private IMessageStruct buildMessageStruct(Connection connection, NCObjectId object_id, String from, String subject, String contact, int channelTypeIndex, NCObjectId dynamic_recipient_id, boolean is_static, boolean is_avoid_dupe, String credential) throws DTException {
        MessageStructImpl message = new MessageStructImpl();
        message.setNCObjectId(object_id);
        this.loadStaticRecipientLinks(message, connection);
        message.setStatic(true);
        message.setFrom(from);
        message.setSubject(subject);
        message.setContact(contact);
        ChannelType channelType = ChannelType.get((int)channelTypeIndex);
        message.setChannelType(channelType);
        Collection lines = this.loadMessageLines(connection, object_id);
        Vector vlines = new Vector(lines);
        message.setMessageLines(vlines);
        message.setCredential(credential);
        return message;
    }

    @Override
    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(Connection conn, HelperOption option) throws DTException {
        return new INCObjectUpdate[0];
    }
}

