/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.property;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import noticecast.datatier.property.IJDBCProperties;

public class JDBCPropertiesImpl
implements IJDBCProperties {
    public static final String TABLE_NAME = "NC_CONFIGURATION";
    public static final String PROPERTY_KEY = "PROPERTY_KEY";
    public static final String PROPERTY_VALUE = "PROPERTY_VALUE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties(Connection connection) {
        String selectStatement = "SELECT * FROM NC_CONFIGURATION";
        ResultSet rs = null;
        Statement stmt = null;
        Properties props = new Properties();
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(selectStatement);
            String propertyKey = null;
            String propertyValue = null;
            while (rs.next()) {
                propertyKey = rs.getString(PROPERTY_KEY);
                propertyValue = rs.getString(PROPERTY_VALUE);
                props.put(propertyKey, propertyValue);
            }
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{PROPERTY_KEY, TABLE_NAME}, (Map)ap);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, (Statement)stmt);
                throw throwable;
            }
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)stmt);
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)stmt);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateProperty(Connection connection, String key, String oldValue, String newValue) {
        boolean updated = false;
        String updateStatement = "UPDATE NC_CONFIGURATION SET PROPERTY_KEY = ?, PROPERTY_VALUE = ? WHERE PROPERTY_KEY = ? AND PROPERTY_VALUE = ?";
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(updateStatement);
            ps.setString(1, key);
            ps.setString(2, newValue);
            ps.setString(3, key);
            ps.setString(4, oldValue);
            int i = ps.executeUpdate();
            if (i == 1) {
                updated = true;
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{PROPERTY_KEY, TABLE_NAME}, (Map)ap);
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
        return updated;
    }
}

