/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.recipient;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import noticecast.datatier.DTException;
import noticecast.datatier.recipient.IJDBCDhDeliveryAddress;
import noticecast.datatier.recipient.address.AddressFactoryImpl;
import noticecast.datatier.recipient.address.IAddressHandler;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.recipient.DeliveryAddressType;
import noticecast.logictier.recipient.IDeliveryAddress;
import noticecast.logictier.recipient.IRecipient;
import noticecast.services.NCPackage;

public class JDBCDhDeliveryAddressImpl
implements IJDBCDhDeliveryAddress {
    public static final String JT_DELIVERY_ADDRESS = "NC_DELIVERYADDRESS";
    public static final String JTDIF_PK_OID = "PK_DELADDRESS_ID";
    public static final String JTDIF_CHANNEL_TYPE = "CHANNEL_TYPE";
    public static final String JTDIF_FK_RECIPIENT = "FK_RECIPIENT_ID";
    public static final String JTDIF_DELIVERY_ADDRESS = "DELIVERY_ADDRESS";
    public static final String JTDIF_ISDEFAULT = "IS_DEFAULT";
    public static final String JTDIF_ADDRESS_TYPE = "ADDRESS_TYPE";
    private String JT_RECIPIENT_SCHEDULE = "NC_RECIPIENTSCHEDULE";
    private String JTDIF_SCHEDULE_ID = "PK_SCHEDULE_ID";
    private String JTDIF_FK_DELADDRESS = "FK_DELADDRESS_ID";
    private String sqlAllAddressesStmt = "SELECT PK_DELADDRESS_ID, DELIVERY_ADDRESS, CHANNEL_TYPE, IS_DEFAULT, FK_RECIPIENT_ID, ADDRESS_TYPE FROM NC_DELIVERYADDRESS WHERE FK_RECIPIENT_ID = ?";
    private String sqlScheduleAddressesStmt = "SELECT PK_DELADDRESS_ID, DELIVERY_ADDRESS, CHANNEL_TYPE, IS_DEFAULT, NC_DELIVERYADDRESS.FK_RECIPIENT_ID, ADDRESS_TYPE FROM NC_DELIVERYADDRESS , " + this.JT_RECIPIENT_SCHEDULE + " WHERE " + this.JT_RECIPIENT_SCHEDULE + "." + "FK_RECIPIENT_ID" + " = ?" + " AND " + this.JT_RECIPIENT_SCHEDULE + "." + this.JTDIF_SCHEDULE_ID + " = ? " + " AND " + "NC_DELIVERYADDRESS" + "." + "PK_DELADDRESS_ID" + " = " + this.JT_RECIPIENT_SCHEDULE + "." + this.JTDIF_FK_DELADDRESS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDeliveryAddress[] retrieveDeliveryAddresses(Connection conn, IRecipient recipient, NCObjectId scheduleId, Principal principal) throws SQLException, DTException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sqlStmt = scheduleId == null ? this.sqlAllAddressesStmt : this.sqlScheduleAddressesStmt;
            ps = conn.prepareStatement(sqlStmt);
            NCObjectIdUtil.instance().setIntoStatement(recipient.getNCObjectId(), 1, ps);
            if (scheduleId != null) {
                NCObjectIdUtil.instance().setIntoStatement(scheduleId, 2, ps);
            }
            rs = ps.executeQuery();
            IDeliveryAddress[] iDeliveryAddressArray = this.recreateDeliveryAddresses(rs, principal);
            this.closeResources(rs, ps);
            return iDeliveryAddressArray;
        }
        catch (Throwable throwable) {
            this.closeResources(rs, ps);
            throw throwable;
        }
    }

    private IDeliveryAddress[] checkAddressType(IDeliveryAddress[] new_addresses, String old_accman) {
        IDeliveryAddress new_accman = null;
        Hashtable<String, IDeliveryAddress> nc_table = new Hashtable<String, IDeliveryAddress>();
        for (int i = 0; i < new_addresses.length; ++i) {
            if (new_addresses[i].getType().isEqualTo(DeliveryAddressType.ACCMAN)) {
                new_accman = new_addresses[i];
                continue;
            }
            nc_table.put(new_addresses[i].getAddress(), new_addresses[i]);
        }
        if (new_accman != null) {
            if (!new_accman.getAddress().equals(old_accman) && nc_table.containsKey(new_accman.getAddress())) {
                new_accman.setType(DeliveryAddressType.NOTICECAST);
                IDeliveryAddress temp = (IDeliveryAddress)nc_table.get(new_accman.getAddress());
                new_accman.setAddress(old_accman);
                new_accman.setName(old_accman);
                temp.setType(DeliveryAddressType.ACCMAN);
                nc_table.remove(new_accman.getAddress());
                nc_table.put(temp.getAddress(), temp);
            } else if (new_accman.getAddress().equals(old_accman) && nc_table.containsKey(new_accman.getAddress())) {
                nc_table.remove(new_accman.getAddress());
            }
        }
        ArrayList list = new ArrayList(nc_table.values());
        if (new_accman != null) {
            list.add(new_accman);
        }
        return list.toArray(new IDeliveryAddress[list.size()]);
    }

    private IDeliveryAddress[] recreateDeliveryAddresses(ResultSet rs, Principal principal) {
        IDeliveryAddress[] addresses;
        IAddressHandler handler = null;
        int type_index = -1;
        DeliveryAddressType type = null;
        Vector<IDeliveryAddress> all_addresses = new Vector<IDeliveryAddress>();
        String old_accman_address = "";
        try {
            while (rs.next()) {
                type_index = rs.getInt(JTDIF_ADDRESS_TYPE);
                type = DeliveryAddressType.get(type_index);
                handler = AddressFactoryImpl.getInstance().create(type, principal);
                if (type.isEqualTo(DeliveryAddressType.ACCMAN)) {
                    old_accman_address = rs.getString(JTDIF_DELIVERY_ADDRESS);
                }
                if (handler == null) continue;
                addresses = handler.getAddresses(rs);
                for (int i = 0; i < addresses.length; ++i) {
                    all_addresses.add(addresses[i]);
                }
                type_index = -1;
                handler = null;
            }
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(NCPackage.DATA_TIER.getLabel() + " SQL Error: Unable to rebuild a recipient delivery address from the returned Result Set.");
        }
        catch (DTException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)((Object)e));
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(NCPackage.DATA_TIER.getLabel() + " DTException: Unable to rebuild a recipient delivery address from the returned Result Set.");
        }
        addresses = all_addresses.toArray(new IDeliveryAddress[all_addresses.size()]);
        addresses = this.checkAddressType(addresses, old_accman_address);
        return addresses;
    }

    @Override
    public void storeDeliveryAddresses(Connection conn, IRecipient recipient, Principal principal) throws DTException {
        try {
            this.deleteDeliveryAddresses(conn, recipient.getNCObjectId());
            IDeliveryAddress[] addresses = recipient.getDeliveryAddresses();
            IAddressHandler handler = null;
            for (int i = 0; i < addresses.length; ++i) {
                handler = AddressFactoryImpl.getInstance().create(addresses[i].getType(), principal);
                handler.storeAddress(conn, addresses[i], recipient.getNCObjectId());
            }
        }
        catch (DTException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.PERST_UNABLE_STORE_OBJECT, (Object[])new String[]{NCObjectType.DELIVERY_ADDRESS.toString()});
            throw new DTException(I18NCode.PERST_UNABLE_STORE_OBJECT, new Object[]{NCObjectType.DELIVERY_ADDRESS}, e);
        }
    }

    @Override
    public void deleteDeliveryAddresses(Connection conn, NCObjectId recipient_id) throws DTException {
        String s_recipient_id = recipient_id.toString();
        String sql = "DELETE FROM NC_DELIVERYADDRESS WHERE FK_RECIPIENT_ID = ?";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(recipient_id, 1, ps);
            int n = ps.executeUpdate();
        }
        catch (SQLException sqle) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sqle);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_TO_DELETE_ADDRESSES_FOR_RECIPIENT, new Object[]{s_recipient_id}, (Map)ap);
            throw new DTException(I18NCode.MSG_UNABLE_TO_DELETE_ADDRESSES_FOR_RECIPIENT, new Object[]{s_recipient_id});
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    private void closeResources(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
    }
}

