/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.recipient;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import noticecast.datatier.DTException;
import noticecast.datatier.IJDBCEntityHelper;
import noticecast.datatier.IJDBCValueGetter;
import noticecast.datatier.IJDBCValueSetter;
import noticecast.datatier.IObjectView;
import noticecast.datatier.JDBCExecute;
import noticecast.datatier.SQLRepositoryException;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.recipient.IJDBCDhDeliveryAddress;
import noticecast.datatier.recipient.JDBCDhDeliveryAddressImpl;
import noticecast.exceptions.LogictierException;
import noticecast.exceptions.NCException;
import noticecast.logictier.NCObjectNotFoundException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.base.NCFeatherWeightImpl;
import noticecast.logictier.base.NCNameComparator;
import noticecast.logictier.recipient.IDeliveryAddress;
import noticecast.logictier.recipient.IRecipient;
import noticecast.logictier.recipient.RecipientFeatherWeightImpl;
import noticecast.logictier.recipient.RecipientImpl;
import noticecast.logictier.recipient.RecipientOrigin;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.NCObjectUpdateImpl;

public class JDBCDhRecipientImpl
implements IJDBCEntityHelper,
IObjectView {
    private String JDBC_TABLE = "NC_RECIPIENT";
    private String F_OID = "PK_RECIPIENT_ID";
    private String F_ACID = "ACCMAN_UID";
    private String F_NAME = "NAME";
    private String F_DESCRIPTION = "DESCRIPTION";
    private String F_LASTMOD_BY = "LASTMOD_BY";
    private String F_MODCOUNT = "MODCOUNT";
    private String F_TITLE = "TITLE";
    private String F_FIRSTNAME = "FIRSTNAME";
    private String F_MIDDLENAME = "MIDDLENAME";
    private String F_LASTNAME = "LASTNAME";
    private String F_EMAILID = "EMAIL_ADDRESS";
    private String F_PHONENUMBER = "PHONENUMBER";
    private String F_JOBTITLE = "JOBTITLE";
    private String F_COMPANY = "COMPANY";
    private String F_DEPARTMENT = "DEPARTMENT";
    private String F_OFFICE = "OFFICE";
    private String F_COUNTRY = "COUNTRY";
    private String F_TIMEZONE = "TIMEZONE";
    private String F_TO_REDIRECT = "TO_REDIRECT";
    private String F_FK_REDIRECT_RID = "FK_REDIRECT_RID";
    private String F_IS_EXTERNAL = "IS_EXTERNAL";
    private String F_IS_USEDEFAULT = "IS_USEDEFAULTADDRESS";
    private String SELECT_CLAUSE = "SELECT " + this.F_OID + ", " + this.F_NAME + ", " + this.F_DESCRIPTION + ", " + this.F_TITLE + ", " + this.F_FIRSTNAME + ", " + this.F_MIDDLENAME + ", " + this.F_LASTNAME + ", " + this.F_PHONENUMBER + ", " + this.F_JOBTITLE + ", " + this.F_COMPANY + ", " + this.F_DEPARTMENT + ", " + this.F_OFFICE + ", " + this.F_COUNTRY + ", " + this.F_TIMEZONE + ", " + this.F_TO_REDIRECT + ", " + this.F_FK_REDIRECT_RID + ", " + this.F_IS_EXTERNAL + ", " + this.F_MODCOUNT + ", " + this.F_IS_USEDEFAULT + " FROM " + this.JDBC_TABLE;
    private IJDBCDhDeliveryAddress m_deliveryAddresses = new JDBCDhDeliveryAddressImpl();
    private Comparator m_featherWtComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            INCFeatherWeight left = (INCFeatherWeight)o1;
            INCFeatherWeight right = (INCFeatherWeight)o2;
            return left.getNCObjectId().compareTo(right.getNCObjectId());
        }

        @Override
        public boolean equals(Object obj) {
            return true;
        }
    };

    @Override
    public void store(Connection connection, INCObjectUpdate objUpdate, Principal user) throws DTException {
        IRecipient recipientToBeStored = (IRecipient)objUpdate.getObject();
        int lastModCount = objUpdate.getStamp();
        this.JDBCStore(connection, recipientToBeStored, user, lastModCount);
    }

    private void JDBCStore(Connection conn, IRecipient object, Principal user, int lastModCount) throws DTException {
        PreparedStatement ps = null;
        try {
            String sqlStmt = "UPDATE " + this.JDBC_TABLE + " SET " + this.F_NAME + " = ?" + ", " + this.F_DESCRIPTION + " = ?" + ", " + this.F_MODCOUNT + " = " + this.F_MODCOUNT + "+1" + ", " + this.F_LASTMOD_BY + " = ?" + ", " + this.F_TITLE + " = ?" + ", " + this.F_FIRSTNAME + " = ?" + ", " + this.F_MIDDLENAME + " = ?" + ", " + this.F_LASTNAME + " = ?" + ", " + this.F_PHONENUMBER + " = ?" + ", " + this.F_JOBTITLE + " = ?" + ", " + this.F_COMPANY + " = ?" + ", " + this.F_DEPARTMENT + " = ?" + ", " + this.F_OFFICE + " = ?" + ", " + this.F_COUNTRY + " = ?" + ", " + this.F_TIMEZONE + " = ?" + ", " + this.F_TO_REDIRECT + " = ?" + ", " + this.F_FK_REDIRECT_RID + " = ?" + ", " + this.F_IS_EXTERNAL + " = ?" + ", " + this.F_IS_USEDEFAULT + " = ?" + " WHERE " + this.F_OID + " = ?" + " AND " + this.F_MODCOUNT + " = ?";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(sqlStmt);
            ps = conn.prepareStatement(sqlStmt);
            String objName = object.getName();
            ps.setString(1, objName);
            String objDescription = object.getDescription();
            ps.setString(2, objDescription);
            if (user == null) {
                ps.setString(3, "");
            } else {
                ps.setString(3, user.getName());
            }
            String title = object.getTitle();
            ps.setString(4, title);
            String firstName = object.getFirstName();
            ps.setString(5, firstName);
            String middleName = object.getMiddleName();
            ps.setString(6, middleName);
            String lastName = object.getLastName();
            ps.setString(7, lastName);
            String phoneNumber = object.getPhoneNumber();
            ps.setString(8, phoneNumber);
            String jobTitle = object.getJobTitle();
            ps.setString(9, jobTitle);
            String company = object.getCompanyName();
            ps.setString(10, company);
            String department = object.getDepartment();
            ps.setString(11, department);
            String office = object.getOffice();
            ps.setString(12, office);
            String country = object.getCountry();
            ps.setString(13, country);
            String timezone = object.getTimezone();
            ps.setString(14, timezone);
            boolean isRedirected = object.isRedirected();
            if (isRedirected) {
                ps.setInt(15, 1);
                INCFeatherWeight redirected = object.getRedirection();
                if (null == redirected) {
                    NCObjectIdUtil.instance().setIntoStatement(null, 16, ps);
                } else {
                    NCObjectIdUtil.instance().setIntoStatement(redirected.getNCObjectId(), 16, ps);
                }
            } else {
                ps.setInt(15, 0);
                NCObjectIdUtil.instance().setIntoStatement(null, 16, ps);
            }
            int source = object.getRecipientOrigin().getInteger();
            ps.setInt(17, source);
            ps.setInt(18, object.isUseDefaultAddress() ? 1 : 0);
            NCObjectId oid = object.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(oid, 19, ps);
            ps.setInt(20, lastModCount);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UPDATED_OID, (Object[])new String[]{oid.toString(), "Rows updated < 1"}, (Map)ap);
                throw new DTException(I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UPDATED_OID);
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE);
            }
            this.storeRecipientDeliveryDetails(conn, object, user);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_USER_OBJECT, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_USER_OBJECT);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)ps);
    }

    @Override
    public void storeNew(Connection connection, INCBaseObjectConsumer object, Principal user) throws DTException {
        String sqlStmt = "INSERT INTO " + this.JDBC_TABLE + " ( " + this.F_NAME + ", " + this.F_DESCRIPTION + ", " + this.F_MODCOUNT + ", " + this.F_LASTMOD_BY + ", " + this.F_TITLE + ", " + this.F_FIRSTNAME + ", " + this.F_MIDDLENAME + ", " + this.F_LASTNAME + ", " + this.F_PHONENUMBER + ", " + this.F_JOBTITLE + ", " + this.F_COMPANY + ", " + this.F_DEPARTMENT + ", " + this.F_OFFICE + ", " + this.F_COUNTRY + ", " + this.F_TIMEZONE + ", " + this.F_TO_REDIRECT + ", " + this.F_FK_REDIRECT_RID + ", " + this.F_IS_EXTERNAL + ", " + this.F_IS_USEDEFAULT + ", " + this.F_OID + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        IRecipient objectToBeStored = (IRecipient)object;
        PreparedStatement ps = null;
        try {
            if (!(object instanceof IRecipient)) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_RECIPIENT_DATAHELPER_IS_CALLED_TO_A, (Map)ap);
                throw new DTException(I18NCode.MSG_RECIPIENT_DATAHELPER_IS_CALLED_TO_A);
            }
            ps = connection.prepareStatement(sqlStmt);
            String objName = objectToBeStored.getName();
            ps.setString(1, objName);
            String objDescription = objectToBeStored.getDescription();
            ps.setString(2, objDescription);
            ps.setInt(3, 1);
            if (user != null) {
                ps.setString(4, user.getName());
            } else {
                ps.setString(4, "");
            }
            String title = objectToBeStored.getTitle();
            ps.setString(5, title);
            String firstName = objectToBeStored.getFirstName();
            ps.setString(6, firstName);
            String middleName = objectToBeStored.getMiddleName();
            ps.setString(7, middleName);
            String lastName = objectToBeStored.getLastName();
            ps.setString(8, lastName);
            String phoneNumber = objectToBeStored.getPhoneNumber();
            ps.setString(9, phoneNumber);
            String jobTitle = objectToBeStored.getJobTitle();
            ps.setString(10, jobTitle);
            String company = objectToBeStored.getCompanyName();
            ps.setString(11, company);
            String department = objectToBeStored.getDepartment();
            ps.setString(12, department);
            String office = objectToBeStored.getOffice();
            ps.setString(13, office);
            String country = objectToBeStored.getCountry();
            ps.setString(14, country);
            String timezone = objectToBeStored.getTimezone();
            ps.setString(15, timezone);
            boolean isRedirected = objectToBeStored.isRedirected();
            if (isRedirected) {
                ps.setInt(16, 1);
                INCFeatherWeight redirected = objectToBeStored.getRedirection();
                if (null == redirected) {
                    NCObjectIdUtil.instance().setIntoStatement(null, 17, ps);
                } else {
                    NCObjectIdUtil.instance().setIntoStatement(redirected.getNCObjectId(), 17, ps);
                }
            } else {
                ps.setInt(16, 0);
                NCObjectIdUtil.instance().setIntoStatement(null, 17, ps);
            }
            int source = objectToBeStored.getRecipientOrigin().getInteger();
            ps.setInt(18, source);
            if (objectToBeStored.isUseDefaultAddress()) {
                ps.setInt(19, 1);
            } else {
                ps.setInt(19, 0);
            }
            NCObjectId oid = objectToBeStored.getNCObjectId();
            if (null == oid) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_RECIPIENT_DOES_NOT_HAVE_AN_ID, (Map)ap);
                throw new DTException(I18NCode.MSG_RECIPIENT_DOES_NOT_HAVE_AN_ID);
            }
            NCObjectIdUtil.instance().setIntoStatement(oid, 20, ps);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UPDATED_OID, (Object[])new String[]{oid.toString(), "Row updated < 1"}, (Map)ap);
                throw new DTException(I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UPDATED_OID);
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE);
            }
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)ps);
        this.storeRecipientDeliveryDetails(connection, objectToBeStored, user);
    }

    @Override
    public void delete(Connection conn, NCObjectId object_id, Principal user) throws DTException {
        this.m_deliveryAddresses.deleteDeliveryAddresses(conn, object_id);
        String sql = "DELETE FROM " + this.JDBC_TABLE + " WHERE " + this.F_OID + " = ?";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            NCObjectIdUtil.instance().setIntoStatement(object_id, 1, ps);
            int n = ps.executeUpdate();
        }
        catch (SQLException sqle) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sqle);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_TO_DELETE_RECIPIENT, (Object[])new String[]{object_id.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_UNABLE_TO_DELETE_RECIPIENT, new Object[]{object_id});
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INCObjectUpdate findByOid(Connection conn, NCObjectId oid, Principal principal) throws DTException {
        NCObjectUpdateImpl nCObjectUpdateImpl;
        String selectStmt = this.SELECT_CLAUSE + " WHERE " + this.F_OID + " = ?";
        int nObjectFound = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(selectStmt);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            IRecipient theRecipient = null;
            int modCount = -999;
            boolean rowExists = false;
            if (rs.next()) {
                rowExists = true;
                ++nObjectFound;
                theRecipient = this.readResultSetIntoObject(conn, rs, principal);
                modCount = rs.getInt(this.F_MODCOUNT);
            }
            if (0 == nObjectFound) {
                String errMsg = "No object is found for Object Id: " + oid;
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.PERST_OBJECT_NOT_FOUND);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(errMsg);
                throw new NCObjectNotFoundException(I18NCode.PERST_OBJECT_NOT_FOUND);
            }
            if (rowExists && rs.next()) {
                String errMsg = "Object Id not unique for " + oid;
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE, (Object[])new String[]{oid.toString()});
                throw new DTException(I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE, new Object[]{oid});
            }
            nCObjectUpdateImpl = new NCObjectUpdateImpl(theRecipient, NCObjectType.RECIPIENT, modCount);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), this.JDBC_TABLE});
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("" + ex.getMessage());
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, this.JDBC_TABLE});
                catch (LogictierException ex2) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, (LocalizableException)ex2);
                    throw new DTException(I18NCode.PERST_OBJECT_NOT_FOUND, ex2);
                }
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, (Statement)ps);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        return nCObjectUpdateImpl;
    }

    @Override
    public Iterator findByName(Connection conn, String name) throws DTException {
        String errMsg = "Operation not supported for Recipient object.";
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_UNSUPPORTED_OPERATION, (Map)ap);
        throw new DTException(I18NCode.OTH_UNSUPPORTED_OPERATION);
    }

    @Override
    public Iterator findByDescription(Connection conn, String description) throws DTException {
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_UNSUPPORTED_OPERATION, (Map)ap);
        throw new DTException(I18NCode.OTH_UNSUPPORTED_OPERATION);
    }

    @Override
    public INCBaseObjectConsumer findCopyByOid(Connection conn, NCObjectId oid, Principal principal) throws DTException {
        IRecipient iRecipient;
        String selectStmt = this.SELECT_CLAUSE + " WHERE " + this.F_OID + " = ?";
        int nObjectFound = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(selectStmt);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            IRecipient theRecipient = null;
            boolean rowExists = false;
            if (rs.next()) {
                rowExists = true;
                ++nObjectFound;
                theRecipient = this.readResultSetIntoObject(conn, rs, principal);
            }
            if (0 == nObjectFound) {
                String errMsg = "No object is found for Object Id: " + oid;
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.PERST_OBJECT_NOT_FOUND);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(errMsg);
                throw new NCObjectNotFoundException(I18NCode.PERST_OBJECT_NOT_FOUND);
            }
            if (rowExists && rs.next()) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE, (Object[])new String[]{oid.toString()});
                throw new DTException(I18NCode.MSG_RECIPIENT_OBJECT_IS_NOT_UNIQUE, new Object[]{oid});
            }
            iRecipient = theRecipient;
        }
        catch (SQLException ex) {
            try {
                String errMsg = "SQL Exception caught in finding Object by Oid " + oid.toString();
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), this.JDBC_TABLE});
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(errMsg);
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, this.JDBC_TABLE});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, (Statement)ps);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        return iRecipient;
    }

    @Override
    public Iterator findCopyByName(Connection conn, String objectName) throws DTException {
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_UNSUPPORTED_OPERATION, (Map)ap);
        throw new DTException(I18NCode.OTH_UNSUPPORTED_OPERATION);
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user) throws DTException {
        return this.getObjectList(connection, user, HelperOptionImpl.EMPTY_OPTION);
    }

    private IRecipient readResultSetIntoObject(Connection conn, ResultSet rs, Principal principal) throws SQLException, DTException {
        NCObjectId ncObjId = NCObjectIdUtil.instance().createObjectId(rs, this.F_OID);
        String objectName = rs.getString(this.F_NAME);
        String objectDescription = rs.getString(this.F_DESCRIPTION);
        String recipient_title = rs.getString(this.F_TITLE);
        String recipient_firstName = rs.getString(this.F_FIRSTNAME);
        String recipient_middleName = rs.getString(this.F_MIDDLENAME);
        String recipient_lastName = rs.getString(this.F_LASTNAME);
        String recipient_phoneNumber = rs.getString(this.F_PHONENUMBER);
        String recipient_jobTitle = rs.getString(this.F_JOBTITLE);
        String recipient_company = rs.getString(this.F_COMPANY);
        String recipient_department = rs.getString(this.F_DEPARTMENT);
        String recipient_office = rs.getString(this.F_OFFICE);
        String recipient_country = rs.getString(this.F_COUNTRY);
        String recipient_timezone = rs.getString(this.F_TIMEZONE);
        int toRedirect = rs.getInt(this.F_TO_REDIRECT);
        NCObjectId redirect_oid = NCObjectIdUtil.instance().createObjectId(rs, this.F_FK_REDIRECT_RID);
        int isExternal = rs.getInt(this.F_IS_EXTERNAL);
        int isDefaultaddress = rs.getInt(this.F_IS_USEDEFAULT);
        RecipientImpl objToReturn = new RecipientImpl();
        objToReturn.setNCObjectId(ncObjId);
        objToReturn.setName(objectName);
        objToReturn.setDescription(objectDescription);
        objToReturn.setTitle(recipient_title);
        objToReturn.setFirstName(recipient_firstName);
        objToReturn.setMiddleName(recipient_middleName);
        objToReturn.setLastName(recipient_lastName);
        objToReturn.setPhoneNumber(recipient_phoneNumber);
        objToReturn.setJobTitle(recipient_jobTitle);
        objToReturn.setCompanyName(recipient_company);
        objToReturn.setDepartment(recipient_department);
        objToReturn.setOffice(recipient_office);
        objToReturn.setCountry(recipient_country);
        objToReturn.setTimezone(recipient_timezone);
        objToReturn.setAccManEmail("");
        objToReturn.setIsUseDefaultAddress(1 == isDefaultaddress);
        if (0 == toRedirect) {
            objToReturn.disableRedirect();
        } else {
            objToReturn.enableRedirect();
            if (redirect_oid != null) {
                try {
                    NCFeatherWeightImpl featherRecipient = new NCFeatherWeightImpl(NCObjectType.RECIPIENT, redirect_oid, "", "");
                    objToReturn.setRedirection(featherRecipient);
                }
                catch (NCException ex) {
                    String errMsg = "Could not create featherweight object of type " + NCObjectType.RECIPIENT.toString();
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_RECIPIENT_SERVICE_EXCP, (Object[])new String[]{errMsg}, (Map)ap);
                }
            }
        }
        switch (isExternal) {
            case 0: {
                objToReturn.setRecipientOrigin(RecipientOrigin.NOTICECAST);
                break;
            }
            case 1: {
                objToReturn.setRecipientOrigin(RecipientOrigin.EXTERNAL);
                break;
            }
            case 2: {
                objToReturn.setRecipientOrigin(RecipientOrigin.ACCMAN);
                break;
            }
            case 3: {
                objToReturn.setRecipientOrigin(RecipientOrigin.SERVICE);
            }
        }
        IDeliveryAddress[] allDeliveryAddresses = this.m_deliveryAddresses.retrieveDeliveryAddresses(conn, objToReturn, null, principal);
        objToReturn.setDeliveryAddresses(allDeliveryAddresses);
        return objToReturn;
    }

    private void storeRecipientDeliveryDetails(Connection conn, IRecipient recipient, Principal principal) throws DTException {
        this.m_deliveryAddresses.storeDeliveryAddresses(conn, recipient, principal);
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user, HelperOption option) throws DTException {
        String select_statement = this.SELECT_CLAUSE;
        ResultSet result_set = null;
        Statement statement = null;
        TreeSet<IRecipient> recipient_list = new TreeSet<IRecipient>(new NCNameComparator());
        try {
            statement = connection.createStatement();
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                statement.setFetchSize(JDBCConnectionProperties.instance(null).getFetchSize());
            }
            result_set = statement.executeQuery(select_statement);
            while (result_set.next()) {
                recipient_list.add(this.readResultSetIntoObject(connection, result_set, null));
            }
        }
        catch (SQLException sql_exception) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sql_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_GETOBJECTLIST, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_GETOBJECTLIST);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(result_set, (Statement)statement);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)result_set, (Statement)statement);
        return recipient_list.iterator();
    }

    @Override
    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(Connection conn, HelperOption option) throws DTException {
        return new INCObjectUpdate[0];
    }

    private List getRecipientList(Connection conn, String SQLStr, final NCObjectId ncoid, final String filter) throws DTException {
        IJDBCValueSetter setter = new IJDBCValueSetter(){

            @Override
            public boolean setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, "%" + filter + "%");
                NCObjectIdUtil.instance().setIntoStatement(ncoid, 2, ps);
                return true;
            }
        };
        IJDBCValueGetter getter = new IJDBCValueGetter(){

            @Override
            public Object getObject(ResultSet rs) throws SQLException {
                return JDBCDhRecipientImpl.this.getList(rs);
            }
        };
        List recipientList = null;
        try {
            recipientList = (List)JDBCExecute.executeQuery(conn, SQLStr, setter, getter);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, (Object[])new String[]{NCObjectType.RECIPIENT.toString(), "NC_RECIPIENT"}, (Map)ap);
            throw new SQLRepositoryException(I18NCode.SQL_RETRIEVE_LIST_BY_TYPE_ERROR, new Object[]{NCObjectType.RECIPIENT, "NC_RECIPIENT"});
        }
        return recipientList;
    }

    private List getList(ResultSet rs) throws SQLException {
        boolean NC_RECIPIENT = false;
        int ACCMAN_RECIPIENT = 2;
        int NC_SERVICE = 3;
        ArrayList<RecipientFeatherWeightImpl> recipientList = new ArrayList<RecipientFeatherWeightImpl>();
        try {
            RecipientFeatherWeightImpl recip = null;
            int recipientType = -1;
            NCObjectId ncId = null;
            String recipientName = null;
            String description = null;
            String email = null;
            while (rs.next()) {
                recip = null;
                recipientType = rs.getInt(1);
                if (recipientType == 0) {
                    ncId = NCObjectId.valueOf((ResultSet)rs, (int)2);
                    recipientName = rs.getString(3);
                    description = rs.getString(4);
                    email = rs.getString(6);
                    recip = new RecipientFeatherWeightImpl(RecipientOrigin.NOTICECAST, ncId, recipientName, description, email, null);
                } else if (recipientType == 3) {
                    ncId = NCObjectId.valueOf((ResultSet)rs, (int)2);
                    recipientName = rs.getString(3);
                    description = rs.getString(4);
                    recip = new RecipientFeatherWeightImpl(RecipientOrigin.NOTICECAST, ncId, recipientName, description, null, null);
                } else {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_UNKNOWN_RECIPIENT_TYPE_FOUND_WHILE_RETRIEVING_RECIPIENT_LIST, (Map)ap);
                }
                recipientList.add(recip);
            }
        }
        catch (NCException ncex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ncex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_CREATING_FEATHER_WEIGHT_OBJECT, (Map)ap);
            throw new SQLException("Unable to create feather weight object.");
        }
        return recipientList;
    }

    private void deleteTempRecipients(Connection conn, NCObjectId temp_id) throws DTException {
        String delete_sql = "DELETE FROM NC_ACCMAN_TEMP_STORE WHERE TMP_ID = ?";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(delete_sql);
            NCObjectIdUtil.instance().setIntoStatement(temp_id, 1, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{temp_id.toString(), "NC_ACCMAN_TEMP_STORE"}, (Map)ap);
            throw new SQLRepositoryException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{temp_id, "NC_ACCMAN_TEMP_STORE"});
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public INCFeatherWeight[] cleanRecipientsList(Connection conn, INCFeatherWeight[] recipients) throws DTException {
        String delev_sql = "SELECT DISTINCT(FK_RECIPIENT_ID) FROM NC_DELIVERYADDRESS";
        ArrayList<INCFeatherWeight> result = new ArrayList<INCFeatherWeight>(recipients.length);
        INCFeatherWeight[] resultArray = new INCFeatherWeight[]{};
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<NCObjectId> allWhoHasEmail = new ArrayList<NCObjectId>();
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT DISTINCT(FK_RECIPIENT_ID) FROM NC_DELIVERYADDRESS");
            while (rs.next()) {
                allWhoHasEmail.add(NCObjectId.valueOf((ResultSet)rs, (int)1));
            }
            Arrays.sort(recipients, this.m_featherWtComparator);
            NCFeatherWeightImpl dummyFeatherWt = new NCFeatherWeightImpl(NCObjectType.RECIPIENT, NCObjectId.createNew(), null, null);
            for (int i = 0; i < allWhoHasEmail.size(); ++i) {
                dummyFeatherWt.setNCObjectId((NCObjectId)allWhoHasEmail.get(i));
                int foundAt = Arrays.binarySearch(recipients, dummyFeatherWt, this.m_featherWtComparator);
                if (foundAt <= -1 || recipients[foundAt] == null) continue;
                result.add(recipients[foundAt]);
            }
            resultArray = result.toArray(new INCFeatherWeight[result.size()]);
            Arrays.sort(resultArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    INCFeatherWeight f1 = (INCFeatherWeight)o1;
                    INCFeatherWeight f2 = (INCFeatherWeight)o2;
                    return f1.getName().compareToIgnoreCase(f2.getName());
                }

                @Override
                public boolean equals(Object o) {
                    return true;
                }
            });
        }
        catch (NCException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_CREATING_FEATHER_WEIGHT_OBJECT, (Map)ap);
                throw new SQLRepositoryException(I18NCode.MSG_FAILED_CREATING_FEATHER_WEIGHT_OBJECT, ex);
                catch (SQLException ex2) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_CREATING_FEATHER_WEIGHT_OBJECT, (Map)ap);
                    throw new SQLRepositoryException(I18NCode.MSG_FAILED_CREATING_FEATHER_WEIGHT_OBJECT);
                }
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)stmt);
        return resultArray;
    }
}

