/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.recipient.address;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import noticecast.datatier.DTException;
import noticecast.datatier.recipient.address.IAddressHandler;
import noticecast.logictier.recipient.DeliveryAddressImpl;
import noticecast.logictier.recipient.DeliveryAddressType;
import noticecast.logictier.recipient.IDeliveryAddress;

public abstract class AbstractAddressHandler
implements IAddressHandler {
    private DeliveryAddressType m_addressType;
    private final String store_sql = "INSERT INTO NC_DELIVERYADDRESS( PK_DELADDRESS_ID, DELIVERY_ADDRESS, CHANNEL_TYPE, IS_DEFAULT, FK_RECIPIENT_ID, ADDRESS_TYPE) VALUES (?, ?, ?, ?, ?, ?)";

    public AbstractAddressHandler(DeliveryAddressType type) {
        this.m_addressType = type;
    }

    DeliveryAddressType getType() {
        return this.m_addressType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAddress(Connection conn, IDeliveryAddress address, NCObjectId recipient_id) throws DTException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("INSERT INTO NC_DELIVERYADDRESS( PK_DELADDRESS_ID, DELIVERY_ADDRESS, CHANNEL_TYPE, IS_DEFAULT, FK_RECIPIENT_ID, ADDRESS_TYPE) VALUES (?, ?, ?, ?, ?, ?)");
            NCObjectId.setIntoStatement((NCObjectId)address.getNCObjectId(), (int)1, (PreparedStatement)ps);
            ps.setString(2, address.getAddress());
            ps.setInt(3, address.getDeliveryChannelType().getIndex());
            ps.setInt(4, address.isDefault() ? 1 : 0);
            NCObjectId.setIntoStatement((NCObjectId)recipient_id, (int)5, (PreparedStatement)ps);
            ps.setInt(6, address.getType().getSQLValue());
            int updated_count = ps.executeUpdate();
            if (updated_count != 1) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_UNABLE_TO_STORE_DELIVERY_ADDRESS_FOR_RECIPIENT);
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_RECIPIENT_DELIVERY_ADDRESS);
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    protected IDeliveryAddress buildCommonComponents(ResultSet rs) {
        NCObjectId deliAddressId = null;
        DeliveryAddressImpl deliveryAddress = new DeliveryAddressImpl(this.getType());
        try {
            deliAddressId = NCObjectIdUtil.instance().createObjectId(rs, "PK_DELADDRESS_ID");
            this.checkForNull(deliAddressId);
            int channelTypeIndex = rs.getInt("CHANNEL_TYPE");
            ChannelType channelType = ChannelType.get((int)channelTypeIndex);
            int isDefault = rs.getInt("IS_DEFAULT");
            deliveryAddress.setNCObjectId(deliAddressId);
            deliveryAddress.setDeliveryChannelType(channelType);
            deliveryAddress.setIsDefault(0 != isDefault);
            deliveryAddress.setDescription("");
        }
        catch (SQLException sQLException) {
        }
        catch (DTException dTException) {
            // empty catch block
        }
        return deliveryAddress;
    }

    private void checkForNull(Object anObj) throws DTException {
        if (null != anObj) {
            return;
        }
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_NO_ID_IS_DEFINED_FOR_THE_DELIVERY_ADDRESS);
        throw new DTException(I18NCode.MSG_NO_ID_IS_DEFINED_FOR_THE_DELIVERY_ADDRESS);
    }

    protected void closeResources(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
        }
    }
}

