/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.recipient.address;

import java.security.Principal;
import noticecast.datatier.DTException;
import noticecast.datatier.NCIllegalParameterException;
import noticecast.datatier.recipient.address.IAddressFactory;
import noticecast.datatier.recipient.address.IAddressHandler;
import noticecast.datatier.recipient.address.NCAddressHandlerImpl;
import noticecast.logictier.recipient.DeliveryAddressType;

public final class AddressFactoryImpl
implements IAddressFactory {
    private static AddressFactoryImpl m_fact;

    @Override
    public IAddressHandler create(DeliveryAddressType type, Principal principal) throws DTException {
        NCAddressHandlerImpl addressHandler = null;
        if (!DeliveryAddressType.NOTICECAST.isEqualTo(type)) {
            throw new NCIllegalParameterException(null);
        }
        addressHandler = new NCAddressHandlerImpl(type);
        return addressHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AddressFactoryImpl getInstance() {
        if (null != m_fact) return m_fact;
        Class<AddressFactoryImpl> clazz = AddressFactoryImpl.class;
        synchronized (AddressFactoryImpl.class) {
            if (null != m_fact) return m_fact;
            m_fact = new AddressFactoryImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_fact;
        }
    }
}

