/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.scheduling;

import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import noticecast.datatier.DTException;
import noticecast.datatier.IObjectView;
import noticecast.datatier.MiscUtil;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.scheduling.IJDBCDhSchedule;
import noticecast.debug.Debug;
import noticecast.logictier.NCObjectNotFoundException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.NCObjectUpdateImpl;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.DailyScheduleWithIntradayRecurrence;
import noticecast.scheduling.schedules.FixedIntervalSchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.IntradayRecurrenceSchedule;
import noticecast.scheduling.schedules.MonthlySchedule;
import noticecast.scheduling.schedules.MonthlyScheduleWithIntradayRecurrence;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.scheduling.schedules.SubscriptionSchedule;
import noticecast.scheduling.schedules.TriggeredSchedule;
import noticecast.scheduling.schedules.WeeklySchedule;
import noticecast.scheduling.schedules.WeeklyScheduleWithIntradayRecurrence;
import noticecast.scheduling.schedules.YearlySchedule;
import noticecast.scheduling.schedules.YearlyScheduleWithIntradayRecurrence;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class JDBCDhScheduleImpl
implements IJDBCDhSchedule,
IObjectView {
    public static final String JDBC_TABLE = "NC_SCHEDULE";
    public static final String F_OID = "PK_SCHEDULE_ID";
    public static final String F_NAME = "NAME";
    public static final String F_DESCRIPTION = "DESCRIPTION";
    public static final String F_LASTMOD_BY = "LASTMOD_BY";
    public static final String F_MODCOUNT = "MODCOUNT";
    public static final String F_SCHEDULE_TYPE = "SCHEDULE_TYPE";
    public static final String F_TIMEZONE = "TIMEZONE";
    public static final String F_START_DATE = "START_DATE";
    public static final String F_END_DATE = "END_DATE";
    public static final String F_REPEAT_FOREVER = "REPEAT_FOREVER";
    public static final String F_ACTIVE = "ACTIVE";
    public static final String F_VALID_SCHEDULE = "VALID_SCHEDULE";
    public static final String F_USE_DAY_NUMBER = "USE_DAY_NUMBER";
    public static final String F_DAY_OF_MONTH = "DAY_OF_MONTH";
    public static final String F_DAY_OF_WEEK = "DAY_OF_WEEK";
    public static final String F_DAY_OF_WEEK_IN_MONTH = "DAY_OF_WEEK_IN_MONTH";
    public static final String F_MONTH_OF_YEAR = "MONTH_OF_YEAR";
    public static final String F_REPEAT_INTERVAL = "REPEAT_INTERVAL";
    public static final String F_DAYS_OF_WEEK = "DAYS_OF_WEEK";
    public static final String F_FIXED_INTERVAL_TYPE = "FIXED_INTERVAL_TYPE";
    public static final String F_FIXED_INTERVAL_IN_MILLIS = "FIXED_INTERVAL_IN_MILLIS";
    public static final String F_TRIGGER_ID = "TRIGGER_ID";
    public static final String F_PERIODICAL_ID = "PERIODICAL_PRODUCER_ID";
    public static final String F_INTRADAY_RECUR_START = "INTERDAY_RECUR_START";
    public static final String F_INTRADAY_RECUR_END = "INTERDAY_RECUR_END";
    public static final String F_INTRADAY_RECUR_INTERVAL = "INTERDAY_RECUR_INTERVAL";
    public final String SELECT_CLAUSE = "SELECT PK_SCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, TIMEZONE, START_DATE, END_DATE, REPEAT_FOREVER, ACTIVE, VALID_SCHEDULE, USE_DAY_NUMBER, DAY_OF_MONTH, DAY_OF_WEEK, DAY_OF_WEEK_IN_MONTH, MONTH_OF_YEAR, REPEAT_INTERVAL, SCHEDULE_TYPE, TRIGGER_ID, PERIODICAL_PRODUCER_ID, DAYS_OF_WEEK, FIXED_INTERVAL_TYPE, FIXED_INTERVAL_IN_MILLIS, INTERDAY_RECUR_START, INTERDAY_RECUR_END, INTERDAY_RECUR_INTERVAL";
    public static final String DELTE_STMT = "DELETE FROM NC_SCHEDULE WHERE PK_SCHEDULE_ID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safelyDelete(Connection conn, NCObjectId oid) throws SQLException {
        if (oid == null) {
            return;
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(DELTE_STMT);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            ps.executeUpdate();
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    @Override
    public void remove(Connection conn, NCObjectId oid, Principal user) throws DTException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(DELTE_STMT);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < -1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SCHEDULE_OBJECT_IS_NOT_DELETED, (Object[])new String[]{oid.toString(), "Updated < -1"}, (Map)ap);
                throw new DTException(I18NCode.MSG_SCHEDULE_OBJECT_IS_NOT_DELETED, new Object[]{oid, "Updated < -1"});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SCHEDULE_OBJECT_IS_NOT_UNIQUE, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_SCHEDULE_OBJECT_IS_NOT_UNIQUE, new Object[]{oid});
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_REMOVING_A_SCHEDULE, (Object[])new String[]{oid.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_REMOVING_A_SCHEDULE, new Object[]{oid});
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    @Override
    public void store(Connection connection, INCObjectUpdate objUpdate, Principal user) throws DTException {
        NcScheduleWrapper scheduleWrapper = null;
        int modcount = -999;
        scheduleWrapper = (NcScheduleWrapper)objUpdate.getObject();
        modcount = objUpdate.getStamp();
        ISchedule schedule = scheduleWrapper.getSchedule();
        StringBuffer sqlStmtBuffer = new StringBuffer();
        sqlStmtBuffer.append("UPDATE NC_SCHEDULE SET NAME = ?, DESCRIPTION = ?, MODCOUNT = MODCOUNT+1, LASTMOD_BY = ?, START_DATE = ?, END_DATE = ?, REPEAT_FOREVER = ?, VALID_SCHEDULE = ?, USE_DAY_NUMBER = ?, DAY_OF_MONTH = ?, DAY_OF_WEEK = ?, DAY_OF_WEEK_IN_MONTH = ?, MONTH_OF_YEAR = ?, REPEAT_INTERVAL = ?, SCHEDULE_TYPE = ?, TIMEZONE = ?");
        int numberOfParametersAdded = this.additionalUpdateStmtString(sqlStmtBuffer, schedule);
        sqlStmtBuffer.append(" WHERE PK_SCHEDULE_ID = ? AND MODCOUNT = ?");
        String sqlStmt = sqlStmtBuffer.toString();
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sqlStmt);
            String objName = scheduleWrapper.getName();
            if (objName.length() == 0) {
                ps.setString(1, "");
            } else {
                ps.setString(1, objName);
            }
            String objDescription = scheduleWrapper.getDescription();
            if (objName.length() == 0) {
                ps.setString(2, "");
            } else {
                ps.setString(2, objDescription);
            }
            ps.setString(3, user == null ? "unknown" : user.getName());
            Date startDate = schedule.getStartDate();
            long startDateLong = startDate.getTime();
            ps.setDouble(4, startDateLong);
            Date endDate = schedule.getEndDate();
            if (endDate == null) {
                ps.setNull(5, 8);
            } else {
                long endDateLong = endDate.getTime();
                ps.setDouble(5, endDateLong);
            }
            boolean repeatForever = schedule.getRepeatForever();
            ps.setInt(6, MiscUtil.getInt(repeatForever));
            boolean scheduleValid = schedule.getScheduleValid();
            ps.setInt(7, MiscUtil.getInt(scheduleValid));
            boolean useDayNumber = schedule.getUseDayNumber();
            ps.setInt(8, MiscUtil.getInt(useDayNumber));
            int dayOfMonth = schedule.getDayOfMonth();
            ps.setInt(9, dayOfMonth);
            NcDayConstants dayOfWeek = schedule.getDayOfWeek();
            if (dayOfWeek != null) {
                ps.setInt(10, dayOfWeek.intValue());
            } else {
                ps.setNull(10, 4);
            }
            int dayOfWeekInMonth = schedule.getDayOfWeekInMonth();
            ps.setInt(11, dayOfWeekInMonth);
            int monthOfYear = schedule.getMonthOfYear().intValue();
            ps.setInt(12, monthOfYear);
            int repeatInterval = schedule.getRepeatInterval();
            ps.setInt(13, repeatInterval);
            String scheduleType = schedule.getType().toSQLString();
            ps.setString(14, scheduleType);
            String tzID = schedule.getTimeZone().getID();
            ps.setString(15, tzID);
            int nextParameterPosition = 16;
            this.additionalInsertPreparedStatementParameters(schedule, ps, nextParameterPosition);
            nextParameterPosition += numberOfParametersAdded;
            NCObjectId oid = scheduleWrapper.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(oid, nextParameterPosition++, ps);
            ps.setInt(nextParameterPosition, modcount);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
            throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    @Override
    public void delete(Connection conn, NCObjectId object_id, Principal user) throws DTException {
        this.remove(conn, object_id, user);
    }

    @Override
    public void storeNew(Connection connection, INCBaseObjectConsumer object, Principal user) throws DTException {
        if (!(object instanceof NcScheduleWrapper)) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
            throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
        }
        NcScheduleWrapper scheduleWrapper = (NcScheduleWrapper)object;
        ISchedule schedule = scheduleWrapper.getSchedule();
        String sqlStmt = "INSERT INTO NC_SCHEDULE ( NAME, DESCRIPTION, LASTMOD_BY, START_DATE, END_DATE, REPEAT_FOREVER, VALID_SCHEDULE, USE_DAY_NUMBER, DAY_OF_MONTH, DAY_OF_WEEK, DAY_OF_WEEK_IN_MONTH, MONTH_OF_YEAR, REPEAT_INTERVAL, SCHEDULE_TYPE, TIMEZONE" + this.additionalInsertStmtString(schedule) + ", " + F_OID + ") VALUES (?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, " + this.additionalInsertStmtParametersString(schedule) + "? )";
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sqlStmt);
            String objName = scheduleWrapper.getName();
            ps.setString(1, objName);
            String objDescription = scheduleWrapper.getDescription();
            ps.setString(2, objDescription);
            ps.setString(3, user == null ? "unknown" : user.getName());
            Date startDate = schedule.getStartDate();
            long startDateLong = startDate.getTime();
            ps.setDouble(4, startDateLong);
            Date endDate = schedule.getEndDate();
            if (endDate == null) {
                ps.setNull(5, 8);
            } else {
                long endDateLong = endDate.getTime();
                ps.setDouble(5, endDateLong);
            }
            boolean repeatForever = schedule.getRepeatForever();
            ps.setInt(6, MiscUtil.getInt(repeatForever));
            boolean scheduleValid = schedule.getScheduleValid();
            ps.setInt(7, MiscUtil.getInt(scheduleValid));
            boolean useDayNumber = schedule.getUseDayNumber();
            ps.setInt(8, MiscUtil.getInt(useDayNumber));
            int dayOfMonth = schedule.getDayOfMonth();
            ps.setInt(9, dayOfMonth);
            NcDayConstants dayOfWeek = schedule.getDayOfWeek();
            if (dayOfWeek != null) {
                ps.setInt(10, dayOfWeek.intValue());
            } else {
                ps.setNull(10, 4);
            }
            int dayOfWeekInMonth = schedule.getDayOfWeekInMonth();
            ps.setInt(11, dayOfWeekInMonth);
            int monthOfYear = schedule.getMonthOfYear().intValue();
            ps.setInt(12, monthOfYear);
            int repeatInterval = schedule.getRepeatInterval();
            ps.setInt(13, repeatInterval);
            String scheduleType = schedule.getType().toSQLString();
            ps.setString(14, scheduleType);
            String tzID = schedule.getTimeZone().getID();
            ps.setString(15, tzID);
            int nextParameterPosition = 16;
            int numberOfParametersAdded = this.additionalInsertPreparedStatementParameters(schedule, ps, nextParameterPosition);
            NCObjectId oid = scheduleWrapper.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(oid, nextParameterPosition += numberOfParametersAdded, ps);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
            throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, JDBC_TABLE});
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INCObjectUpdate findByOid(Connection conn, NCObjectId oid, Principal principal) throws DTException {
        String selectStmt = "SELECT PK_SCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, TIMEZONE, START_DATE, END_DATE, REPEAT_FOREVER, ACTIVE, VALID_SCHEDULE, USE_DAY_NUMBER, DAY_OF_MONTH, DAY_OF_WEEK, DAY_OF_WEEK_IN_MONTH, MONTH_OF_YEAR, REPEAT_INTERVAL, SCHEDULE_TYPE, TRIGGER_ID, PERIODICAL_PRODUCER_ID, DAYS_OF_WEEK, FIXED_INTERVAL_TYPE, FIXED_INTERVAL_IN_MILLIS, INTERDAY_RECUR_START, INTERDAY_RECUR_END, INTERDAY_RECUR_INTERVAL FROM NC_SCHEDULE  WHERE PK_SCHEDULE_ID = ?";
        int nObjectFound = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        NcScheduleWrapper scheduleWrapper = null;
        try {
            NCObjectUpdateImpl objToReturn;
            ps = conn.prepareStatement(selectStmt);
            int updateStamp = -999;
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                ++nObjectFound;
                scheduleWrapper = this.readResultSetIntoObject(rs);
                updateStamp = rs.getInt(F_MODCOUNT);
            }
            if (0 == nObjectFound) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                throw new NCObjectNotFoundException(I18NCode.PERST_OBJECT_NOT_FOUND);
            }
            if (rs.next()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, JDBC_TABLE});
            }
            NCObjectUpdateImpl nCObjectUpdateImpl = objToReturn = new NCObjectUpdateImpl(scheduleWrapper, NCObjectType.SCHEDULE, updateStamp);
            this.closeResources(rs, ps);
            return nCObjectUpdateImpl;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_OBJECT_B, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_OBJECT_B, new Object[]{oid});
                catch (LocalizableException ex2) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                    throw new DTException(I18NCode.PERST_OBJECT_NOT_FOUND, ex2);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    @Override
    public Iterator findByName(Connection conn, String name) throws DTException {
        return null;
    }

    @Override
    public Iterator findByDescription(Connection conn, String description) throws DTException {
        return null;
    }

    @Override
    public INCBaseObjectConsumer findCopyByOid(Connection conn, NCObjectId oid, Principal principal) throws DTException {
        String selectStmt = "SELECT PK_SCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, TIMEZONE, START_DATE, END_DATE, REPEAT_FOREVER, ACTIVE, VALID_SCHEDULE, USE_DAY_NUMBER, DAY_OF_MONTH, DAY_OF_WEEK, DAY_OF_WEEK_IN_MONTH, MONTH_OF_YEAR, REPEAT_INTERVAL, SCHEDULE_TYPE, TRIGGER_ID, PERIODICAL_PRODUCER_ID, DAYS_OF_WEEK, FIXED_INTERVAL_TYPE, FIXED_INTERVAL_IN_MILLIS, INTERDAY_RECUR_START, INTERDAY_RECUR_END, INTERDAY_RECUR_INTERVAL  FROM NC_SCHEDULE  WHERE PK_SCHEDULE_ID = ?";
        int nObjectFound = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(selectStmt);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            NcScheduleWrapper scheduleWrapper = null;
            if (rs.next()) {
                ++nObjectFound;
                scheduleWrapper = this.readResultSetIntoObject(rs);
            }
            if (0 == nObjectFound) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                throw new NCObjectNotFoundException(I18NCode.PERST_OBJECT_NOT_FOUND);
            }
            if (rs.next()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, JDBC_TABLE});
            }
            NcScheduleWrapper ap = scheduleWrapper;
            this.closeResources(rs, ps);
            return ap;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_REMOTEEXCEPTION_CAUGHT_IN_FINDING_OBJECT, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_OBJECT_B, new Object[0]);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    @Override
    public Iterator findCopyByName(Connection conn, String objectName) throws DTException {
        return null;
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user) throws DTException {
        return this.getObjectList(connection, user, HelperOptionImpl.EMPTY_OPTION);
    }

    private NcScheduleWrapper readResultSetIntoObject(ResultSet rs) throws DTException {
        try {
            NCObjectId ncObjId = NCObjectIdUtil.instance().createObjectId(rs, F_OID);
            String objectName = rs.getString(F_NAME);
            String objectDescription = rs.getString(F_DESCRIPTION);
            String startDateStr = rs.getString(F_START_DATE);
            Date startDate = null;
            if (null != startDateStr) {
                long startDateLong = MiscUtil.convertStringToLong(startDateStr);
                startDate = new Date(startDateLong);
            }
            String endDateStr = rs.getString(F_END_DATE);
            Date endDate = null;
            if (null != endDateStr) {
                long endDateLong = MiscUtil.convertStringToLong(endDateStr);
                endDate = new Date(endDateLong);
            }
            boolean repeatForever = MiscUtil.getBoolean(rs.getInt(F_REPEAT_FOREVER));
            boolean isValidSchedule = MiscUtil.getBoolean(rs.getInt(F_VALID_SCHEDULE));
            boolean useDayNumber = MiscUtil.getBoolean(rs.getInt(F_USE_DAY_NUMBER));
            int dayOfMonth = rs.getInt(F_DAY_OF_MONTH);
            NcDayConstants dayOfWeek = NcDayConstants.getDay(rs.getInt(F_DAY_OF_WEEK));
            int dayOfWeekInMonth = rs.getInt(F_DAY_OF_WEEK_IN_MONTH);
            NcMonthConstants monthOfYear = NcMonthConstants.getMonth(rs.getInt(F_MONTH_OF_YEAR));
            int repeatInterval = rs.getInt(F_REPEAT_INTERVAL);
            String scheduleTypeString = rs.getString(F_SCHEDULE_TYPE);
            ScheduleType scheduleType = ScheduleType.valueOf(scheduleTypeString);
            String tzString = rs.getString(F_TIMEZONE);
            TimeZone tz = this.getTimeZone(tzString);
            String triggerID = rs.getString(F_TRIGGER_ID);
            String periodicalID = rs.getString(F_PERIODICAL_ID);
            int intradayRecurStart = rs.getInt(F_INTRADAY_RECUR_START);
            int intradayRecurEnd = rs.getInt(F_INTRADAY_RECUR_END);
            int intradayRecurInterval = rs.getInt(F_INTRADAY_RECUR_INTERVAL);
            ISchedule schedule = this.getScheduleInstance(rs, scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz, triggerID, periodicalID, intradayRecurStart, intradayRecurEnd, intradayRecurInterval);
            return new NcScheduleWrapper(ncObjId, objectName, objectDescription, schedule);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_READ_RS_ERROR, (Map)ap);
            throw new DTException(I18NCode.SQL_READ_RS_ERROR);
        }
        catch (Throwable ex) {
            String s = "Found RunTimeException in JDBCDHScheduleImpl.readResultSetIntoObject()";
            if (Debug.debug) {
                System.out.print(s);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{s});
            return null;
        }
    }

    private ISchedule getScheduleInstance(ResultSet rs, ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz, String triggerId, String producerId, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws SQLException {
        ISchedule schedule;
        block13: {
            schedule = null;
            if (scheduleType.equals(ScheduleType.YEARLY_SCHEDULE)) {
                schedule = new YearlySchedule(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.YEARLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE_SCHEDULE) || scheduleType.equals(ScheduleType.YEARLY_RELATIVE_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
                schedule = new YearlyScheduleWithIntradayRecurrence(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.MONTHLY_SCHEDULE)) {
                schedule = new MonthlySchedule(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.MONTHLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE_SCHEDULE) || scheduleType.equals(ScheduleType.MONTHLY_RELATIVE_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
                schedule = new MonthlyScheduleWithIntradayRecurrence(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.WEEKLY_SCHEDULE)) {
                int daysOfWeek = rs.getInt(F_DAYS_OF_WEEK);
                schedule = new WeeklySchedule(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, daysOfWeek, tz);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
                int daysOfWeek = rs.getInt(F_DAYS_OF_WEEK);
                schedule = new WeeklyScheduleWithIntradayRecurrence(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, daysOfWeek, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.DAILY_SCHEDULE)) {
                schedule = new DailySchedule(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.DAILY_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
                schedule = new DailyScheduleWithIntradayRecurrence(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.TRIGGERED_SCHEULE)) {
                schedule = new TriggeredSchedule(triggerId, startDate, endDate, repeatForever, tz);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.SUBSCRIPTION_SCHEDULE)) {
                schedule = new SubscriptionSchedule(producerId, startDate, endDate, repeatForever, tz);
                break block13;
            }
            if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
                long fixedIntervalInMillis = rs.getLong(F_FIXED_INTERVAL_IN_MILLIS);
                schedule = new FixedIntervalSchedule(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, fixedIntervalInMillis, tz);
                break block13;
            }
            String errmsg = "JDBCDhSchedleImpl.getScheduleInstance(): exception Unhandled schedule type! (schedule not created): " + scheduleType.integerValue();
            throw new IllegalStateException(errmsg);
        }
        return schedule;
    }

    private int additionalUpdateStmtString(StringBuffer buffer, ISchedule schedule) {
        String stmt;
        ScheduleType scheduleType = schedule.getType();
        int paramsAdded = 0;
        if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
            stmt = ", FIXED_INTERVAL_IN_MILLIS = ?";
            buffer.append(stmt);
            paramsAdded = 1;
        } else if (scheduleType.equals(ScheduleType.WEEKLY_SCHEDULE) || scheduleType.equals(ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
            stmt = ", DAYS_OF_WEEK = ?";
            buffer.append(stmt);
            paramsAdded = 1;
        } else if (scheduleType.equals(ScheduleType.TRIGGERED_SCHEULE)) {
            stmt = ", TRIGGER_ID = ?";
            buffer.append(stmt);
            paramsAdded = 1;
        } else if (scheduleType.equals(ScheduleType.SUBSCRIPTION_SCHEDULE)) {
            stmt = ", PERIODICAL_PRODUCER_ID = ?";
            buffer.append(stmt);
            paramsAdded = 1;
        }
        if (schedule instanceof IntradayRecurrenceSchedule) {
            stmt = ", INTERDAY_RECUR_START = ?, INTERDAY_RECUR_END = ?, INTERDAY_RECUR_INTERVAL = ?";
            buffer.append(stmt);
            paramsAdded += 3;
        }
        return paramsAdded;
    }

    private String additionalInsertStmtString(ISchedule schedule) {
        ScheduleType scheduleType = schedule.getType();
        String stmt = "";
        if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
            stmt = ", FIXED_INTERVAL_IN_MILLIS";
        } else if (scheduleType.equals(ScheduleType.WEEKLY_SCHEDULE) || scheduleType.equals(ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
            stmt = ", DAYS_OF_WEEK";
        } else if (scheduleType.equals(ScheduleType.TRIGGERED_SCHEULE)) {
            stmt = ", TRIGGER_ID";
        } else if (scheduleType.equals(ScheduleType.SUBSCRIPTION_SCHEDULE)) {
            stmt = ", PERIODICAL_PRODUCER_ID";
        }
        if (schedule instanceof IntradayRecurrenceSchedule) {
            stmt = stmt + ", INTERDAY_RECUR_START, INTERDAY_RECUR_END, INTERDAY_RECUR_INTERVAL";
        }
        return stmt;
    }

    private String additionalInsertStmtParametersString(ISchedule schedule) {
        ScheduleType scheduleType = schedule.getType();
        String stmt = "";
        if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
            stmt = "?, ";
        } else if (scheduleType.equals(ScheduleType.WEEKLY_SCHEDULE) || scheduleType.equals(ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
            stmt = "?, ";
        } else if (scheduleType.equals(ScheduleType.TRIGGERED_SCHEULE)) {
            stmt = "?, ";
        } else if (scheduleType.equals(ScheduleType.SUBSCRIPTION_SCHEDULE)) {
            stmt = "?, ";
        }
        if (schedule instanceof IntradayRecurrenceSchedule) {
            stmt = stmt + "?, ?, ?, ";
        }
        return stmt;
    }

    private int additionalInsertPreparedStatementParameters(ISchedule schedule, PreparedStatement ps, int position) throws DTException {
        int addedParameters = 0;
        try {
            ISchedule weeklySchedule;
            ScheduleType scheduleType = schedule.getType();
            if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE) || scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
                if (!(schedule instanceof FixedIntervalSchedule)) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE, (Map)ap);
                    throw new DTException(I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE);
                }
                FixedIntervalSchedule fixedIntervalSchedule = (FixedIntervalSchedule)schedule;
                long repeatIntervalInMillis = fixedIntervalSchedule.getRepeatIntervalInMillis();
                ps.setDouble(position++, repeatIntervalInMillis);
                addedParameters = 1;
            } else if (scheduleType.equals(ScheduleType.WEEKLY_SCHEDULE)) {
                if (!(schedule instanceof WeeklySchedule)) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE_NOT_WEEKLY, (Map)ap);
                    throw new DTException(I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE_NOT_WEEKLY);
                }
                weeklySchedule = (WeeklySchedule)schedule;
                int daysOfWeek = ((WeeklySchedule)weeklySchedule).getDaysOfWeek();
                ps.setInt(position++, daysOfWeek);
                addedParameters = 1;
            } else if (scheduleType.equals(ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE)) {
                if (!(schedule instanceof WeeklyScheduleWithIntradayRecurrence)) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE_NOT_WEEKLY, (Map)ap);
                    throw new DTException(I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE_NOT_WEEKLY);
                }
                weeklySchedule = (WeeklyScheduleWithIntradayRecurrence)schedule;
                int daysOfWeek = ((WeeklyScheduleWithIntradayRecurrence)weeklySchedule).getDaysOfWeek();
                ps.setInt(position++, daysOfWeek);
                addedParameters = 1;
            } else if (scheduleType.equals(ScheduleType.TRIGGERED_SCHEULE)) {
                if (!(schedule instanceof TriggeredSchedule)) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE_NOT_TRIGGERED, (Map)ap);
                    throw new DTException(I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_SCHEDULE_NOT_TRIGGERED);
                }
                TriggeredSchedule triggered = (TriggeredSchedule)schedule;
                String triggerID = triggered.getTrigger();
                ps.setString(position++, triggerID);
                addedParameters = 1;
            } else if (scheduleType.equals(ScheduleType.SUBSCRIPTION_SCHEDULE)) {
                SubscriptionSchedule subscriptionSchedule = (SubscriptionSchedule)schedule;
                String producerID = subscriptionSchedule.getProducer();
                ps.setString(position++, producerID);
                addedParameters = 1;
            }
            if (schedule instanceof IntradayRecurrenceSchedule) {
                IntradayRecurrenceSchedule irs = (IntradayRecurrenceSchedule)schedule;
                ps.setInt(position++, irs.getIntradayRecurrenceStart());
                ps.setInt(position++, irs.getIntradayRecurrenceEnd());
                ps.setInt(position, irs.getIntradayRecurrenceInterval());
                addedParameters += 3;
            }
            return addedParameters;
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_PROBLEM_PARAMETERS, (Map)ap);
            throw new DTException(I18NCode.MSG_JDBCDHSCHEDULEIMPL_ADDITIONALPREPAREDSTATEMENTPARAMETERS_PROBLEM_PARAMETERS);
        }
    }

    private void closeResources(ResultSet rs, Statement statement) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != statement) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user, HelperOption option) throws DTException {
        String select_statement = "SELECT PK_SCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, TIMEZONE, START_DATE, END_DATE, REPEAT_FOREVER, ACTIVE, VALID_SCHEDULE, USE_DAY_NUMBER, DAY_OF_MONTH, DAY_OF_WEEK, DAY_OF_WEEK_IN_MONTH, MONTH_OF_YEAR, REPEAT_INTERVAL, SCHEDULE_TYPE, TRIGGER_ID, PERIODICAL_PRODUCER_ID, DAYS_OF_WEEK, FIXED_INTERVAL_TYPE, FIXED_INTERVAL_IN_MILLIS, INTERDAY_RECUR_START, INTERDAY_RECUR_END, INTERDAY_RECUR_INTERVAL";
        ResultSet result_set = null;
        PreparedStatement prepared_statement = null;
        Vector<NcScheduleWrapper> schedule_list = new Vector<NcScheduleWrapper>();
        try {
            prepared_statement = connection.prepareStatement(select_statement);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                prepared_statement.setFetchSize(JDBCConnectionProperties.instance(null).getFetchSize());
            }
            result_set = prepared_statement.executeQuery();
            while (result_set.next()) {
                schedule_list.add(this.readResultSetIntoObject(result_set));
            }
            this.closeResources(result_set, prepared_statement);
        }
        catch (SQLException sql_exception) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sql_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_GETOBJECTLIST, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_GETOBJECTLIST);
            }
            catch (Throwable throwable) {
                this.closeResources(result_set, prepared_statement);
                throw throwable;
            }
        }
        return schedule_list.iterator();
    }

    private TimeZone getTimeZone(String tzString) {
        TimeZone tz = null;
        tz = tzString == null ? TimeZone.getDefault() : TimeZone.getTimeZone((String)tzString);
        return tz;
    }

    @Override
    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(Connection conn, HelperOption option) throws DTException {
        return new INCObjectUpdate[0];
    }
}

