/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.scheduling;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.SQLParserUtils;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.IEventId;
import com.cognos.sds.event.persist.EventStatusPersister;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import noticecast.datatier.IJDBCListValueSetter;
import noticecast.datatier.IJDBCValueGetter;
import noticecast.datatier.IJDBCValueSetter;
import noticecast.datatier.JDBCExecute;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleImpl;
import noticecast.logictier.base.INCBaseObject;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.ScheduleLink;

public class JDBCDhTaskScheduleEventOverrideDetails {
    private static final String EVENT_OVERRIDES_TABLE = "NC_SCHEDULED_EVENT_OVERRIDE";
    private static final String TASKSCHEDULE_ID = "FK_TASKSCHEDULE_ID";
    private static final String EVENT_DATE = "EVENT_DATE";
    private static final String EVENT_STATUS = "EVENT_STATUS";
    private static final String EVENT_PRIORITY = "EVENT_PRIORITY";
    private static final String SCHEDULE_ID = "FK_SCHEDULE_ID";
    private static final String CANCELLED_BY = "CANCELLED_BY";
    private static final String DELAY_UNTIL = "DELAY_UNTIL";
    protected final String SELECT_SQL = "SELECT EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, FK_TASKSCHEDULE_ID, DELAY_UNTIL FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID = ?";
    protected final String SELECT_BY_ID_SQL = "SELECT EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, FK_TASKSCHEDULE_ID, DELAY_UNTIL FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID = ? AND EVENT_DATE = ?";
    protected final String SELECT_SQL_LIST = "SELECT EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, FK_TASKSCHEDULE_ID, DELAY_UNTIL FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID ";
    protected final String SELECT_SQL_TASKSCHEDULEID_BY_STATUS = "SELECT DISTINCT FK_TASKSCHEDULE_ID FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE EVENT_STATUS = ?";
    private static final String INSERT_SQL = "INSERT INTO NC_SCHEDULED_EVENT_OVERRIDE ( FK_TASKSCHEDULE_ID, EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, DELAY_UNTIL) VALUES (?, ?, ?, ?, ?, ?, ?)";
    protected final String DELETE_SQL = "DELETE FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID = ?";
    protected final String COUNT_SQL_BY_STATUS = "SELECT COUNT(*) FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE EVENT_STATUS = ?";

    public void storeOverrideDates(Connection conn, ITaskSchedule taskSchedule) throws SQLException {
        this.deleteOverrideDates(conn, taskSchedule);
        this.storeNewOverrideDates(conn, taskSchedule);
    }

    public void storeNewOverrideDates(Connection conn, ITaskSchedule taskSchedule) throws SQLException {
        taskSchedule.verifyOverrideEvents();
        ScheduleLink[] links = taskSchedule.getScheduleLinks();
        ArrayList<OverridesDatesWrapper> store_dates = new ArrayList<OverridesDatesWrapper>();
        for (int i = 0; i < links.length; ++i) {
            NCObjectId schedule_id = links[i].getScheduleId();
            Collection events = links[i].getOverrideEvents();
            for (Event event : events) {
                OverridesDatesWrapper wrap = new OverridesDatesWrapper(event.getScheduledStartDate(), event.getStatus(), event.getPriority(), event.getCancelUser(), event.getRequestedStartDate(), taskSchedule.getNCObjectId(), schedule_id);
                store_dates.add(wrap);
            }
        }
        if (store_dates.size() > 0) {
            CancelledDateListSetter datesSetter = new CancelledDateListSetter(taskSchedule.getNCObjectId());
            JDBCExecute.executeUpdate(conn, INSERT_SQL, datesSetter, store_dates);
        }
    }

    public void populateOverrideDates(Connection conn, ITaskSchedule taskSchedule) throws SQLException {
        OverrideDatesValueGetter datesGetter;
        OverrideDatesTaskScheduleIdSetter idSetter = new OverrideDatesTaskScheduleIdSetter(taskSchedule.getNCObjectId());
        Collection wrappers = (Collection)JDBCExecute.executeQuery(conn, "SELECT EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, FK_TASKSCHEDULE_ID, DELAY_UNTIL FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID = ?", idSetter, datesGetter = new OverrideDatesValueGetter());
        if (wrappers != null) {
            for (OverridesDatesWrapper wrap : wrappers) {
                Event event = this.buildEvent(taskSchedule.getTaskId(), wrap);
                taskSchedule.addOverrideEvent(event, wrap.m_scheduleId);
            }
        }
    }

    public Event getOverrideEvent(Connection conn, IEventId eventId) throws SQLException {
        NCObjectId taskId = eventId.getTaskId();
        Date eventDate = eventId.getRunDate();
        if (eventDate == null) {
            return null;
        }
        JDBCDhTaskScheduleImpl jdbcTs = new JDBCDhTaskScheduleImpl();
        NCObjectId taskScheduleId = jdbcTs.findIDByTaskId(conn, taskId);
        Event event = null;
        OverrideDatesTaskScheduleIdAndDateSetter idSetter = new OverrideDatesTaskScheduleIdAndDateSetter(taskScheduleId, eventDate);
        OverrideDatesValueGetter datesGetter = new OverrideDatesValueGetter();
        Collection wrappers = (Collection)JDBCExecute.executeQuery(conn, "SELECT EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, FK_TASKSCHEDULE_ID, DELAY_UNTIL FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID = ? AND EVENT_DATE = ?", idSetter, datesGetter);
        if (wrappers != null) {
            for (OverridesDatesWrapper wrap : wrappers) {
                event = this.buildEvent(taskId, wrap);
            }
        }
        return event;
    }

    public int getCountByStatus(Connection conn, EventStatus status) throws SQLException {
        IJDBCValueGetter countGetter;
        final int statusAsInt = new EventStatusPersister(status).getInteger();
        IJDBCValueSetter idSetter = new IJDBCValueSetter(){

            @Override
            public boolean setValues(PreparedStatement ps) throws SQLException {
                ps.setInt(1, statusAsInt);
                return true;
            }
        };
        Integer count = (Integer)JDBCExecute.executeQuery(conn, "SELECT COUNT(*) FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE EVENT_STATUS = ?", idSetter, countGetter = new IJDBCValueGetter(){

            @Override
            public Object getObject(ResultSet rs) throws SQLException {
                int count = 0;
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                return new Integer(count);
            }
        });
        if (count != null) {
            return count;
        }
        return 0;
    }

    public void populateOverrideDates(Connection conn, ITaskSchedule[] taskSchedules) throws SQLException {
        if (taskSchedules == null || taskSchedules.length == 0) {
            return;
        }
        HashMap<String, ITaskSchedule> tsByIdMap = new HashMap<String, ITaskSchedule>();
        String[] ids = new String[taskSchedules.length];
        for (int i = 0; i < taskSchedules.length; ++i) {
            ids[i] = taskSchedules[i].getNCObjectId().toString();
            tsByIdMap.put(ids[i], taskSchedules[i]);
        }
        OverrideDatesValueGetter datesGetter = new OverrideDatesValueGetter();
        Collection wrappers = null;
        boolean quoteStrings = false;
        String[] inClauses = SQLParserUtils.createInClauses((String[])ids, (boolean)quoteStrings);
        ITaskSchedule taskSchedule = null;
        for (int i = 0; i < inClauses.length; ++i) {
            wrappers = (Collection)JDBCExecute.executeQuery(conn, "SELECT EVENT_DATE, EVENT_STATUS, EVENT_PRIORITY, FK_SCHEDULE_ID, CANCELLED_BY, FK_TASKSCHEDULE_ID, DELAY_UNTIL FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID " + inClauses[i], datesGetter);
            if (wrappers == null) continue;
            for (OverridesDatesWrapper wrap : wrappers) {
                taskSchedule = (ITaskSchedule)tsByIdMap.get(wrap.m_taskScheduleId.toString());
                Event event = this.buildEvent(taskSchedule.getTaskId(), wrap);
                taskSchedule.addOverrideEvent(event, wrap.m_scheduleId);
            }
        }
    }

    private Event buildEvent(NCObjectId taskId, OverridesDatesWrapper wrap) {
        EventId id = new EventId(taskId, wrap.m_scheduledDate);
        Event event = new Event(wrap.m_status, id);
        event.setCancelUser(wrap.m_cancelledBy);
        if (wrap.m_requestedDate != null) {
            event.setRequestedStartDate(wrap.m_requestedDate);
        } else if (wrap.m_status.equals((Object)EventStatus.SUSPENDED)) {
            event.setRequestedStartDate(wrap.m_requestedDate);
        }
        event.setPriority(wrap.m_priority);
        event.setIsOverride(true);
        return event;
    }

    public void deleteOverrideDates(Connection conn, NCObjectId id) throws SQLException {
        OverrideDatesTaskScheduleIdSetter idSetter = new OverrideDatesTaskScheduleIdSetter(id);
        int row = JDBCExecute.executeUpdate(conn, "DELETE FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE FK_TASKSCHEDULE_ID = ?", idSetter);
    }

    public void deleteOverrideDates(Connection conn, INCBaseObject baseObject) throws SQLException {
        this.deleteOverrideDates(conn, baseObject.getNCObjectId());
    }

    public NCObjectId[] getTaskScheduleIdsByStatus(Connection conn, EventStatus status) throws SQLException {
        IJDBCValueGetter datesGetter;
        final int statusAsInt = new EventStatusPersister(status).getInteger();
        IJDBCValueSetter idSetter = new IJDBCValueSetter(){

            @Override
            public boolean setValues(PreparedStatement ps) throws SQLException {
                ps.setInt(1, statusAsInt);
                return true;
            }
        };
        Collection ids = (Collection)JDBCExecute.executeQuery(conn, "SELECT DISTINCT FK_TASKSCHEDULE_ID FROM NC_SCHEDULED_EVENT_OVERRIDE WHERE EVENT_STATUS = ?", idSetter, datesGetter = new IJDBCValueGetter(){

            @Override
            public Object getObject(ResultSet rs) throws SQLException {
                ArrayList<NCObjectId> taskScheduleIds = null;
                while (rs.next()) {
                    if (taskScheduleIds == null) {
                        taskScheduleIds = new ArrayList<NCObjectId>();
                    }
                    taskScheduleIds.add(NCObjectIdUtil.instance().createObjectId(rs, JDBCDhTaskScheduleEventOverrideDetails.TASKSCHEDULE_ID));
                }
                return taskScheduleIds;
            }
        });
        if (ids != null) {
            return ids.toArray(new NCObjectId[ids.size()]);
        }
        return null;
    }

    public class OverridesDatesWrapper {
        public Date m_scheduledDate;
        public EventStatus m_status;
        public Integer m_priority;
        public String m_cancelledBy;
        public Date m_requestedDate;
        public NCObjectId m_scheduleId;
        public NCObjectId m_taskScheduleId;

        public OverridesDatesWrapper(Date eventDate, EventStatus status, Integer priority, String cancelledBy, Date requestedDate, NCObjectId taskScheduleId, NCObjectId scheduleId) {
            this.m_scheduledDate = eventDate;
            this.m_status = status;
            this.m_priority = priority;
            this.m_cancelledBy = cancelledBy;
            this.m_requestedDate = requestedDate;
            this.m_taskScheduleId = taskScheduleId;
            this.m_scheduleId = scheduleId;
        }
    }

    public class OverrideDatesValueGetter
    implements IJDBCValueGetter {
        @Override
        public Object getObject(ResultSet rs) throws SQLException {
            ArrayList<OverridesDatesWrapper> cancelledDates = null;
            while (rs.next()) {
                if (cancelledDates == null) {
                    cancelledDates = new ArrayList<OverridesDatesWrapper>();
                }
                Date date = new Date(rs.getLong(JDBCDhTaskScheduleEventOverrideDetails.EVENT_DATE));
                EventStatus status = null;
                int eventStatusInt = rs.getInt(JDBCDhTaskScheduleEventOverrideDetails.EVENT_STATUS);
                if (!rs.wasNull()) {
                    EventStatusPersister persister = new EventStatusPersister();
                    persister.valueOf(eventStatusInt);
                    status = persister.getEventStatus();
                }
                Integer priority = null;
                int priorityInt = rs.getInt(JDBCDhTaskScheduleEventOverrideDetails.EVENT_PRIORITY);
                if (!rs.wasNull()) {
                    priority = new Integer(priorityInt);
                }
                NCObjectId taskScheduleId = NCObjectIdUtil.instance().createObjectId(rs, JDBCDhTaskScheduleEventOverrideDetails.TASKSCHEDULE_ID);
                NCObjectId schedule_id = NCObjectIdUtil.instance().createObjectId(rs, JDBCDhTaskScheduleEventOverrideDetails.SCHEDULE_ID);
                String user = rs.getString(JDBCDhTaskScheduleEventOverrideDetails.CANCELLED_BY);
                Date requestedDate = null;
                long delayUntilLong = rs.getLong(JDBCDhTaskScheduleEventOverrideDetails.DELAY_UNTIL);
                if (!rs.wasNull()) {
                    requestedDate = new Date(delayUntilLong);
                }
                OverridesDatesWrapper wrapper = new OverridesDatesWrapper(date, status, priority, user, requestedDate, taskScheduleId, schedule_id);
                cancelledDates.add(wrapper);
            }
            return cancelledDates;
        }
    }

    public class OverrideDatesTaskScheduleIdAndDateSetter
    implements IJDBCValueSetter {
        private NCObjectId m_baseObjectId;
        private Date m_eventDate;

        public OverrideDatesTaskScheduleIdAndDateSetter(NCObjectId baseObjectId, Date eventDate) {
            this.m_baseObjectId = baseObjectId;
            this.m_eventDate = eventDate;
        }

        @Override
        public boolean setValues(PreparedStatement ps) throws SQLException {
            NCObjectIdUtil.instance().setIntoStatement(this.m_baseObjectId, 1, ps);
            long eventDateLong = this.m_eventDate.getTime();
            ps.setLong(2, eventDateLong);
            return true;
        }
    }

    public class OverrideDatesTaskScheduleIdSetter
    implements IJDBCValueSetter {
        private NCObjectId m_baseObjectId;

        public OverrideDatesTaskScheduleIdSetter(NCObjectId baseObjectId) {
            this.m_baseObjectId = baseObjectId;
        }

        @Override
        public boolean setValues(PreparedStatement ps) throws SQLException {
            NCObjectIdUtil.instance().setIntoStatement(this.m_baseObjectId, 1, ps);
            return true;
        }
    }

    private class CancelledDateListSetter
    implements IJDBCListValueSetter {
        NCObjectId baseObjectId;

        public CancelledDateListSetter(NCObjectId baseObjectId) {
            this.baseObjectId = baseObjectId;
        }

        @Override
        public boolean setValues(PreparedStatement ps, Object object) throws SQLException {
            ps.clearParameters();
            NCObjectIdUtil.instance().setIntoStatement(this.baseObjectId, 1, ps);
            if (!(object instanceof OverridesDatesWrapper)) {
                return false;
            }
            OverridesDatesWrapper wrapper = (OverridesDatesWrapper)object;
            long dateLong = wrapper.m_scheduledDate.getTime();
            ps.setDouble(2, dateLong);
            EventStatus status = wrapper.m_status;
            if (status != null) {
                EventStatusPersister esp = new EventStatusPersister(status);
                ps.setInt(3, esp.getInteger());
            } else {
                ps.setNull(3, 4);
            }
            Integer priority = wrapper.m_priority;
            if (priority != null) {
                ps.setInt(4, priority);
            } else {
                ps.setNull(4, 4);
            }
            NCObjectIdUtil.instance().setIntoStatement(wrapper.m_scheduleId, 5, ps);
            String user = wrapper.m_cancelledBy;
            ps.setString(6, user);
            if (wrapper.m_requestedDate != null) {
                long ddelayDateLong = wrapper.m_requestedDate.getTime();
                ps.setDouble(7, ddelayDateLong);
            } else {
                ps.setNull(7, 2);
            }
            return true;
        }
    }
}

