/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.scheduling;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import noticecast.datatier.DTException;
import noticecast.datatier.IObjectView;
import noticecast.datatier.MiscUtil;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.helperoptions.HelperType;
import noticecast.datatier.scheduling.IJDBCDhTaskSchedule;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleEventOverrideDetails;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleLinkHelper;
import noticecast.logictier.NCObjectNotFoundException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.NCObjectUpdateImpl;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.ScheduleLink;
import noticecast.scheduling.nc.TaskScheduleImpl;

public class JDBCDhTaskScheduleImpl
implements IJDBCDhTaskSchedule,
IObjectView {
    private JDBCDhTaskScheduleLinkHelper m_scheduleLinkHelper = new JDBCDhTaskScheduleLinkHelper();
    private JDBCDhTaskScheduleEventOverrideDetails m_overrideDatesDataHelper = new JDBCDhTaskScheduleEventOverrideDetails();
    public static final String JDBC_TABLE = "NC_TASKSCHEDULE";
    private static final String F_OID = "PK_TASKSCHEDULE_ID";
    private static final String F_NAME = "NAME";
    private static final String F_DESCRIPTION = "DESCRIPTION";
    private static final String F_LASTMOD_BY = "LASTMOD_BY";
    private static final String F_MODCOUNT = "MODCOUNT";
    private static final String F_RUN_REQUIREMENTS = "RUN_REQUIREMENTS";
    private static final String F_LAST_EXECUTION_AT = "LAST_EXECUTION_AT";
    private static final String F_NEXT_EXECUTION_REQUEST = "NEXT_EXECUTION_REQUEST";
    private static final String F_TASK_ID = "FK_TASK_ID";
    private static final String F_SCHEDULE_DELAY = "SCHEDULE_DELAY";
    private static final String F_DELETE_AFTER_LAST_RUN = "DELETE_AFTER_LAST_RUN";
    private static final String F_PRIORITY = "PRIORITY";
    private static final String F_SCHEDULED_BY = "SCHEDULED_BY";
    private static final String F_TENANT_ID = "TENANT_ID";
    private static final String SELECT_CLAUSE = "SELECT PK_TASKSCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PRIORITY, SCHEDULED_BY, TENANT_ID";
    private static final String SELECT_TASK_ID = "SELECT FK_TASK_ID FROM NC_TASKSCHEDULE WHERE PK_TASKSCHEDULE_ID = ?";
    private static final String SELECT_ID_BY_TASK_ID = "SELECT PK_TASKSCHEDULE_ID FROM NC_TASKSCHEDULE WHERE FK_TASK_ID = ?";
    private static final String DELETE_SQL = "DELETE FROM NC_TASKSCHEDULE WHERE PK_TASKSCHEDULE_ID = ?";
    private static final String UPDATE_SQL = "UPDATE NC_TASKSCHEDULE SET NAME = ?, DESCRIPTION = ?, LASTMOD_BY = ?, RUN_REQUIREMENTS = ?, LAST_EXECUTION_AT = ?, NEXT_EXECUTION_REQUEST = ?, FK_TASK_ID = ?, SCHEDULE_DELAY = ?, DELETE_AFTER_LAST_RUN = ?, PRIORITY = ?, SCHEDULED_BY = ?, TENANT_ID = ? WHERE PK_TASKSCHEDULE_ID = ?";
    public static final String INSERT_SQL = "INSERT INTO NC_TASKSCHEDULE ( NAME, DESCRIPTION, LASTMOD_BY, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PK_TASKSCHEDULE_ID, PRIORITY, SCHEDULED_BY, TENANT_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String FIND_BY_ID_SELECT_SQL = "SELECT PK_TASKSCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PRIORITY, SCHEDULED_BY, TENANT_ID FROM NC_TASKSCHEDULE  WHERE PK_TASKSCHEDULE_ID = ?";
    private static final String FIND_COPY_BY_ID_SELECT_SQL = "SELECT PK_TASKSCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PRIORITY, SCHEDULED_BY, TENANT_ID FROM NC_TASKSCHEDULE  WHERE PK_TASKSCHEDULE_ID = ?";

    public NCObjectId[] deleteTaskScheduleAndSchedules(Connection conn, NCObjectId oid) throws DTException {
        PreparedStatement ps = null;
        NCObjectId[] scheduleIds = new NCObjectId[]{};
        try {
            this.m_scheduleLinkHelper.safelyDeleteAllLinksAndSchedules(conn, oid);
            this.m_overrideDatesDataHelper.deleteOverrideDates(conn, oid);
            ps = conn.prepareStatement(DELETE_SQL);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            ps.executeUpdate();
            this.closeResources(null, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_REMOVING_A_SCHEDULE, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_REMOVING_A_SCHEDULE, new Object[]{oid});
            }
            catch (Throwable throwable) {
                this.closeResources(null, ps);
                throw throwable;
            }
        }
        return scheduleIds;
    }

    @Override
    public void delete(Connection conn, NCObjectId oid, Principal user) throws DTException {
        PreparedStatement ps = null;
        try {
            this.removeScheduleLinks(conn, oid, user);
            this.m_overrideDatesDataHelper.deleteOverrideDates(conn, oid);
            ps = conn.prepareStatement(DELETE_SQL);
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, JDBC_TABLE});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, JDBC_TABLE});
            }
            this.closeResources(null, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_REMOVING_A_SCHEDULE, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_REMOVING_A_SCHEDULE, new Object[]{oid});
            }
            catch (Throwable throwable) {
                this.closeResources(null, ps);
                throw throwable;
            }
        }
    }

    @Override
    public void store(Connection connection, ITaskSchedule taskSchedule) throws DTException {
        try {
            this.JDBCStore(connection, taskSchedule, null);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_TASK_SCHEDULE, (Object[])new String[]{taskSchedule.getNCObjectId().toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_TASK_SCHEDULE, new Object[]{taskSchedule.getNCObjectId()});
        }
    }

    @Override
    public void store(Connection connection, INCObjectUpdate objUpdate, Principal user) throws DTException {
        try {
            ITaskSchedule taskScheduleToBeStored = (ITaskSchedule)objUpdate.getObject();
            this.JDBCStore(connection, taskScheduleToBeStored, user);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_USE, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_USE);
        }
    }

    private void JDBCStore(Connection conn, ITaskSchedule taskSchedule, Principal user) throws SQLException, DTException {
        PreparedStatement ps = conn.prepareStatement(UPDATE_SQL);
        try {
            String objName = taskSchedule.getName();
            ps.setString(1, objName);
            String objDescription = taskSchedule.getDescription();
            ps.setString(2, objDescription);
            ps.setString(3, user == null ? null : user.getName());
            int runRequirements = taskSchedule.getRunOption();
            ps.setInt(4, runRequirements);
            Date lastExecution = taskSchedule.getLastExecution();
            if (lastExecution == null) {
                ps.setNull(5, 8);
            } else {
                long lastExecutionLong = lastExecution.getTime();
                ps.setDouble(5, lastExecutionLong);
            }
            Date nextExecution = taskSchedule.getNextExecution();
            if (nextExecution == null) {
                ps.setNull(6, 8);
            } else {
                long nextExecutionLong = nextExecution.getTime();
                ps.setDouble(6, nextExecutionLong);
            }
            NCObjectId taskId = taskSchedule.getTaskId();
            NCObjectIdUtil.instance().setIntoStatement(taskId, 7, ps);
            long scheduleDelay = taskSchedule.getDelay();
            ps.setDouble(8, scheduleDelay);
            boolean deleteAfterLastRun = taskSchedule.getDeleteAfterLastRun();
            ps.setInt(9, MiscUtil.getInt(deleteAfterLastRun));
            int priority = taskSchedule.getPriority();
            ps.setInt(10, priority);
            String ownerStoreID = taskSchedule.getOwnerStoreID();
            if (ownerStoreID != null) {
                ps.setString(11, ownerStoreID);
            } else {
                ps.setNull(11, 12);
            }
            String tenantID = taskSchedule.getTenantID();
            if (tenantID != null) {
                ps.setString(12, tenantID);
            } else {
                ps.setNull(12, 12);
            }
            NCObjectId oid = taskSchedule.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(oid, 13, ps);
            int nUpdated = ps.executeUpdate();
            ps.close();
            ps = null;
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK_SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, JDBC_TABLE});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK_SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_UPDATE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, JDBC_TABLE});
            }
            this.removeScheduleLinks(conn, taskSchedule, user);
            this.storeScheduleLinks(conn, taskSchedule, user);
            this.m_overrideDatesDataHelper.storeOverrideDates(conn, taskSchedule);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_USE, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_USE);
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    @Override
    public void storeNew(Connection conn, INCBaseObjectConsumer object, Principal user) throws DTException {
        ITaskSchedule taskSchedule = null;
        PreparedStatement ps = null;
        try {
            if (!(object instanceof ITaskSchedule)) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK_SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, JDBC_TABLE});
            }
            taskSchedule = (ITaskSchedule)object;
            ps = conn.prepareStatement(INSERT_SQL);
            String objName = taskSchedule.getName();
            ps.setString(1, objName);
            String objDescription = taskSchedule.getDescription();
            ps.setString(2, objDescription);
            ps.setString(3, user == null ? null : user.getName());
            int runRequirements = taskSchedule.getRunOption();
            ps.setInt(4, runRequirements);
            Date lastExecution = taskSchedule.getLastExecution();
            if (null == lastExecution) {
                ps.setNull(5, 8);
            } else {
                long lastExecutionLong = lastExecution.getTime();
                ps.setDouble(5, lastExecutionLong);
            }
            Date nextExecution = taskSchedule.getNextExecution();
            if (null == nextExecution) {
                ps.setNull(6, 8);
            } else {
                long nextExecutionLong = nextExecution.getTime();
                ps.setDouble(6, nextExecutionLong);
            }
            NCObjectId taskId = taskSchedule.getTaskId();
            NCObjectIdUtil.instance().setIntoStatement(taskId, 7, ps);
            long scheduleDelay = taskSchedule.getDelay();
            ps.setDouble(8, scheduleDelay);
            boolean deleteAfterLastRun = taskSchedule.getDeleteAfterLastRun();
            ps.setInt(9, MiscUtil.getInt(deleteAfterLastRun));
            NCObjectId oid = taskSchedule.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(oid, 10, ps);
            int priority = taskSchedule.getPriority();
            ps.setInt(11, priority);
            String ownerStoreID = taskSchedule.getOwnerStoreID();
            if (ownerStoreID != null) {
                ps.setString(12, ownerStoreID);
            } else {
                ps.setNull(12, 12);
            }
            String tenantID = taskSchedule.getTenantID();
            if (tenantID != null) {
                ps.setString(13, tenantID);
            } else {
                ps.setNull(13, 12);
            }
            int nUpdated = ps.executeUpdate();
            ps.close();
            ps = null;
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK_SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, JDBC_TABLE});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK_SCHEDULE.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, JDBC_TABLE});
            }
            this.storeScheduleLinks(conn, taskSchedule, user);
            this.m_overrideDatesDataHelper.storeNewOverrideDates(conn, taskSchedule);
            this.closeResources(null, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT);
            }
            catch (Throwable throwable) {
                this.closeResources(null, ps);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INCObjectUpdate findByOid(Connection conn, NCObjectId oid, Principal principal) throws DTException {
        int nObjectFound = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        ITaskSchedule taskSchedule = null;
        try {
            ps = conn.prepareStatement("SELECT PK_TASKSCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PRIORITY, SCHEDULED_BY, TENANT_ID FROM NC_TASKSCHEDULE  WHERE PK_TASKSCHEDULE_ID = ?");
            int updateStamp = -999;
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                ++nObjectFound;
                taskSchedule = JDBCDhTaskScheduleImpl.readResultSetIntoObject(rs);
                updateStamp = rs.getInt(F_MODCOUNT);
            }
            if (0 == nObjectFound) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                throw new NCObjectNotFoundException(I18NCode.PERST_OBJECT_NOT_FOUND);
            }
            if (rs.next()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, JDBC_TABLE});
            }
            NCObjectUpdateImpl objToReturn = new NCObjectUpdateImpl(taskSchedule, NCObjectType.TASK_SCHEDULE, updateStamp);
            ScheduleLink[] scheduleLinks = this.m_scheduleLinkHelper.getLinks(conn, taskSchedule);
            if (scheduleLinks != null) {
                taskSchedule.setScheduleLinks(scheduleLinks);
            }
            this.m_overrideDatesDataHelper.populateOverrideDates(conn, taskSchedule);
            NCObjectUpdateImpl nCObjectUpdateImpl = objToReturn;
            this.closeResources(rs, ps);
            return nCObjectUpdateImpl;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_FINDING_A_TASK_SCHEDULE, (Object[])new String[]{oid.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_FINDING_A_TASK_SCHEDULE, new Object[]{oid});
                catch (LocalizableException ex2) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                    throw new DTException(I18NCode.PERST_OBJECT_NOT_FOUND, ex2);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    @Override
    public Iterator findByName(Connection conn, String name) throws DTException {
        return null;
    }

    @Override
    public Iterator findByDescription(Connection conn, String description) throws DTException {
        return null;
    }

    @Override
    public INCBaseObjectConsumer findCopyByOid(Connection conn, NCObjectId oid, Principal principal) throws DTException {
        ITaskSchedule taskSchedule = null;
        int nObjectFound = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("SELECT PK_TASKSCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PRIORITY, SCHEDULED_BY, TENANT_ID FROM NC_TASKSCHEDULE  WHERE PK_TASKSCHEDULE_ID = ?");
            NCObjectIdUtil.instance().setIntoStatement(oid, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                ++nObjectFound;
                taskSchedule = JDBCDhTaskScheduleImpl.readResultSetIntoObject(rs);
            }
            if (0 == nObjectFound) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                throw new NCObjectNotFoundException(I18NCode.PERST_OBJECT_NOT_FOUND);
            }
            if (rs.next()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{oid.toString(), JDBC_TABLE}, (Map)ap);
                throw new DTException(I18NCode.SQL_RETRIEVE_OBJECT_IN_TABLE_ERROR, new Object[]{oid, JDBC_TABLE});
            }
            ScheduleLink[] scheduleLinks = this.m_scheduleLinkHelper.getLinks(conn, taskSchedule);
            if (scheduleLinks != null) {
                taskSchedule.setScheduleLinks(scheduleLinks);
            }
            this.m_overrideDatesDataHelper.populateOverrideDates(conn, taskSchedule);
            ITaskSchedule iTaskSchedule = taskSchedule;
            this.closeResources(rs, ps);
            return iTaskSchedule;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_FINDING_A_TASK_SCHEDULE, (Object[])new String[]{taskSchedule.getNCObjectId().toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_FINDING_A_TASK_SCHEDULE, new Object[]{oid});
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    @Override
    public Iterator findCopyByName(Connection conn, String objectName) throws DTException {
        return null;
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user) throws DTException {
        return this.getObjectList(connection, user, HelperOptionImpl.EMPTY_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCObjectId findTaskId(Connection conn, NCObjectId taskScheduleId) {
        NCObjectId taskId = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(SELECT_TASK_ID);
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                taskId = NCObjectIdUtil.instance().createObjectId(rs, F_TASK_ID);
            }
            this.closeResources(rs, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_FINDING_A_TASK_SCHEDULE, (Object[])new String[]{taskScheduleId.toString()}, (Map)ap);
                this.closeResources(rs, ps);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCObjectId findIDByTaskId(Connection conn, NCObjectId taskId) {
        NCObjectId taskScheduleId = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(SELECT_ID_BY_TASK_ID);
            NCObjectIdUtil.instance().setIntoStatement(taskId, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                taskScheduleId = NCObjectIdUtil.instance().createObjectId(rs, F_OID);
            }
            this.closeResources(rs, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_FINDING_A_TASK_SCHEDULE, null, (Map)ap);
                this.closeResources(rs, ps);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
        return taskScheduleId;
    }

    static ITaskSchedule readResultSetIntoObject(ResultSet rs) throws SQLException, DTException {
        NCObjectId taskScheduleId = NCObjectIdUtil.instance().createObjectId(rs, F_OID);
        String objectName = rs.getString(F_NAME);
        int runRequirements = rs.getInt(F_RUN_REQUIREMENTS);
        String dummyStr = rs.getString(F_LAST_EXECUTION_AT);
        Date lastExecution = null;
        if (!rs.wasNull()) {
            long last_execution = 0L;
            try {
                last_execution = MiscUtil.convertStringToLong(dummyStr);
            }
            catch (ParseException parse_exception) {
                AuditProperties ap = AuditPropUtil.doProps(JDBCDhTaskScheduleImpl.class, (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)parse_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_READ_RS_ERROR, (Map)ap);
                throw new DTException(I18NCode.SQL_READ_RS_ERROR);
            }
            lastExecution = new Date(last_execution);
        }
        dummyStr = rs.getString(F_NEXT_EXECUTION_REQUEST);
        Date nextExecution = null;
        if (!rs.wasNull()) {
            long next_execution = 0L;
            try {
                next_execution = MiscUtil.convertStringToLong(dummyStr);
            }
            catch (ParseException parse_exception) {
                AuditProperties ap = AuditPropUtil.doProps(JDBCDhTaskScheduleImpl.class, (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)parse_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_READ_RS_ERROR, (Map)ap);
                throw new DTException(I18NCode.SQL_READ_RS_ERROR);
            }
            nextExecution = new Date(next_execution);
        }
        NCObjectId taskId = NCObjectIdUtil.instance().createObjectId(rs, F_TASK_ID);
        dummyStr = rs.getString(F_SCHEDULE_DELAY);
        long schedule_delay = 0L;
        try {
            schedule_delay = MiscUtil.convertStringToLong(dummyStr);
        }
        catch (ParseException parse_exception) {
            AuditProperties ap = AuditPropUtil.doProps(JDBCDhTaskScheduleImpl.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)parse_exception);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_READ_RS_ERROR, (Map)ap);
            throw new DTException(I18NCode.SQL_READ_RS_ERROR);
        }
        int deleteAfterLastRunInt = rs.getInt(F_DELETE_AFTER_LAST_RUN);
        boolean deleteAfterLastRun = MiscUtil.getBoolean(deleteAfterLastRunInt);
        int priority = rs.getInt(F_PRIORITY);
        String ownerStoreID = rs.getString(F_SCHEDULED_BY);
        String tenantID = rs.getString(F_TENANT_ID);
        TaskScheduleImpl taskSchedule = new TaskScheduleImpl(runRequirements, lastExecution, nextExecution, schedule_delay);
        taskSchedule.setNCObjectId(taskScheduleId);
        taskSchedule.setTaskId(taskId);
        taskSchedule.setName(objectName);
        taskSchedule.setDeleteAfterLastRun(deleteAfterLastRun);
        taskSchedule.setPriority(priority);
        taskSchedule.setOwnerStoreID(ownerStoreID);
        taskSchedule.setTenantID(tenantID);
        return taskSchedule;
    }

    private void removeScheduleLinks(Connection conn, ITaskSchedule taskSchedule, Principal user) throws DTException {
        ScheduleLink[] links = taskSchedule.getScheduleLinks();
        if (null != links) {
            this.m_scheduleLinkHelper.removeLinks(conn, taskSchedule, user);
        }
    }

    private void removeScheduleLinks(Connection conn, NCObjectId taskScheduleId, Principal user) throws DTException {
        this.m_scheduleLinkHelper.removeLinks(conn, taskScheduleId, user);
    }

    private void storeScheduleLinks(Connection conn, ITaskSchedule taskSchedule, Principal user) throws DTException {
        ScheduleLink[] scheduleLinks = taskSchedule.getScheduleLinks();
        if (null != scheduleLinks) {
            for (int i = 0; i < scheduleLinks.length; ++i) {
                this.m_scheduleLinkHelper.storeLink(conn, taskSchedule, scheduleLinks[i], user);
            }
        }
    }

    private void closeResources(ResultSet rs, Statement statement) {
        try {
            if (null != rs) {
                rs.close();
                rs = null;
            }
            if (null != statement) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user, HelperOption option) throws DTException {
        Collection task_schedule_list = this.getObjectList(connection, option, false);
        return task_schedule_list.iterator();
    }

    @Override
    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(Connection conn, HelperOption option) throws DTException {
        Collection updatableList = this.getObjectList(conn, option, true);
        INCObjectUpdate[] arrayList = new INCObjectUpdate[updatableList.size()];
        updatableList.toArray(arrayList);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection getObjectList(Connection connection, HelperOption helperOption, boolean isUpdatableList) throws DTException {
        ArrayList<NCObjectUpdateImpl> arrayList;
        String select_statement = "SELECT PK_TASKSCHEDULE_ID, NAME, DESCRIPTION, MODCOUNT, RUN_REQUIREMENTS, LAST_EXECUTION_AT, NEXT_EXECUTION_REQUEST, FK_TASK_ID, SCHEDULE_DELAY, DELETE_AFTER_LAST_RUN, PRIORITY, SCHEDULED_BY, TENANT_ID FROM NC_TASKSCHEDULE";
        String[] selectStatements = null;
        if (!HelperType.FULL.equals(helperOption.getHelperType()) || !NCObjectType.TASK_SCHEDULE.equals(helperOption.getNCObjectType())) {
            selectStatements = new String[]{select_statement};
        } else {
            String[] option_strings = helperOption.getOptionStrings();
            selectStatements = new String[option_strings.length];
            for (int i = 0; i < selectStatements.length; ++i) {
                selectStatements[i] = select_statement + (!option_strings[i].equals("") ? " WHERE " + option_strings[i] : "");
            }
        }
        ResultSet result_set = null;
        Statement statement = null;
        ArrayList<ITaskSchedule> taskScheduleList = new ArrayList<ITaskSchedule>();
        ArrayList<NCObjectUpdateImpl> updatableTaskScheduleList = new ArrayList<NCObjectUpdateImpl>();
        try {
            for (int i = 0; i < selectStatements.length; ++i) {
                statement = connection.createStatement();
                if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                    statement.setFetchSize(JDBCConnectionProperties.instance((String)"SDS").getFetchSize());
                }
                result_set = statement.executeQuery(selectStatements[i]);
                while (result_set.next()) {
                    ITaskSchedule task_schedule = JDBCDhTaskScheduleImpl.readResultSetIntoObject(result_set);
                    taskScheduleList.add(task_schedule);
                    if (!isUpdatableList) continue;
                    int updateStamp = result_set.getInt(F_MODCOUNT);
                    updatableTaskScheduleList.add(new NCObjectUpdateImpl(task_schedule, NCObjectType.TASK_SCHEDULE, updateStamp));
                }
            }
            ITaskSchedule[] taskSchedules = new ITaskSchedule[taskScheduleList.size()];
            taskScheduleList.toArray(taskSchedules);
            this.m_scheduleLinkHelper.addLinks(connection, taskSchedules);
            this.m_overrideDatesDataHelper.populateOverrideDates(connection, taskSchedules);
            this.closeResources(result_set, statement);
        }
        catch (SQLException sql_exception) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sql_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_GETOBJECTLIST, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_GETOBJECTLIST);
                catch (LocalizableException ex) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NOT_FOUND, (Map)ap);
                    throw new DTException(I18NCode.PERST_OBJECT_NOT_FOUND, ex);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(result_set, statement);
                throw throwable;
            }
        }
        if (isUpdatableList) {
            arrayList = updatableTaskScheduleList;
            return arrayList;
        }
        arrayList = taskScheduleList;
        return arrayList;
    }
}

