/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.scheduling;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.SQLParserUtils;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import noticecast.accesscontrol.CMVersion;
import noticecast.datatier.DTException;
import noticecast.datatier.MiscUtil;
import noticecast.datatier.scheduling.JDBCDhScheduleImpl;
import noticecast.exceptions.NCException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.NCObjectTypeException;
import noticecast.logictier.base.INCBaseObject;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.base.NCFeatherWeightImpl;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.ScheduleLink;
import noticecast.services.RepositoryServicesImpl;

public class JDBCDhTaskScheduleLinkHelper {
    private static final String T_TASKSCHEDULE_SCHEDULE = "R_TASKSCHEDULE_SCHEDULE";
    private static final String F_TSS_TASKSCHEDULE_ID = "FK_TASKSCHEDULE_ID";
    private static final String F_TSS_SCHEDULE_ID = "FK_SCHEDULE_ID";
    private static final String F_TSS_IS_ACTIVE = "IS_ACTIVE";
    private static final String F_TSS_IS_ESCALATION = "IS_ESCALATION";
    private static final String Q_F_TSS_TASKSCHEDULE_ID = "R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID";
    private static final String Q_F_TSS_SCHEDULE_ID = "R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID";
    private static final String Q_F_TSS_IS_ACTIVE = "R_TASKSCHEDULE_SCHEDULE.IS_ACTIVE";
    private static final String Q_F_TSS_IS_ESCALATION = "R_TASKSCHEDULE_SCHEDULE.IS_ESCALATION";
    private static final String T_OBJCAT = "NC_OBJECTCATALOGUE";
    private static final String F_OC_OBJECT_ID = "PK_OID";
    private static final String F_OC_NAME = "NAME";
    private static final String F_OC_DESCRIPTION = "DESCRIPTION";
    private static final String F_OC_TYPE = "TYPE";
    private static final String F_OC_SUBTYPE = "SUBTYPE";
    private static final String F_OC_MODCOUNT = "MODCOUNT";
    private static final String F_OC_CM_VERSION = "CM_VERSION";
    private static final String Q_F_OC_OBJECT_ID = "NC_OBJECTCATALOGUE.PK_OID";
    private static final String Q_F_OC_NAME = "NC_OBJECTCATALOGUE.NAME";
    private static final String Q_F_OC_DESCRIPTION = "NC_OBJECTCATALOGUE.DESCRIPTION";
    private static final String Q_F_OC_TYPE = "NC_OBJECTCATALOGUE.TYPE";
    private static final String Q_F_OC_SUBTYPE = "NC_OBJECTCATALOGUE.SUBTYPE";
    private static final String Q_F_OC_MODCOUNT = "NC_OBJECTCATALOGUE.MODCOUNT";
    private static final String Q_F_OC_CM_VERSION = "NC_OBJECTCATALOGUE.CM_VERSION";
    private static final String GET_LINKS = "SELECT R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID, R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID, R_TASKSCHEDULE_SCHEDULE.IS_ACTIVE, R_TASKSCHEDULE_SCHEDULE.IS_ESCALATION, NC_OBJECTCATALOGUE.PK_OID, NC_OBJECTCATALOGUE.NAME, NC_OBJECTCATALOGUE.DESCRIPTION, NC_OBJECTCATALOGUE.TYPE, NC_OBJECTCATALOGUE.SUBTYPE, NC_OBJECTCATALOGUE.MODCOUNT, NC_OBJECTCATALOGUE.CM_VERSION FROM R_TASKSCHEDULE_SCHEDULE, NC_OBJECTCATALOGUE WHERE R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID = NC_OBJECTCATALOGUE.PK_OID";
    private static final String GET_LINKS_BY_TASKSCHEDULE_ID_STATEMENT = "SELECT R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID, R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID, R_TASKSCHEDULE_SCHEDULE.IS_ACTIVE, R_TASKSCHEDULE_SCHEDULE.IS_ESCALATION, NC_OBJECTCATALOGUE.PK_OID, NC_OBJECTCATALOGUE.NAME, NC_OBJECTCATALOGUE.DESCRIPTION, NC_OBJECTCATALOGUE.TYPE, NC_OBJECTCATALOGUE.SUBTYPE, NC_OBJECTCATALOGUE.MODCOUNT, NC_OBJECTCATALOGUE.CM_VERSION FROM R_TASKSCHEDULE_SCHEDULE, NC_OBJECTCATALOGUE WHERE R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID = ? AND R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID = NC_OBJECTCATALOGUE.PK_OID";
    private static final String INSERT_STATEMENT = "INSERT INTO R_TASKSCHEDULE_SCHEDULE ( FK_TASKSCHEDULE_ID, FK_SCHEDULE_ID, IS_ACTIVE, IS_ESCALATION) VALUES (?, ?, ?, ?)";
    private static final String DELETE_STATEMENT = "DELETE FROM R_TASKSCHEDULE_SCHEDULE WHERE FK_TASKSCHEDULE_ID = ?";

    public void storeLink(Connection conn, INCBaseObject taskSchedule, ScheduleLink scheduleLink, Principal user) throws DTException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(INSERT_STATEMENT);
            NCObjectId taskScheduleId = taskSchedule.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            NCObjectId scheduleId = scheduleLink.getScheduleId();
            NCObjectIdUtil.instance().setIntoStatement(scheduleId, 2, ps);
            boolean isActive = scheduleLink.isActive();
            ps.setInt(3, MiscUtil.getInt(isActive));
            boolean isEscalation = scheduleLink.isEscalation();
            ps.setInt(4, MiscUtil.getInt(isEscalation));
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                String errMsg = "Entry was not updated. It may have been updated by another user.";
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{errMsg, NCObjectType.TASK_SCHEDULE.toString(), T_TASKSCHEDULE_SCHEDULE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, T_TASKSCHEDULE_SCHEDULE});
            }
            if (nUpdated > 1) {
                String errMsg = "TaskSchedule object is not unique";
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{errMsg, NCObjectType.TASK_SCHEDULE.toString(), T_TASKSCHEDULE_SCHEDULE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, T_TASKSCHEDULE_SCHEDULE});
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT);
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    public ScheduleLink[] getLinks(Connection conn, INCBaseObject taskSchedule) throws DTException {
        return this.getLinks(conn, taskSchedule.getNCObjectId());
    }

    public ScheduleLink[] getLinks(Connection conn, NCObjectId taskScheduleId) throws DTException {
        boolean nObjectFound = false;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ArrayList<ScheduleLink> scheduleLinks = new ArrayList<ScheduleLink>();
            ps = conn.prepareStatement(GET_LINKS_BY_TASKSCHEDULE_ID_STATEMENT);
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            rs = ps.executeQuery();
            ScheduleLink scheduleLink = null;
            while (rs.next()) {
                NCObjectId scheduleId = NCObjectIdUtil.instance().createObjectId(rs, F_TSS_SCHEDULE_ID);
                int isActiveInt = rs.getInt(F_TSS_IS_ACTIVE);
                boolean isActive = MiscUtil.getBoolean(isActiveInt);
                int isEscalationInt = rs.getInt(F_TSS_IS_ESCALATION);
                boolean isEscalation = MiscUtil.getBoolean(isEscalationInt);
                INCFeatherWeight scheduleFeatherWeight = this.getScheduleFeatherWeight(rs);
                scheduleLink = new ScheduleLink(scheduleFeatherWeight, isActive, isEscalation);
                scheduleLinks.add(scheduleLink);
            }
            ScheduleLink[] linkArray = new ScheduleLink[scheduleLinks.size()];
            scheduleLinks.toArray(linkArray);
            ScheduleLink[] scheduleLinkArray = linkArray;
            this.closeResources(rs, ps);
            return scheduleLinkArray;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_OBJECT_B, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_OBJECT_B);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCObjectId[] safelyDeleteAllLinksAndSchedules(Connection conn, NCObjectId taskScheduleId) throws SQLException {
        ScheduleLink[] links = new ScheduleLink[]{};
        if (taskScheduleId == null) {
            return new NCObjectId[0];
        }
        try {
            links = this.getLinks(conn, taskScheduleId);
        }
        catch (DTException dTException) {
            // empty catch block
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(DELETE_STATEMENT);
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            ps.executeUpdate();
        }
        finally {
            this.closeResources(null, ps);
        }
        ArrayList<NCObjectId> ids = new ArrayList<NCObjectId>();
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            JDBCDhScheduleImpl dataHelper = (JDBCDhScheduleImpl)pm.getDataHelper(NCObjectType.SCHEDULE);
            for (int i = 0; i < links.length; ++i) {
                ids.add(links[i].getScheduleId());
                dataHelper.safelyDelete(conn, links[i].getScheduleId());
            }
        }
        catch (PersistManagerException persistManagerException) {
            // empty catch block
        }
        return ids.toArray(new NCObjectId[0]);
    }

    public void removeLinks(Connection conn, NCObjectId id, Principal user) throws DTException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(DELETE_STATEMENT);
            NCObjectId taskScheduleId = id;
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{id.toString(), T_TASKSCHEDULE_SCHEDULE}, (Map)ap);
            throw new DTException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{id, T_TASKSCHEDULE_SCHEDULE});
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    public void removeLinks(Connection conn, INCBaseObject object, Principal user) throws DTException {
        this.removeLinks(conn, object.getNCObjectId(), user);
    }

    private void closeResources(ResultSet rs, Statement statement) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != statement) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
    }

    public void addLinks(Connection conn, ITaskSchedule[] taskSchedules) throws DTException {
        HashMap<String, ITaskSchedule> tsByIdMap = new HashMap<String, ITaskSchedule>();
        String[] ids = new String[taskSchedules.length];
        for (int i = 0; i < taskSchedules.length; ++i) {
            ids[i] = taskSchedules[i].getNCObjectId().toString();
            tsByIdMap.put(ids[i], taskSchedules[i]);
        }
        boolean quoteStrings = false;
        String[] inClauses = SQLParserUtils.createInClauses((String[])ids, (boolean)quoteStrings);
        Statement statement = null;
        ResultSet rs = null;
        String sqlStatement = null;
        String tsIdString = null;
        try {
            ScheduleLink scheduleLink = null;
            ITaskSchedule ts = null;
            statement = conn.createStatement();
            for (int i = 0; i < inClauses.length; ++i) {
                sqlStatement = "SELECT R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID, R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID, R_TASKSCHEDULE_SCHEDULE.IS_ACTIVE, R_TASKSCHEDULE_SCHEDULE.IS_ESCALATION, NC_OBJECTCATALOGUE.PK_OID, NC_OBJECTCATALOGUE.NAME, NC_OBJECTCATALOGUE.DESCRIPTION, NC_OBJECTCATALOGUE.TYPE, NC_OBJECTCATALOGUE.SUBTYPE, NC_OBJECTCATALOGUE.MODCOUNT, NC_OBJECTCATALOGUE.CM_VERSION FROM R_TASKSCHEDULE_SCHEDULE, NC_OBJECTCATALOGUE WHERE R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID = NC_OBJECTCATALOGUE.PK_OID AND R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID " + inClauses[i];
                rs = statement.executeQuery(sqlStatement);
                while (rs.next()) {
                    tsIdString = rs.getString(F_TSS_TASKSCHEDULE_ID);
                    try {
                        scheduleLink = this.readScheduleLink(rs);
                    }
                    catch (DTException e1) {
                        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_READ_RS_ERROR, (Map)ap);
                    }
                    if (scheduleLink == null) continue;
                    ts = (ITaskSchedule)tsByIdMap.get(tsIdString);
                    ts.addScheduleLink(scheduleLink);
                    scheduleLink = null;
                }
            }
            this.closeResources(rs, statement);
        }
        catch (SQLException e) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK_SCHEDULE.toString(), T_TASKSCHEDULE_SCHEDULE}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK_SCHEDULE, T_TASKSCHEDULE_SCHEDULE});
            }
            catch (Throwable throwable) {
                this.closeResources(rs, statement);
                throw throwable;
            }
        }
    }

    private ScheduleLink readScheduleLink(ResultSet rs) throws DTException {
        try {
            NCObjectId scheduleId = NCObjectIdUtil.instance().createObjectId(rs, F_TSS_SCHEDULE_ID);
            int isActiveInt = rs.getInt(F_TSS_IS_ACTIVE);
            boolean isActive = MiscUtil.getBoolean(isActiveInt);
            int isEscalationInt = rs.getInt(F_TSS_IS_ESCALATION);
            boolean isEscalation = MiscUtil.getBoolean(isEscalationInt);
            INCFeatherWeight scheduleFeatherWeight = this.getScheduleFeatherWeight(rs);
            return new ScheduleLink(scheduleFeatherWeight, isActive, isEscalation);
        }
        catch (SQLException e) {
            throw new DTException(I18NCode.SQL_READ_RS_ERROR);
        }
    }

    private INCFeatherWeight getScheduleFeatherWeight(ResultSet rs) throws DTException {
        String type = null;
        try {
            NCObjectId oid = NCObjectIdUtil.instance().createObjectId(rs, F_OC_OBJECT_ID);
            String name = rs.getString(F_OC_NAME);
            String desc = rs.getString(F_OC_DESCRIPTION);
            type = rs.getString(F_OC_TYPE);
            int version = rs.getInt(F_OC_CM_VERSION);
            NCObjectType objType = NCObjectType.valueOf(type);
            return new NCFeatherWeightImpl(objType, oid, name, desc, new CMVersion(version));
        }
        catch (NCObjectTypeException e) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJ_FAILED_FOR_TYPE, (Object[])new String[]{type}, (Map)ap);
            throw new DTException(I18NCode.MSG_OBJ_FAILED_FOR_TYPE, new Object[]{type}, e);
        }
        catch (NCException e) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJ_FAILED_FOR_TYPE, (Object[])new String[]{type}, (Map)ap);
            throw new DTException(I18NCode.MSG_OBJ_FAILED_FOR_TYPE, new Object[]{type}, e);
        }
        catch (SQLException e) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_READ_RS_ERROR, (Object[])new String[]{type}, (Map)ap);
            throw new DTException(I18NCode.SQL_READ_RS_ERROR);
        }
    }
}

