/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.scheduling;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.IEventId;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleEventOverrideDetails;

public class JDBCDhTaskScheduleUtil {
    private JDBCDhTaskScheduleUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSuspendedCount() {
        int count = 0;
        AbstractFactory cf = null;
        JDBCConnection conn = null;
        try {
            cf = NCConnection.instance().getConnectionFactory();
            conn = cf.createReadOnlyConnection();
            JDBCDhTaskScheduleEventOverrideDetails overridesDh = new JDBCDhTaskScheduleEventOverrideDetails();
            count = overridesDh.getCountByStatus((Connection)conn, EventStatus.SUSPENDED);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)ex);
        }
        finally {
            if (conn != null && cf != null) {
                try {
                    cf.releaseConnection(conn);
                }
                catch (SQLException e) {
                    AuditProperties ap = AuditPropUtil.doProps(JDBCDhTaskScheduleUtil.class, (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage());
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SQL_RELEASE_ERROR, (Map)ap);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NCObjectId[] getTaskScheduleIdsForSuspendedEvents() {
        NCObjectId[] taskScheduleIds = null;
        AbstractFactory cf = null;
        JDBCConnection conn = null;
        try {
            cf = NCConnection.instance().getConnectionFactory();
            conn = cf.createReadOnlyConnection();
            JDBCDhTaskScheduleEventOverrideDetails overridesDh = new JDBCDhTaskScheduleEventOverrideDetails();
            taskScheduleIds = overridesDh.getTaskScheduleIdsByStatus((Connection)conn, EventStatus.SUSPENDED);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)ex);
        }
        finally {
            if (conn != null && cf != null) {
                try {
                    cf.releaseConnection(conn);
                }
                catch (SQLException e) {
                    AuditProperties ap = AuditPropUtil.doProps(JDBCDhTaskScheduleUtil.class, (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage());
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SQL_RELEASE_ERROR, (Map)ap);
                }
            }
        }
        return taskScheduleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event getOverrideEvent(IEventId eventId) {
        Event event = null;
        AbstractFactory cf = null;
        JDBCConnection conn = null;
        try {
            cf = NCConnection.instance().getConnectionFactory();
            conn = cf.createReadOnlyConnection();
            JDBCDhTaskScheduleEventOverrideDetails overridesDh = new JDBCDhTaskScheduleEventOverrideDetails();
            event = overridesDh.getOverrideEvent((Connection)conn, eventId);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)ex);
        }
        finally {
            if (conn != null && cf != null) {
                try {
                    cf.releaseConnection(conn);
                }
                catch (SQLException e) {
                    AuditProperties ap = AuditPropUtil.doProps(JDBCDhTaskScheduleUtil.class, (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage());
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SQL_RELEASE_ERROR, (Map)ap);
                }
            }
        }
        return event;
    }

    public static boolean isOverrideEvent(IEventId eventId) {
        Event event = JDBCDhTaskScheduleUtil.getOverrideEvent(eventId);
        return event != null;
    }
}

