/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.scheduling;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import noticecast.datatier.DTException;
import noticecast.datatier.IJDBCLinkHelper;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObject;

public class JDBCDhTaskSchedule_ScheduleLinkHelper
implements IJDBCLinkHelper {
    private final String JDBC_TASKSCHEDULE_SCHEDULE_TABLE = "R_TASKSCHEDULE_SCHEDULE";
    protected final String F_TASKSCHEDULE_ID = "FK_TASKSCHEDULE_ID";
    protected final String F_SCHEDULE_ID = "FK_SCHEDULE_ID";
    protected final String SELECT_CLAUSE = "SELECT FK_TASKSCHEDULE_ID, FK_SCHEDULE_ID";

    @Override
    public void storeLink(Connection conn, INCBaseObject taskSchedule, INCBaseObject schedule, Principal user) throws DTException {
        String sqlStmt = "INSERT INTO R_TASKSCHEDULE_SCHEDULE ( FK_TASKSCHEDULE_ID, FK_SCHEDULE_ID) VALUES (?, ?)";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("INSERT INTO R_TASKSCHEDULE_SCHEDULE ( FK_TASKSCHEDULE_ID, FK_SCHEDULE_ID) VALUES (?, ?)");
            NCObjectId taskScheduleId = taskSchedule.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            NCObjectId scheduleId = schedule.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(scheduleId, 2, ps);
            int nUpdated = ps.executeUpdate();
            if (nUpdated < 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), "R_TASKSCHEDULE_SCHEDULE"}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, "R_TASKSCHEDULE_SCHEDULE"});
            }
            if (nUpdated > 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.SCHEDULE.toString(), "R_TASKSCHEDULE_SCHEDULE"}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.SCHEDULE, "R_TASKSCHEDULE_SCHEDULE"});
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_NEW_OBJECT);
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    @Override
    public NCObjectId[] getLinks(Connection conn, INCBaseObject taskSchedule) throws DTException {
        String selectStmt = "SELECT FK_TASKSCHEDULE_ID, FK_SCHEDULE_ID FROM R_TASKSCHEDULE_SCHEDULE  WHERE FK_TASKSCHEDULE_ID = ?";
        boolean nObjectFound = false;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            Vector<NCObjectId> scheduleIds = new Vector<NCObjectId>();
            ps = conn.prepareStatement("SELECT FK_TASKSCHEDULE_ID, FK_SCHEDULE_ID FROM R_TASKSCHEDULE_SCHEDULE  WHERE FK_TASKSCHEDULE_ID = ?");
            NCObjectId taskScheduleId = taskSchedule.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            rs = ps.executeQuery();
            while (rs.next()) {
                NCObjectId scheduleId = NCObjectIdUtil.instance().createObjectId(rs, "FK_SCHEDULE_ID");
                scheduleIds.addElement(scheduleId);
            }
            NCObjectId[] scheduleIdArray = new NCObjectId[]{};
            NCObjectId[] nCObjectIdArray = scheduleIdArray = scheduleIds.toArray(scheduleIdArray);
            this.closeResources(rs, ps);
            return nCObjectIdArray;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_NEW_LINK, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_IN_FINDING_NEW_LINK);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    @Override
    public void removeLinks(Connection conn, INCBaseObject object, Principal user) throws DTException {
        String sqlStmt = "DELETE FROM R_TASKSCHEDULE_SCHEDULE WHERE FK_TASKSCHEDULE_ID = ?";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("DELETE FROM R_TASKSCHEDULE_SCHEDULE WHERE FK_TASKSCHEDULE_ID = ?");
            NCObjectId taskScheduleId = object.getNCObjectId();
            NCObjectIdUtil.instance().setIntoStatement(taskScheduleId, 1, ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            String errMsg = "failed to remove links from task schedule link table";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{object.getNCObjectId().toString(), "R_TASKSCHEDULE_SCHEDULE"}, (Map)ap);
            throw new DTException(I18NCode.SQL_DELETE_OBJECT_IN_TABLE_ERROR, new Object[]{object.getNCObjectId(), "R_TASKSCHEDULE_SCHEDULE"});
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    private void closeResources(ResultSet rs, Statement statement) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != statement) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
    }
}

