/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.task;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import noticecast.datatier.DTException;
import noticecast.datatier.IJDBCEntityHelper;
import noticecast.datatier.IObjectViewPlus;
import noticecast.datatier.NCObjectStoreException;
import noticecast.datatier.SQLRepositoryException;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.message.IJDBCDhJDBCMessageStruct;
import noticecast.datatier.scheduling.IJDBCDhTaskSchedule;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleImpl;
import noticecast.datatier.task.JDBCRhTask;
import noticecast.debug.Debug;
import noticecast.exceptions.LogictierException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.AgentException;
import noticecast.logictier.agent.DetectionOption;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.agent.TaskImpl;
import noticecast.logictier.agent.TaskType;
import noticecast.logictier.base.INCBaseObject;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.IRecipientLink;
import noticecast.logictier.message.RecipientRetrieverImpl;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.IPersistManager;
import noticecast.persist.NCObjectUpdateImpl;
import noticecast.persist.PersistManagerException;
import noticecast.persist.StoreObjectException;
import noticecast.services.RepositoryServicesImpl;

public final class JDBCDhJDBCTask
implements IJDBCEntityHelper,
IObjectViewPlus {
    private final String JDBC_TASK_TABLE = "NC_TASK";
    private final String F_TASK_ID = "PK_TASK_ID";
    private final String F_NAME = "NAME";
    private final String F_DESCRIPTION = "DESCRIPTION";
    private final String F_MODCOUNT = "MODCOUNT";
    private final String F_THRESHOLD = "THRESHOLD";
    private final String F_BIE_LINK = "FK_BIE_ID";
    private final String F_WEIGHTS = "WEIGHTS";
    private final String F_TASK_TYPE = "TASK_TYPE";
    private final String F_DATEFORMAT = "DATEFORMAT";
    private final String F_DETECTION_OPTION = "DETECTION_OPTION";
    private final String F_LAST_MOD_TIME = "LASTMOD_TIME";
    private final String F_TYPE = "TYPE";
    private final String F_SUB_TYPE = "SUBTYPE";
    private final String F_LOCATION_ROOT = "LOCATION_ROOT";
    private final String F_OBJECT_CLASS = "OBJECT_CLASS";
    private final String F_OWNED_BY = "OWNED_BY";
    private JDBCRhTask mRelationBuilder = null;
    private IJDBCDhTaskSchedule mDhTaskSchedule = new JDBCDhTaskScheduleImpl();
    private IJDBCDhJDBCMessageStruct mDhMsgStructHelper = null;
    private String m_CLASS_NAME = "JDBCDhJDBCTask";
    String update_sql_string = "UPDATE NC_TASK SET NAME = ?, DESCRIPTION = ?, FK_BIE_ID = ?, THRESHOLD = ?, WEIGHTS = ?, TASK_TYPE = ?, DATEFORMAT = ?, DETECTION_OPTION = ?, OBJECT_CLASS = ?, OWNED_BY = ?, MODCOUNT = MODCOUNT + 1 WHERE PK_TASK_ID = ? AND MODCOUNT = ?";
    private final String store_new_statement = "INSERT INTO NC_TASK ( PK_TASK_ID, NAME, DESCRIPTION, FK_BIE_ID, THRESHOLD, WEIGHTS, TASK_TYPE, DATEFORMAT, DETECTION_OPTION, MODCOUNT, OBJECT_CLASS, OWNED_BY ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private String DELETE_STMT = "DELETE FROM NC_TASK WHERE PK_TASK_ID = ?";

    public JDBCDhJDBCTask() {
        this.mRelationBuilder = new JDBCRhTask(false);
    }

    public void shallowUpdateTask(Connection connection, ITask task, int modCount, Principal user) throws DTException {
        PreparedStatement prepared_statement = null;
        try {
            prepared_statement = connection.prepareStatement(this.update_sql_string);
            prepared_statement.setString(1, task.getName());
            prepared_statement.setString(2, task.getDescription());
            NCObjectIdUtil.instance().setIntoStatement(null, 3, prepared_statement);
            prepared_statement.setInt(4, task.getThreshold());
            prepared_statement.setString(5, this.generateWeightsString(task.getWeights()));
            prepared_statement.setInt(6, task.getTaskType().getIndex());
            prepared_statement.setString(7, "");
            prepared_statement.setInt(8, task.getDetectionOption().getOrdinal());
            prepared_statement.setString(9, task.getObjectClass());
            prepared_statement.setString(10, task.getOwner());
            NCObjectIdUtil.instance().setIntoStatement(task.getNCObjectId(), 11, prepared_statement);
            prepared_statement.setInt(12, modCount);
            int updatedRows = prepared_statement.executeUpdate();
            if (updatedRows != 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_NUMBER_OF_ROWS_UPDATED_IN_TASK_TABLE_ARE, (Object[])new String[]{Integer.toString(updatedRows)}, (Map)ap);
                throw new DTException(I18NCode.MSG_NUMBER_OF_ROWS_UPDATED_IN_TASK_TABLE_ARE, new Object[]{Integer.toString(updatedRows)});
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_UPDATE_TASK_ATTRIBUTES, (Object[])new String[]{task.getNCObjectId().toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_UPDATE_TASK_ATTRIBUTES, new Object[]{task.getNCObjectId()});
        }
        finally {
            SqlResourceCloser.closeResources(null, (Statement)prepared_statement);
        }
    }

    private void updateTask(Connection connection, ITask task, int modCount, Principal user) throws DTException {
        Statement prepared_statement = null;
        try {
            if (connection.isReadOnly()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_READONLY_CONNECTION_PASSESD_TO_DATA_HELP, (Map)ap);
                throw new DTException(I18NCode.MSG_READONLY_CONNECTION_PASSESD_TO_DATA_HELP);
            }
            this.shallowUpdateTask(connection, task, modCount, user);
            this.updateMessageStructs(connection, task, user);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_TAS, (Object[])new String[]{task.getNCObjectId().toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_EXCEPTION_CAUGHT_WHILE_STORING_A_TAS, new Object[]{task.getNCObjectId()});
        }
        finally {
            this.closeResources(null, prepared_statement);
        }
    }

    public void store(Connection connection, ITask task, Principal user) throws DTException {
        int modCount = 0;
        boolean shouldCloseConnection = false;
        NCObjectId taskId = task.getNCObjectId();
        String sqlStr = "SELECT MODCOUNT FROM NC_TASK WHERE PK_TASK_ID = " + taskId;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(sqlStr);
            if (!rs.next()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, (Object[])new String[]{task.getName(), taskId.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, new Object[]{task.getName(), taskId});
            }
            modCount = rs.getInt(1);
            this.closeResources(rs, stmt);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, (Object[])new String[]{task.getName(), taskId.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, new Object[]{task.getName(), taskId});
            }
            catch (Throwable throwable) {
                this.closeResources(rs, stmt);
                throw throwable;
            }
        }
        this.updateTask(connection, task, modCount, user);
    }

    @Override
    public void store(Connection connection, INCObjectUpdate object_update, Principal user) throws DTException {
        this.checkForNull(connection, I18NCode.MSG_CONNECTION_OBJECT_PASSED_TO_AGENT_TASK);
        this.checkForNull(object_update, I18NCode.MSG_UPDATE_OBJECT_IS_NULL);
        INCBaseObject localObject = object_update.getObject();
        if (!(localObject instanceof ITask)) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_LOCALOBJECT_CANNOT_BE_CAST_TO, (Object[])new String[]{localObject.getClass().getName()}, (Map)ap);
            throw new DTException(I18NCode.MSG_LOCALOBJECT_CANNOT_BE_CAST_TO, new Object[]{localObject.getClass().getName()});
        }
        ITask task = (ITask)localObject;
        int modCount = object_update.getStamp();
        this.updateTask(connection, task, modCount, user);
    }

    private String generateWeightsString(Iterator weights) {
        StringBuffer theWeights = new StringBuffer();
        if (weights != null) {
            while (weights.hasNext()) {
                theWeights.append(weights.next().toString());
                theWeights.append(';');
            }
        }
        return theWeights.toString();
    }

    private Collection generateWeightsCollection(String weights) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (weights != null) {
            StringTokenizer weightTokens = new StringTokenizer(weights, "; ", false);
            String oneToken = null;
            Integer oneWeight = null;
            while (weightTokens.hasMoreTokens()) {
                oneToken = weightTokens.nextToken();
                try {
                    oneWeight = Integer.valueOf(oneToken);
                }
                catch (NumberFormatException ex) {
                    String errMsg = "Failed to convert " + oneToken + " to an integer.";
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, null, (Object[])new String[]{errMsg}, (Map)ap);
                }
                result.add(oneWeight);
            }
        }
        return result;
    }

    @Override
    public void storeNew(Connection connection, INCBaseObjectConsumer object, Principal user) throws DTException {
        PreparedStatement prepared_statement = null;
        ITask task = (ITask)object;
        try {
            prepared_statement = connection.prepareStatement("INSERT INTO NC_TASK ( PK_TASK_ID, NAME, DESCRIPTION, FK_BIE_ID, THRESHOLD, WEIGHTS, TASK_TYPE, DATEFORMAT, DETECTION_OPTION, MODCOUNT, OBJECT_CLASS, OWNED_BY ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            NCObjectIdUtil.instance().setIntoStatement(task.getNCObjectId(), 1, prepared_statement);
            prepared_statement.setString(2, task.getName());
            prepared_statement.setString(3, task.getDescription());
            NCObjectIdUtil.instance().setIntoStatement(null, 4, prepared_statement);
            prepared_statement.setInt(5, task.getThreshold());
            prepared_statement.setString(6, this.generateWeightsString(task.getWeights()));
            prepared_statement.setInt(7, task.getTaskType().getIndex());
            prepared_statement.setNull(8, 1);
            prepared_statement.setInt(9, task.getDetectionOption().getOrdinal());
            prepared_statement.setInt(10, 1);
            prepared_statement.setString(11, task.getObjectClass());
            prepared_statement.setString(12, task.getOwner());
            int inserted_rows = prepared_statement.executeUpdate();
            if (inserted_rows != 1) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, (Object[])new String[]{NCObjectType.TASK.toString(), "NC_TASK"}, (Map)ap);
                throw new DTException(I18NCode.SQL_STORE_OBJECT_IN_TABLE_ERROR, new Object[]{NCObjectType.TASK, "NC_TASK"});
            }
            Iterator messageStructs = task.getMessages();
            IMessageStruct messageStruct = null;
            Object oneElement = null;
            while (messageStructs.hasNext()) {
                oneElement = messageStructs.next();
                if (!(oneElement instanceof IMessageStruct)) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_TYPE_IS_AND_NOT, (Object[])new String[]{messageStruct.getName()}, (Map)ap);
                    throw new DTException(I18NCode.MSG_OBJECT_TYPE_IS_AND_NOT, new Object[]{oneElement.getClass().getName()});
                }
                messageStruct = (IMessageStruct)oneElement;
                try {
                    IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
                    pm.storeNew(messageStruct, NCObjectType.MESSAGE_STRUCT, NCObjectType.MESSAGE_STRUCT, connection, null);
                }
                catch (StoreObjectException e) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)e);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_TO_STORE_THE_MESSAGE_STRUCT, (Map)ap);
                    throw new DTException(I18NCode.MSG_UNABLE_TO_STORE_THE_MESSAGE_STRUCT, e);
                }
            }
            this.linkToMessageStructs(connection, task.getNCObjectId(), task.getMessages());
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_STORE_TASK_ATTRIBUTES, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_STORE_TASK_ATTRIBUTES);
        }
        finally {
            this.closeResources(null, prepared_statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteTaskAndRecipients(Connection connection, NCObjectId object_id) throws DTException {
        PreparedStatement ps = null;
        try {
            this.getRelationHelper().unlinkTaskAndDeleteMessageStructAndLinkedRecipients(connection, object_id);
            this.getRelationHelper().unlinkTaskSchedule(connection, object_id);
            StringBuffer deleteInfo = new StringBuffer();
            ps = connection.prepareStatement(this.DELETE_STMT);
            NCObjectIdUtil.instance().setIntoStatement(object_id, 1, ps);
            int deletedTaskRecords = ps.executeUpdate();
            deleteInfo.append(Integer.toString(deletedTaskRecords) + " records are deleted from task repository");
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Success");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, (Object[])new String[]{deleteInfo.toString()}, (Map)ap);
            this.closeResources(null, ps);
            return;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_DELETE_TASK, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_DELETE_TASK);
                catch (PersistManagerException ex2) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)((Object)ex2));
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_DELETE_TASK, (Map)ap);
                    throw new DTException(I18NCode.MSG_FAILED_TO_DELETE_TASK);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(null, ps);
                throw throwable;
            }
        }
    }

    @Override
    public void delete(Connection connection, NCObjectId object_id, Principal user) throws DTException {
        this.checkForNull(object_id, I18NCode.MSG_OBJECT_ID_IS_NULL);
        PreparedStatement ps = null;
        try {
            this.getRelationHelper().unlinkTaskAndDeleteMessageStruct(connection, object_id);
            this.getRelationHelper().unlinkTaskSchedule(connection, object_id);
            StringBuffer deleteInfo = new StringBuffer();
            ps = connection.prepareStatement(this.DELETE_STMT);
            NCObjectIdUtil.instance().setIntoStatement(object_id, 1, ps);
            int deletedTaskRecords = ps.executeUpdate();
            deleteInfo.append(Integer.toString(deletedTaskRecords) + " records are deleted from task repository");
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Success");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, (Object[])new String[]{deleteInfo.toString()}, (Map)ap);
            this.closeResources(null, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_DELETE_TASK, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_DELETE_TASK);
            }
            catch (Throwable throwable) {
                this.closeResources(null, ps);
                throw throwable;
            }
        }
    }

    @Override
    public INCObjectUpdate findByOid(Connection connection, NCObjectId object_id, Principal principal) throws DTException {
        NCObjectUpdateImpl result = null;
        ModCountHolder modCount = new ModCountHolder();
        ITask localObject = this.findTaskByOid(connection, object_id, modCount);
        if (localObject == null) {
            return null;
        }
        try {
            result = new NCObjectUpdateImpl(localObject, NCObjectType.AGENT, modCount.getModCount());
        }
        catch (LogictierException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)((Object)ex));
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_GENERATE_OBJECT_UPDATE_FOR_TAS, (Object[])new String[]{object_id.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_GENERATE_OBJECT_UPDATE_FOR_TAS);
        }
        return result;
    }

    @Override
    public Iterator findByName(Connection connection, String name) throws DTException {
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_UNSUPPORTED_OPERATION, (Map)ap);
        throw new DTException(I18NCode.OTH_UNSUPPORTED_OPERATION);
    }

    @Override
    public Iterator findByDescription(Connection connection, String description) throws DTException {
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_UNSUPPORTED_OPERATION, (Map)ap);
        throw new DTException(I18NCode.OTH_UNSUPPORTED_OPERATION);
    }

    private void addLinks(Connection connection, ITask task, List messageStructs) throws SQLException, DTException {
        NCObjectId oneId2 = null;
        IPersistManager thePM = RepositoryServicesImpl.instance().getPersistManager();
        this.checkForNull(thePM, I18NCode.MSG_FAILED_TO_GET_PERSISTMANAGER);
        IMessageStruct oneMsgStruct = null;
        for (NCObjectId oneId2 : messageStructs) {
            try {
                oneMsgStruct = (IMessageStruct)thePM.findNCObjectConsumerCopyByOid(oneId2, NCObjectType.MESSAGE_STRUCT);
                task.addMessage(oneMsgStruct);
            }
            catch (PersistManagerException ex) {
                String errMsg = "failed to get message struct with id, " + oneId2 + " for task, " + task.getName();
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_MESSAGE_STRUCT_NOTFOUND, (Object[])new String[]{oneId2.toString()}, (Map)ap);
            }
        }
    }

    private ITask readTask(ResultSet rs, ModCountHolder modCountHolder) throws SQLException, AgentException, DTException {
        TaskImpl task = null;
        NCObjectId taskId = NCObjectIdUtil.instance().createObjectId(rs, 1);
        this.checkForNull(taskId, I18NCode.MSG_RETRIEVED_TASK_ID_IS_NULL);
        String taskName = rs.getString(2);
        String taskDescription = rs.getString(3);
        task = new TaskImpl(taskId, taskName, taskDescription);
        NCObjectType agentType = NCObjectType.valueOf(rs, 4);
        NCObjectType agentSubType = NCObjectType.valueOf(rs, 5);
        if (!NCObjectType.UNKNOWN.equals(agentSubType)) {
            task.setAgentSubType(agentSubType);
        } else if (!NCObjectType.UNKNOWN.equals(agentType)) {
            task.setAgentSubType(agentType);
        } else {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_NEITHER_AGENT_TYPE_NOR_SUB_TYPE_IS_DEFIN, (Object[])new String[]{taskId.toString()}, (Map)ap);
            throw new DTException(I18NCode.MSG_NEITHER_AGENT_TYPE_NOR_SUB_TYPE_IS_DEFIN, new Object[]{taskId});
        }
        int threshold = rs.getInt(6);
        task.setThreshold(new Integer(threshold));
        String weightsStr = rs.getString(7);
        Collection taskWeights = this.generateWeightsCollection(weightsStr);
        task.setWeights(new Vector(taskWeights));
        int taskTypeIndex = rs.getInt(8);
        TaskType taskType = TaskType.get(taskTypeIndex);
        task.setTaskType(taskType);
        String datePattern = rs.getString(9);
        int detectionOptionOrdinal = rs.getInt(10);
        DetectionOption detectionOption = DetectionOption.get(detectionOptionOrdinal);
        task.setDetectionOption(detectionOption);
        int modCount = rs.getInt(11);
        if (modCountHolder != null) {
            modCountHolder.setModCount(modCount);
        }
        task.setObjectClass(rs.getString(12));
        task.setOwner(rs.getString(13));
        return task;
    }

    @Override
    public INCBaseObjectConsumer findCopyByOid(Connection connection, NCObjectId objectId, Principal principal) throws DTException {
        return this.findTaskByOid(connection, objectId, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITask findTaskByOid(Connection connection, NCObjectId taskId, ModCountHolder modCountHolder) throws DTException {
        ITask task = null;
        this.checkForNull(connection, I18NCode.MSG_CONNECTION_OBJECT_IS_NULL);
        this.checkForNull(taskId, I18NCode.MSG_OBJECT_IS_NULL);
        String sqlStr = "SELECT PK_TASK_ID, NC_TASK.NAME, NC_TASK.DESCRIPTION, TYPE, SUBTYPE, THRESHOLD, WEIGHTS, TASK_TYPE, DATEFORMAT, DETECTION_OPTION, NC_TASK.MODCOUNT, OBJECT_CLASS, OWNED_BY, FK_MESSAGESTRUCT_ID, LASTMOD_TIME FROM NC_TASK, R_MESSAGESTRUCT_TASK, NC_OBJECTCATALOGUE  WHERE PK_TASK_ID = PK_OID AND PK_TASK_ID = FK_TASK_ID AND PK_TASK_ID = ? ";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(sqlStr);
            NCObjectIdUtil.instance().setIntoStatement(taskId, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                task = this.readTask(rs, modCountHolder);
                NCObjectId messageStructId = null;
                ArrayList<NCObjectId> linkedMessageStructs = new ArrayList<NCObjectId>();
                do {
                    if ((messageStructId = NCObjectIdUtil.instance().createObjectId(rs, 14)) != null && !linkedMessageStructs.contains(messageStructId)) {
                        linkedMessageStructs.add(messageStructId);
                    }
                    task.setLastModDate(rs.getDate(15));
                } while (rs.next());
                rs.close();
                rs = null;
                this.addLinks(connection, task, linkedMessageStructs);
            } else {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, (Object[])new String[]{taskId.toString()}, (Map)ap);
            }
            this.closeResources(rs, ps);
            return task;
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, (Object[])new String[]{taskId.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, new Object[]{taskId});
                catch (AgentException ex2) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_SET_TASK_OBJECT_ATTRIBUTES, (Map)ap);
                    throw new DTException(I18NCode.MSG_FAILED_TO_SET_TASK_OBJECT_ATTRIBUTES, ex2);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
    }

    public NCObjectId findTaskScheduleId(Connection connection, NCObjectId taskId) throws DTException {
        Object task = null;
        this.checkForNull(connection, I18NCode.MSG_CONNECTION_OBJECT_IS_NULL);
        this.checkForNull(taskId, I18NCode.MSG_OBJECT_IS_NULL);
        NCObjectId taskScheduleId = null;
        String sqlStr = "SELECT PK_TASKSCHEDULE_ID FROM NC_TASKSCHEDULE WHERE FK_TASK_ID = ? ";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(sqlStr);
            NCObjectIdUtil.instance().setIntoStatement(taskId, 1, ps);
            rs = ps.executeQuery();
            if (rs.next()) {
                taskScheduleId = NCObjectIdUtil.instance().createObjectId(rs, 1);
            } else {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECTS_TASK_SCHEDULE, (Object[])new String[]{taskId.toString()}, (Map)ap);
            }
            this.closeResources(rs, ps);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECTS_TASK_SCHEDULE, (Object[])new String[]{taskId.toString()}, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECTS_TASK_SCHEDULE, new Object[]{taskId});
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
        return taskScheduleId;
    }

    @Override
    public Iterator findCopyByName(Connection connection, String object_name) throws DTException {
        String errMsg = "Method not supported: DhTaskImpl::findCopyByName";
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_UNSUPPORTED_OPERATION, (Map)ap);
        throw new DTException(I18NCode.OTH_UNSUPPORTED_OPERATION);
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user) throws DTException {
        return this.getObjectList(connection, user, HelperOptionImpl.EMPTY_OPTION);
    }

    private void closeResources(ResultSet rs, Statement stmt) throws DTException {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
        }
    }

    private void checkForNull(Object anObject, I18NCode code) throws DTException {
        if (anObject != null) {
            return;
        }
        throw new DTException(code);
    }

    public void updateLinkToMessageStructs(Connection connection, ITask task) throws DTException {
        NCObjectId taskId = task.getNCObjectId();
        Iterator messageStructs = task.getMessages();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            this.getRelationHelper().unlinkTaskToMessageStruct(connection, taskId);
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_UNLINK_TASK_TO_MESSAGE_STRUCTS, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_UNLINK_TASK_TO_MESSAGE_STRUCTS);
        }
        finally {
            this.closeResources(null, stmt);
        }
        this.linkToMessageStructs(connection, taskId, messageStructs);
    }

    private void shallowUpdateLinkToMessageStructs(Connection connection, ITask task) throws DTException {
        NCObjectId taskId = task.getNCObjectId();
        Iterator messageStructs = task.getMessages();
        Statement stmt = null;
        try {
            JDBCRhTask taskRelationHelper = this.getRelationHelper();
            stmt = connection.createStatement();
            while (messageStructs.hasNext()) {
                IMessageStruct messageStruct = (IMessageStruct)messageStructs.next();
                if (messageStruct != null) {
                    taskRelationHelper.updateTaskLinkToMessageStruct(stmt, taskId, messageStruct.getNCObjectId());
                    continue;
                }
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_UPDATE_LINKS_FROM_TASKS_TO_MES, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_UPDATE_LINKS_FROM_TASKS_TO_MES);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_UNLINK_TASK_TO_MESSAGE_STRUCTS, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_UNLINK_TASK_TO_MESSAGE_STRUCTS);
        }
        finally {
            this.closeResources(null, stmt);
        }
    }

    private void linkToMessageStructs(Connection connection, NCObjectId taskId, Iterator messageStructs) throws DTException {
        if (messageStructs == null) {
            String errMsg = "no message struct objects is passed to be linked";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_MESSAGE_STRUCT_NOTFOUND, (Object[])new String[]{"null messageStruct"}, (Map)ap);
            return;
        }
        IMessageStruct oneMessageStruct = null;
        Object oneObject = null;
        NCObjectId msgId = null;
        Statement stmt = null;
        try {
            boolean flag2;
            if (messageStructs.hasNext()) {
                stmt = connection.createStatement();
            }
            while (messageStructs.hasNext()) {
                oneObject = messageStructs.next();
                if (!(oneObject instanceof IMessageStruct)) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ONE_OF_THE_OBJECTS_IS_NOT_A_MESSAGE_STRU, (Object[])new String[]{oneObject.getClass().getName()}, (Map)ap);
                    throw new DTException(I18NCode.MSG_ONE_OF_THE_OBJECTS_IS_NOT_A_MESSAGE_STRU, new Object[]{oneObject.getClass().getName()});
                }
                oneMessageStruct = (IMessageStruct)oneObject;
                msgId = oneMessageStruct.getNCObjectId();
                this.getRelationHelper().linkTaskToMessageStruct(stmt, taskId, msgId);
            }
            boolean flag1 = this.getRelationHelper().statementsAreBatched();
            boolean bl = flag2 = stmt != null;
            if (flag1 && flag2) {
                stmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_LINK_TASK_TO_THE_MESSAGE_STRUCTS, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_LINK_TASK_TO_THE_MESSAGE_STRUCTS);
        }
        finally {
            this.closeResources(null, stmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMessageStructs(Connection connection, ITask task, Principal user) throws DTException {
        IJDBCDhJDBCMessageStruct messageStructDataHelper = this.getMsgStructHelper();
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        JDBCRhTask relationHelper = this.getRelationHelper();
        this.deleteRedundantMessages(connection, task, user);
        Iterator messageStructs = task.getMessages();
        IMessageStruct messageStruct = null;
        Object oneElement = null;
        while (messageStructs.hasNext()) {
            oneElement = messageStructs.next();
            messageStruct = oneElement;
            boolean existing = false;
            existing = messageStructDataHelper.checkExistsMessageStruct(connection, messageStruct);
            if (existing) {
                messageStructDataHelper.storeExistingMessageStruct(connection, messageStruct);
                continue;
            }
            Statement st = null;
            try {
                pm.storeNew(messageStruct, NCObjectType.MESSAGE_STRUCT, NCObjectType.MESSAGE_STRUCT, connection, user);
                st = connection.createStatement();
                relationHelper.linkTaskToMessageStruct(st, task.getNCObjectId(), messageStruct.getNCObjectId());
                this.closeResources(null, st);
            }
            catch (StoreObjectException e) {
                try {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)e);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_STORE_OBJECT, (Object[])new String[]{NCObjectType.MESSAGE_STRUCT.toString()}, (Map)ap);
                    throw new DTException(I18NCode.PERST_UNABLE_STORE_OBJECT, new Object[]{NCObjectType.MESSAGE_STRUCT}, e);
                    catch (SQLException e2) {
                        ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e2);
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_ERROR_FAILED_TO_STORE_A_NEW_MESSAGE, (Map)ap);
                        throw new DTException(I18NCode.MSG_SQL_ERROR_FAILED_TO_STORE_A_NEW_MESSAGE);
                    }
                }
                catch (Throwable throwable) {
                    this.closeResources(null, st);
                    throw throwable;
                }
            }
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteRedundantMessages(Connection connection, ITask task, Principal user) throws DTException {
        JDBCConnection ro_connection = null;
        ArrayList<NCObjectId> delete_list = null;
        try {
            ro_connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            Collection redundantMSIds = this.getRelationHelper().getRedundantMessageStructIds((Connection)ro_connection, task);
            Iterator itr = redundantMSIds.iterator();
            delete_list = new ArrayList<NCObjectId>(redundantMSIds.size());
            while (itr.hasNext()) {
                NCObjectId id = (NCObjectId)itr.next();
                delete_list.add(id);
            }
        }
        catch (SQLException e) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, (Object[])new String[]{e.getMessage() + ""}, (Map)ap);
                throw new DTException(I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM);
            }
            catch (Throwable throwable) {
                try {
                    NCConnection.instance().getConnectionFactory().releaseConnection(ro_connection);
                    throw throwable;
                }
                catch (SQLException e2) {
                    AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_ERROR_UNABLE_TO_RELEASE_CONNECTION_, (Object[])new String[]{e2.getMessage() + ""}, (Map)ap);
                    throw new DTException(I18NCode.MSG_SQL_ERROR_UNABLE_TO_RELEASE_CONNECTION_);
                }
            }
        }
        try {
            NCConnection.instance().getConnectionFactory().releaseConnection(ro_connection);
        }
        catch (SQLException e) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_SQL_ERROR_UNABLE_TO_RELEASE_CONNECTION_, (Object[])new String[]{e.getMessage() + ""}, (Map)ap);
            throw new DTException(I18NCode.MSG_SQL_ERROR_UNABLE_TO_RELEASE_CONNECTION_);
        }
        NCObjectId[] delete_array = new NCObjectId[delete_list.size()];
        delete_list.toArray(delete_array);
        try {
            int i = 0;
            while (i < delete_array.length) {
                this.getRelationHelper().unlinkMessageStructFromTask(connection, task.getNCObjectId(), delete_array[i]);
                this.getMsgStructHelper().delete(connection, delete_array[i], user);
                ++i;
            }
            return;
        }
        catch (SQLException e) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)e);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_DELETE_OBJECT, (Object[])new String[]{NCObjectType.MESSAGE_STRUCT.toString()}, (Map)ap);
            throw new DTException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{NCObjectType.MESSAGE_STRUCT});
        }
    }

    private IJDBCDhTaskSchedule getScheduleRelationHelper() {
        return this.mDhTaskSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IJDBCDhJDBCMessageStruct getMsgStructHelper() throws DTException {
        if (this.mDhMsgStructHelper == null) {
            JDBCDhJDBCTask jDBCDhJDBCTask = this;
            synchronized (jDBCDhJDBCTask) {
                if (this.mDhMsgStructHelper == null) {
                    try {
                        this.mDhMsgStructHelper = (IJDBCDhJDBCMessageStruct)RepositoryServicesImpl.instance().getPersistManager().getDataHelper(NCObjectType.MESSAGE_STRUCT);
                    }
                    catch (PersistManagerException ex) {
                        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_GET_HELPER_FOR_MESSAGE_STRUCT, (Map)ap);
                        throw new DTException(I18NCode.MSG_FAILED_TO_GET_HELPER_FOR_MESSAGE_STRUCT, ex);
                    }
                }
            }
        }
        return this.mDhMsgStructHelper;
    }

    public JDBCRhTask getRelationHelper() {
        return this.mRelationBuilder;
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user, HelperOption option) throws DTException {
        ArrayList<NCObjectId> task_id_list = new ArrayList<NCObjectId>();
        String sql_string = "SELECT PK_TASK_ID FROM NC_TASK";
        if (option != null) {
            sql_string = sql_string + " WHERE " + option.getOptionString();
        }
        Statement statement = null;
        ResultSet result_set = null;
        try {
            statement = connection.createStatement();
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                statement.setFetchSize(JDBCConnectionProperties.instance(null).getFetchSize());
            }
            result_set = statement.executeQuery(sql_string);
            while (result_set.next()) {
                task_id_list.add(NCObjectIdUtil.instance().createObjectId(result_set, 1));
            }
            this.closeResources(result_set, statement);
        }
        catch (SQLException sql_exception) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sql_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_RETRIEVE_TASK_IDS_FROM_REPOSIT, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_RETRIEVE_TASK_IDS_FROM_REPOSIT);
            }
            catch (Throwable throwable) {
                this.closeResources(result_set, statement);
                throw throwable;
            }
        }
        ArrayList<ITask> task_list = new ArrayList<ITask>();
        Iterator elements = task_id_list.iterator();
        while (elements.hasNext()) {
            task_list.add(this.findTaskByOid(connection, (NCObjectId)elements.next(), null));
        }
        return task_list.iterator();
    }

    @Override
    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(Connection conn, HelperOption option) throws DTException {
        return new INCObjectUpdate[0];
    }

    private IRecipientLink getRecipientLink(INCFeatherWeight fwRecipient, IRecipientLink[] recipientLinks) {
        int index = -1;
        NCObjectId key = fwRecipient.getNCObjectId();
        IRecipientLink link = null;
        Arrays.sort(recipientLinks, new Comparator(){

            public int compare(Object o1, Object o2) {
                int sortResult = 0;
                IRecipientLink r1 = (IRecipientLink)o1;
                IRecipientLink r2 = (IRecipientLink)o2;
                sortResult = r1.getRecipientId().compareTo(r2.getRecipientId());
                return sortResult;
            }
        });
        index = Arrays.binarySearch(recipientLinks, key, new Comparator(){

            public int compare(Object recipientObj, Object key) {
                IRecipientLink link = (IRecipientLink)recipientObj;
                NCObjectId comparisonKey = link.getRecipientId();
                return comparisonKey.compareTo((NCObjectId)key);
            }
        });
        if (index >= 0) {
            link = recipientLinks[index];
        }
        return link;
    }

    private void removeRecipientFromMessage(Connection conn, IRecipientLink recipientLink, IMessageStruct message, INCFeatherWeight agent) throws DTException {
        message.removeRecipientLink(recipientLink);
        try {
            if (Debug.debug) {
                String msg = "Removing recipient [" + recipientLink.getRecipient(new RecipientRetrieverImpl()).getName() + "] from agent [" + agent.getName() + "] with message subject [" + message.getSubject() + "]";
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(msg);
                System.out.println(msg);
            }
            this.getMsgStructHelper().storeExistingMessageStruct(conn, message);
        }
        catch (DTException ex) {
            throw new NCObjectStoreException(NCObjectType.MESSAGE_STRUCT.toString(), message.getNCObjectId().toString(), (LocalizableException)ex);
        }
    }

    private int getTaskModCount(Connection connection, INCFeatherWeight task) throws DTException, SQLRepositoryException {
        int modCount = 0;
        NCObjectId taskId = task.getNCObjectId();
        String sqlStr = "SELECT MODCOUNT FROM NC_TASK WHERE PK_TASK_ID = " + taskId;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(sqlStr);
            if (!rs.next()) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, (Object[])new String[]{task.getName(), taskId.toString()}, (Map)ap);
                throw new SQLRepositoryException(I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, new Object[]{task.getName(), task.getNCObjectId()});
            }
            modCount = rs.getInt(1);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, (Object[])new String[]{task.getName(), task.getNCObjectId().toString()}, (Map)ap);
                throw new SQLRepositoryException(I18NCode.MSG_FAILED_TO_GET_MODIFIED_COUNTER_FOR_TASK, new Object[]{task.getName(), task.getNCObjectId()});
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)stmt);
        return modCount;
    }

    @Override
    public Iterator getObjectList(Connection connection, Principal user, NCObjectId id) throws DTException {
        ArrayList<NCObjectId> task_id_list = new ArrayList<NCObjectId>();
        String sql_string = "SELECT PK_TASK_ID FROM NC_TASK WHERE FK_BIE_ID = ?";
        ResultSet result_set = null;
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql_string);
            NCObjectIdUtil.instance().setIntoStatement(id, 1, ps);
            if (JDBCConnectionProperties.instance((String)"SDS").shouldSetFetchSize()) {
                ps.setFetchSize(JDBCConnectionProperties.instance(null).getFetchSize());
            }
            result_set = ps.executeQuery();
            while (result_set.next()) {
                task_id_list.add(NCObjectIdUtil.instance().createObjectId(result_set, 1));
            }
            this.closeResources(result_set, ps);
        }
        catch (SQLException sql_exception) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)sql_exception);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_RETRIEVE_TASK_IDS_FROM_REPOSIT, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_RETRIEVE_TASK_IDS_FROM_REPOSIT);
            }
            catch (Throwable throwable) {
                this.closeResources(result_set, ps);
                throw throwable;
            }
        }
        ArrayList<ITask> task_list = new ArrayList<ITask>();
        Iterator elements = task_id_list.iterator();
        while (elements.hasNext()) {
            task_list.add(this.findTaskByOid(connection, (NCObjectId)elements.next(), null));
        }
        return task_list.iterator();
    }

    private class ModCountHolder {
        int modCount;

        private ModCountHolder() {
        }

        int getModCount() {
            return this.modCount;
        }

        void setModCount(int aModCount) {
            this.modCount = aModCount;
        }
    }
}

