/*
 * Decompiled with CFR 0.152.
 */
package noticecast.datatier.task;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import noticecast.datatier.DTException;
import noticecast.datatier.IJDBCEntityHelper;
import noticecast.datatier.message.JDBCDhJDBCMessageStruct;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.IRecipientLink;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.services.RepositoryServicesImpl;

public class JDBCRhTask {
    static final String JDBC_MESSAGESTRUCT_TASK = "R_MESSAGESTRUCT_TASK";
    static final String JDBC_TASKSCHEDULE = "NC_TASKSCHEDULE";
    static final String JDBC_TASKSCHEDULE_SCHEDULE = "R_TASKSCHEDULE_SCHEDULE";
    static final String R_TASK_ID = "FK_TASK_ID";
    static final String R_RULE_ID = "FK_RULE_ID";
    static final String R_LITERAL_TYPE = "LITERAL_TYPE";
    static final String R_CHILD_AGENT_ID = "FK_CHILD_AGENT_ID";
    static final String R_PARENT_AGENT_ID = "FK_PARENT_AGENT_ID";
    static final String R_MESSAGESTRUCT_ID = "FK_MESSAGESTRUCT_ID";
    static final String R_TASK_SCHEDULE_ID = "PK_TASKSCHEDULE_ID";
    static final String R_AVOID_MSG_DUPES = "AVOID_MSG_DUPES";
    static final String R_FK_TASKSCHEDULE = "FK_TASKSCHEDULE_ID";
    static final String R_CHILD_ID = "FK_CHILD_ID";
    private boolean mSupportsBatchUpdates = false;
    private final String delete_link = "DELETE FROM R_MESSAGESTRUCT_TASK WHERE FK_TASK_ID = ? AND FK_MESSAGESTRUCT_ID = ?";
    private static final String m_getMessageStructSql = "select FK_MESSAGESTRUCT_ID from R_MESSAGESTRUCT_TASK where FK_TASK_ID = ?";

    JDBCRhTask(boolean supportsBatchUpdates) {
    }

    boolean statementsAreBatched() {
        return this.mSupportsBatchUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkMessageStructFromTask(Connection conn, NCObjectId taskId, NCObjectId structId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("DELETE FROM R_MESSAGESTRUCT_TASK WHERE FK_TASK_ID = ? AND FK_MESSAGESTRUCT_ID = ?");
            NCObjectIdUtil.instance().setIntoStatement(taskId, 1, ps);
            NCObjectIdUtil.instance().setIntoStatement(structId, 2, ps);
            ps.executeUpdate();
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    void unlinkTaskToMessageStruct(Connection con, NCObjectId taskId) throws SQLException, DTException {
        this.removeLinks(con, JDBC_MESSAGESTRUCT_TASK, R_TASK_ID, taskId, "failed to unlink to messages");
    }

    void unlinkTaskAndDeleteMessageStructAndLinkedRecipients(Connection con, NCObjectId taskId) throws SQLException, DTException, PersistManagerException {
        NCObjectId[] msgStructIds = this.findMessageStructs(con, taskId);
        JDBCDhJDBCMessageStruct msgHelper = (JDBCDhJDBCMessageStruct)RepositoryServicesImpl.instance().getPersistManager().getDataHelper(NCObjectType.MESSAGE_STRUCT);
        ArrayList<IRecipientLink> recipLinks = new ArrayList<IRecipientLink>();
        for (int i = 0; i < msgStructIds.length; ++i) {
            recipLinks.addAll(Arrays.asList(msgHelper.getStaticRecipientLinks(msgStructIds[i], con)));
        }
        IRecipientLink[] links = recipLinks.toArray(new IRecipientLink[0]);
        this.removeLinks(con, JDBC_MESSAGESTRUCT_TASK, R_TASK_ID, taskId, "failed to unlink to messages");
        this.deleteMessageStructs(con, msgStructIds);
        IJDBCEntityHelper recipHelper = RepositoryServicesImpl.instance().getPersistManager().getDataHelper(NCObjectType.RECIPIENT);
        for (int i = 0; i < links.length; ++i) {
            recipHelper.delete(con, links[i].getRecipientId(), null);
        }
    }

    void unlinkTaskAndDeleteMessageStruct(Connection con, NCObjectId taskId) throws SQLException, DTException {
        NCObjectId[] msgStructIds = this.findMessageStructs(con, taskId);
        this.removeLinks(con, JDBC_MESSAGESTRUCT_TASK, R_TASK_ID, taskId, "failed to unlink to messages");
        this.deleteMessageStructs(con, msgStructIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NCObjectId[] findMessageStructs(Connection con, NCObjectId taskId) throws SQLException {
        PreparedStatement ps = con.prepareStatement(m_getMessageStructSql);
        NCObjectIdUtil.instance().setIntoStatement(taskId, 1, ps);
        ResultSet rs = null;
        ArrayList<NCObjectId> msgStructIds = new ArrayList<NCObjectId>();
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                msgStructIds.add(NCObjectIdUtil.instance().createObjectId(rs, R_MESSAGESTRUCT_ID));
            }
        }
        finally {
            this.closeResources(rs, ps);
        }
        NCObjectId[] ids = new NCObjectId[msgStructIds.size()];
        msgStructIds.toArray(ids);
        return ids;
    }

    private void deleteMessageStructs(Connection con, NCObjectId[] messageStructIds) throws SQLException, DTException {
        try {
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            for (int x = 0; x < messageStructIds.length; ++x) {
                pm.delete(messageStructIds[x], NCObjectType.MESSAGE_STRUCT, null, con);
            }
        }
        catch (PersistManagerException e) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ERROR_TRYING_TO_DELETE_AN_AGENTS_MESSAGE, (Map)ap);
            throw new DTException(I18NCode.MSG_ERROR_TRYING_TO_DELETE_AN_AGENTS_MESSAGE, e);
        }
    }

    public void linkTaskToMessageStruct(Statement stmt, NCObjectId taskId, NCObjectId msgStructId) throws SQLException, DTException {
        String sqlStr = "INSERT INTO R_MESSAGESTRUCT_TASK ( FK_TASK_ID, FK_MESSAGESTRUCT_ID) VALUES ( " + taskId + ", " + msgStructId + " )";
        try {
            if (this.mSupportsBatchUpdates) {
                stmt.addBatch(sqlStr);
            } else {
                stmt.executeUpdate(sqlStr);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_LINK_TASK_TO_MESSAGE_STRUCT, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_LINK_TASK_TO_MESSAGE_STRUCT);
        }
    }

    public void updateTaskLinkToMessageStruct(Statement stmt, NCObjectId taskId, NCObjectId msgStructId) throws SQLException, DTException {
        String sqlStr = "UPDATE R_MESSAGESTRUCT_TASK SET FK_TASK_ID = " + taskId + " WHERE " + R_MESSAGESTRUCT_ID + " = " + msgStructId;
        try {
            if (this.mSupportsBatchUpdates) {
                stmt.addBatch(sqlStr);
            } else {
                stmt.executeUpdate(sqlStr);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_LINK_TASK_TO_MESSAGE_STRUCT, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_LINK_TASK_TO_MESSAGE_STRUCT);
        }
    }

    public void unlinkTaskSchedule(Connection conn, NCObjectId taskId) throws SQLException, DTException {
        String delete_sched = "DELETE FROM R_TASKSCHEDULE_SCHEDULE WHERE FK_TASKSCHEDULE_ID IN (SELECT PK_TASKSCHEDULE_ID FROM NC_TASKSCHEDULE WHERE FK_TASK_ID = " + NCObjectIdUtil.instance().getSqlString(taskId) + ")";
        String delete_tasksched = "DELETE FROM NC_TASKSCHEDULE WHERE FK_TASK_ID = " + NCObjectIdUtil.instance().getSqlString(taskId);
        Statement statement = conn.createStatement();
        int rows_deleted = 0;
        try {
            block9: for (int i = 1; i < 3; ++i) {
                switch (i) {
                    case 1: {
                        rows_deleted = statement.executeUpdate(delete_sched);
                        continue block9;
                    }
                    case 2: {
                        rows_deleted = statement.executeUpdate(delete_tasksched);
                    }
                }
            }
        }
        catch (SQLException sqle) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ERROR_DELETING_TASKSCHEDULE_LINKS, (Map)ap);
            throw new DTException(I18NCode.MSG_ERROR_DELETING_TASKSCHEDULE_LINKS);
        }
        finally {
            this.closeResources(null, statement);
        }
    }

    private void linkObjectToObject(Statement stmt, String linkTableName, String objOneColName, NCObjectId objOneId, String objTwoColName, NCObjectId ObjectTwo) throws SQLException, DTException {
        String sqlStr = "INSERT INTO " + linkTableName + " ( " + objOneColName + ", " + objTwoColName + ")" + " VALUES ( " + objOneId + ", " + ObjectTwo + " )";
        try {
            if (this.mSupportsBatchUpdates) {
                stmt.addBatch(sqlStr);
            } else {
                stmt.executeUpdate(sqlStr);
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_LINK_AGENT_TO_ESCALATION_AGENT, (Map)ap);
            throw new DTException(I18NCode.MSG_FAILED_TO_LINK_AGENT_TO_ESCALATION_AGENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLinks(Connection con, String linkTableName, String keyColName, NCObjectId keyId, String errorMessage) throws SQLException {
        String sqlStr = "DELETE FROM " + linkTableName + " WHERE " + keyColName + " = " + NCObjectIdUtil.instance().getSqlString(keyId);
        Statement stmt = con.createStatement();
        try {
            if (this.mSupportsBatchUpdates) {
                stmt.addBatch(sqlStr);
            } else {
                int n = stmt.executeUpdate(sqlStr);
            }
        }
        finally {
            this.closeResources(null, stmt);
        }
    }

    private void closeResources(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
    }

    public Collection getRedundantMessageStructIds(Connection connection, ITask task) throws DTException {
        ArrayList<NCObjectId> idList = new ArrayList<NCObjectId>();
        IMessageStruct messageStruct = null;
        StringBuffer buffer = new StringBuffer();
        Iterator messageStructs = task.getMessages();
        boolean noMessagesLeft = false;
        if (messageStructs.hasNext()) {
            messageStruct = (IMessageStruct)messageStructs.next();
            buffer.append(messageStruct.getNCObjectId());
        } else {
            noMessagesLeft = true;
        }
        while (messageStructs.hasNext()) {
            buffer.append(", ");
            messageStruct = (IMessageStruct)messageStructs.next();
            buffer.append(messageStruct.getNCObjectId());
        }
        NCObjectId taskId = task.getNCObjectId();
        String option = noMessagesLeft ? "" : " AND FK_MESSAGESTRUCT_ID NOT IN (" + buffer + ")";
        String selectStmt = "SELECT FK_MESSAGESTRUCT_ID FROM R_MESSAGESTRUCT_TASK WHERE FK_TASK_ID = " + taskId + option;
        Statement stmt = null;
        ResultSet rs = null;
        NCObjectId oneId = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(selectStmt);
            while (rs.next()) {
                oneId = NCObjectIdUtil.instance().createObjectId(rs, R_MESSAGESTRUCT_ID);
                if (oneId == null) continue;
                idList.add(oneId);
            }
            this.closeResources(rs, stmt);
        }
        catch (SQLException ex) {
            try {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_OBTAIN_REDUNDANT_MESSAGESTRUCT, (Map)ap);
                throw new DTException(I18NCode.MSG_FAILED_TO_OBTAIN_REDUNDANT_MESSAGESTRUCT);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, stmt);
                throw throwable;
            }
        }
        return idList;
    }
}

