/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.AuditStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import noticecast.datatier.base.ObjectTypeHelper;
import noticecast.exceptions.LogictierException;
import noticecast.exceptions.NCException;
import noticecast.logictier.INCObjectFactory;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObject;
import noticecast.services.RepositoryServicesImpl;

public class NCObjectFactoryImpl
implements INCObjectFactory {
    static final long serialVersionUID = 70009003L;
    private Class mINCBaseObjectClass = null;
    private final String mLocalClassName = "noticecast.logictier.base.INCBaseObject";

    public NCObjectFactoryImpl() {
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("NCObjectFactoryImpl constructor is called.");
    }

    private Class getLocalBaseClass() throws LogictierException {
        if (this.mINCBaseObjectClass == null) {
            try {
                this.mINCBaseObjectClass = Class.forName("noticecast.logictier.base.INCBaseObject");
                if (this.mINCBaseObjectClass == null) {
                    String errMsg = "the class for noticecast.logictier.base.INCBaseObject was not found";
                    throw new LogictierException(I18NCode.MSG_CLASSNOTF_EXCP, new String[]{"noticecast.logictier.base.INCBaseObject"});
                }
            }
            catch (SecurityException ex) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ACCESSRIGHT_EXCP, (Object[])new String[]{"noticecast.logictier.base.INCBaseObject"}, (Map)ap);
                throw new LogictierException(I18NCode.MSG_ACCESSRIGHT_EXCP, new String[]{"noticecast.logictier.base.INCBaseObject"});
            }
            catch (ClassNotFoundException ex) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CLASSNOTF_EXCP, (Object[])new String[]{"noticecast.logictier.base.INCBaseObject"}, (Map)ap);
                throw new LogictierException(I18NCode.MSG_CLASSNOTF_EXCP, new String[]{"noticecast.logictier.base.INCBaseObject"});
            }
        }
        return this.mINCBaseObjectClass;
    }

    private INCBaseObject getLocal(String className) throws LogictierException {
        INCBaseObject theObject = null;
        try {
            Class<?> theClass = Class.forName(className);
            theObject = (INCBaseObject)theClass.newInstance();
            NCObjectId theId = NCObjectId.createNew();
            theObject.setNCObjectId(theId);
        }
        catch (IllegalAccessException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ACCESSRIGHT_EXCP, (Object[])new String[]{className}, (Map)ap);
            throw new LogictierException(I18NCode.MSG_ACCESSRIGHT_EXCP, new String[]{className});
        }
        catch (InstantiationException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, (Object[])new String[]{className}, (Map)ap);
            throw new LogictierException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{className});
        }
        catch (SecurityException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ACCESSRIGHT_EXCP, (Object[])new String[]{className}, (Map)ap);
            throw new LogictierException(I18NCode.MSG_ACCESSRIGHT_EXCP, new Object[]{className});
        }
        catch (ClassNotFoundException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CLASSNOTF_EXCP, (Object[])new String[]{className}, (Map)ap);
            throw new LogictierException(I18NCode.MSG_CLASSNOTF_EXCP, new Object[]{className});
        }
        return theObject;
    }

    @Override
    public INCBaseObject makeByValue(NCObjectType objectType, Principal user) throws LogictierException {
        try {
            ObjectTypeHelper typeHelper = RepositoryServicesImpl.instance().getPersistManager().getObjectTypeHelper();
            String theClassName = typeHelper.getLocalClassName(objectType);
            if (theClassName == null) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CLASS_NOT_DEFINED_FOR_TYPE, (Object[])new String[]{"theClassName is null."}, (Map)ap);
                throw new LogictierException(I18NCode.MSG_CLASS_NOT_DEFINED_FOR_TYPE, new Object[]{objectType});
            }
            INCBaseObject localObject = this.getLocal(theClassName);
            return localObject;
        }
        catch (NCException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJ_FAILED_FOR_TYPE, (Object[])new String[]{objectType.toString()}, (Map)ap);
            throw new LogictierException(I18NCode.MSG_OBJ_FAILED_FOR_TYPE, new Object[]{objectType}, ex);
        }
    }

    @Override
    public INCBaseObject makeByValue(NCObjectType objectType, Object[] parameters, Principal user) throws LogictierException {
        INCBaseObject madeObject = null;
        String className = null;
        ObjectTypeHelper typeHelper = RepositoryServicesImpl.instance().getPersistManager().getObjectTypeHelper();
        className = typeHelper.getLocalClassName(objectType);
        madeObject = this.getLocal(className, parameters);
        return madeObject;
    }

    private INCBaseObject getLocal(String className, Object[] parameters) throws LogictierException {
        INCBaseObject theObject = null;
        try {
            Class<?> theClass = Class.forName(className);
            if (!this.getLocalBaseClass().isAssignableFrom(theClass)) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_INCORRECT_HIERARCHY_EXCP, (Object[])new String[]{className, className}, (Map)ap);
                throw new LogictierException(I18NCode.MSG_INCORRECT_HIERARCHY_EXCP, new Object[]{className, className});
            }
            Constructor<?>[] availableConstructors = theClass.getConstructors();
            Object createdObject = null;
            boolean tryAgain = true;
            for (int theCounter = 0; tryAgain && theCounter < availableConstructors.length; ++theCounter) {
                AuditProperties ap;
                try {
                    createdObject = availableConstructors[theCounter].newInstance(parameters);
                    if (createdObject == null) continue;
                    theObject = createdObject;
                    NCObjectId theId = NCObjectId.createNew();
                    theObject.setNCObjectId(theId);
                    tryAgain = false;
                    continue;
                }
                catch (InstantiationException ex) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, (Object[])new String[]{className}, (Map)ap);
                    throw new LogictierException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{className});
                }
                catch (InvocationTargetException ex) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, (Object[])new String[]{className}, (Map)ap);
                    throw new LogictierException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{className});
                }
                catch (IllegalAccessException ex) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ACCESSRIGHT_EXCP, (Object[])new String[]{className}, (Map)ap);
                    throw new LogictierException(I18NCode.MSG_ACCESSRIGHT_EXCP, new Object[]{className});
                }
                catch (IllegalArgumentException ex) {
                    ap = AuditPropUtil.doProps(this.getClass(), (String)AuditStatus.BLANK);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_ACCESSRIGHT_EXCP, (Object[])new String[]{className}, (Map)ap);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CLASSNOTF_EXCP, (Object[])new String[]{className}, (Map)ap);
            throw new LogictierException(I18NCode.MSG_CLASSNOTF_EXCP, new Object[]{className});
        }
        return theObject;
    }
}

