/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import noticecast.logictier.NCObjectName;
import noticecast.logictier.NCObjectTypeException;

public final class NCObjectType
implements Serializable {
    static final long serialVersionUID = 70009003L;
    private static final transient short m_TEST_FACTORY_OBJECT = 0;
    private static final transient short m_UNKNOWN = 1;
    private static final transient short m_Recipient = 700;
    private static final transient short m_Message = 720;
    private static final transient short m_MessageStruct = 740;
    private static final transient short m_deliveryAddress = 746;
    private static final transient short m_agent = 900;
    private static final transient short m_task = 901;
    private static final transient short m_TaskSchedule = 902;
    private static final transient short m_ncAgent = 907;
    private static final transient short m_ntAgent = 908;
    private static final transient short m_jobservice = 911;
    private static final transient short m_YearlySchedule = 1000;
    private static final transient short m_MonthlySchedule = 1001;
    private static final transient short m_WeeklySchedule = 1002;
    private static final transient short m_DailySchedule = 1003;
    private static final transient short m_FixedIntervalSchedule = 1004;
    private static final transient short m_schedule = 1005;
    private static final transient short m_ncSchedule = 1020;
    private static final transient short m_triggerSchedule = 1024;
    private Short m_short_object;
    public static NCObjectType TEST_FACTORY_OBJECT = new NCObjectType(0);
    public static NCObjectType UNKNOWN = new NCObjectType(1);
    public static NCObjectType RECIPIENT = new NCObjectType(700);
    public static NCObjectType MESSAGE = new NCObjectType(720);
    public static NCObjectType MESSAGE_STRUCT = new NCObjectType(740);
    public static NCObjectType TASK = new NCObjectType(901);
    public static NCObjectType AGENT = new NCObjectType(900);
    public static NCObjectType TASK_SCHEDULE = new NCObjectType(902);
    public static NCObjectType NC_AGENT = new NCObjectType(907);
    public static NCObjectType NOTIFICATION_AGENT = new NCObjectType(908);
    public static NCObjectType JOB_SERVICE_AGENT = new NCObjectType(911);
    public static NCObjectType YEARLY_SCHEDULE = new NCObjectType(1000);
    public static NCObjectType MONTHLY_SCHEDULE = new NCObjectType(1001);
    public static NCObjectType WEEKLY_SCHEDULE = new NCObjectType(1002);
    public static NCObjectType DAILY_SCHEDULE = new NCObjectType(1003);
    public static NCObjectType FIXED_INTERVAL_SCHEDULE = new NCObjectType(1004);
    public static NCObjectType SCHEDULE = new NCObjectType(1005);
    public static NCObjectType DELIVERY_ADDRESS = new NCObjectType(746);
    public static NCObjectType NC_SCHEDULE = new NCObjectType(1020);
    public static NCObjectType TRIGGER_SCHEDULE = new NCObjectType(1024);

    private NCObjectType(short type) {
        this.m_short_object = new Short(type);
    }

    private short shortValue() {
        return this.m_short_object;
    }

    private Short getShortObject() {
        return this.m_short_object;
    }

    public String toSQLString() {
        return this.m_short_object.toString();
    }

    public String toString() {
        String theStr = null;
        try {
            NCObjectName ncobj = NCObjectName.instance();
            theStr = ncobj.getName(this);
        }
        catch (Throwable ex) {
            String s = "Exception in NCObjectType : " + ex.getMessage();
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{s}, (Map)ap);
        }
        if (theStr == null) {
            theStr = this.m_short_object.toString() + NCObjectName.warnMsg;
        }
        return theStr;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (null != obj && obj.getClass().equals(NCObjectType.class)) {
            NCObjectType other = (NCObjectType)obj;
            result = this.m_short_object.shortValue() == other.m_short_object.shortValue();
        }
        return result;
    }

    public int hashCode() {
        return this.m_short_object.hashCode();
    }

    private static NCObjectType getNCObjectType(short value) {
        return new NCObjectType(value);
    }

    public static NCObjectType valueOf(ResultSet rs, int index) throws SQLException {
        NCObjectType result = UNKNOWN;
        short value = rs.getShort(index);
        if (!rs.wasNull()) {
            result = NCObjectType.getNCObjectType(value);
        }
        return result;
    }

    public static void setValue(PreparedStatement ps, int index, NCObjectType objType) throws SQLException {
        if (objType == null) {
            ps.setNull(index, 5);
        } else {
            ps.setInt(index, objType.m_short_object.intValue());
        }
    }

    public static NCObjectType valueOf(String string) throws NCObjectTypeException {
        NCObjectType result = UNKNOWN;
        if (null == string) {
            String errMsg = "invalid string passed for NCObjectType.valueOf";
            AuditProperties ap = AuditPropUtil.doProps(NCObjectType.class, (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_IS_NULL, (Map)ap);
            throw new NCObjectTypeException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        try {
            short val = Short.parseShort(string.trim());
            result = NCObjectType.getNCObjectType(val);
        }
        catch (NumberFormatException ex) {
            AuditProperties ap = AuditPropUtil.doProps(NCObjectType.class, (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, (Object[])new String[]{NCObjectType.class.getName()}, (Map)ap);
            throw new NCObjectTypeException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{NCObjectType.class.getName()});
        }
        return result;
    }
}

