/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.agent;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import noticecast.debug.Debug;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.AgentException;
import noticecast.logictier.agent.DetectionOption;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.agent.TaskType;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.base.NCBaseObjectImpl;
import noticecast.logictier.message.IMessageStruct;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistWrapperException;
import noticecast.services.RepositoryServicesImpl;
import noticecast.util.ValidResult;
import noticecast.util.ValidityErrMsgs;

public final class TaskImpl
extends NCBaseObjectImpl
implements ITask {
    static final long serialVersionUID = 70009003L;
    private Vector m_messages = new Vector(10);
    private Integer m_threshold = new Integer(1);
    private Vector m_weights = new Vector(10);
    private Hashtable m_agent_variables = new Hashtable();
    private TaskType m_taskType = null;
    private Date m_last_mod_date = null;
    private boolean m_success = false;
    private NCObjectType m_agentSubType = NCObjectType.UNKNOWN;
    private static final DateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private DetectionOption m_detection_option = DetectionOption.CONTINUE;
    private String m_objectClass;
    private String m_owner;

    public TaskImpl(NCObjectId taskId, String taskName, String taskDescription) throws AgentException {
        this.setNCObjectId(taskId);
        if (taskName != null) {
            this.setName(taskName);
        }
        if (taskDescription != null) {
            this.setDescription(taskDescription);
        }
    }

    public TaskImpl() {
    }

    @Override
    public DetectionOption getDetectionOption() {
        return this.m_detection_option;
    }

    @Override
    public void setDetectionOption(DetectionOption detection_option) {
        this.m_detection_option = detection_option;
    }

    @Override
    public Iterator getMessages() {
        return this.m_messages.iterator();
    }

    @Override
    public void setMessages(Vector messages) {
        this.m_messages = messages;
    }

    @Override
    public void addMessage(IMessageStruct message) {
        this.m_messages.addElement(message);
    }

    @Override
    public void removeMessage(IMessageStruct message) {
        this.m_messages.removeElement(message);
    }

    @Override
    public Integer getThreshold() {
        return this.m_threshold;
    }

    @Override
    public void setThreshold(Integer threshold) {
        this.m_threshold = threshold;
    }

    @Override
    public Iterator getWeights() {
        return this.m_weights.iterator();
    }

    @Override
    public void setWeights(Vector weights) {
        this.m_weights = weights;
    }

    @Override
    public TaskType getTaskType() {
        return this.m_taskType;
    }

    @Override
    public void setTaskType(TaskType type) {
        this.m_taskType = type;
    }

    @Override
    public NCObjectType getAgentSubType() {
        if (null != this.m_agentSubType) {
            return this.m_agentSubType;
        }
        return NCObjectType.NC_AGENT;
    }

    @Override
    public void setAgentSubType(NCObjectType agentSubType) {
        this.m_agentSubType = agentSubType;
    }

    private void checkForNull(Object anObject, String errMsg) throws AgentException {
        if (anObject != null) {
            return;
        }
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_IS_NULL, (Map)ap);
        throw new AgentException(I18NCode.MSG_OBJECT_IS_NULL);
    }

    @Override
    public String getObjectRef() {
        return super.toString();
    }

    @Override
    public Date getLastModDate() {
        return this.m_last_mod_date;
    }

    @Override
    public void setLastModDate(Date lastModDate) {
        this.m_last_mod_date = lastModDate;
    }

    private boolean isNameUnique() {
        boolean result;
        block4: {
            result = true;
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            try {
                INCFeatherWeight[] agNames = pm.getObjectList(NCObjectType.NC_AGENT, this.getName());
                INCFeatherWeight[] jdbcAgNames = pm.getObjectList(NCObjectType.NC_AGENT, this.getName());
                ArrayList<INCFeatherWeight> all = new ArrayList<INCFeatherWeight>(3);
                all.addAll(Arrays.asList(agNames));
                all.addAll(Arrays.asList(jdbcAgNames));
                if (all.isEmpty()) break block4;
                NCObjectId otherId = null;
                INCFeatherWeight oneObj2 = null;
                for (INCFeatherWeight oneObj2 : all) {
                    otherId = oneObj2.getNCObjectId();
                    if (otherId.equals(this.getNCObjectId())) continue;
                    result = false;
                    break;
                }
            }
            catch (PersistWrapperException ex) {
                if (Debug.debug) {
                    ex.printStackTrace(System.err);
                }
                result = false;
            }
        }
        return result;
    }

    @Override
    public ValidResult isValid() {
        ValidResult result = new ValidResult();
        if (this.getName() == null) {
            result.setValid(false);
            result.setMsgId(ValidityErrMsgs.AGENT_UNDEFINED);
        } else if (!this.isNameUnique()) {
            result.setValid(false);
            result.setMsgId(ValidityErrMsgs.AGENT_DUPLICATE);
        } else {
            result.setValid(true);
        }
        return result;
    }

    @Override
    public boolean isExecuteSuccess() {
        return this.m_success;
    }

    @Override
    public String getObjectClass() {
        return this.m_objectClass;
    }

    @Override
    public String getOwner() {
        return this.m_owner;
    }

    @Override
    public void setObjectClass(String objectClass) {
        this.m_objectClass = objectClass;
    }

    @Override
    public void setOwner(String owner) {
        this.m_owner = owner;
    }
}

