/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.message;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Map;
import noticecast.logictier.message.IMessage;
import noticecast.logictier.message.IMessageContent;
import noticecast.logictier.message.IMessageFactory;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.JobMessage;
import noticecast.logictier.recipient.IRecipient;

public class MessageFactoryImpl
implements IMessageFactory {
    private static MessageFactoryImpl m_messageFactory;

    private MessageFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMessageFactory instance() {
        if (m_messageFactory != null) return m_messageFactory;
        Class<MessageFactoryImpl> clazz = MessageFactoryImpl.class;
        synchronized (MessageFactoryImpl.class) {
            if (m_messageFactory != null) return m_messageFactory;
            m_messageFactory = new MessageFactoryImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_messageFactory;
        }
    }

    @Override
    public IMessage getMessageObject(IRecipient[] recipients, IMessageStruct messageStruct, IMessageContent messageContent) {
        IMessage message = null;
        ChannelType messageType = messageStruct.getChannelType();
        if (messageType.equals((Object)ChannelType.JOBSERVICE_DELIVERY_CHANNEL)) {
            message = this.buildJobMessage(recipients, messageStruct, messageContent);
        } else {
            String errMsg = "unsupported message type: maybe throw an exception!";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_ONE_OF_THE_OBJECTS_IS_NOT_A_MESSAGE_STRU, (Object[])new String[]{errMsg}, (Map)ap);
        }
        if (message != null) {
            message.setMessageStructId(messageStruct.getNCObjectId());
            message.setCredential(messageStruct.getCredential());
            message.setBusHeader(messageStruct.getBusHeader());
        }
        return message;
    }

    private IMessage buildJobMessage(IRecipient[] recipients, IMessageStruct messageStruct, IMessageContent messageContent) {
        String from = messageStruct.getFrom();
        String subject = messageStruct.getSubject();
        JobMessage message = new JobMessage(from, recipients, subject, messageContent);
        return message;
    }
}

