/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.message;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SubscriptionOptionEnum;
import com.cognos.developer.schemas.bibus._3.SubscriptionOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jms.client.JMSConnection;
import com.cognos.jsmcommon.logging.LogManager;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.event.IEventId;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.ObjectMessage;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueSender;
import com.ibm.cognos.jsmcommon.jms.QueueSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessage;
import noticecast.logictier.message.IMessageBuildInformation;
import noticecast.logictier.message.IMessageBuilder;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.MessageBuildInformationImpl;
import noticecast.logictier.message.MessageException;
import noticecast.logictier.message.StaticMessageBuilder;
import noticecast.runtime.IAgentStateListener;
import noticecast.runtime.task.AgentEventSenderImpl;
import noticecast.runtime.task.AgentState;
import noticecast.runtime.task.ITaskRunDetails;
import noticecast.runtime.task.SchedulePriority;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;

public class MessageManager {
    private static String LOGONAS = "logonAs";
    private static MessageManager m_messageManager = new MessageManager();
    AxisEngine engine = Client.instance().getService().getEngine();
    JMSConnection connection;
    QueueSender sender;
    QueueSession session;
    Queue queue;

    public static MessageManager instance() {
        return m_messageManager;
    }

    private MessageManager() {
        try {
            this.connection = new JMSConnection();
            this.session = this.connection.getConnection().createQueueSession(false, 2);
            this.queue = this.session.createQueue("JobQueue");
            this.sender = this.session.createSender(this.queue);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage());
        }
        catch (NamingException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage());
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage());
        }
    }

    private IMessageBuildInformation[] getBuildInformation(IMessageStruct messageStruct) throws Exception {
        ArrayList<MessageBuildInformationImpl> returnInfo = new ArrayList<MessageBuildInformationImpl>();
        MessageBuildInformationImpl mbi = new MessageBuildInformationImpl(messageStruct);
        returnInfo.add(mbi);
        IMessageBuildInformation[] mbiArray = new IMessageBuildInformation[returnInfo.size()];
        return returnInfo.toArray(mbiArray);
    }

    private boolean processMessages(IMessageBuildInformation mbi, ITask task, IAgentStateListener listener, ITaskRunDetails taskRunDetails) throws MessageException {
        boolean messagesSent = false;
        StaticMessageBuilder builder = new StaticMessageBuilder(mbi);
        messagesSent = this.processMessages(builder, task, listener, taskRunDetails);
        return messagesSent;
    }

    private boolean processMessages(IMessageBuilder builder, ITask task, IAgentStateListener listener, ITaskRunDetails taskRunDetails) throws MessageException {
        boolean messagesSent = false;
        IMessage[] messages = builder.getMessages();
        if (messages != null && messages.length > 0) {
            listener.addMessages(messages);
            for (int i = 0; i < messages.length; ++i) {
                messages[i].setCreatingTask(task);
                this.queueMessage(messages[i], task, taskRunDetails);
                messages[i].wasSent(true);
            }
        } else {
            this.changeState(AgentState.SEND_FAILED, task, taskRunDetails.getRunNumber());
        }
        return messagesSent;
    }

    private void changeState(AgentState agentState, ITask task, int runNumber) {
        AgentEventSenderImpl.instance().sendEvent(task.getNCObjectId(), runNumber, agentState);
    }

    private synchronized void queueMessage(IMessage message, ITask task, ITaskRunDetails taskRunDetails) throws MessageException {
        try {
            ObjectMessage msg = this.session.createObjectMessage();
            SequenceSpec runSpec = this.getObjects(message, task, taskRunDetails);
            SequenceSpec[] seqSpec = new SequenceSpec[]{runSpec};
            boolean hasCanUseSchedulingPriorityCapability = this.hasCanUseSchedulingPriorityCapability(runSpec);
            SchedulePriority sp = taskRunDetails.getSchedulePriority(hasCanUseSchedulingPriorityCapability);
            ((BiBusRunSpec)runSpec.getTask()).priority = sp.priority;
            ((BiBusRunSpec)runSpec.getTask()).setDefaultSchedulePriorityEnforced(sp.isDefaultSchedulePriorityEnforced);
            TaskPersistLayer.TaskRecords taskRecords = TaskPersistLayer.getInstance().addTasks(null, seqSpec);
            msg.setObject((Serializable)taskRecords.taskRecord.getTaskId());
            this.sender.send((Message)msg);
        }
        catch (Exception e) {
            message.wasSent(false);
            String s = I18NUtil.getMessage((I18NCode)I18NCode.MSG_UNABLE_QUEUE_MESSAGE, (Object[])new String[]{message.getSubject()}, (Locale)LogManager.getLocale());
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(e.getMessage() + " " + s);
            throw new MessageException(I18NCode.MSG_UNABLE_QUEUE_MESSAGE, new String[]{message.getSubject()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCanUseSchedulingPriorityCapability(SequenceSpec runSpec) {
        boolean hasCanUseSchedulingPriorityCapability = false;
        try {
            hasCanUseSchedulingPriorityCapability = AuthenticatorFactory.getInstance().hasCapability(((BiBusRunSpec)runSpec.getTask()).header, UserCapabilityEnum.canUseSchedulingPriority);
            return hasCanUseSchedulingPriorityCapability;
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(e.getMessage());
        }
        finally {
            return hasCanUseSchedulingPriorityCapability;
        }
    }

    private SequenceSpec getObjects(IMessage msg, ITask task, ITaskRunDetails taskRunDetails) throws AxisFault, SOAPException, PublishedGuidException {
        String text = "<SOAP-ENV:Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' xmlns:SOAP-ENC='http://schemas.xmlsoap.org/soap/encoding/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:bus='http://developer.cognos.com/schemas/bibus/3/'>" + msg.getMessageText() + "</SOAP-ENV:Envelope>";
        IEventId eventID = taskRunDetails.getEvent().getEventId();
        String eventIDString = eventID.toXMLString();
        org.apache.axis.Message m = new org.apache.axis.Message((Object)text, true);
        MessageContext mc = new MessageContext(this.engine);
        m.setMessageContext(mc);
        mc.setCurrentMessage(m);
        BiBusHeader hdr = new BiBusHeader();
        if (hdr.getCAM() == null) {
            hdr.setCAM(new CAM());
        }
        hdr.getCAM().setCAMCredentialPath(msg.getCredential());
        hdr.getCAM().setAction(LOGONAS);
        SOAPEnvelope env = (SOAPEnvelope)m.getSOAPPart().getEnvelope();
        SOAPBodyElement be = env.getFirstBody();
        BiBusRunSpec taskSpec = new BiBusRunSpec(hdr);
        taskSpec.scheduleType = taskRunDetails.getScheduleType();
        taskSpec.setCredentialPath(msg.getCredential());
        taskSpec.scheduleTrigger = taskRunDetails.getScheduleTrigger();
        taskSpec.objectClass = task.getObjectClass();
        taskSpec.isCancelledRun = taskRunDetails.isCancelledRun();
        taskSpec.cancelledBy = taskRunDetails.getCancelledBy();
        taskSpec.eventID = eventIDString;
        taskSpec.tenantID = taskRunDetails.getTenantID();
        SequenceSpec runSpec = new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)taskSpec);
        Iterator children = be.getChildElements();
        while (children.hasNext()) {
            MessageElement me = (MessageElement)children.next();
            Object o = me.getObjectValue();
            if (o == null) continue;
            if (o instanceof SearchPathSingleObject) {
                this.alterPath(msg, (SearchPathSingleObject)o);
                taskSpec.searchPath = ((SearchPathSingleObject)o).get_value();
                continue;
            }
            if (o instanceof Option[]) {
                Option[] options = (Option[])o;
                String documentVersionID = taskRunDetails.getDocumentVersionID();
                if (documentVersionID != null) {
                    SubscriptionOptionSearchPathSingleObject documentVersionOption = new SubscriptionOptionSearchPathSingleObject();
                    documentVersionOption.setName(SubscriptionOptionEnum.documentVersion);
                    SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
                    searchPathSingleObject.set_value(documentVersionID);
                    documentVersionOption.setValue(searchPathSingleObject);
                    taskSpec.options = OptionUtils.concatenateOptions((Option[])options, (Option[])new Option[]{documentVersionOption});
                    continue;
                }
                taskSpec.options = options;
                continue;
            }
            if (!(o instanceof ParameterValue[])) continue;
            taskSpec.parameters = (ParameterValue[])o;
        }
        taskSpec.options = OptionUtils.concatenateOptions((Option[])taskSpec.options, (Option[])taskRunDetails.getTaskOptions());
        return runSpec;
    }

    private void alterPath(IMessage msg, SearchPathSingleObject objPath) throws PublishedGuidException {
        String path = objPath.get_value();
        int startOfFakeGuid = path.indexOf("abcdefghijklmtaskidnopqrstuvwxyz");
        if (startOfFakeGuid > 0) {
            ITask task = msg.getCreatingTask();
            PublishedGuidPersist guidPersist = PublishedGuidPersist.getInstance();
            String guid = guidPersist.getGuid(task.getNCObjectId(), task.getAgentSubType());
            if (guid == null || guid.equals("")) {
                throw new PublishedGuidException(I18NCode.GUID_ERROR_RETRIEVE_LINK, new Object[]{guid});
            }
            path = path.substring(0, startOfFakeGuid) + guid + path.substring(startOfFakeGuid + 32);
            objPath.set_value(path);
        }
    }

    public boolean processMessages(ITask task, Collection messages, ITaskRunDetails taskRunDetails, IAgentStateListener listener) {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        boolean messagesSent = false;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "ENTER", "build messages - synchronous");
        Iterator list = messages.iterator();
        while (list.hasNext()) {
            try {
                boolean checkMessagesSent = false;
                IMessageBuildInformation[] mbiArray = this.getBuildInformation((IMessageStruct)list.next());
                for (int i = 0; i < mbiArray.length; ++i) {
                    checkMessagesSent = this.processMessages(mbiArray[i], task, listener, taskRunDetails);
                    if (!checkMessagesSent) continue;
                    messagesSent = checkMessagesSent;
                }
            }
            catch (Exception ex) {
                errors.add(ex);
            }
        }
        Iterator errors_list = errors.iterator();
        if (errors_list.hasNext()) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).log(SDSLevel.WARN, I18NCode.MSG_AN_ERROR_HAS_OCCURED_WHILE_TRYING_TO_SEND_A_MESSAGE);
        }
        while (errors_list.hasNext()) {
            Exception ex = (Exception)errors_list.next();
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug((Throwable)ex);
        }
        perf.stop();
        return messagesSent;
    }
}

