/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.message;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.objectid.NCObjectId;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import noticecast.datatier.message.JDBCDhJDBCMessageStruct;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.NCBaseObjectImpl;
import noticecast.logictier.message.IMessageLine;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.IRecipientLink;
import noticecast.logictier.message.IRecipientRetriever;
import noticecast.logictier.message.RecipientRetrieverImpl;
import noticecast.logictier.message.TextMessageLine;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.services.RepositoryServicesImpl;

public class MessageStructImpl
extends NCBaseObjectImpl
implements IMessageStruct {
    static final long serialVersionUID = 70009003L;
    private Vector m_messageLines = new Vector();
    private String m_shortMessage = "";
    private String m_from = "";
    private String m_subject = "";
    private Hashtable m_recipients = new Hashtable();
    private boolean m_staticMessageRecipient = true;
    private ChannelType m_channelType = ChannelType.INVALID_DELIVERY_CHANNEL;
    private boolean m_applyMsgDuplicationAvoidance;
    private boolean m_archiveMsgDuplicationAvoidance;
    private String m_contact;
    private String m_credential;
    private BiBusHeader m_biBusHeader;
    private boolean m_isCustomView = false;
    private transient IRecipientRetriever m_recipient_retriever = new RecipientRetrieverImpl();
    private static int MESSAGE_TEXT_COLUMN_WIDTH = JDBCConnectionProperties.instance((String)"SDS").getMessageTokenLength();
    private String m_html_form;
    private String m_text_form;

    public boolean equals(Object messageStruct) {
        if (null == messageStruct) {
            return false;
        }
        boolean success = false;
        IMessageStruct msgStruct = (IMessageStruct)messageStruct;
        if (msgStruct.getNCObjectId().equals(this.getNCObjectId())) {
            success = true;
        }
        return success;
    }

    @Override
    public boolean addMessageLine(IMessageLine ml) {
        int origSize = this.m_messageLines.size();
        this.m_messageLines.addElement(ml);
        int newSize = this.m_messageLines.size();
        return ++origSize == newSize;
    }

    @Override
    public boolean addMessageLine(String text) {
        int newSize;
        int origSize = this.m_messageLines.size();
        int i = 0;
        for (int sizeLeft = text.length(); sizeLeft > 0; sizeLeft -= MESSAGE_TEXT_COLUMN_WIDTH) {
            if (sizeLeft <= MESSAGE_TEXT_COLUMN_WIDTH) {
                this.m_messageLines.addElement(new TextMessageLine(text.substring(i)));
                break;
            }
            this.m_messageLines.addElement(new TextMessageLine(text.substring(i, i + MESSAGE_TEXT_COLUMN_WIDTH)));
            i += MESSAGE_TEXT_COLUMN_WIDTH;
        }
        return origSize < (newSize = this.m_messageLines.size());
    }

    @Override
    public void setShortMessage(String text) {
        this.m_shortMessage = text;
    }

    @Override
    public void setRecipientLinks(IRecipientLink[] links) {
        Hashtable<NCObjectId, IRecipientLink> linkMap = new Hashtable<NCObjectId, IRecipientLink>();
        for (int i = 0; i < links.length; ++i) {
            linkMap.put(links[i].getRecipientId(), links[i]);
        }
        this.m_recipients = linkMap;
    }

    @Override
    public Vector getMessageLines() {
        return this.m_messageLines;
    }

    @Override
    public void setMessageLines(Vector messageLines) {
        this.m_messageLines = messageLines;
    }

    @Override
    public String getShortMessage() {
        return this.m_shortMessage == null ? "" : this.m_shortMessage;
    }

    @Override
    public void setFrom(String from) {
        this.m_from = from;
    }

    @Override
    public String getFrom() {
        return this.m_from == null ? "" : this.m_from;
    }

    @Override
    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    @Override
    public String getSubject() {
        return this.m_subject == null ? "" : this.m_subject;
    }

    @Override
    public boolean isAvoidMessageDuplication() {
        return this.m_applyMsgDuplicationAvoidance;
    }

    @Override
    public boolean isArchiveMessageDuplicationAvoidance() {
        return this.m_archiveMsgDuplicationAvoidance;
    }

    @Override
    public void setAvoidMessageDuplication(boolean status) {
        this.m_applyMsgDuplicationAvoidance = status;
    }

    @Override
    public void setArchiveMessageDuplicationAvoidance(boolean status) {
        this.m_archiveMsgDuplicationAvoidance = status;
    }

    @Override
    public boolean isStatic() {
        return this.m_staticMessageRecipient;
    }

    @Override
    public void setStatic(boolean staticMessageRecipient) {
        this.m_staticMessageRecipient = staticMessageRecipient;
    }

    private JDBCDhJDBCMessageStruct getDataHelper() {
        IPersistManager pm = this.getPersistManager();
        JDBCDhJDBCMessageStruct dhelper = null;
        try {
            dhelper = (JDBCDhJDBCMessageStruct)pm.getDataHelper(NCObjectType.MESSAGE_STRUCT);
        }
        catch (PersistManagerException persistManagerException) {
            // empty catch block
        }
        return dhelper;
    }

    private IPersistManager getPersistManager() {
        return RepositoryServicesImpl.instance().getPersistManager();
    }

    @Override
    public String getContact() {
        return this.m_contact;
    }

    @Override
    public void setContact(String contact) {
        this.m_contact = contact;
    }

    @Override
    public ChannelType getChannelType() {
        return this.m_channelType;
    }

    @Override
    public void setChannelType(ChannelType channelType) {
        this.m_channelType = channelType;
    }

    @Override
    public void removeRecipientLink(IRecipientLink recipientLink) {
        this.m_recipients.remove(recipientLink.getRecipientId());
    }

    @Override
    public void addRecipientLink(IRecipientLink recipientLink) {
        this.m_recipients.put(recipientLink.getRecipientId(), recipientLink);
    }

    @Override
    public IRecipientLink[] getRecipientLinks() {
        IRecipientLink[] linkArray = new IRecipientLink[this.m_recipients.size()];
        Enumeration xenum = this.m_recipients.elements();
        int index = 0;
        while (xenum.hasMoreElements()) {
            linkArray[index] = (IRecipientLink)xenum.nextElement();
            ++index;
        }
        return linkArray;
    }

    @Override
    public void setCustomView(boolean isView) {
        this.m_isCustomView = isView;
    }

    @Override
    public boolean isCustomView() {
        return this.m_isCustomView;
    }

    @Override
    public void setCredential(String cred) {
        this.m_credential = cred;
    }

    @Override
    public String getCredential() {
        return this.m_credential;
    }

    @Override
    public void setRecipientRetriever(IRecipientRetriever retriever) {
        this.m_recipient_retriever = retriever;
    }

    @Override
    public IRecipientRetriever getRecipientRetriever() {
        return this.m_recipient_retriever;
    }

    @Override
    public BiBusHeader getBusHeader() {
        return this.m_biBusHeader;
    }

    @Override
    public void setBusHeader(BiBusHeader busHeader) {
        this.m_biBusHeader = busHeader;
    }

    @Override
    public void setHtmlForm(String htmlForm) {
        this.m_html_form = htmlForm;
    }

    @Override
    public void setTextForm(String textForm) {
        this.m_text_form = textForm;
    }

    @Override
    public String getHtmlForm() {
        return this.m_html_form;
    }

    @Override
    public String getTextForm() {
        return this.m_text_form;
    }
}

