/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.message;

import com.cognos.jsmcommon.objectid.NCObjectId;
import java.util.Date;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.message.IRecipientLink;
import noticecast.logictier.message.IRecipientRetriever;
import noticecast.logictier.recipient.IRecipient;

public class RecipientLinkImpl
implements IRecipientLink {
    private INCFeatherWeight m_recipientFeatherWeight;
    private Date m_linkDate;
    private NCObjectId m_adderId;

    public RecipientLinkImpl(INCFeatherWeight recipientFeatherWeight, Date linkDate, NCObjectId adderId) {
        this.m_recipientFeatherWeight = recipientFeatherWeight;
        this.m_linkDate = linkDate == null ? new Date() : linkDate;
        this.m_adderId = adderId;
    }

    public RecipientLinkImpl(INCFeatherWeight recipientFeatherWeight, Date linkDate) {
        this(recipientFeatherWeight, linkDate, null);
    }

    public RecipientLinkImpl(INCFeatherWeight recipientFeatherWeight, NCObjectId adderId) {
        this(recipientFeatherWeight, null, adderId);
    }

    public RecipientLinkImpl(INCFeatherWeight recipientFeatherWeight) {
        this(recipientFeatherWeight, null, null);
    }

    @Override
    public Date getLinkedDate() {
        return this.m_linkDate;
    }

    @Override
    public IRecipient getRecipient(IRecipientRetriever retriever) {
        return retriever.getRecipient(this.m_recipientFeatherWeight.getNCObjectId());
    }

    @Override
    public NCObjectId getRecipientId() {
        return this.m_recipientFeatherWeight.getNCObjectId();
    }

    @Override
    public INCFeatherWeight getRecipientFeatherWeight() {
        return this.m_recipientFeatherWeight;
    }

    @Override
    public NCObjectId getRecipientAdderId() {
        return this.m_adderId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof IRecipient) {
            NCObjectId oid = ((IRecipient)o).getNCObjectId();
            if (this.m_recipientFeatherWeight.getNCObjectId().equals(oid)) {
                result = true;
            }
        }
        return result;
    }
}

