/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.message;

import java.util.ArrayList;
import noticecast.logictier.message.IMessage;
import noticecast.logictier.message.IMessageBuildInformation;
import noticecast.logictier.message.IMessageBuilder;
import noticecast.logictier.message.IMessageContent;
import noticecast.logictier.message.IMessageContentBuilder;
import noticecast.logictier.message.IMessageFactory;
import noticecast.logictier.message.MessageBuilderImpl;
import noticecast.logictier.message.MessageException;
import noticecast.logictier.message.MessageFactoryImpl;
import noticecast.logictier.message.SimpleMessageContentBuilder;
import noticecast.logictier.recipient.IRecipient;
import noticecast.logictier.recipient.RecipientType;

public class StaticMessageBuilder
extends MessageBuilderImpl
implements IMessageBuilder {
    IMessageBuildInformation m_mbi = null;
    private IMessageContentBuilder m_contentBuilder = null;

    public StaticMessageBuilder(IMessageBuildInformation mbi) {
        this.m_mbi = mbi;
        this.m_contentBuilder = new SimpleMessageContentBuilder(mbi.getMessageStruct());
    }

    @Override
    public IMessage[] getMessages() throws MessageException {
        return this.getStaticMessages();
    }

    private IMessage[] getStaticMessages() {
        IMessage[] messages = new IMessage[]{};
        IRecipient[] recipients = this.m_mbi.getRecipients();
        if (recipients.length < 1) {
            return messages;
        }
        IMessageFactory messageFactory = MessageFactoryImpl.instance();
        IMessageContent content = this.m_contentBuilder.getMessageContent();
        ArrayList<IMessage> messageList = new ArrayList<IMessage>();
        recipients = this.m_mbi.getRecipients();
        for (int i = 0; i < recipients.length; ++i) {
            recipients[i].setRecipientType(RecipientType.STATIC_RECIPIENT);
        }
        IMessage message = messageFactory.getMessageObject(recipients, this.m_mbi.getMessageStruct(), content);
        messageList.add(message);
        messages = new IMessage[messageList.size()];
        messageList.toArray(messages);
        return messages;
    }
}

