/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.recipient;

import java.io.Serializable;

public final class DeliveryAddressType
implements Serializable {
    static final long serialVersionUID = 70009003L;
    private int m_addressType;
    private boolean m_allowDuplicates = false;
    private static final int m_NOTICECAST = 0;
    private static final int m_ACCMAN = 1;
    public static final DeliveryAddressType NOTICECAST = new DeliveryAddressType(0, false);
    public static final DeliveryAddressType ACCMAN = new DeliveryAddressType(1, false);

    private DeliveryAddressType(int type, boolean allowDuplicates) {
        this.m_addressType = type;
        this.m_allowDuplicates = allowDuplicates;
    }

    public static DeliveryAddressType get(int i) {
        DeliveryAddressType type = null;
        switch (i) {
            case 0: {
                type = NOTICECAST;
                break;
            }
            case 1: {
                type = ACCMAN;
            }
        }
        return type;
    }

    public boolean isEqualTo(DeliveryAddressType obj) {
        boolean result;
        boolean bl = result = obj != null && obj instanceof DeliveryAddressType;
        if (result) {
            DeliveryAddressType other = obj;
            result = this.m_addressType - other.m_addressType == 0;
            result = result && this.m_allowDuplicates == other.m_allowDuplicates;
        }
        return result;
    }

    public int hashCode() {
        return this.m_addressType;
    }

    public int getSQLValue() {
        return this.m_addressType;
    }

    public Integer getInteger() {
        Integer value = new Integer(this.m_addressType);
        return value;
    }

    public String toString() {
        String value = "";
        switch (this.m_addressType) {
            case 0: {
                value = "NoticeCast";
                break;
            }
            case 1: {
                value = "AccMan";
            }
        }
        return value;
    }

    public boolean allowsDuplicates() {
        return this.m_allowDuplicates;
    }
}

