/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.recipient;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import noticecast.logictier.recipient.IDeliverySchedule;
import noticecast.logictier.recipient.LocalDeliverySchedule;
import noticecast.util.NcDayConstants;

public class DeliverySchedule
implements IDeliverySchedule,
Serializable {
    static final long serialVersionUID = 70009003L;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_DAY = 86400;
    private static final int BACKWARD = -1;
    private static final int FORWARD = 1;
    private LocalDeliverySchedule m_localSchedule;

    public LocalDeliverySchedule getLocalSchedule() {
        return this.m_localSchedule;
    }

    public LocalDeliverySchedule getLocalSchedule(TimeZone requiredTz) {
        Calendar orig_cal = this.getStartTime(this.m_localSchedule.getTimeZone());
        Calendar start_cal = this.getStartTime(requiredTz);
        Calendar end_cal = this.getEndTime(requiredTz);
        int start_secs = this.determineSeconds(start_cal);
        int end_secs = this.determineSeconds(end_cal);
        this.m_localSchedule.setStartSecond(start_secs);
        this.m_localSchedule.setEndSecond(end_secs);
        this.m_localSchedule.setTimeZone(requiredTz);
        int orig_day = orig_cal.get(5);
        int start_day = start_cal.get(5);
        if (orig_day < start_day) {
            this.m_localSchedule = this.rollDays(1, this.m_localSchedule);
        } else if (orig_day > start_day) {
            this.m_localSchedule = this.rollDays(-1, this.m_localSchedule);
        }
        return this.m_localSchedule;
    }

    public void setLocalSchedule(LocalDeliverySchedule localSchedule) {
        this.m_localSchedule = localSchedule;
    }

    @Override
    public boolean isValid() {
        return this.isValid(new Date());
    }

    @Override
    public boolean isValid(Date date) {
        NcDayConstants day;
        boolean valid;
        int start = this.m_localSchedule.getStartSecond();
        int end = this.m_localSchedule.getEndSecond();
        Calendar startCal = this.getStartTime(this.m_localSchedule.getTimeZone());
        Calendar endCal = this.getEndTime(this.m_localSchedule.getTimeZone());
        Calendar current = Calendar.getInstance((TimeZone)this.m_localSchedule.getTimeZone());
        current.setTime(date);
        boolean daySpan = start == 0 && end == 0;
        boolean possiblePrevious = false;
        if (end < start || daySpan) {
            endCal.add(5, 1);
            possiblePrevious = true;
        }
        if (!(valid = this.checkValid(day = NcDayConstants.getDay(current.get(7)), current, startCal, endCal)) && possiblePrevious && !daySpan) {
            startCal.add(5, -1);
            endCal.add(5, -1);
            day = NcDayConstants.getDay(day.intValue() - 1);
            valid = this.checkValid(day, current, startCal, endCal);
        }
        return valid;
    }

    private boolean checkValid(NcDayConstants day, Calendar current, Calendar start, Calendar end) {
        boolean valid = this.m_localSchedule.isDayChecked(day);
        valid = valid && current.after(start);
        valid = valid && current.before(end);
        return valid;
    }

    private LocalDeliverySchedule rollDays(int rollIndex, LocalDeliverySchedule localSchedule) {
        int days = NcDayConstants.DAYS.length;
        int index = 0;
        boolean firstLoop = true;
        boolean currentDayChecked = false;
        boolean nextDayChecked = false;
        for (int i = 0; i < 7 && i > -7; i += rollIndex) {
            index = this.getNextIndex(i, rollIndex, days);
            if (firstLoop) {
                currentDayChecked = localSchedule.isDayChecked(NcDayConstants.DAYS[i]);
            }
            nextDayChecked = localSchedule.isDayChecked(NcDayConstants.DAYS[index]);
            localSchedule.setDayChecked(NcDayConstants.DAYS[index], currentDayChecked);
            currentDayChecked = nextDayChecked;
            firstLoop = false;
        }
        return localSchedule;
    }

    private int getNextIndex(int index, int offset, int radix) {
        if ((index += offset) < 0) {
            index += radix;
        } else if (index >= radix) {
            index -= radix;
        }
        return index;
    }

    @Override
    public String toRepositoryString() {
        StringBuffer toReturn = new StringBuffer();
        toReturn.append(this.getTimeString(this.m_localSchedule.getStartSecond()));
        toReturn.append(",");
        toReturn.append(this.getTimeString(this.m_localSchedule.getEndSecond()));
        toReturn.append(",");
        for (int i = 0; i < NcDayConstants.DAYS.length; ++i) {
            if (this.m_localSchedule.isDayChecked(NcDayConstants.DAYS[i])) {
                toReturn.append("T");
                continue;
            }
            toReturn.append("F");
        }
        toReturn.append(",");
        toReturn.append(this.m_localSchedule.getTimeZone().getID());
        return toReturn.toString();
    }

    String getTimeString(int seconds) {
        String secondString;
        String minuteString;
        int hours = 0;
        int minutes = 0;
        int remainingSecs = seconds;
        while (remainingSecs >= 3600) {
            remainingSecs -= 3600;
            ++hours;
        }
        while (remainingSecs >= 60) {
            remainingSecs -= 60;
            ++minutes;
        }
        String hourString = Integer.toString(hours);
        if (hourString.length() == 1) {
            hourString = "0" + hourString;
        }
        if ((minuteString = Integer.toString(minutes)).length() == 1) {
            minuteString = "0" + minuteString;
        }
        if ((secondString = Integer.toString(remainingSecs)).length() == 1) {
            secondString = "0" + secondString;
        }
        return hourString + ":" + minuteString + ":" + secondString;
    }

    public static DeliverySchedule parseRepositoryString(String str) {
        boolean minsAsSecs;
        boolean hoursAsSecs;
        String endSecStr;
        String endMinStr;
        String endHrStr;
        String startSecStr;
        String startMinStr;
        String startHrStr;
        StringTokenizer tokens = new StringTokenizer(str, ":,");
        String errMsg = "Error parsing schedule string: Recipient Schedule not created";
        int startSecond = 0;
        int endSecond = 0;
        String days = null;
        String timeZoneId = null;
        if (tokens.countTokens() == 3) {
            startHrStr = tokens.nextToken();
            String endHrStr2 = tokens.nextToken();
            days = tokens.nextToken();
            try {
                startSecond = Integer.parseInt(startHrStr) * 3600;
                endSecond = Integer.parseInt(endHrStr2) * 3600;
            }
            catch (NumberFormatException ex) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_ERROR_PARSING_RECIPIENT_SCHEDULE_STRING);
                return null;
            }
        } else if (tokens.countTokens() == 7) {
            startHrStr = tokens.nextToken();
            startMinStr = tokens.nextToken();
            startSecStr = tokens.nextToken();
            endHrStr = tokens.nextToken();
            endMinStr = tokens.nextToken();
            endSecStr = tokens.nextToken();
            days = tokens.nextToken();
            timeZoneId = "GMT";
            hoursAsSecs = false;
            minsAsSecs = false;
            try {
                startSecond += Integer.parseInt(startHrStr) * 3600;
                startSecond += Integer.parseInt(startMinStr) * 60;
                startSecond += Integer.parseInt(startSecStr);
                endSecond += Integer.parseInt(endHrStr) * 3600;
                endSecond += Integer.parseInt(endMinStr) * 60;
                endSecond += Integer.parseInt(endSecStr);
            }
            catch (NumberFormatException ex) {
                AuditProperties ap = AuditPropUtil.doProps(DeliverySchedule.class, (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_ERROR_PARSING_RECIPIENT_SCHEDULE_STRING);
                return null;
            }
        } else if (tokens.countTokens() == 8) {
            startHrStr = tokens.nextToken();
            startMinStr = tokens.nextToken();
            startSecStr = tokens.nextToken();
            endHrStr = tokens.nextToken();
            endMinStr = tokens.nextToken();
            endSecStr = tokens.nextToken();
            days = tokens.nextToken();
            timeZoneId = tokens.nextToken();
            hoursAsSecs = false;
            minsAsSecs = false;
            try {
                startSecond += Integer.parseInt(startHrStr) * 3600;
                startSecond += Integer.parseInt(startMinStr) * 60;
                startSecond += Integer.parseInt(startSecStr);
                endSecond += Integer.parseInt(endHrStr) * 3600;
                endSecond += Integer.parseInt(endMinStr) * 60;
                endSecond += Integer.parseInt(endSecStr);
            }
            catch (NumberFormatException ex) {
                AuditProperties ap = AuditPropUtil.doProps(DeliverySchedule.class, (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_ERROR_PARSING_RECIPIENT_SCHEDULE_STRING);
                return null;
            }
        } else {
            AuditProperties ap = AuditPropUtil.doProps(DeliverySchedule.class, (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_ERROR_PARSING_RECIPIENT_SCHEDULE_STRING);
            return null;
        }
        LocalDeliverySchedule localSchedule = new LocalDeliverySchedule();
        localSchedule.setStartSecond(startSecond);
        localSchedule.setEndSecond(endSecond);
        localSchedule.setTimeZone(TimeZone.getTimeZone((String)timeZoneId));
        if (days.length() != 7) {
            AuditProperties ap = AuditPropUtil.doProps(DeliverySchedule.class, (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_UNSUPPORTED_TIMEZONE_EXCEPTION, (Object[])new String[]{timeZoneId});
            return null;
        }
        for (int i = 0; i < days.length(); ++i) {
            if (days.charAt(i) != 'T') continue;
            localSchedule.setDayChecked(NcDayConstants.DAYS[i], true);
        }
        DeliverySchedule schedule = new DeliverySchedule();
        schedule.setLocalSchedule(localSchedule);
        return schedule;
    }

    private Calendar getStartTime(TimeZone requestedTZ) {
        int start = this.m_localSchedule.getStartSecond();
        Calendar schedule_start = Calendar.getInstance((TimeZone)this.m_localSchedule.getTimeZone());
        int hours = start / 3600;
        int mins = (start - hours * 3600) / 60;
        int secs = start - hours * 3600 - mins * 60;
        schedule_start.set(11, hours);
        schedule_start.set(12, mins);
        schedule_start.set(13, secs);
        hours = schedule_start.get(11);
        mins = schedule_start.get(12);
        secs = schedule_start.get(13);
        schedule_start.setTimeZone(requestedTZ);
        hours = schedule_start.get(11);
        mins = schedule_start.get(12);
        secs = schedule_start.get(13);
        return schedule_start;
    }

    private Calendar getEndTime(TimeZone requestedTZ) {
        int end = this.m_localSchedule.getEndSecond();
        Calendar schedule_end = Calendar.getInstance((TimeZone)this.m_localSchedule.getTimeZone());
        int hours = end / 3600;
        int mins = (end - hours * 3600) / 60;
        int secs = end - hours * 3600 - mins * 60;
        schedule_end.set(11, hours);
        schedule_end.set(12, mins);
        schedule_end.set(13, secs);
        hours = schedule_end.get(11);
        mins = schedule_end.get(12);
        secs = schedule_end.get(13);
        schedule_end.setTimeZone(requestedTZ);
        hours = schedule_end.get(11);
        mins = schedule_end.get(12);
        secs = schedule_end.get(13);
        return schedule_end;
    }

    private int determineSeconds(Calendar cal) {
        int hours = cal.get(11);
        int mins = cal.get(12);
        int secs = cal.get(13) + mins * 60 + hours * 3600;
        return secs;
    }
}

