/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.recipient;

import com.cognos.i18n.TimeZone;
import java.io.Serializable;
import java.util.Hashtable;
import noticecast.util.NcDayConstants;

public class LocalDeliverySchedule
implements Serializable,
Cloneable {
    static final long serialVersionUID = 70009003L;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int SECONDS_IN_HOUR = 3600;
    private Hashtable m_daysChecked;
    private int m_startSecond = 0;
    private int m_endSecond = 0;
    private TimeZone m_TimeZone = TimeZone.getTimeZone((String)"GMT");

    public LocalDeliverySchedule() {
        this.m_daysChecked = new Hashtable(13);
        this.m_daysChecked.put(NcDayConstants.SUNDAY, Boolean.FALSE);
        this.m_daysChecked.put(NcDayConstants.MONDAY, Boolean.FALSE);
        this.m_daysChecked.put(NcDayConstants.TUESDAY, Boolean.FALSE);
        this.m_daysChecked.put(NcDayConstants.WEDNESDAY, Boolean.FALSE);
        this.m_daysChecked.put(NcDayConstants.THURSDAY, Boolean.FALSE);
        this.m_daysChecked.put(NcDayConstants.FRIDAY, Boolean.FALSE);
        this.m_daysChecked.put(NcDayConstants.SATURDAY, Boolean.FALSE);
    }

    public int getStartSecond() {
        return this.m_startSecond;
    }

    public int getEndSecond() {
        return this.m_endSecond;
    }

    public boolean isDayChecked(NcDayConstants day) {
        Boolean isDayChecked = (Boolean)this.m_daysChecked.get(day);
        return isDayChecked;
    }

    public void setDayChecked(NcDayConstants day, boolean use) {
        this.m_daysChecked.put(day, use);
    }

    public void setStartSecond(int startSecond) {
        this.m_startSecond = this.getValidSecond(startSecond);
    }

    public void setEndSecond(int endSecond) {
        this.m_endSecond = this.getValidSecond(endSecond);
    }

    public void setTimeZone(TimeZone tz) {
        this.m_TimeZone = tz;
    }

    public TimeZone getTimeZone() {
        return this.m_TimeZone;
    }

    public Object clone() {
        LocalDeliverySchedule localSchedule = null;
        try {
            localSchedule = (LocalDeliverySchedule)super.clone();
            localSchedule.m_daysChecked = (Hashtable)this.m_daysChecked.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return localSchedule;
    }

    private int getValidSecond(int second) {
        if (second < 0) {
            return 0;
        }
        if (second > 86399) {
            return 86399;
        }
        return second;
    }
}

