/*
 * Decompiled with CFR 0.152.
 */
package noticecast.logictier.recipient;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import noticecast.debug.Debug;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.logictier.base.NCBaseObjectImpl;
import noticecast.logictier.recipient.IDeliveryAddress;
import noticecast.logictier.recipient.IRecipient;
import noticecast.logictier.recipient.IRecipientDeliverySchedule;
import noticecast.logictier.recipient.RecipientOrigin;
import noticecast.logictier.recipient.RecipientType;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistWrapperException;
import noticecast.services.RepositoryServicesImpl;
import noticecast.util.ValidResult;
import noticecast.util.ValidityErrMsgs;

public class RecipientImpl
extends NCBaseObjectImpl
implements IRecipient {
    static final long serialVersionUID = 70009003L;
    private String m_title = "";
    private String m_firstName = "";
    private String m_middleName = "";
    private String m_lastName = "";
    private String m_phoneNumber = "";
    private String m_jobTitle = "";
    private String m_companyName = "";
    private String m_department = "";
    private String m_office = "";
    private String m_country = "";
    private String m_timezone = "";
    private String m_accManEmail;
    private transient RecipientType m_recipient_type;
    private Vector m_groups;
    private INCFeatherWeight m_redirection;
    private boolean m_redirect;
    private RecipientOrigin m_recipient_origin;
    private boolean m_isUseDefaultAddress = true;
    private ArrayList m_deliveryAddresses;
    private IRecipientDeliverySchedule[] m_recipientDeliverySchedule = new IRecipientDeliverySchedule[0];

    public RecipientImpl() {
        this.m_deliveryAddresses = new ArrayList();
        this.m_groups = new Vector();
    }

    public IRecipientDeliverySchedule[] getRecipientDeliverySchedule() {
        return this.m_recipientDeliverySchedule;
    }

    public void setRecipientDeliverySchedule(IRecipientDeliverySchedule[] deliverySchedule) {
        this.m_recipientDeliverySchedule = deliverySchedule;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public void setTitle(String title) {
        if (title != null) {
            this.m_title = title;
        }
    }

    @Override
    public String getFirstName() {
        return this.m_firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        if (firstName != null) {
            this.m_firstName = firstName;
        }
    }

    @Override
    public String getJobTitle() {
        return this.m_jobTitle;
    }

    @Override
    public void setJobTitle(String jobTitle) {
        if (jobTitle != null) {
            this.m_jobTitle = jobTitle;
        }
    }

    @Override
    public String getMiddleName() {
        return this.m_middleName;
    }

    @Override
    public void setMiddleName(String middleName) {
        if (middleName != null) {
            this.m_middleName = middleName;
        }
    }

    @Override
    public String getLastName() {
        return this.m_lastName;
    }

    @Override
    public void setLastName(String lastName) {
        if (lastName != null) {
            this.m_lastName = lastName;
        }
    }

    @Override
    public String getPhoneNumber() {
        return this.m_phoneNumber;
    }

    @Override
    public void setPhoneNumber(String phoneNumber) {
        if (phoneNumber != null) {
            this.m_phoneNumber = phoneNumber;
        }
    }

    @Override
    public String getCompanyName() {
        return this.m_companyName;
    }

    @Override
    public void setCompanyName(String companyName) {
        if (companyName != null) {
            this.m_companyName = companyName;
        }
    }

    @Override
    public String getDepartment() {
        return this.m_department;
    }

    @Override
    public void setDepartment(String department) {
        if (department != null) {
            this.m_department = department;
        }
    }

    @Override
    public void setIsUseDefaultAddress(boolean status) {
        this.m_isUseDefaultAddress = status;
    }

    @Override
    public boolean isUseDefaultAddress() {
        return this.m_isUseDefaultAddress;
    }

    @Override
    public String getOffice() {
        return this.m_office;
    }

    @Override
    public void setOffice(String office) {
        if (office != null) {
            this.m_office = office;
        }
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public void setCountry(String country) {
        if (country != null) {
            this.m_country = country;
        }
    }

    @Override
    public String getTimezone() {
        return this.m_timezone;
    }

    @Override
    public void setTimezone(String timezone) {
        if (timezone != null) {
            this.m_timezone = timezone;
        }
    }

    public String toString() {
        return this.m_firstName + this.m_middleName + this.m_lastName;
    }

    @Override
    public void setRedirection(INCFeatherWeight recipient) {
        this.m_redirection = recipient;
    }

    @Override
    public INCFeatherWeight getRedirection() {
        return this.m_redirection;
    }

    @Override
    public void enableRedirect() {
        this.m_redirect = true;
    }

    @Override
    public void disableRedirect() {
        this.m_redirect = false;
    }

    @Override
    public boolean isRedirected() {
        return this.m_redirect;
    }

    @Override
    public void setRecipientType(RecipientType recipient_type) {
        this.m_recipient_type = recipient_type;
    }

    @Override
    public RecipientType getRecipientType() {
        return this.m_recipient_type;
    }

    @Override
    public RecipientOrigin getRecipientOrigin() {
        return this.m_recipient_origin;
    }

    @Override
    public void setRecipientOrigin(RecipientOrigin source) {
        this.m_recipient_origin = source;
    }

    @Override
    public IDeliveryAddress[] getDefaultDeliveryAddresses() {
        ArrayList<IDeliveryAddress> defaultAddresses = new ArrayList<IDeliveryAddress>(1);
        for (IDeliveryAddress defaultAddress : this.m_deliveryAddresses) {
            if (!defaultAddress.isDefault()) continue;
            defaultAddresses.add(defaultAddress);
        }
        return defaultAddresses.toArray(new IDeliveryAddress[0]);
    }

    @Override
    public IDeliveryAddress[] getDefaultDeliveryAddresses(ChannelType channelType) {
        ArrayList<IDeliveryAddress> channelAddresses = new ArrayList<IDeliveryAddress>();
        IDeliveryAddress[] defaultAddresses = this.getDefaultDeliveryAddresses();
        int len = defaultAddresses.length;
        for (int i = 0; i < len; ++i) {
            if (!defaultAddresses[i].getDeliveryChannelType().equals((Object)channelType)) continue;
            channelAddresses.add(defaultAddresses[i]);
        }
        IDeliveryAddress[] addressesToReturn = channelAddresses.toArray(new IDeliveryAddress[0]);
        return addressesToReturn;
    }

    @Override
    public IDeliveryAddress[] getValidDeliveryAddresses(ChannelType channelType) {
        ArrayList<IDeliveryAddress> channelAddresses = new ArrayList<IDeliveryAddress>();
        IDeliveryAddress[] validAddresses = this.getValidDeliveryAddresses();
        int len = validAddresses.length;
        for (int i = 0; i < len; ++i) {
            if (Debug.checkConstraints && validAddresses[i] == null) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_AN_ADDRESS_IS_NULL, (Map)ap);
                continue;
            }
            if (!channelType.equals((Object)validAddresses[i].getDeliveryChannelType())) continue;
            channelAddresses.add(validAddresses[i]);
        }
        validAddresses = channelAddresses.toArray(new IDeliveryAddress[0]);
        return validAddresses;
    }

    @Override
    public IDeliveryAddress[] getValidDeliveryAddresses() {
        ArrayList<IDeliveryAddress> deliveryAddresses = new ArrayList<IDeliveryAddress>();
        boolean delAddrLength = false;
        IRecipientDeliverySchedule[] deliverySchedules = this.getRecipientDeliverySchedule();
        int schedulesLength = deliverySchedules.length;
        if (schedulesLength != 0 && !this.isUseDefaultAddress()) {
            boolean anyValidDSchedule = false;
            for (int i = 0; i < schedulesLength; ++i) {
                if (!deliverySchedules[i].isValid()) continue;
                deliveryAddresses.addAll(Arrays.asList(deliverySchedules[i].getDeliveryAddress()));
                anyValidDSchedule = true;
            }
            if (!anyValidDSchedule) {
                deliveryAddresses.addAll(Arrays.asList(this.getDefaultDeliveryAddresses()));
            }
        } else {
            deliveryAddresses.addAll(Arrays.asList(this.getDefaultDeliveryAddresses()));
        }
        IDeliveryAddress[] addressesToReturn = deliveryAddresses.toArray(new IDeliveryAddress[0]);
        return addressesToReturn;
    }

    @Override
    public IDeliveryAddress[] getDeliveryAddresses() {
        return this.m_deliveryAddresses.toArray(new IDeliveryAddress[this.m_deliveryAddresses.size()]);
    }

    @Override
    public IDeliveryAddress[] getDeliveryAddresses(ChannelType channelType) {
        ArrayList<IDeliveryAddress> channelAddresses = new ArrayList<IDeliveryAddress>();
        IDeliveryAddress[] allDeliveryAddresses = this.getDeliveryAddresses();
        int len = allDeliveryAddresses.length;
        for (int i = 0; i < len; ++i) {
            if (!allDeliveryAddresses[i].getDeliveryChannelType().equals((Object)channelType)) continue;
            channelAddresses.add(allDeliveryAddresses[i]);
        }
        IDeliveryAddress[] addressesToReturn = channelAddresses.toArray(new IDeliveryAddress[0]);
        return addressesToReturn;
    }

    @Override
    public void setDeliveryAddresses(IDeliveryAddress[] deliveryaddresses) {
        this.m_deliveryAddresses.clear();
        this.m_deliveryAddresses.addAll(Arrays.asList(deliveryaddresses));
    }

    private boolean isNameUnique() {
        boolean result;
        block4: {
            result = true;
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            try {
                INCFeatherWeight[] rcpNames = pm.getObjectList(NCObjectType.RECIPIENT, this.getName());
                INCFeatherWeight[] jdbcRcpNames = pm.getObjectList(NCObjectType.RECIPIENT, this.getName());
                ArrayList<INCFeatherWeight> all = new ArrayList<INCFeatherWeight>(3);
                all.addAll(Arrays.asList(rcpNames));
                all.addAll(Arrays.asList(jdbcRcpNames));
                if (all.isEmpty()) break block4;
                NCObjectId otherId = null;
                INCFeatherWeight oneObj2 = null;
                for (INCFeatherWeight oneObj2 : all) {
                    otherId = oneObj2.getNCObjectId();
                    if (otherId.equals(this.getNCObjectId())) continue;
                    result = false;
                    break;
                }
            }
            catch (PersistWrapperException ex) {
                if (Debug.debug) {
                    ex.printStackTrace(System.err);
                }
                result = false;
            }
        }
        return result;
    }

    @Override
    public ValidResult isValid() {
        ValidResult result = new ValidResult();
        boolean isNC = this.m_recipient_origin.isEqualTo(RecipientOrigin.NOTICECAST);
        if (this.getName() == null) {
            result.setValid(false);
            result.setMsgId(ValidityErrMsgs.RECIPIENT_UNDEFINED);
        } else if (!this.isNameUnique() && isNC) {
            result.setValid(false);
            result.setMsgId(ValidityErrMsgs.RECIPIENT_DUPLICATE);
        } else {
            result.setValid(true);
        }
        return result;
    }

    @Override
    public String getAccManEmail() {
        return this.m_accManEmail;
    }

    @Override
    public void setAccManEmail(String email) {
        this.m_accManEmail = email == null ? "" : email.trim();
    }
}

