/*
 * Decompiled with CFR 0.152.
 */
package noticecast.persist;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import noticecast.exceptions.LogictierException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCBaseObject;
import noticecast.persist.INCObjectUpdate;

public class NCObjectUpdateImpl
implements INCObjectUpdate {
    static final long serialVersionUID = 70009003L;
    private INCBaseObject m_localCopy;
    private NCObjectId m_ref;
    private int m_updateCount;
    private NCObjectType m_objType;

    public NCObjectUpdateImpl(INCBaseObject object, NCObjectType objType, int updateStamp) throws LogictierException {
        if (objType == null) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_IS_NULL);
            throw new LogictierException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        if (object == null) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_IS_NULL);
            throw new LogictierException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        this.setObject(object);
        this.setObjectType(objType);
        this.setStamp(updateStamp);
    }

    @Override
    public void setObject(INCBaseObject object) {
        this.m_localCopy = object;
        this.m_ref = object.getNCObjectId();
    }

    @Override
    public INCBaseObject getObject() {
        return this.m_localCopy;
    }

    protected void setStamp(int updateStamp) {
        this.m_updateCount = updateStamp;
    }

    @Override
    public int getStamp() {
        return this.m_updateCount;
    }

    private NCObjectId getNCRef() {
        return this.m_ref;
    }

    @Override
    public NCObjectType getObjectType() {
        return this.m_objType;
    }

    private void setObjectType(NCObjectType objectType) {
        this.m_objType = objectType;
    }

    public boolean isUpToDate(NCObjectUpdateImpl update) {
        int yourCnt = update.getStamp();
        int myCnt = this.getStamp();
        NCObjectId yourRef = update.getNCRef();
        if (!this.m_ref.equals(yourRef)) {
            return false;
        }
        return myCnt == yourCnt;
    }
}

