/*
 * Decompiled with CFR 0.152.
 */
package noticecast.persist;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import noticecast.datatier.DTException;
import noticecast.datatier.IJDBCEntityHelper;
import noticecast.datatier.IJDBCLinkHelper;
import noticecast.datatier.IObjectView;
import noticecast.datatier.IObjectViewPlus;
import noticecast.datatier.accesscontrol.IJDBCDhObjectCat;
import noticecast.datatier.accesscontrol.JDBCDhObjectCatImpl;
import noticecast.datatier.base.ObjectTypeHelper;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.property.JDBCPropertiesImpl;
import noticecast.debug.Debug;
import noticecast.logictier.NCObjectNotFoundException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.NCObjectTypeMapping;
import noticecast.logictier.base.INCBaseObject;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.IPersistManager;
import noticecast.persist.ObjectIdAndTypeWrapper;
import noticecast.persist.PersistManagerException;
import noticecast.persist.PersistWrapperException;
import noticecast.persist.StoreObjectException;
import noticecast.runtime.IRunTimeManager;
import noticecast.runtime.RunTimeManager;

public final class PersistManagerImpl
implements IPersistManager {
    private final transient String m_propsKey = "persist.conf";
    private Map m_loadedHelpers = new HashMap(25);
    private ObjectTypeHelper m_ObjectTypeHelper = new ObjectTypeHelper();
    private IJDBCDhObjectCat m_objectCatHelper = null;
    private Properties m_dbProperties;

    private boolean isKeySpecified(String value) {
        if (null == value) {
            return false;
        }
        return value.length() > 0;
    }

    public PersistManagerImpl() throws PersistManagerException {
        this.loadDataHelpers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void store(INCObjectUpdate obj, Principal user) throws PersistManagerException {
        boolean success = false;
        JDBCConnection theConn = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            theConn = this.getHelperConnection();
            theConn.setAutoCommit(false);
            success = this.store((Connection)theConn, obj, user);
            return;
        }
        catch (SQLException ex) {
            PersistManagerImpl.logException(ex);
            return;
        }
        finally {
            block20: {
                perf.stop();
                try {
                    if (success) {
                        theConn.commit();
                        break block20;
                    }
                    if (theConn != null) {
                        theConn.rollback();
                    }
                }
                catch (SQLException ex) {
                    PersistManagerImpl.logException(ex);
                }
                finally {
                    this.releaseConnection(theConn);
                }
            }
        }
    }

    @Override
    public boolean store(Connection theConn, INCObjectUpdate obj, Principal user, boolean updateRuntime) throws PersistManagerException {
        this.checkForNull(obj);
        boolean successfulTransaction = false;
        INCBaseObject objToBeStored = null;
        IJDBCEntityHelper dataHelper = null;
        IJDBCDhObjectCat objCatHelper = null;
        try {
            objToBeStored = obj.getObject();
            dataHelper = this.getDataHelper(objToBeStored);
            dataHelper.store(theConn, obj, user);
            objCatHelper = this.getObjectCatHelper();
            objCatHelper.store(theConn, obj, user);
            successfulTransaction = true;
        }
        catch (DTException ex) {
            Throwable t = ex.fillInStackTrace();
            String errMsg = "Failed to store object: " + t.getMessage();
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_UPDATE_OBJECT, new Object[]{obj.getClass().getName()}, ex);
        }
        catch (Throwable ex) {
            Throwable t = ex.fillInStackTrace();
            String errMsg = "Failed to store object: " + t.getMessage();
            if (Debug.debug) {
                this.logException((Exception)ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_UPDATE_OBJECT, new Object[]{obj.getClass().getName()});
        }
        finally {
            if (successfulTransaction && updateRuntime) {
                IRunTimeManager rtm = RunTimeManager.getInstance();
                rtm.updateLiveEnvironment(objToBeStored, 0);
            }
        }
        return successfulTransaction;
    }

    @Override
    public boolean store(Connection theConn, INCObjectUpdate obj, Principal user) throws PersistManagerException {
        this.checkForNull(obj);
        boolean successfulTransaction = false;
        INCBaseObject objToBeStored = null;
        IJDBCEntityHelper dataHelper = null;
        IJDBCDhObjectCat objCatHelper = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            objToBeStored = obj.getObject();
            dataHelper = this.getDataHelper(objToBeStored);
            dataHelper.store(theConn, obj, user);
            objCatHelper = this.getObjectCatHelper();
            objCatHelper.store(theConn, obj, user);
            successfulTransaction = true;
        }
        catch (DTException ex) {
            String errMsg = "Failed to store object";
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_UPDATE_OBJECT, new Object[]{obj.getClass().getName()}, ex);
        }
        catch (Throwable ex) {
            String errMsg = "Failed to store object";
            if (Debug.debug) {
                this.logException((Exception)ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_UPDATE_OBJECT, new Object[]{obj.getClass().getName()});
        }
        finally {
            perf.stop();
        }
        return successfulTransaction;
    }

    @Override
    public void storeNew(INCBaseObjectConsumer obj, NCObjectType objType, NCObjectType subType, Connection transaction, Principal user) throws StoreObjectException {
        boolean success = true;
        IJDBCEntityHelper dataHelper = null;
        IJDBCDhObjectCat objCatHelper = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            dataHelper = subType != null ? this.getDataHelper(subType) : this.getDataHelper(objType);
            dataHelper.storeNew(transaction, obj, user);
            objCatHelper = this.getObjectCatHelper();
            objCatHelper.storeNew(transaction, obj, objType, subType, user);
        }
        catch (DTException ex) {
            success = false;
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJ_STORE_EXCP, (Object[])new String[]{objType.toString(), obj.getNCObjectId().toString()});
            throw new StoreObjectException(I18NCode.MSG_OBJ_STORE_EXCP, new Object[]{objType, obj.getNCObjectId()}, ex);
        }
        catch (Throwable ex) {
            success = false;
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJ_STORE_EXCP, (Object[])new String[]{objType.toString(), obj.getNCObjectId().toString()});
            throw new StoreObjectException(I18NCode.MSG_OBJ_STORE_EXCP, new Object[]{objType, obj.getNCObjectId()});
        }
        finally {
            perf.stop();
        }
    }

    @Override
    public void storeNew(INCBaseObjectConsumer obj, NCObjectType objType, Principal user) throws PersistManagerException {
        this.storeNew(obj, objType, null, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNew(INCBaseObjectConsumer obj, NCObjectType objType, NCObjectType subType, Principal user) throws PersistManagerException {
        if (Debug.checkConstraints) {
            this.checkForNull(obj);
            this.checkForNull(objType);
        }
        JDBCConnection theConn = null;
        boolean successfulTransaction = false;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            theConn = this.getHelperConnection();
            theConn.setAutoCommit(false);
            this.storeNew(obj, objType, subType, (Connection)theConn, user);
            successfulTransaction = true;
        }
        catch (SQLException ex) {
            String errMsg = "failed to set auto commit to false";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_STORE_OBJECT, new Object[]{objType});
        }
        catch (StoreObjectException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_STORE_OBJECT, (Object[])new String[]{objType.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_STORE_OBJECT, new Object[]{objType}, ex);
        }
        finally {
            try {
                this.updateLiveEnvironment(obj, (Connection)theConn, successfulTransaction);
            }
            finally {
                this.releaseConnection(theConn);
                perf.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(NCObjectId obj_id, NCObjectType obj_type, Principal user) throws PersistManagerException {
        this.checkForNull(obj_id);
        this.checkForNull(obj_type);
        JDBCConnection theConn = null;
        boolean successfulTransaction = false;
        NCObjectId taskScheduleId = null;
        IJDBCDhObjectCat objCatHelper = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            IJDBCEntityHelper dataHelper = this.getDataHelper(obj_type);
            theConn = this.getHelperConnection();
            theConn.setAutoCommit(false);
            this.unlinkRecipientFromAgents((Connection)theConn, obj_type, obj_id);
            dataHelper.delete((Connection)theConn, obj_id, user);
            if (Debug.debug) {
                System.out.println("Deleting from Object Catalogue for type=" + obj_type);
            }
            objCatHelper = this.getObjectCatHelper();
            objCatHelper.delete((Connection)theConn, obj_id, user);
            successfulTransaction = true;
            return;
        }
        catch (DTException ex) {
            String errMsg = "The item could not be deleted. Dependencies may exist";
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg + " :" + obj_id.toString());
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_DELETE_OBJECT, (Object[])new String[]{obj_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{obj_type}, ex);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_DELETE_OBJECT, (Object[])new String[]{obj_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{obj_type});
        }
        catch (Throwable ex) {
            String errMsg = "failed to delete object of id, " + obj_id.toString() + " of type, " + obj_type.toString();
            if (Debug.debug) {
                this.logException((Exception)ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{obj_type});
        }
        finally {
            block21: {
                try {
                    if (successfulTransaction) {
                        theConn.commit();
                        if (taskScheduleId != null) {
                            ObjectIdAndTypeWrapper wrapper = new ObjectIdAndTypeWrapper(taskScheduleId, NCObjectType.TASK_SCHEDULE);
                            IRunTimeManager rtm = RunTimeManager.getInstance();
                            rtm.updateLiveEnvironment(wrapper, 1);
                        }
                        break block21;
                    }
                    theConn.rollback();
                }
                catch (SQLException ex) {
                    PersistManagerImpl.logException(ex);
                }
                finally {
                    this.releaseConnection(theConn);
                }
            }
            perf.stop();
        }
    }

    @Override
    public void delete(NCObjectId obj_id, NCObjectType obj_type, Principal user, Connection connection) throws PersistManagerException {
        this.checkForNull(obj_id);
        this.checkForNull(obj_type);
        IJDBCDhObjectCat objCatHelper = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            IJDBCEntityHelper dataHelper = this.getDataHelper(obj_type);
            this.unlinkRecipientFromAgents(connection, obj_type, obj_id);
            dataHelper.delete(connection, obj_id, user);
            if (Debug.debug) {
                System.out.println("Deleting from Object Catalogue for type=" + obj_type);
            }
            objCatHelper = this.getObjectCatHelper();
            objCatHelper.delete(connection, obj_id, user);
        }
        catch (DTException dte) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)dte);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_DELETE_OBJECT, (Object[])new String[]{obj_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{obj_type}, dte);
        }
        catch (Throwable ex) {
            String errMsg = "failed to delete object of id, " + obj_id.toString() + " of type, " + obj_type.toString();
            if (Debug.debug) {
                this.logException((Exception)ex, errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_DELETE_OBJECT, (Object[])new String[]{obj_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_DELETE_OBJECT, new Object[]{obj_type});
        }
        finally {
            perf.stop();
        }
    }

    public IJDBCEntityHelper getDataHelper(INCBaseObject object) throws PersistManagerException {
        return this.getDataHelper(object.getClass().getName());
    }

    @Override
    public ObjectTypeHelper getObjectTypeHelper() {
        return this.m_ObjectTypeHelper;
    }

    private NCObjectType getObjectType(ResultSet rs) {
        NCObjectType theType;
        block3: {
            theType = null;
            try {
                String typeStr = rs.getString("objType");
                if (typeStr != null) {
                    theType = NCObjectType.valueOf(typeStr.trim());
                }
            }
            catch (Throwable ex) {
                if (!Debug.debug) break block3;
                this.logException((Exception)ex, "Cannot retrieve the object type from the result set");
            }
        }
        return theType;
    }

    public IJDBCEntityHelper getDataHelper(String objectClassName) throws PersistManagerException {
        IJDBCEntityHelper dh = (IJDBCEntityHelper)this.m_loadedHelpers.get(objectClassName);
        if (dh == null) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, (Object[])new String[]{objectClassName.toString()});
            throw new PersistManagerException(I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, new Object[]{objectClassName});
        }
        return dh;
    }

    @Override
    public IJDBCEntityHelper getDataHelper(NCObjectType objectType) throws PersistManagerException {
        IJDBCEntityHelper dh = (IJDBCEntityHelper)this.m_loadedHelpers.get(objectType);
        if (dh == null) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, (Object[])new String[]{objectType.toString()});
            throw new PersistManagerException(I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, new Object[]{objectType});
        }
        return dh;
    }

    public IJDBCLinkHelper getLinkHelper(INCBaseObject object1, INCBaseObject object2) throws PersistManagerException {
        IJDBCLinkHelper dh = null;
        String getHelperStatement = "SELECT HELPER FROM NC_RELATE WHERE (CLASS1 = ? AND CLASS2 = ?) OR (CLASS1 = ? AND CLASS2 = ?)";
        ResultSet rs = null;
        PreparedStatement ps = null;
        JDBCConnection theConn = null;
        try {
            theConn = this.getReadOnlyConnection();
            ps = theConn.prepareStatement(getHelperStatement);
            String obj1ClassName = object1.getClass().getName();
            String obj2ClassName = object1.getClass().getName();
            ps.setString(1, obj1ClassName);
            ps.setString(2, obj2ClassName);
            ps.setString(3, obj2ClassName);
            ps.setString(4, obj1ClassName);
            rs = ps.executeQuery();
            if (rs.next()) {
                String helperName = rs.getString("helper");
                try {
                    Class<?> helperClass = Class.forName(helperName);
                    dh = (IJDBCLinkHelper)helperClass.newInstance();
                }
                catch (ClassNotFoundException ex) {
                    String errMsg = "ClassNotFoundException caught.\n" + ex.toString();
                    if (Debug.debug) {
                        this.logException(ex, errMsg);
                    }
                    throw new PersistManagerException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{helperName});
                }
                catch (InstantiationException ex) {
                    String errMsg = "InstantiationException caught.\n" + ex.toString();
                    if (Debug.debug) {
                        this.logException(ex, errMsg);
                    }
                    throw new PersistManagerException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{helperName});
                }
                catch (IllegalAccessException ex) {
                    String errMsg = "IllegalAccessException caught.\n" + ex.toString();
                    if (Debug.debug) {
                        this.logException(ex, errMsg);
                    }
                    throw new PersistManagerException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{helperName});
                }
                catch (SecurityException ex) {
                    String errMsg = "SecurityException caught.\n" + ex.toString();
                    if (Debug.debug) {
                        this.logException(ex, errMsg);
                    }
                    throw new PersistManagerException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{helperName});
                }
            } else {
                String errMsg = "LinkHelper is not found Exception";
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, (Object[])new String[]{object1.getClass().getName()});
                throw new PersistManagerException(I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, new Object[]{object1.getClass().getName()});
            }
            this.closeResources(ps, rs);
            this.releaseConnection(theConn);
        }
        catch (SQLException ex) {
            try {
                String errMsg = "SQL Exception Caught.\n" + ex.toString();
                if (Debug.debug) {
                    this.logException(ex, errMsg);
                }
                throw new PersistManagerException(I18NCode.SQL_RETRIEVE_HELPER_BY_TYPE, new Object[]{object1.getClass().getName()});
            }
            catch (Throwable throwable) {
                this.closeResources(ps, rs);
                this.releaseConnection(theConn);
                throw throwable;
            }
        }
        return dh;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeLink(INCBaseObject object1, INCBaseObject object2, Principal user) throws PersistManagerException {
        this.checkForNull(object1);
        this.checkForNull(object2);
        JDBCConnection theConn = null;
        try {
            IJDBCLinkHelper linkHelper = this.getLinkHelper(object1, object2);
            theConn = this.getHelperConnection();
            theConn.setAutoCommit(true);
            linkHelper.storeLink((Connection)theConn, object1, object2, user);
            this.releaseConnection(theConn);
            return;
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NO_LINK, (Object[])new String[]{object1.getName(), object2.getName()});
                throw new PersistManagerException(I18NCode.PERST_OBJECT_NO_LINK, new Object[]{object1.getName(), object2.getName()});
                catch (DTException ex2) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NO_LINK, (Object[])new String[]{object1.getName(), object2.getName()});
                    throw new PersistManagerException(I18NCode.PERST_OBJECT_NO_LINK, new Object[]{object1.getName(), object2.getName()}, ex2);
                }
                catch (Throwable ex3) {
                    String errMsg = "failed to link " + object1.getName() + " with " + object2.getName();
                    if (Debug.debug) {
                        this.logException((Exception)ex3, errMsg);
                    }
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex3);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_OBJECT_NO_LINK, (Object[])new String[]{object1.getName(), object2.getName()});
                    throw new PersistManagerException(I18NCode.PERST_OBJECT_NO_LINK, new Object[]{object1.getName(), object2.getName()});
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(theConn);
                throw throwable;
            }
        }
    }

    private JDBCConnection getHelperConnection() throws SQLException {
        AbstractFactory cf = NCConnection.instance().getConnectionFactory();
        JDBCConnection theConn = cf.createConnection();
        return theConn;
    }

    private JDBCConnection getReadOnlyConnection() throws SQLException {
        AbstractFactory cf = NCConnection.instance().getConnectionFactory();
        JDBCConnection theConn = cf.createReadOnlyConnection();
        return theConn;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INCBaseObjectConsumer findNCObjectConsumerCopyByOid(NCObjectId oid, NCObjectType objType) throws PersistManagerException {
        INCBaseObjectConsumer iNCBaseObjectConsumer;
        this.checkForNull(oid);
        this.checkForNull(objType);
        JDBCConnection theConn = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            IJDBCEntityHelper dataHelper = this.getDataHelper(objType);
            theConn = this.getReadOnlyConnection();
            iNCBaseObjectConsumer = dataHelper.findCopyByOid((Connection)theConn, oid, null);
            this.releaseConnection(theConn);
        }
        catch (DTException ex) {
            try {
                String errMsg = "Data Tier Exception caught while finding NCObject consumer by Object Id:" + oid.toString() + "\n" + (Object)((Object)ex);
                if (Debug.debug) {
                    this.logException((Exception)((Object)ex), errMsg);
                }
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
                throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType}, ex);
                catch (Throwable ex2) {
                    errMsg = "failed to find object by id, " + oid.toString() + " of type, " + objType.toString();
                    if (Debug.debug) {
                        this.logException((Exception)ex2, errMsg);
                    }
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex2);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
                    throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType});
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(theConn);
                perf.stop();
                throw throwable;
            }
        }
        perf.stop();
        return iNCBaseObjectConsumer;
    }

    public Iterator findNCObjectConsumerCopyByName(String objName, NCObjectType objType) throws PersistManagerException {
        this.checkForNull(objName);
        this.checkForNull(objName);
        IJDBCEntityHelper dataHelper = this.getDataHelper(objType);
        JDBCConnection theConn = null;
        try {
            theConn = this.getReadOnlyConnection();
            Iterator iterator = dataHelper.findCopyByName((Connection)theConn, objName);
            return iterator;
        }
        catch (DTException ex) {
            String errMsg = "Data Tier Exception found while finding consumer copies by name\n" + (Object)((Object)ex);
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType}, ex);
        }
        catch (Throwable ex) {
            String errMsg = "failed to find object by name, " + objName + " of type, " + objType.toString();
            if (Debug.debug) {
                this.logException((Exception)ex, errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType});
        }
        finally {
            this.releaseConnection(theConn);
        }
    }

    public INCBaseObject findFirstNCObjectByName(String objName, NCObjectType objType) throws PersistManagerException {
        this.checkForNull(objName);
        this.checkForNull(objName);
        IJDBCEntityHelper dataHelper = this.getDataHelper(objType);
        JDBCConnection theConn = null;
        try {
            theConn = this.getReadOnlyConnection();
            INCBaseObject iNCBaseObject = (INCBaseObject)((Object)dataHelper.findCopyByName((Connection)theConn, objName));
            return iNCBaseObject;
        }
        catch (DTException ex) {
            String errMsg = "Data Tier Exception found while trying to find Object by name:" + objName + ".\n" + ex.toString();
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType}, ex);
        }
        catch (Throwable ex) {
            String errMsg = "failed to find object by name, " + objName + " of type, " + objType.toString();
            if (Debug.debug) {
                this.logException((Exception)ex, errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType});
        }
        finally {
            this.releaseConnection(theConn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INCObjectUpdate findNCObjectUpdateByOid(NCObjectId oid, NCObjectType objType, Principal user) throws PersistManagerException {
        this.checkForNull(oid);
        this.checkForNull(objType);
        INCObjectUpdate theOU = null;
        JDBCConnection theConn = null;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).start(this.getClass(), SDSLevel.DEBUG, "CALL");
        try {
            IJDBCEntityHelper dataHelper = this.getDataHelper(objType);
            theConn = this.getReadOnlyConnection();
            theOU = dataHelper.findByOid((Connection)theConn, oid, user);
            this.releaseConnection(theConn);
        }
        catch (NCObjectNotFoundException ex) {
            String errMsg = "persist manager could not find  id = " + oid.toString() + " of type " + objType.toString();
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            theOU = null;
            this.releaseConnection(theConn);
            {
                catch (Throwable throwable) {
                    this.releaseConnection(theConn);
                    perf.stop();
                    throw throwable;
                }
            }
            perf.stop();
            return theOU;
            catch (DTException ex2) {
                errMsg = "Data Tier Exception found while trying to find Object by Oid:" + oid.toString() + ".\n" + ex2.toString();
                if (Debug.debug) {
                    this.logException((Exception)((Object)ex2), errMsg);
                }
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex2);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
                throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType}, ex2);
                catch (Throwable ex3) {
                    errMsg = "failed to find object by id, " + oid.toString() + " of type, " + objType.toString();
                    if (Debug.debug) {
                        this.logException((Exception)ex3, errMsg);
                    }
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(ex3);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{objType.toString()});
                    throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{objType});
                }
            }
        }
        perf.stop();
        return theOU;
    }

    @Override
    public Iterator getObjectList(NCObjectType object_type, Principal user, HelperOption helper_option) throws PersistManagerException {
        IJDBCEntityHelper data_helper;
        if (Debug.checkConstraints) {
            this.checkForNull(object_type);
        }
        if (!((data_helper = this.getDataHelper(object_type)) instanceof IObjectView)) {
            String errMsg = "Data Helper does not support getObjectList operation.";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type});
        }
        JDBCConnection connection = null;
        Iterator object_list = null;
        try {
            connection = this.getReadOnlyConnection();
            object_list = ((IObjectView)((Object)data_helper)).getObjectList((Connection)connection, user, helper_option);
        }
        catch (SQLException ex) {
            String errMsg = "DTException caught in getObjectList.";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type});
        }
        catch (DTException ex) {
            String errMsg = "DTException caught in getObjectList.";
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type}, ex);
        }
        finally {
            this.releaseConnection(connection);
        }
        return object_list;
    }

    @Override
    public Iterator getObjectList(NCObjectType objectType, Principal user) throws PersistManagerException {
        return this.getObjectList(objectType, user, HelperOptionImpl.EMPTY_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getObjectList(NCObjectType object_type, Principal user, NCObjectId id) throws PersistManagerException {
        IJDBCEntityHelper data_helper;
        if (Debug.checkConstraints) {
            this.checkForNull(object_type);
            this.checkForNull(id);
        }
        if (!((data_helper = this.getDataHelper(object_type)) instanceof IObjectView)) {
            String errMsg = "Data Helper does not support getObjectList operation.";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type});
        }
        JDBCConnection connection = null;
        Iterator object_list = null;
        try {
            connection = this.getReadOnlyConnection();
            object_list = ((IObjectViewPlus)((Object)data_helper)).getObjectList((Connection)connection, user, id);
        }
        catch (DTException ex) {
            String errMsg = "DTException caught in getObjectList.";
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type}, ex);
        }
        catch (Exception ex) {
            PersistManagerImpl.logException(ex);
        }
        finally {
            this.releaseConnection(connection);
        }
        return object_list;
    }

    @Override
    public INCFeatherWeight[] getFeatherWeightList(NCObjectType object_type, HelperOption helper_option) throws PersistManagerException {
        JDBCConnection connection = null;
        Iterator iterator = null;
        try {
            connection = this.getReadOnlyConnection();
            iterator = this.getObjectCatHelper().getObjectList((Connection)connection, object_type, helper_option);
        }
        catch (SQLException ex) {
            String errMsg = "failed to get object list  of type, " + object_type.toString();
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type});
        }
        catch (DTException ex) {
            String errMsg = "failed to get object list  of type, " + object_type.toString();
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{object_type}, ex);
        }
        finally {
            this.releaseConnection(connection);
        }
        ArrayList al = new ArrayList();
        while (iterator.hasNext()) {
            al.add(iterator.next());
        }
        return al.toArray(new INCFeatherWeight[al.size()]);
    }

    @Override
    public INCFeatherWeight[] getFeatherWeightList(NCObjectType object_type) throws PersistManagerException {
        return this.getFeatherWeightList(object_type, HelperOptionImpl.EMPTY_OPTION);
    }

    @Override
    public INCFeatherWeight getFeatherWeight(NCObjectId object_id) throws PersistManagerException {
        INCFeatherWeight feather = null;
        if (Debug.checkConstraints) {
            this.checkForNull(object_id);
        }
        JDBCConnection theConn = null;
        try {
            theConn = this.getReadOnlyConnection();
            IJDBCDhObjectCat cat_helper = this.getObjectCatHelper();
            feather = (INCFeatherWeight)cat_helper.findCopyByOid((Connection)theConn, object_id);
        }
        catch (SQLException ex) {
            String errMsg = "failed to get object of ID: " + object_id.toString() + " from catalogue";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM);
        }
        catch (DTException ex) {
            String errMsg = "failed to get object of ID: " + object_id.toString() + " from catalogue";
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{INCFeatherWeight.class.getName()});
        }
        finally {
            this.releaseConnection(theConn);
        }
        return feather;
    }

    protected void finalize() throws Throwable {
        if (Debug.debug) {
            System.out.println("Persist service is now closing down and clearing up resources...");
        }
    }

    private void releaseConnection(JDBCConnection connection) {
        block3: {
            if (null == connection) {
                return;
            }
            try {
                AbstractFactory cf = NCConnection.instance().getConnectionFactory();
                cf.releaseConnection(connection);
            }
            catch (SQLException ex) {
                String errMsg = "Failed to release connection ";
                if (!Debug.debug) break block3;
                this.logException(ex, errMsg);
            }
        }
    }

    @Override
    public final IJDBCDhObjectCat getObjectCatHelper() {
        if (this.m_objectCatHelper == null) {
            this.m_objectCatHelper = new JDBCDhObjectCatImpl();
        }
        return this.m_objectCatHelper;
    }

    private void closeResources(Statement statement, ResultSet result_set) {
        block4: {
            try {
                if (result_set != null) {
                    result_set.close();
                    result_set = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException ex) {
                if (!Debug.debug) break block4;
                this.logException(ex, "Failed to close SQL resources.");
            }
        }
    }

    private void checkForNull(Object obj) throws PersistManagerException {
        if (obj != null) {
            return;
        }
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_IS_NULL);
        throw new PersistManagerException(I18NCode.MSG_OBJECT_IS_NULL);
    }

    @Override
    public INCFeatherWeight[] getObjectList(NCObjectType type, String name) throws PersistWrapperException {
        INCFeatherWeight[] result = null;
        JDBCConnection theConn = null;
        try {
            theConn = this.getReadOnlyConnection();
            IJDBCDhObjectCat helper = this.getObjectCatHelper();
            result = helper.getObjectList((Connection)theConn, type, name);
        }
        catch (SQLException ex) {
            PersistManagerImpl.logException(ex);
            throw new PersistWrapperException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{type});
        }
        catch (DTException ex) {
            PersistManagerImpl.logException((Exception)((Object)ex));
            throw new PersistWrapperException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{type}, ex);
        }
        finally {
            this.releaseConnection(theConn);
        }
        return result;
    }

    @Override
    public INCObjectUpdate[] findNCObjectUpdateByHelperOption(NCObjectType object_type, HelperOption helper_option) throws PersistManagerException {
        if (Debug.checkConstraints) {
            this.checkForNull(object_type);
        }
        IJDBCEntityHelper data_helper = this.getDataHelper(object_type);
        JDBCConnection connection = null;
        INCObjectUpdate[] updateList = null;
        try {
            connection = this.getReadOnlyConnection();
            updateList = data_helper.findNCObjectUpdateByHelperOption((Connection)connection, helper_option);
        }
        catch (SQLException ex) {
            String errMsg = "SQLException caught in findNCObjectUpdateByHelperOption.";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{object_type});
        }
        catch (DTException ex) {
            String errMsg = "DTException caught in findNCObjectUpdateByHelperOption.";
            if (Debug.debug) {
                this.logException((Exception)((Object)ex), errMsg);
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, (Object[])new String[]{object_type.toString()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT, new Object[]{object_type}, ex);
        }
        finally {
            this.releaseConnection(connection);
        }
        return updateList;
    }

    public static void main(String[] args) throws Exception {
        PersistManagerImpl pm = new PersistManagerImpl();
        JDBCConnection conn = pm.getReadOnlyConnection();
    }

    private void updateLiveEnvironment(INCBaseObjectConsumer obj, Connection theConn, boolean successfulTransaction) {
        try {
            if (theConn != null) {
                if (successfulTransaction) {
                    theConn.commit();
                    IRunTimeManager rtm = RunTimeManager.getInstance();
                    rtm.updateLiveEnvironment(obj, 0);
                } else {
                    theConn.rollback();
                }
            }
        }
        catch (SQLException ex) {
            PersistManagerImpl.logException(ex);
        }
    }

    private static void logException(Exception ex) {
        String s = null;
        s = null != ex.getMessage() ? ex.getMessage() : ex.toString();
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{s});
    }

    private void logException(Exception ex, String msg) {
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(msg + " " + ex.getMessage());
    }

    private void loadDataHelpers() throws PersistManagerException {
        HashMap<String, HashSet<Object>> tmpMap = new HashMap<String, HashSet<Object>>();
        NCObjectTypeMapping tm = NCObjectTypeMapping.instance();
        NCObjectType[] types = tm.getTypes();
        for (int counter = 0; counter < types.length; ++counter) {
            NCObjectType type = types[counter];
            String objClassName = tm.getLocalClassName(type);
            String helperName = tm.getDataHelperClassName(type);
            if (helperName == null) continue;
            HashSet<Object> values = (HashSet<Object>)tmpMap.get(helperName);
            if (values == null) {
                values = new HashSet<Object>();
                tmpMap.put(helperName, values);
            }
            if (objClassName != null) {
                values.add(objClassName);
            }
            values.add(type);
        }
        if (tmpMap.isEmpty()) {
            String errMsg = "PersistManagerImpl.loadDataHelpers: No dataHelpers found, check system setup";
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, (Object[])new String[]{NCObjectType.class.getName()});
            throw new PersistManagerException(I18NCode.PERST_UNABLE_RETRIEVE_OBJECT_LIST, new Object[]{NCObjectType.class.getName()});
        }
        Iterator mapIter = tmpMap.entrySet().iterator();
        Map.Entry entry = null;
        while (mapIter.hasNext()) {
            entry = mapIter.next();
            String helperName = (String)entry.getKey();
            IJDBCEntityHelper dh = this.createDataHelper(helperName);
            Iterator valuesIter = ((Set)entry.getValue()).iterator();
            while (valuesIter.hasNext()) {
                this.m_loadedHelpers.put(valuesIter.next(), dh);
            }
        }
    }

    private IJDBCEntityHelper createDataHelper(String helperName) throws PersistManagerException {
        IJDBCEntityHelper dh = null;
        try {
            if (helperName != null) {
                Class<?> helperClass = Class.forName(helperName);
                dh = (IJDBCEntityHelper)helperClass.newInstance();
            }
        }
        catch (ClassNotFoundException ex) {
            String errMsg = "PersistManagerImpl.createDataHelper: ClassNotFoundException creating dataHelper - " + helperName + "Please check system set up";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
        }
        catch (InstantiationException ex) {
            String errMsg = "PersistManagerImpl.createDataHelper: InstantiationException creating dataHelper - " + helperName + "Please check system set up";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{helperName});
        }
        catch (IllegalAccessException ex) {
            String errMsg = "PersistManagerImpl.createDataHelper: IllegalAccessException creating dataHelper - " + helperName + "Please check system set up";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.MSG_OBJ_FAILED_FOR_TYPE, new Object[]{helperName});
        }
        catch (SecurityException ex) {
            String errMsg = "PersistManagerImpl.createDataHelper: SecurityException creating dataHelper - " + helperName + "Please check system set up";
            if (Debug.debug) {
                this.logException(ex, errMsg);
            }
            throw new PersistManagerException(I18NCode.MSG_OBJ_FAILED_FOR_TYPE, new Object[]{helperName});
        }
        return dh;
    }

    @Override
    public String getProperty(String key) throws PersistManagerException {
        if (this.m_dbProperties == null) {
            JDBCConnection conn = null;
            try {
                conn = this.getReadOnlyConnection();
                JDBCPropertiesImpl jdbcProperties = new JDBCPropertiesImpl();
                this.m_dbProperties = jdbcProperties.getProperties((Connection)conn);
            }
            catch (SQLException ex) {
                throw new PersistManagerException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{key});
            }
            finally {
                this.releaseConnection(conn);
            }
        }
        return (String)this.m_dbProperties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateProperty(String key, String oldValue, String newValue) throws PersistManagerException {
        JDBCConnection conn = null;
        try {
            conn = this.getHelperConnection();
            JDBCPropertiesImpl jdbcProperties = new JDBCPropertiesImpl();
            boolean bl = jdbcProperties.updateProperty((Connection)conn, key, oldValue, newValue);
            return bl;
        }
        catch (SQLException ex) {
            if (Debug.debug) {
                ex.printStackTrace(System.err);
            }
        }
        finally {
            this.releaseConnection(conn);
        }
        return false;
    }

    @Override
    public void unlinkRecipientFromAgents(Connection conn, NCObjectType obj_type, NCObjectId obj_id) throws PersistManagerException, DTException {
    }
}

