/*
 * Decompiled with CFR 0.152.
 */
package noticecast.property;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.IBaseConfig;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import noticecast.debug.Debug;
import noticecast.property.IPropertiesManager;
import noticecast.property.NCDefaultCFG;
import noticecast.property.RepositoryAdminPropertiesManager;
import noticecast.property.ServerPropertiesManager;

public final class PropertiesManagerImpl
implements IPropertiesManager {
    public static final String[] PATH_SEPARATORS = new String[]{"\\", "/"};
    private String m_rootDir;
    private String m_logDir;
    private boolean server_found = false;
    private IBaseConfig m_propMan = null;
    private NCDefaultCFG config = null;

    public PropertiesManagerImpl() throws PropertiesException {
        String logDirString;
        File testLogDir;
        String theStr = System.getProperty("noticecast.server_dir");
        if (theStr != null && theStr.length() > 0) {
            this.m_propMan = new ServerPropertiesManager();
            this.server_found = true;
        }
        if ((theStr = System.getProperty("noticecast.repository_dir")) != null && theStr.length() > 0) {
            this.m_propMan = new RepositoryAdminPropertiesManager();
        }
        if (this.m_propMan == null) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        String test = this.getParentDir(System.getProperty("user.dir"));
        this.m_rootDir = test + File.separator;
        if (Debug.debug) {
            System.out.println("Using base directory: " + this.m_rootDir);
        }
        this.m_logDir = (testLogDir = new File(logDirString = this.m_rootDir + "logs")).exists() && testLogDir.isDirectory() ? logDirString : this.m_rootDir + "log";
    }

    @Override
    public String getParentDir(String path) {
        int currentIndex = -1;
        int maxIndex = -1;
        String test = path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
        for (int index = 0; index < PATH_SEPARATORS.length; ++index) {
            currentIndex = test.lastIndexOf(PATH_SEPARATORS[index]);
            maxIndex = Math.max(maxIndex, currentIndex);
        }
        test = maxIndex <= 0 ? ".." : test.substring(0, maxIndex);
        return test;
    }

    public void storeProperties(String filename, Properties props) throws PropertiesException {
        if (this.m_propMan == null) {
            String theErrMsg = "PropertiesManagerImpl.storeProperties: The properties manager was null";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        this.m_propMan.storeProperties(filename, props);
    }

    @Override
    public Properties getProperties(String filename) throws PropertiesException {
        Properties props = null;
        if (this.m_propMan != null) {
            try {
                props = this.m_propMan.getProperties(filename);
            }
            catch (PropertiesException ne) {
                if (this.server_found) {
                    if (this.config == null) {
                        this.config = new NCDefaultCFG();
                    }
                    props = this.config.getProperties();
                }
                throw ne;
            }
        } else {
            String theErrMsg = "PropertiesManagerImpl.getProperty: no manager is defined";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        return props;
    }

    @Override
    public String getProperty(String key) throws PropertiesException {
        String prop = null;
        if (this.m_propMan != null) {
            try {
                prop = this.m_propMan.getProperty(key);
            }
            catch (PropertiesException ex) {
                if (this.server_found) {
                    if (this.config == null) {
                        this.config = new NCDefaultCFG();
                    }
                    prop = this.config.getProperty(key);
                }
                throw ex;
            }
        } else if (this.server_found) {
            if (this.config == null) {
                this.config = new NCDefaultCFG();
            }
            prop = this.config.getProperty(key);
        } else {
            String theErrMsg = "PropertiesManagerImpl.getProperty: no manager is defined";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CONFIG_PROPERTY_EXCP, (Object[])new String[]{key}, (Map)ap);
            throw new PropertiesException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{key});
        }
        return prop;
    }

    @Override
    public String setProperty(String key, String value) throws PropertiesException {
        String ret_value = null;
        if (this.m_propMan == null) {
            String theErrMsg = "PropertiesManagerImpl.setProperty: no manager is defined";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        ret_value = this.m_propMan.setProperty(key, value);
        return ret_value;
    }

    @Override
    public String getLogDir() throws PropertiesException {
        return this.m_logDir;
    }

    @Override
    public String getNCRoot() {
        return this.m_rootDir;
    }

    @Override
    public void resetStatus() {
        if (this.m_propMan != null) {
            this.m_propMan.resetStatus();
        }
    }

    public static void main(String[] args) {
        PropertiesManagerImpl propsMan = null;
        String server = System.getProperty("noticecast.server_dir");
        String admin = System.getProperty("noticecast.admin_dir");
        String gui = System.getProperty("noticecast.client_dir");
        Properties theProps = null;
        try {
            propsMan = new PropertiesManagerImpl();
            if (server != null) {
                theProps = propsMan.getProperties("server.conf");
                System.out.println("Using the server properties file:server.conf");
            } else if (admin != null) {
                theProps = propsMan.getProperties("admingui.conf");
                System.out.println("Using the admin properties file:admingui.conf");
            } else if (gui != null) {
                theProps = propsMan.getProperties("client.conf");
                System.out.println("Using the client properties file:client.conf");
            }
            if (theProps != null) {
                theProps.list(System.out);
            } else {
                System.out.println("No properties set in the VM parameters");
            }
        }
        catch (PropertiesException ex) {
            if (server != null) {
                try {
                    NCDefaultCFG config = new NCDefaultCFG();
                    theProps = config.getProperties();
                    System.out.println("Using the default CFG properties file");
                    if (theProps != null) {
                        theProps.list(System.out);
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            ex.printStackTrace();
        }
    }
}

