/*
 * Decompiled with CFR 0.152.
 */
package noticecast.property;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.AbstractPropertiesManager;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import noticecast.property.IPropertiesManager;

public class RepositoryAdminPropertiesManager
extends AbstractPropertiesManager {
    private String mPath;
    private boolean mHasRead = false;
    private boolean mHasAttempted = false;
    private String mPropsDir;
    private Properties mNcProperties;

    public void resetStatus() {
        this.mPath = null;
        this.mHasRead = false;
        this.mHasAttempted = false;
        this.mPropsDir = null;
        if (null != this.mNcProperties) {
            this.mNcProperties.clear();
        }
        this.mNcProperties = null;
    }

    public void storeProperties(String filename, Properties props) throws PropertiesException {
        this.validateEnv();
        String theFilePath = this.getValidatedFileName(filename);
        try {
            FileOutputStream theFile = new FileOutputStream(theFilePath, false);
            props.store(theFile, null);
            theFile.close();
        }
        catch (FileNotFoundException ex) {
            String errMsg = "RepositoryAdminPropertiesManager.storeProperties:Could not find " + theFilePath;
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        catch (SecurityException ex) {
            String errMsg = "RepositoryAdminPropertiesManager.storeProperties:Could not open for writing to " + theFilePath;
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        catch (IOException ex) {
            String errMsg = "RepositoryAdminPropertiesManager.storeProperties:Could not close or store to " + theFilePath;
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        catch (ClassCastException ex) {
            String errMsg = "RepositoryAdminPropertiesManager.storeProperties:Keys or values did not contains strings";
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
    }

    public String getProperty(String key) throws PropertiesException {
        return this.getDefProperties().getProperty(key);
    }

    public String setProperty(String key, String value) throws PropertiesException {
        String old_value = this.mNcProperties.getProperty(key);
        if (old_value == null) {
            String theErrMsg = "CM.setProperty: property is not defined";
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        this.mNcProperties.setProperty(key, value);
        return old_value;
    }

    public Properties getProperties(String fileName) throws PropertiesException {
        this.validateEnv();
        Properties theProps = null;
        String theFilePath = this.getValidatedFileName(fileName);
        try {
            FileInputStream theFile = new FileInputStream(theFilePath);
            theProps = new Properties();
            theProps.load(theFile);
            theFile.close();
        }
        catch (FileNotFoundException ex) {
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        catch (SecurityException ex) {
            String errMsg = "RepositoryAdminPropertiesManager.getProperties:Could not open for reading from " + theFilePath;
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        catch (IOException ex) {
            String errMsg = "RepositoryAdminPropertiesManager.getProperties:Could not load or close " + theFilePath;
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        return theProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateEnv() throws PropertiesException {
        this.validateStatus();
        if (!this.mHasRead) {
            RepositoryAdminPropertiesManager repositoryAdminPropertiesManager = this;
            synchronized (repositoryAdminPropertiesManager) {
                String errMsg = "Could not retrieve noticecast.repository_dir";
                try {
                    this.mHasAttempted = true;
                    this.mPath = System.getProperty("noticecast.repository_dir");
                    this.mPropsDir = System.getProperty("noticecast.props_dir");
                    if (this.mPropsDir == null) {
                        this.mPropsDir = IPropertiesManager.DEF_PROPS_DIR;
                    }
                }
                catch (SecurityException ex) {
                    this.logException(ex, errMsg);
                    throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
                }
                if (this.mPath == null || this.mPath.length() <= 0) {
                    this.logException(null, errMsg);
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR);
                    throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
                }
                this.mHasRead = true;
            }
        }
    }

    private void validateStatus() throws PropertiesException {
        if (!this.mHasRead && this.mHasAttempted) {
            String errStr = "The server resource manager status is not valid: an earlier attempt was failed.";
            this.logException(null, errStr);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
    }

    private String getValidatedFileName(String filename) throws PropertiesException {
        StringBuffer theFilePath = new StringBuffer();
        theFilePath.append(this.mPath);
        theFilePath.append(this.mPropsDir);
        theFilePath.append(filename.trim());
        return theFilePath.toString();
    }

    private Properties getDefProperties() throws PropertiesException {
        this.validateEnv();
        if (this.mNcProperties == null) {
            this.readProperties();
            if (this.mNcProperties == null) {
                String errMsg = "RepositoryAdminPropertiesManager.getDefProperties:The system properties are not valid.";
                this.logException(null, errMsg);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
                throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
            }
        }
        return this.mNcProperties;
    }

    private void readProperties() throws PropertiesException {
        this.mNcProperties = this.getProperties("repository_admin.conf");
    }
}

