/*
 * Decompiled with CFR 0.152.
 */
package noticecast.property;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.AbstractPropertiesManager;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import noticecast.property.IPropertiesManager;

final class ServerPropertiesManager
extends AbstractPropertiesManager {
    private String mNCPath;
    private boolean mHasRead = false;
    private boolean mHasAttempted = false;
    private String mPropsDir;
    private Properties mNcProperties;
    private final Object mMutex = new Object();

    ServerPropertiesManager() throws PropertiesException {
    }

    private void readMainProperties() throws PropertiesException {
        String filePath = this.getValidatedFileName("server.conf");
        this.mNcProperties = this.readProperties(filePath);
    }

    private void readOverrideProperties() {
        try {
            String filePath = ".." + File.separator + "configuration" + File.separator + "dotone.properties";
            this.mNcProperties.putAll((Map<?, ?>)this.readProperties(filePath));
            String rmiport = this.mNcProperties.getProperty("cogx.rmi.port");
            if (rmiport != null && rmiport.length() > 1) {
                this.mNcProperties.setProperty("cogxserver.rmiport", rmiport);
            }
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getDefProperties() throws PropertiesException {
        this.validateEnv();
        if (this.mNcProperties == null) {
            Object object = this.mMutex;
            synchronized (object) {
                if (this.mNcProperties == null) {
                    this.readMainProperties();
                    if (this.mNcProperties == null) {
                        String errMsg = "ServerPropertiesManager.getdefProperties:The system properties are not valid";
                        this.logException(null, errMsg);
                        AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Warning");
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap);
                        throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
                    }
                }
            }
        }
        return this.mNcProperties;
    }

    private void validateStatus() throws PropertiesException {
        if (!this.mHasRead && this.mHasAttempted) {
            String errMsg = "The resource manager status is not valid: an earlier attempt failed.";
            this.logException(null, errMsg);
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateEnv() throws PropertiesException {
        if (!this.mHasRead) {
            Object object = this.mMutex;
            synchronized (object) {
                if (!this.mHasRead) {
                    String errMsg = "Could not retrieve noticecast.server_dir";
                    try {
                        this.mHasAttempted = true;
                        this.mNCPath = System.getProperty("noticecast.server_dir");
                        this.mPropsDir = System.getProperty("noticecast.props_dir");
                        if (this.mPropsDir == null) {
                            this.mPropsDir = IPropertiesManager.DEF_PROPS_DIR;
                        }
                    }
                    catch (SecurityException ex) {
                        this.logException(ex, errMsg);
                        AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
                        throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
                    }
                    if (this.mNCPath == null || this.mNCPath.length() <= 0) {
                        this.logException(null, errMsg);
                        AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Warning");
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
                        throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
                    }
                    this.mHasRead = true;
                }
            }
        }
    }

    private String getValidatedFileName(String filename) throws PropertiesException {
        StringBuffer theFilePath = new StringBuffer();
        theFilePath.append(this.mNCPath);
        theFilePath.append(this.mPropsDir);
        theFilePath.append(filename.trim());
        return theFilePath.toString();
    }

    private Properties readProperties(String filePath) throws PropertiesException {
        Properties theProps = null;
        try {
            FileInputStream theFileStream = new FileInputStream(filePath);
            theProps = new Properties();
            theProps.load(theFileStream);
            theFileStream.close();
        }
        catch (FileNotFoundException ex) {
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        catch (SecurityException ex) {
            String errMsg = "ServerPropertiesManager.getProperties:Could not open for reading from " + filePath;
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        catch (IOException ex) {
            String errMsg = "ServerPropertiesManager.getProperties:Could not load or close " + filePath;
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        return theProps;
    }

    public Properties getProperties(String filename) throws PropertiesException {
        this.validateEnv();
        Properties theProps = null;
        String theFilePath = this.getValidatedFileName(filename);
        theProps = this.readProperties(theFilePath);
        return theProps;
    }

    public void storeProperties(String filename, Properties props) throws PropertiesException {
        this.validateEnv();
        String theFilePath = this.getValidatedFileName(filename);
        try {
            FileOutputStream theFile = new FileOutputStream(theFilePath, false);
            props.store(theFile, null);
            theFile.close();
        }
        catch (FileNotFoundException ex) {
            String errMsg = "ServerPropertiesManager.storeProperties:Could not find " + theFilePath;
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        catch (SecurityException ex) {
            String errMsg = "ServerPropertiesManager.storeProperties:Could not open for writing to " + theFilePath;
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        catch (IOException ex) {
            String errMsg = "ServerPropertiesManager.storeProperties:Could not close or store to " + theFilePath;
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        catch (ClassCastException ex) {
            String errMsg = "ServerPropertiesManager.storeProperties:Keys or values did not contains strings";
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
    }

    public String getProperty(String key) throws PropertiesException {
        return this.getDefProperties().getProperty(key);
    }

    public String setProperty(String key, String value) throws PropertiesException {
        String old_value = this.mNcProperties.getProperty(key);
        if (old_value == null) {
            String theErrMsg = "CM.setProperty: property is not defined";
            AuditProperties ap = AuditPropUtil.doProps(((Object)((Object)this)).getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, (Map)ap);
            throw new PropertiesException(I18NCode.OTH_PROPS_ERROR);
        }
        this.mNcProperties.setProperty(key, value);
        return old_value;
    }

    public void resetStatus() {
        this.mNCPath = null;
        this.mHasRead = false;
        this.mHasAttempted = false;
        this.mPropsDir = null;
        if (null != this.mNcProperties) {
            this.mNcProperties.clear();
            this.mNcProperties = null;
        }
    }
}

