/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import java.security.Principal;
import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.datatier.helperoptions.HelperOptionWithParam;
import noticecast.debug.Debug;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.IRecipientLink;
import noticecast.persist.IPersistManager;
import noticecast.persist.ObjectIdAndTypeWrapper;
import noticecast.persist.PersistManagerException;
import noticecast.runtime.IDetailsUpdater;
import noticecast.runtime.IRunTimeManager;
import noticecast.runtime.task.FinalState;
import noticecast.runtime.task.ITaskRunDetails;
import noticecast.runtime.task.RunTaskThread;
import noticecast.runtime.task.TaskRunDetailsImpl;
import noticecast.scheduling.core.Scheduler;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NCSchedulable;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.nc.ScheduleLink;
import noticecast.scheduling.nc.TaskScheduleImpl;
import noticecast.services.RepositoryServicesImpl;
import noticecast.starter.ProcessType;
import noticecast.starter.SingletonServiceProvider;

public final class RunTimeManager
extends ThreadGroup
implements IRunTimeManager {
    private static ThreadLocal initHolder = new ThreadLocal();
    private static IRunTimeManager instance = null;
    private Map m_runningTasks = null;
    private Map m_taskScheduleStateChanges = null;
    private Scheduler m_scheduler = null;
    private boolean m_canActivateTasks;
    private long m_waitPeriod = 2000L;
    private boolean m_dataBaseAvailable;
    private static final int DEFAULT_MAX_RUNTASK_THREADS = 20;
    private int m_maxTaskThreads = 20;
    private int m_currentTaskThreads = 0;

    protected RunTimeManager(ThreadGroup parent) {
        super(parent, "SingletonRunTimeManager");
        this.setDaemon(false);
        this.m_canActivateTasks = true;
        this.m_scheduler = Scheduler.getInstance();
        this.m_runningTasks = Collections.synchronizedMap(new HashMap());
        this.m_taskScheduleStateChanges = Collections.synchronizedMap(new HashMap());
        ProcessType type = SingletonServiceProvider.getInstance().getProcessType();
        this.m_dataBaseAvailable = !ProcessType.CR1_delivery.equals(type);
        try {
            String runTaskMaxThreadsString = CRNProperties.getInstance().getProperty("run.task.max.threads");
            this.m_maxTaskThreads = Integer.parseInt(runTaskMaxThreadsString);
            String msg = "Run Task Threads max count set to " + this.m_maxTaskThreads;
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(msg);
        }
        catch (PropertiesException e) {
            String s = "Error retrieving property 'run.task.max.threads'.  Property is either not set, or is badly configured.  SDS will use default value of :20";
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{s});
        }
        catch (NumberFormatException e) {
            String s = "Error retrieving property 'run.task.max.threads'.  Property is either not set, or is badly configured.  SDS will use default value of :20";
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{s});
        }
    }

    private boolean databaseAvailable() {
        return this.m_dataBaseAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRunTimeManager getInstance() {
        if (initHolder.get() != null) return instance;
        Class<RunTimeManager> clazz = RunTimeManager.class;
        synchronized (RunTimeManager.class) {
            if (null == instance) {
                ThreadGroup parent = Thread.currentThread().getThreadGroup();
                instance = new RunTimeManager(parent);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            initHolder.set(Boolean.TRUE);
            return instance;
        }
    }

    @Override
    public void updateLiveEnvironment(Object object, int action) {
        if (action == 0) {
            if (object instanceof ITaskSchedule) {
                this.updateScheduling((ITaskSchedule)object);
            } else if (object instanceof NcScheduleWrapper) {
                NcScheduleWrapper wrapper = (NcScheduleWrapper)object;
                this.updateLiveEnvironment(wrapper);
            }
        } else if (action == 1) {
            this.removeFromLiveEnvironment(object);
        }
    }

    private void removeFromLiveEnvironment(Object object) {
        NCObjectId taskScheduleId;
        ObjectIdAndTypeWrapper wrapper;
        if (object instanceof ITaskSchedule) {
            NCObjectId taskScheduleId2 = ((ITaskSchedule)object).getNCObjectId();
            ITaskSchedule dummyTS = this.createDummyISchedulable(taskScheduleId2);
            this.updateScheduling(dummyTS);
        } else if (object instanceof ObjectIdAndTypeWrapper && (wrapper = (ObjectIdAndTypeWrapper)object).getObjectType().equals(NCObjectType.TASK_SCHEDULE) && null != (taskScheduleId = wrapper.getObjectId())) {
            ITaskSchedule ts = this.createDummyISchedulable(taskScheduleId);
            this.updateScheduling(ts);
        }
    }

    private void updateLiveEnvironment(NcScheduleWrapper scheduleWrapper) {
        String scheduleIDString = scheduleWrapper.getNCObjectId().toString().trim();
        HelperOptionWithParam helper_option = new HelperOptionWithParam(HelperOptionImpl.TASKSCHEDULE_FROM_SCHEDULE_ID, new String[]{scheduleIDString});
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        Iterator iter = null;
        try {
            iter = pm.getObjectList(NCObjectType.TASK_SCHEDULE, null, helper_option);
            while (iter != null && iter.hasNext()) {
                ITaskSchedule taskSchedule = (ITaskSchedule)iter.next();
                this.updateScheduling(taskSchedule);
            }
        }
        catch (PersistManagerException ex) {
            String errMsg = "RunTimeManager.updateLiveEnvironment() - taskSchedules not loaded: id= ";
            String idString = NCObjectIdUtil.instance().getSqlString(scheduleWrapper.getNCObjectId());
            if (null == idString) {
                idString = "null";
            }
            if (Debug.debug) {
                System.out.println(errMsg);
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)ex);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_RUNTIMEMANAGERLOADSCHEDULES_TASKSCH, (Map)ap);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECTS_TASK_SCHEDULE, (Object[])new String[]{idString}, (Map)ap);
        }
    }

    private ITaskSchedule getTaskScheduleByTask(NCObjectId taskId) {
        HelperOptionWithParam helper_option = new HelperOptionWithParam(HelperOptionImpl.TASKSCHEDULE_FROM_TASK_ID, new String[]{taskId.toString()});
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        Iterator iter = null;
        ITaskSchedule taskSchedule = null;
        try {
            iter = pm.getObjectList(NCObjectType.TASK_SCHEDULE, null, helper_option);
            taskSchedule = (ITaskSchedule)iter.next();
            if (iter.hasNext()) {
                String errMsg = "RunTimeManager.updateLiveEnvironment(ITask) - taskSchedule not unique for task: ";
                if (Debug.debug) {
                    System.out.println(errMsg);
                }
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_SCHEDULE_OBJECT_IS_NOT_UNIQUE, (Object[])new String[]{taskSchedule.getNCObjectId().toString()}, (Map)ap);
            }
        }
        catch (PersistManagerException ex) {
            String errMsg = "RunTimeManager.updateLiveEnvironment() - taskSchedule not loaded for given task";
            if (Debug.debug) {
                System.out.println(errMsg);
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)ex);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_RUNTIMEMANAGERLOADSCHEDULES_TASKSCH, (Map)ap);
        }
        return taskSchedule;
    }

    @Override
    public void loadSchedules() {
        if (this.m_scheduler.initialiseQueueOnRestart()) {
            Runnable loader = new Runnable(){

                @Override
                public void run() {
                    RunTimeManager.this.loadSchedulesRun();
                }
            };
            Thread loaderThread = new Thread(this, loader, "scheduler loader");
            loaderThread.start();
        }
    }

    private void loadSchedulesRun() {
        if (Debug.debug) {
            System.out.println("RunTime is loading TaskSchedules into the Scheduler...");
        }
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        Iterator iter = null;
        try {
            iter = pm.getObjectList(NCObjectType.TASK_SCHEDULE, (Principal)null);
            while (iter != null && iter.hasNext()) {
                ITaskSchedule taskSchedule = (ITaskSchedule)iter.next();
                this.updateScheduling(taskSchedule);
            }
        }
        catch (PersistManagerException ex) {
            String errMsg = "RunTimeManager.loadSchedules() - taskSchedules not loaded";
            if (Debug.debug) {
                System.out.println(errMsg);
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)ex);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_RUNTIMEMANAGERLOADSCHEDULES_TASKSCH, (Map)ap);
        }
        if (Debug.debug) {
            System.out.println("RunTime TaskSchedule loading complete");
        }
    }

    private ITaskSchedule createDummyISchedulable(NCObjectId id) {
        TaskScheduleImpl ts = new TaskScheduleImpl();
        ts.setNCObjectId(id);
        return ts;
    }

    @Override
    public void runTask(NCObjectId nid, IDetailsUpdater updater) {
        this.runTask(nid, updater, null);
    }

    @Override
    public void runTask(NCObjectId nid, IDetailsUpdater updater, Option[] opts) {
        if (!this.m_canActivateTasks) {
            return;
        }
        ITaskSchedule taskSchedule = this.getTaskScheduleByTask(nid);
        EventId eventId = new EventId(nid, null);
        Event event = new Event(EventStatus.SCHEDULED, eventId);
        TaskRunDetailsImpl taskRunDetails = new TaskRunDetailsImpl(event, taskSchedule, null);
        taskRunDetails.setTaskOptions(opts);
        if (updater != null) {
            updater.updateTaskRunDetails(taskRunDetails);
        }
        this.runTask(null, taskSchedule, taskRunDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunTaskThread getThread(ITask task, ITaskSchedule taskSchedule, ITaskRunDetails taskRunDetails) {
        RunTimeManager runTimeManager = this;
        synchronized (runTimeManager) {
            while (this.m_currentTaskThreads >= this.m_maxTaskThreads) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.m_currentTaskThreads;
        }
        RunTaskThread result = new RunTaskThread(this, task, taskSchedule, taskRunDetails);
        return result;
    }

    @Override
    public void runTask(ITask task, ITaskSchedule taskSchedule, ITaskRunDetails taskRunDetails) {
        boolean deleteAfterLastRun = false;
        if (taskRunDetails.getTaskNextRunDate() == null && taskSchedule.getDeleteAfterLastRun()) {
            deleteAfterLastRun = true;
        }
        if (!taskSchedule.isTransient() && this.databaseAvailable() && !deleteAfterLastRun) {
            this.storeTaskScheduleFromThread(taskSchedule, false);
        }
        if (!this.m_canActivateTasks) {
            return;
        }
        NCObjectId taskId = taskSchedule.getTaskId();
        if (task == null) {
            task = this.getTask(taskId);
        }
        if (task == null) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, (Object[])new String[]{taskId.toString()}, (Map)ap);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_OBJECT_IS_NULL, (Map)ap);
        } else {
            this.m_runningTasks.put(task.getNCObjectId(), taskSchedule);
            RunTaskThread taskThread = this.getThread(task, taskSchedule, taskRunDetails);
            if (taskThread != null) {
                taskThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskRunCompleted(ITask task) {
        try {
            NCObjectId taskId = task.getNCObjectId();
            ITaskSchedule taskSchedule = (ITaskSchedule)this.m_runningTasks.get(taskId);
            if (null == taskSchedule) {
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_RUNTIMEMANAGERTASKRUNCOMPLETED, (Object[])new String[]{taskId.toString()}, (Map)ap);
                this.m_taskScheduleStateChanges.remove(taskId);
                return;
            }
            if (null != this.m_taskScheduleStateChanges.remove(taskId)) {
                this.updateScheduling(taskSchedule);
            }
            Date nextExec = taskSchedule.getNextExecution();
            boolean deleteAfterLastRun = false;
            if (nextExec == null && taskSchedule.getDeleteAfterLastRun()) {
                deleteAfterLastRun = true;
            }
            this.m_runningTasks.remove(taskId);
            if (deleteAfterLastRun) {
                this.deleteTaskAndTaskSchedule(task, taskSchedule);
            }
        }
        finally {
            RunTimeManager runTimeManager = this;
            synchronized (runTimeManager) {
                --this.m_currentTaskThreads;
                if (this.m_currentTaskThreads < 0) {
                    this.m_currentTaskThreads = 0;
                }
                this.notifyAll();
            }
        }
    }

    @Override
    public void activateTaskDelay(ITask task) {
        NCObjectId taskId = task.getNCObjectId();
        ITaskSchedule taskSchedule = (ITaskSchedule)this.m_runningTasks.get(taskId);
        boolean stateChanged = taskSchedule.activateDelay();
        if (stateChanged) {
            this.m_taskScheduleStateChanges.put(taskId, taskSchedule);
        }
    }

    /*
     * Exception decompiling
     */
    private void storeTaskScheduleFromThread(ITaskSchedule taskSchedule, boolean updateScheduling) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void activateEscalationSchedules(ITask escalationTask) {
        boolean stateChanged;
        NCObjectId taskId = escalationTask.getNCObjectId();
        ITaskSchedule taskSchedule = this.getTaskScheduleByTask(taskId);
        if (taskSchedule != null && (stateChanged = taskSchedule.activateEscalationSchedules())) {
            this.updateScheduling(taskSchedule);
            this.storeTaskScheduleFromThread(taskSchedule, false);
        }
    }

    @Override
    public void deactivateEscalationSchedules(ITask task) {
    }

    @Override
    public void deactivateSchedules(NCObjectId taskId) {
        ITaskSchedule taskSchedule = (ITaskSchedule)this.m_runningTasks.get(taskId);
        if (taskSchedule == null) {
            taskSchedule = this.getTaskScheduleByTask(taskId);
            if (taskSchedule.deactivateSchedules()) {
                this.storeTaskScheduleFromThread(taskSchedule, true);
            }
        } else {
            boolean stateChanged = taskSchedule.deactivateSchedules();
            this.m_taskScheduleStateChanges.put(taskId, taskSchedule);
        }
    }

    @Override
    public void activateSchedules(NCObjectId taskId) {
        ITaskSchedule taskSchedule = (ITaskSchedule)this.m_runningTasks.get(taskId);
        if (taskSchedule == null) {
            taskSchedule = this.getTaskScheduleByTask(taskId);
            if (taskSchedule.activateSchedules()) {
                this.storeTaskScheduleFromThread(taskSchedule, true);
            }
        } else {
            boolean stateChanged = taskSchedule.activateSchedules();
            this.storeTaskScheduleFromThread(taskSchedule, true);
            this.m_taskScheduleStateChanges.put(taskId, taskSchedule);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (t instanceof RunTaskThread) {
            RunTaskThread taskThread = (RunTaskThread)t;
            NCObjectId taskId = taskThread.getTaskId();
            if (this.m_runningTasks.containsKey(taskId)) {
                ITaskSchedule taskSchedule = (ITaskSchedule)this.m_runningTasks.get(taskId);
                if (null != this.m_taskScheduleStateChanges.remove(taskId)) {
                    this.updateScheduling(taskSchedule);
                }
                this.m_runningTasks.remove(taskId);
            }
        } else {
            super.uncaughtException(t, e);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this;
    }

    private void updateScheduling(ITaskSchedule taskSchedule) {
        String nextRunDateString;
        NCSchedulable schedulable = new NCSchedulable(taskSchedule);
        Date nextExecuteRequest = schedulable.getNextExecution();
        String string = nextRunDateString = null == nextExecuteRequest ? "NULL" : nextExecuteRequest.toString();
        if (null == nextExecuteRequest) {
            this.m_scheduler.remove(schedulable);
            if (this.databaseAvailable() && taskSchedule.getDeleteAfterLastRun()) {
                ITask task = this.getTask(taskSchedule.getTaskId());
                this.deleteTaskAndTaskSchedule(task, taskSchedule);
            }
        } else {
            this.m_scheduler.remove(schedulable);
            this.m_scheduler.add(schedulable, nextExecuteRequest);
        }
    }

    private void stopOnetask(RunTaskThread taskThread) {
        NCObjectId taskId = taskThread.getTaskId();
        try {
            taskThread.join(this.m_waitPeriod);
        }
        catch (InterruptedException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, null, (Object[])new String[]{taskThread.getName() + " is interrupted"});
        }
        if (taskThread.isAlive()) {
            if (Debug.debug) {
                String s = taskThread.getName() + " with id, " + taskId + " will be interrupted";
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(s);
            }
            taskThread.interrupt();
            Thread.yield();
        }
    }

    private void killThread(Thread thread) {
        if (thread.isAlive()) {
            try {
                thread.join(this.m_waitPeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopAllagents() {
        block7: {
            RunTimeManager runTimeManager = this;
            synchronized (runTimeManager) {
                this.m_canActivateTasks = false;
            }
            int activeThreads = this.activeCount();
            Thread[] threads = new Thread[activeThreads];
            int placedThreads = this.enumerate(threads, true);
            RunTaskThread oneTaskThread = null;
            for (int counter = placedThreads - 1; counter >= 0; --counter) {
                if (threads[counter] instanceof RunTaskThread) {
                    oneTaskThread = (RunTaskThread)threads[counter];
                    this.stopOnetask(oneTaskThread);
                    continue;
                }
                this.killThread(threads[counter]);
            }
            this.interrupt();
            Thread.yield();
            try {
                this.destroy();
            }
            catch (IllegalThreadStateException ex) {
                if (!Debug.debug) break block7;
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void activateService(Runnable service, String name) {
        Thread serviceThread = new Thread(this, service, name);
        serviceThread.start();
    }

    @Override
    public void updateTaskLog(NCObjectId taskId, NCObjectId logId, FinalState state) {
    }

    @Override
    public boolean isAgentRunning(NCObjectId id) {
        return this.m_runningTasks.containsKey(id);
    }

    private ITask getTask(NCObjectId taskId) {
        ITask task = null;
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        try {
            task = (ITask)pm.findNCObjectConsumerCopyByOid(taskId, NCObjectType.AGENT);
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)ex);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, (Object[])new String[]{taskId.toString()}, (Map)ap);
        }
        return task;
    }

    @Override
    public boolean purgeScheduler() {
        return this.m_scheduler.removeAll();
    }

    /*
     * Exception decompiling
     */
    private void deleteTaskAndTaskSchedule(ITask task, ITaskSchedule taskSchedule) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteRecipients(ITask task, IPersistManager pm, Connection conn) throws PersistManagerException {
        Iterator iter = task.getMessages();
        while (iter.hasNext()) {
            IMessageStruct message = (IMessageStruct)iter.next();
            IRecipientLink[] links = message.getRecipientLinks();
            for (int i = 0; i < links.length; ++i) {
                pm.delete(links[i].getRecipientId(), NCObjectType.RECIPIENT, null, conn);
            }
        }
    }

    private void deleteSchedules(ITaskSchedule taskSchedule, IPersistManager pm, Connection conn) throws PersistManagerException {
        ScheduleLink[] links = taskSchedule.getScheduleLinks();
        for (int i = 0; i < links.length; ++i) {
            pm.delete(links[i].getScheduleId(), NCObjectType.NC_SCHEDULE, null, conn);
        }
    }

    private void deleteGuidLink(ITask task, Connection conn) throws PublishedGuidException {
        String guid = PublishedGuidPersist.getInstance().getGuid(conn, task.getNCObjectId());
        PublishedGuidPersist.getInstance().deleteGuid(conn, guid);
    }
}

