/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime.task;

import com.cognos.jsmcommon.objectid.NCObjectId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import noticecast.runtime.IAgentStateListener;
import noticecast.runtime.task.AgentEvent;
import noticecast.runtime.task.AgentState;
import noticecast.runtime.task.IAgentEventSender;

public final class AgentEventSenderImpl
implements IAgentEventSender {
    private static transient IAgentEventSender mInstance = new AgentEventSenderImpl();
    private IAgentStateListener[] m_listeners = new IAgentStateListener[0];

    private AgentEventSenderImpl() {
    }

    public static IAgentEventSender instance() {
        return mInstance;
    }

    @Override
    public synchronized void addListener(IAgentStateListener listener) {
        ArrayList<IAgentStateListener> listeners = new ArrayList<IAgentStateListener>(this.m_listeners.length + 1);
        listeners.addAll(Arrays.asList(this.m_listeners));
        listeners.add(listener);
        this.m_listeners = listeners.toArray(new IAgentStateListener[this.m_listeners.length + 1]);
    }

    @Override
    public synchronized void removeListener(IAgentStateListener listener) {
        ArrayList<IAgentStateListener> listeners = new ArrayList<IAgentStateListener>(this.m_listeners.length);
        listeners.addAll(Arrays.asList(this.m_listeners));
        if (listeners.remove(listener)) {
            this.m_listeners = listeners.toArray(new IAgentStateListener[this.m_listeners.length - 1]);
        }
    }

    @Override
    public synchronized void sendEvent(NCObjectId agentId, int agentRunNumber, AgentState state) {
        AgentEvent event = new AgentEvent(agentId, agentRunNumber, state);
        for (int counter = 0; counter < this.m_listeners.length; ++counter) {
            this.m_listeners[counter].processEvent(event);
        }
    }

    @Override
    public synchronized void sendEvent(EventObject event) {
        for (int counter = 0; counter < this.m_listeners.length; ++counter) {
            this.m_listeners[counter].processEvent(event);
        }
    }
}

