/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime.task;

import java.io.Serializable;
import noticecast.debug.Debug;

public final class AgentState
implements Serializable,
Comparable,
Cloneable {
    static final long serialVersionUID = 70009003L;
    private static final transient int mActivated = 0;
    private static final transient int mStarted = 1;
    private static final transient int mFindingTopics = 2;
    private static final transient int mWaitingForDre = 3;
    private static final transient int mProcessingData = 4;
    private static final transient int mSendingMessages = 5;
    private static final transient int mCompleted = 6;
    private static final transient int mMessageNotSent = 7;
    private static final transient int mMessageSent = 8;
    private static final transient int mMessagesFiltered = 9;
    private static final transient int mConditionSucceeded = 10;
    private static final transient int mConditionFailed = 11;
    private static final transient int mMessagesSent = 12;
    private static final transient int mConditionSucceededNoRecipients = 13;
    public static final AgentState ACTIVATED = new AgentState(0);
    public static final AgentState STARTED = new AgentState(1);
    public static final AgentState FINDING_TOPICS = new AgentState(2);
    public static final AgentState WAITING_FOR_DRE = new AgentState(3);
    private static final AgentState PROCESSING_DATA = new AgentState(4);
    public static final AgentState SENDING_MESSAGES = new AgentState(5);
    public static final AgentState COMPLETED = new AgentState(6);
    public static final AgentState SEND_FAILED = new AgentState(7);
    public static final AgentState MESSAGE_SENT = new AgentState(8);
    public static final AgentState MESSAGES_FILTERED = new AgentState(9);
    public static final AgentState CONDITION_SUCCEEDED = new AgentState(10);
    public static final AgentState CONDITION_FAILED = new AgentState(11);
    public static final AgentState MESSAGES_SENT = new AgentState(12);
    public static final AgentState CONDITION_SUCCEEDED_NO_RECIPIENTS = new AgentState(13);
    private static String[] mStateDefinitions = new String[]{"activated", "started", "parsing involved objects to find the required topics", "waiting for data retrieval engine", "processing the values", "sending messages to recipients", "execution completed", "failed to send one or more messages", "one messages is sent", "one or more messages not sent - messages filtered", "execution completed - rules succeeded", "execution completed - rules failed", "All messages are sent", "Condition met - no recipients set into message"};
    private Integer mState = null;

    private AgentState(int state) {
        if (state < 0 || state > 13) {
            throw new IllegalArgumentException(state + " is not valid for agent state");
        }
        this.mState = new Integer(state);
    }

    public int hashCode() {
        this.checkState();
        return this.mState;
    }

    public int compareTo(AgentState anState) {
        int result = -1;
        this.checkState();
        if (anState != null) {
            result = this.mState.compareTo(anState.mState);
        }
        return result;
    }

    public boolean equals(AgentState state) {
        boolean result = false;
        this.checkState();
        if (state != null) {
            result = this.mState.equals(state.mState);
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj.getClass().equals(AgentState.class)) {
            AgentState state = (AgentState)obj;
            result = this.equals(state);
        }
        return result;
    }

    public int compareTo(Object obj) {
        if (Debug.debug && obj != null && !obj.getClass().equals(AgentState.class)) {
            throw new ClassCastException(obj.getClass().getName() + " is not AgentState");
        }
        AgentState state = (AgentState)obj;
        return this.compareTo(state);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.mState == null ? "invalid agent state" : mStateDefinitions[this.mState];
    }

    private void checkState() {
        if (this.mState == null) {
            throw new IllegalStateException("unidentifiable agent state");
        }
    }
}

