/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime.task;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public final class FinalState
implements Comparable,
Serializable {
    static final long serialVersionUID = 70009003L;
    private int mState;
    private static final transient FinalState[] allStates = new FinalState[]{new FinalState(0), new FinalState(1), new FinalState(2), new FinalState(3), new FinalState(4), new FinalState(5), new FinalState(6), new FinalState(7), new FinalState(8)};
    public static final transient FinalState UNKNOWN = allStates[0];
    public static final transient FinalState MESSAGES_IN_QUEUE = allStates[1];
    public static final transient FinalState COMPLETED_NO_DATA = allStates[2];
    public static final transient FinalState SEND_FAILED = allStates[3];
    public static final transient FinalState MESSAGES_SENT = allStates[4];
    public static final transient FinalState ERROR_OCCURED = allStates[5];
    public static final transient FinalState NO_LOG_DATA = allStates[6];
    public static final transient FinalState MESSAGES_FILTERED = allStates[7];
    public static final transient FinalState NO_RECIPIENTS = allStates[8];
    private static final transient I18NCode[] i18NCodesToLocalize = new I18NCode[]{I18NCode.MSG_UNKNOWN_STATE, I18NCode.MSG_QUEUED_MESSAGES_CONDITION_MET, I18NCode.MSG_NO_MESSAGES_SENT_CONDITION_NOT_MET, I18NCode.MSG_ONE_OR_MORE_MESSAGES_FAILED_TO_BE_SENT, I18NCode.MSG_MESSAGES_ALL_SENT_CONDITION_MET, I18NCode.MSG_FAILED_TO_COMPLETE_ERROR, I18NCode.MSG_NO_LOG_DATA, I18NCode.MSG_COMPLETED_BUT_ONE_OR_MORE_MESSAGES_ARE_NOT_SENT, I18NCode.MSG_COMPLETED_NO_RECIPIENTS_SET};
    private static final transient String[] mNames = new String[]{"Unknown state", "Messages are queued to be sent - condition was met", "Completed but no data to send messages ", "Completed but one or more messages failed to be sent", "Completed and all the messages are sent", "Failed to complete its tasks ", "No data on this agent", "Completed but one or more messages are not sent", "Completed (no recipients set)"};

    private FinalState(int state) {
        this.mState = state;
    }

    public static String getSqlString(FinalState state) {
        return Integer.toString(state.mState);
    }

    public static void setValue(FinalState state, PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index, state == null ? FinalState.UNKNOWN.mState : state.mState);
    }

    public static FinalState getState(ResultSet rs, int index) throws SQLException {
        FinalState result = UNKNOWN;
        int state = rs.getInt(index);
        if (!rs.wasNull()) {
            result = allStates[state];
        }
        return result;
    }

    public static FinalState getState(ResultSet rs, String column) throws SQLException {
        FinalState result = UNKNOWN;
        int state = rs.getInt(column);
        if (!rs.wasNull()) {
            result = allStates[state];
        }
        return result;
    }

    public boolean equals(FinalState state) {
        boolean result = false;
        if (state != null) {
            result = this.mState == state.mState;
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj.getClass().equals(FinalState.class)) {
            FinalState state = (FinalState)obj;
            result = this.equals(state);
        }
        return result;
    }

    public int hashCode() {
        return this.mState;
    }

    public int compareTo(Object o) {
        int result = -1;
        if (o instanceof FinalState) {
            FinalState fs = (FinalState)o;
            result = this.mState - fs.mState;
        }
        return result;
    }

    public String toString() {
        return mNames[this.mState];
    }

    public String toShortString() {
        String code = I18NUtil.getMessage((I18NCode)i18NCodesToLocalize[this.mState], (Locale)SDSLogger.getLocale());
        return code;
    }
}

