/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import noticecast.debug.Debug;
import noticecast.logictier.agent.DetectionOption;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.MessageManager;
import noticecast.runtime.IRunTimeManager;
import noticecast.runtime.task.AgentEventSenderImpl;
import noticecast.runtime.task.AgentState;
import noticecast.runtime.task.ITaskRunDetails;
import noticecast.runtime.task.TaskMessageListener;
import noticecast.runtime.task.TaskRunNumber;
import noticecast.scheduling.nc.ITaskSchedule;

public final class RunTaskThread
extends Thread {
    private ITask m_task;
    private int m_runNumber = TaskRunNumber.getNextAvailableRunNumber();
    private ITaskRunDetails m_taskRunDetails;
    private IRunTimeManager m_runtime;
    private boolean m_lastRunCompleted = false;

    public RunTaskThread(IRunTimeManager runTimeManager, ITask task, ITaskSchedule taskSchedule, ITaskRunDetails taskRunDetails) {
        super(runTimeManager.getThreadGroup(), task.getName());
        if (Debug.checkConstraints && task == null) {
            String errMsg = "task passed to run thread is null";
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_OBJECT_IS_NULL, (Map)ap);
        }
        this.m_task = task;
        this.m_taskRunDetails = taskRunDetails;
        this.m_taskRunDetails.setRunNumber(this.m_runNumber);
        this.m_runtime = runTimeManager;
    }

    public NCObjectId getTaskId() {
        return this.m_task.getNCObjectId();
    }

    private void changeState(AgentState agentState) {
        AgentEventSenderImpl.instance().sendEvent(this.m_task.getNCObjectId(), this.m_runNumber, agentState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskMessageListener listener = new TaskMessageListener(this.m_task.getNCObjectId(), this.m_runNumber, this.m_task.getName());
        AgentEventSenderImpl.instance().addListener(listener);
        boolean agentNotSucceededAndPmError = false;
        Object throwable = null;
        String errInfo = "";
        try {
            this.changeState(AgentState.ACTIVATED);
            if (Debug.debug) {
                String msgString = "TASK: " + this.m_task.getName() + " CALLED TO RUN";
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(msgString);
            }
            ArrayList<IMessageStruct> staticMessages = new ArrayList<IMessageStruct>();
            Iterator list = this.m_task.getMessages();
            while (list.hasNext()) {
                IMessageStruct message = (IMessageStruct)list.next();
                if (!message.isStatic()) continue;
                staticMessages.add(message);
            }
            this.changeState(AgentState.FINDING_TOPICS);
            this.changeState(AgentState.WAITING_FOR_DRE);
            this.changeState(AgentState.COMPLETED);
            boolean agent_succeeded = true;
            if (this.m_task.getDetectionOption().equals(DetectionOption.SUCCESS_AFTER_FAILURE) && this.m_lastRunCompleted) {
                this.m_lastRunCompleted = agent_succeeded;
                agent_succeeded = false;
            }
            if (agent_succeeded && !DetectionOption.CONTINUE.equals(this.m_task.getDetectionOption())) {
                if (DetectionOption.DELAY.equals(this.m_task.getDetectionOption())) {
                    this.m_runtime.activateTaskDelay(this.m_task);
                } else if (DetectionOption.STOP.equals(this.m_task.getDetectionOption())) {
                    this.m_runtime.deactivateSchedules(this.m_task.getNCObjectId());
                }
            }
            MessageManager messageManager = MessageManager.instance();
            this.changeState(AgentState.SENDING_MESSAGES);
            boolean bl = messageManager.processMessages(this.m_task, staticMessages, this.m_taskRunDetails, listener);
        }
        catch (Throwable ex) {
            if (Debug.debug) {
                ex.printStackTrace();
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(ex);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_ERROR_LOGGING_AGENT_EVENT_IN_RUNNING_AGE, (Object[])new String[]{ex.getMessage() + ""}, (Map)ap);
        }
        finally {
            try {
                listener.removeFromEventSender();
            }
            finally {
                this.m_runtime.taskRunCompleted(this.m_task);
            }
        }
    }
}

