/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime.task;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.AuditStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import noticecast.logictier.message.IMessage;
import noticecast.runtime.IAgentStateListener;
import noticecast.runtime.task.AgentEvent;
import noticecast.runtime.task.AgentEventSenderImpl;
import noticecast.runtime.task.AgentState;
import noticecast.runtime.task.FinalState;
import noticecast.runtime.task.MessageEvent;

public final class TaskMessageListener
implements IAgentStateListener {
    private HashMap m_messages = new HashMap();
    private NCObjectId m_taskId;
    private int m_runNumber;
    private String m_name;
    private AgentState m_agentState = AgentState.STARTED;

    public TaskMessageListener(NCObjectId taskId, int runNumber, String name) {
        this.m_taskId = taskId;
        this.m_runNumber = runNumber;
        this.m_name = name;
    }

    @Override
    public void addMessages(IMessage[] msgs) {
        if (msgs == null || msgs.length == 0) {
            AgentEventSenderImpl.instance().removeListener(this);
            return;
        }
        for (int counter = 0; counter < msgs.length; ++counter) {
            this.m_messages.put(msgs[counter].getNCObjectId(), msgs[counter]);
        }
    }

    public FinalState getFinalState() {
        FinalState finalState = null;
        finalState = AgentState.ACTIVATED.equals(this.m_agentState) ? FinalState.ERROR_OCCURED : (AgentState.COMPLETED.equals(this.m_agentState) ? FinalState.MESSAGES_SENT : (AgentState.FINDING_TOPICS.equals(this.m_agentState) ? FinalState.ERROR_OCCURED : (AgentState.CONDITION_FAILED.equals(this.m_agentState) ? FinalState.COMPLETED_NO_DATA : (AgentState.CONDITION_SUCCEEDED.equals(this.m_agentState) ? FinalState.SEND_FAILED : (AgentState.CONDITION_SUCCEEDED_NO_RECIPIENTS.equals(this.m_agentState) ? FinalState.NO_RECIPIENTS : (AgentState.MESSAGES_FILTERED.equals(this.m_agentState) ? FinalState.MESSAGES_FILTERED : (AgentState.MESSAGES_SENT.equals(this.m_agentState) ? FinalState.MESSAGES_SENT : (AgentState.SEND_FAILED.equals(this.m_agentState) ? FinalState.SEND_FAILED : (AgentState.SENDING_MESSAGES.equals(this.m_agentState) ? FinalState.MESSAGES_IN_QUEUE : (AgentState.STARTED.equals(this.m_agentState) ? FinalState.ERROR_OCCURED : (AgentState.WAITING_FOR_DRE.equals(this.m_agentState) ? FinalState.ERROR_OCCURED : FinalState.UNKNOWN)))))))))));
        return finalState;
    }

    @Override
    public void processEvent(EventObject event) {
        if (!this.m_taskId.equals((NCObjectId)event.getSource())) {
            return;
        }
        if (event instanceof MessageEvent) {
            this.processMessageEvent((MessageEvent)event);
        } else if (event instanceof AgentEvent) {
            this.processAgentEvent((AgentEvent)event);
        }
    }

    public void removeFromEventSender() {
        AgentEventSenderImpl.instance().removeListener(this);
    }

    public void attemptRemovalFromEventSender() {
        if (this.m_messages.isEmpty()) {
            AgentEventSenderImpl.instance().removeListener(this);
        }
    }

    private void processAgentEvent(AgentEvent agentEvent) {
        if (agentEvent.getTaskRunNumber() == this.m_runNumber) {
            this.m_agentState = agentEvent.getState();
        }
    }

    private void processMessageEvent(MessageEvent msgEvent) {
        if (!this.m_messages.containsKey(msgEvent.getMsgId())) {
            return;
        }
        FinalState log_state = FinalState.SEND_FAILED;
        try {
            if (AgentState.MESSAGE_SENT.equals(msgEvent.getState())) {
                this.oneMessageSent(msgEvent.getMsgId());
                log_state = FinalState.MESSAGES_SENT;
            } else if (AgentState.SEND_FAILED.equals(msgEvent.getState())) {
                this.oneMessageFailed(msgEvent.getMsgId());
            }
        }
        finally {
            if (this.m_messages.remove(msgEvent.getMsgId()) == null) {
                // empty if block
            }
        }
        if (this.m_messages.isEmpty()) {
            AgentEventSenderImpl.instance().removeListener(this);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)AuditStatus.BLANK);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_UPDATE_TASK_LOG_TO_IPF, (Object[])new String[]{this.m_name, log_state.toString()}, (Map)ap);
        }
    }

    private void oneMessageFailed(NCObjectId msgId) {
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_NOT_SENT, (Object[])new String[]{this.getMessageSubject(msgId), this.m_name}, (Map)ap);
    }

    private void oneMessageSent(NCObjectId msgId) {
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Success");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_SENT, (Object[])new String[]{this.getMessageSubject(msgId), this.m_name}, (Map)ap);
    }

    private String getMessageSubject(NCObjectId id) {
        IMessage message = (IMessage)this.m_messages.get(id);
        String subject = "";
        if (message != null) {
            subject = message.getSubject();
        }
        return subject;
    }
}

