/*
 * Decompiled with CFR 0.152.
 */
package noticecast.runtime.task;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.sds.api.converter.scheduling.ScheduleConverter;
import com.cognos.sds.event.Event;
import java.util.Date;
import noticecast.runtime.task.ITaskRunDetails;
import noticecast.runtime.task.SchedulePriority;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.schedules.TriggeredSchedule;

public class TaskRunDetailsImpl
implements ITaskRunDetails {
    private Date m_nextRunDate;
    private int m_runNumber;
    private String m_triggerName = null;
    private byte m_priority;
    private String m_documentVersionID = null;
    private Event m_event;
    private String scheduleType;
    private Option[] taskOptions = null;
    private String m_tenantID = null;

    public TaskRunDetailsImpl(Event event, ITaskSchedule ts, Date nextExecution) {
        this.m_event = event;
        this.m_nextRunDate = ts.getNextExecution();
        this.m_tenantID = ts.getTenantID();
        this.m_priority = event.getPriority() != null ? (byte)event.getPriority().intValue() : (byte)ts.getPriority();
        NcScheduleWrapper wrapper = ts.getScheduleLinks()[0].getSchedule();
        this.scheduleType = ScheduleConverter.getOMScheduleType(wrapper);
        if (wrapper.getSchedule() instanceof TriggeredSchedule) {
            this.m_triggerName = ((TriggeredSchedule)wrapper.getSchedule()).getTrigger();
        }
    }

    @Override
    public Event getEvent() {
        return this.m_event;
    }

    @Override
    public Date getTaskNextRunDate() {
        return this.m_nextRunDate;
    }

    @Override
    public int getRunNumber() {
        return this.m_runNumber;
    }

    @Override
    public void setRunNumber(int runNumber) {
        this.m_runNumber = runNumber;
    }

    @Override
    public boolean isCancelledRun() {
        return this.m_event.getStatus().equals((Object)EventStatus.CANCELLED);
    }

    @Override
    public String getCancelledBy() {
        return this.m_event.getCancelUser();
    }

    @Override
    public String getScheduleTrigger() {
        return this.m_triggerName;
    }

    @Override
    public String getScheduleType() {
        return this.scheduleType;
    }

    @Override
    public byte getSchedulePriority(BiBusHeader header) {
        byte schedulePriority = 3;
        try {
            if (this.m_priority != 3) {
                boolean hasCanUseSchedulingPriorityCapability = AuthenticatorFactory.getInstance().hasCapability(header, UserCapabilityEnum.canUseSchedulingPriority);
                SchedulePriority sp = this.getSchedulePriority(hasCanUseSchedulingPriorityCapability);
                schedulePriority = sp.priority;
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Exception 2: Error getting schedule priority: " + ex);
        }
        return schedulePriority;
    }

    @Override
    public SchedulePriority getSchedulePriority(boolean hasCanUseSchedulingPriorityCapability) {
        SchedulePriority sp = null;
        boolean isSchedulingPriorityCapabilityCheckDisabled = false;
        try {
            sp = new SchedulePriority(3, false);
            if (this.m_priority != 3) {
                isSchedulingPriorityCapabilityCheckDisabled = CRNProperties.getProperty((String)"emf.scheduling.priority.capability.check.disabled", (boolean)false);
                if (!isSchedulingPriorityCapabilityCheckDisabled) {
                    if (hasCanUseSchedulingPriorityCapability) {
                        sp = new SchedulePriority(this.m_priority, false);
                    } else {
                        sp = new SchedulePriority(3, true);
                        String logMsg = "The schedule user does not have canUseSchedulingPriority capability, so default priority 3 will be used for the current schedule task run.";
                        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, null, new Object[]{logMsg});
                    }
                } else {
                    sp = new SchedulePriority(this.m_priority, false);
                }
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Exception 2: Error retriving schedule priority: " + e);
        }
        return sp;
    }

    @Override
    public void setDocumentVersionID(String documentVersionID) {
        this.m_documentVersionID = documentVersionID;
    }

    @Override
    public String getDocumentVersionID() {
        return this.m_documentVersionID;
    }

    @Override
    public Option[] getTaskOptions() {
        return this.taskOptions;
    }

    @Override
    public void setTaskOptions(Option[] taskOptions) {
        this.taskOptions = taskOptions;
    }

    @Override
    public String getTenantID() {
        return this.m_tenantID;
    }
}

