/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Date;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.IQueueFactory;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulerQueue;
import noticecast.scheduling.core.memoryqueue.MemoryQueueFactory;
import noticecast.services.RepositoryServicesImpl;
import noticecast.starter.ProcessType;
import noticecast.starter.SingletonServiceProvider;

public class QueueFactory
implements IQueueFactory {
    private static final String QUEUE_FACTORY_CLASS_NAME = "scheduler.queue.factory.class";
    private static final String QUEUE_POLL_INTERVAL = "scheduler.queue.poll.interval.seconds";
    private static final String defaultQueueFactoryClassName = "noticecast.scheduling.core.persistqueue.PersistQueueFactory";
    private static QueueFactory m_instance;
    private IQueueFactory m_factory = new MemoryQueueFactory();
    private Long m_queuePollInterval;

    public static synchronized QueueFactory instance() {
        return m_instance == null ? (m_instance = new QueueFactory()) : m_instance;
    }

    @Override
    public ISchedulerQueue createQueue() {
        ISchedulerQueue queue = this.getFactory().createQueue();
        queue.setPollInterval(this.m_queuePollInterval);
        return queue;
    }

    @Override
    public IQueueEntry createQueueEntry(ISchedulable schedulable, Date date) {
        return this.getFactory().createQueueEntry(schedulable, date);
    }

    @Override
    public boolean initializeOnRestart() {
        return this.getFactory().initializeOnRestart();
    }

    private QueueFactory() {
        String queueFactoryClassName = defaultQueueFactoryClassName;
        if (ProcessType.CR1_scheduler.equals(SingletonServiceProvider.getInstance().getProcessType())) {
            try {
                IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
                queueFactoryClassName = pm.getProperty(QUEUE_FACTORY_CLASS_NAME);
                String pollIntervalString = pm.getProperty(QUEUE_POLL_INTERVAL);
                this.setQueuePollInterval(pollIntervalString);
            }
            catch (PersistManagerException ex) {
                this.log(ex.getMessage());
            }
        }
        try {
            IQueueFactory queueFactory = null;
            if (queueFactoryClassName != null && (queueFactory = (IQueueFactory)Class.forName(queueFactoryClassName).newInstance()) != null) {
                this.m_factory = queueFactory;
            }
        }
        catch (ClassNotFoundException ex) {
            this.log(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            this.log(ex.getMessage());
        }
        catch (InstantiationException ex) {
            this.log(ex.getMessage());
        }
    }

    private IQueueFactory getFactory() {
        return this.m_factory;
    }

    private void log(String msg) {
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{msg + ""});
    }

    private void setQueuePollInterval(String pollIntervalString) {
        if (pollIntervalString == null || pollIntervalString.equals("")) {
            return;
        }
        try {
            long queuePollInterval = Long.parseLong(pollIntervalString);
            if (queuePollInterval > 0L) {
                this.m_queuePollInterval = new Long(queuePollInterval * 1000L);
            }
        }
        catch (NumberFormatException ex) {
            this.m_queuePollInterval = new Long(30000L);
        }
    }
}

