/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core;

import java.util.HashMap;
import java.util.Map;
import noticecast.scheduling.core.ISchedulableId;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SchedulableIdAbstractFactory {
    public static final Logger logger = LogManager.getLogger((String)SchedulableIdAbstractFactory.class.getName());
    private static Map m_factories = new HashMap();

    public static SchedulableIdAbstractFactory getFactory(String className) {
        Object factory = m_factories.get(className);
        Object errorMessage = null;
        if (factory == null) {
            try {
                Class<?> factoryClass = Class.forName(className);
                factory = factoryClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.ERROR, SchedulableIdAbstractFactory.class, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.ERROR, SchedulableIdAbstractFactory.class, (Throwable)ex);
            }
            catch (InstantiationException ex) {
                logger.log(Level.ERROR, SchedulableIdAbstractFactory.class, (Throwable)ex);
            }
        }
        SchedulableIdAbstractFactory returnFactory = null;
        try {
            returnFactory = (SchedulableIdAbstractFactory)factory;
        }
        catch (ClassCastException ex) {
            logger.log(Level.ERROR, SchedulableIdAbstractFactory.class, (Throwable)ex);
        }
        return returnFactory;
    }

    public abstract ISchedulableId getUniqueId();
}

