/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core;

import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.TreeSet;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.core.SchedulableQueryResponse;
import noticecast.scheduling.core.Scheduler;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleType;

public class SchedulableQuery {
    public static int MAX_COUNT = Integer.MAX_VALUE;
    public static int DEFAULT_COUNT = 1000;

    public static SchedulableQueryResponse doQuery(ISchedulable[] schedulables, Date start, Date end, int count, int skip, boolean ascending, String[] statuses) throws LocalizableException {
        long diff;
        if (!Scheduler.getInstance().isSchedulerThreadActive()) {
            return new SchedulableQueryResponse(new Event[0], true, 0);
        }
        if (count == 0) {
            count = MAX_COUNT;
        }
        if ((diff = (long)end.compareTo(start)) < 0L) {
            end = start;
        } else {
            Date maximumEnd = new Date(start.getTime() + 2592000000L);
            if (maximumEnd.compareTo(end) < 0) {
                throw new LocalizableException(EmsI18NCode.QUERY_EVENTS_MAX_DATE_RANGE_ERROR, new String[]{"30"}){};
            }
        }
        SchedulableQueryResponse result = null;
        result = ascending ? (skip >= 0 ? SchedulableQuery.getAscending(schedulables, start, end, count, skip, statuses) : SchedulableQuery.getAscendingNegativeSkip(schedulables, start, end, count, skip, statuses)) : (skip >= 0 ? SchedulableQuery.getDescending(schedulables, start, end, count, skip, statuses) : SchedulableQuery.getDescendingNegativeSkip(schedulables, start, end, count, skip, statuses));
        return result;
    }

    private static SchedulableQueryResponse getAscending(ISchedulable[] schedulables, Date start, Date end, int count, int skip, String[] statuses) {
        int skipCount = skip;
        TreeSet<Event> schedulableRunDateResultSet = new TreeSet<Event>(new Event.RequestDateComparator());
        HashMap<ISchedulable, Event> schedulableMap = new HashMap<ISchedulable, Event>();
        for (int i = 0; i < schedulables.length; ++i) {
            Event runDate = schedulables[i].getNextExecuteInclusive(start);
            if (runDate == null) continue;
            schedulableMap.put(schedulables[i], runDate);
        }
        Event srd = null;
        Object schedulableRunDateList = null;
        if (!schedulableMap.isEmpty()) {
            srd = Collections.min(schedulableMap.values(), new Event.RequestDateComparator());
        }
        int executeCount = 0;
        while (!schedulableMap.isEmpty() && !srd.getRunDate().after(end) && executeCount < count) {
            ISchedulable schedulable;
            EventStatus theStatus = srd.getStatus();
            if (SchedulableQuery.checkStatusInList(theStatus, statuses)) {
                if (skipCount > 0) {
                    --skipCount;
                } else {
                    schedulableRunDateResultSet.add(srd);
                    ++executeCount;
                }
            }
            if ((srd = (schedulable = srd.getSchedulable()).getNextExecute(srd.getRunDate())) == null) {
                schedulableMap.remove(schedulable);
            } else {
                schedulableMap.put(srd.getSchedulable(), srd);
            }
            if (schedulableMap.isEmpty()) continue;
            srd = Collections.min(schedulableMap.values(), new Event.RequestDateComparator());
        }
        boolean isComplete = schedulableMap.isEmpty();
        Event[] schedulableRunDateArray = new Event[schedulableRunDateResultSet.size()];
        schedulableRunDateResultSet.toArray(schedulableRunDateArray);
        int skipped = skip - skipCount;
        return new SchedulableQueryResponse(schedulableRunDateArray, isComplete, skipped);
    }

    private static SchedulableQueryResponse getAscendingNegativeSkip(ISchedulable[] schedulables, Date start, Date end, int count, int skip, String[] statuses) {
        SchedulableQueryResponse response = null;
        Event[] allRunDates = SchedulableQuery.getFullRunDateArray(schedulables, start, end, statuses);
        if (allRunDates.length == 0) {
            response = new SchedulableQueryResponse(allRunDates, true, skip);
        }
        if (response == null) {
            int modifiedSkip = skip + allRunDates.length;
            if (modifiedSkip <= 0) {
                int actualSkip = allRunDates.length;
                if (count < allRunDates.length) {
                    Event[] requiredRunDates = new Event[count];
                    System.arraycopy(allRunDates, 0, requiredRunDates, 0, count);
                    response = new SchedulableQueryResponse(requiredRunDates, true, actualSkip);
                } else {
                    response = new SchedulableQueryResponse(allRunDates, true, actualSkip);
                }
            } else {
                int arrayStart = modifiedSkip;
                if (arrayStart >= allRunDates.length) {
                    response = new SchedulableQueryResponse(new Event[0], false, allRunDates.length);
                } else {
                    int arrayEnd = count + modifiedSkip;
                    if (arrayEnd >= allRunDates.length) {
                        arrayEnd = allRunDates.length;
                    }
                    Event[] requiredRunDates = new Event[arrayEnd - arrayStart];
                    System.arraycopy(allRunDates, arrayStart, requiredRunDates, 0, arrayEnd - arrayStart);
                    response = new SchedulableQueryResponse(requiredRunDates, true, skip);
                }
            }
        }
        return response;
    }

    private static SchedulableQueryResponse getDescending(ISchedulable[] schedulables, Date start, Date end, int count, int skip, String[] statuses) {
        SchedulableQueryResponse response = null;
        Event[] allRunDates = SchedulableQuery.getFullRunDateArray(schedulables, start, end, statuses);
        if (allRunDates.length == 0) {
            response = new SchedulableQueryResponse(allRunDates, true, skip);
        }
        if (response == null) {
            int subArrayEnd;
            int subArrayStart = allRunDates.length - (skip + count);
            if (subArrayStart < 0) {
                subArrayStart = 0;
            }
            if ((subArrayEnd = allRunDates.length - skip) < 0) {
                subArrayEnd = 0;
            }
            if (subArrayEnd < subArrayStart) {
                subArrayEnd = subArrayStart;
            }
            Event[] schedulableRunDateArray = new Event[subArrayEnd - subArrayStart];
            int newArrayIndex = 0;
            for (int i = subArrayStart; i < subArrayEnd; ++i) {
                schedulableRunDateArray[newArrayIndex] = allRunDates[i];
                ++newArrayIndex;
            }
            Collections.reverse(Arrays.asList(schedulableRunDateArray));
            int skipped = allRunDates.length < skip ? allRunDates.length : skip;
            response = new SchedulableQueryResponse(schedulableRunDateArray, true, skipped);
        }
        return response;
    }

    private static SchedulableQueryResponse getDescendingNegativeSkip(ISchedulable[] schedulables, Date start, Date end, int count, int negativeSkip, String[] statuses) {
        int skip = Math.abs(negativeSkip);
        int skipCount = 0;
        TreeSet<Event> schedulableRunDateResultSet = new TreeSet<Event>(new Event.RequestDateComparator());
        HashMap<ISchedulable, Event> schedulableMap = new HashMap<ISchedulable, Event>();
        for (int i = 0; i < schedulables.length; ++i) {
            Event runDate = schedulables[i].getNextExecuteInclusive(start);
            if (runDate == null) continue;
            schedulableMap.put(schedulables[i], runDate);
        }
        Event srd = null;
        Object schedulableRunDateList = null;
        if (!schedulableMap.isEmpty()) {
            srd = Collections.min(schedulableMap.values(), new Event.RequestDateComparator());
        }
        boolean executeCount = false;
        while (!schedulableMap.isEmpty() && !srd.getRunDate().after(end) && skipCount < skip) {
            ISchedulable schedulable;
            EventStatus theStatus = srd.getStatus();
            if (SchedulableQuery.checkStatusInList(theStatus, statuses)) {
                ++skipCount;
                schedulableRunDateResultSet.add(srd);
                if (schedulableRunDateResultSet.size() > count) {
                    schedulableRunDateResultSet.remove(schedulableRunDateResultSet.first());
                }
            }
            if ((srd = (schedulable = srd.getSchedulable()).getNextExecute(srd.getRunDate())) == null) {
                schedulableMap.remove(schedulable);
            } else if (SchedulableQuery.checkStatusInList(srd.getStatus(), statuses)) {
                schedulableMap.put(srd.getSchedulable(), srd);
            }
            if (schedulableMap.isEmpty()) continue;
            srd = Collections.min(schedulableMap.values(), new Event.RequestDateComparator());
        }
        boolean isComplete = schedulableMap.isEmpty();
        Event[] schedulableRunDateArray = new Event[schedulableRunDateResultSet.size()];
        schedulableRunDateResultSet.toArray(schedulableRunDateArray);
        int skipped = -skipCount;
        Collections.reverse(Arrays.asList(schedulableRunDateArray));
        return new SchedulableQueryResponse(schedulableRunDateArray, isComplete, skipped);
    }

    private static boolean checkStatusInList(EventStatus status, String[] statuses) {
        if (statuses == null) {
            return true;
        }
        String aStatus = status.statusName();
        for (int i = 0; i < statuses.length; ++i) {
            if (aStatus.compareToIgnoreCase(statuses[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private static Event[] getFullRunDateArray(ISchedulable[] schedulables, Date start, Date end, String[] statuses) {
        TreeSet<Event> schedulableRunDateSet = new TreeSet<Event>();
        for (int i = 0; i < schedulables.length; ++i) {
            Event srd = schedulables[i].getNextExecuteInclusive(start);
            while (srd != null && (srd.getRunDate().before(end) || srd.getRunDate().equals(end))) {
                EventStatus theStatus = srd.getStatus();
                if (SchedulableQuery.checkStatusInList(theStatus, statuses)) {
                    schedulableRunDateSet.add(srd);
                }
                srd = schedulables[i].getNextExecute(srd.getRunDate());
            }
        }
        Event[] schedulableRunDateArrayFull = new Event[schedulableRunDateSet.size()];
        schedulableRunDateSet.toArray(schedulableRunDateArrayFull);
        return schedulableRunDateArrayFull;
    }

    public static void main(String[] args) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss a zzz");
        formatter.setTimeZone(TimeZone.getDefault());
        ISchedule schedule1 = SchedulableQuery.getDailySchedule(formatter, "2002.05.01 at 11:00:00 AM GMT", "2002.05.04 at 11:00:00 AM GMT", false, 1);
        ISchedule schedule2 = SchedulableQuery.getDailySchedule(formatter, "2002.05.07 at 11:00:00 AM GMT", "2002.05.09 at 11:00:00 AM GMT", false, 1);
        Date start = null;
        Date end = null;
        try {
            start = formatter.parse("2002.05.01 at 11:00:00 AM GMT");
            end = formatter.parse("2002.05.09 at 11:00:00 AM GMT");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TestSchedulable sched1 = new TestSchedulable(schedule1, EventStatus.SCHEDULED);
        TestSchedulable sched2 = new TestSchedulable(schedule2, EventStatus.CANCELLED);
        ISchedulable[] schedulables = new ISchedulable[]{sched1, sched2};
        Object[][] data = new Object[][]{{schedulables, start, end, new Integer(0), new Integer(0), Boolean.TRUE}, {schedulables, start, end, new Integer(-1), new Integer(0), Boolean.TRUE}, {schedulables, start, end, new Integer(4), new Integer(0), Boolean.TRUE}, {schedulables, start, end, new Integer(0), new Integer(4), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-2), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-6), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-7), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-8), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-30), Boolean.TRUE}, {schedulables, start, end, new Integer(0), new Integer(0), Boolean.FALSE}, {schedulables, start, end, new Integer(-1), new Integer(0), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(0), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(3), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(6), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(7), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(8), Boolean.FALSE}, {schedulables, start, end, new Integer(0), new Integer(-3), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-5), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-7), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-8), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-30), Boolean.FALSE}};
        String[] statuses = new String[]{"scheduled", "cancelled"};
        try {
            for (int i = 0; i < data.length; ++i) {
                System.out.println("Test[" + i + "]");
                System.out.print("Count:" + data[i][3].toString());
                System.out.print("  Skip:" + data[i][4].toString());
                System.out.print((Boolean)data[i][5] != false ? "  Ascending:" : "  Descending");
                System.out.println();
                SchedulableQueryResponse response = SchedulableQuery.doQuery((ISchedulable[])data[i][0], (Date)data[i][1], (Date)data[i][2], (Integer)data[i][3], (Integer)data[i][4], (Boolean)data[i][5], statuses);
                SchedulableQuery.outputTestResult(response, formatter);
            }
        }
        catch (LocalizableException e) {
            e.printStackTrace();
        }
    }

    private static ISchedule getDailySchedule(DateFormat formatter, String startDateString, String endDateString, boolean repeatForever, int interval) {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = formatter.parse(startDateString);
            endDate = formatter.parse(endDateString);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        DailySchedule schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, startDate, endDate, false, 1, com.cognos.i18n.TimeZone.getDefault());
        return schedule;
    }

    private static void outputTestResult(SchedulableQueryResponse response, SimpleDateFormat formatter) {
        if (response == null) {
            System.out.println("Response in null!");
            return;
        }
        Event[] dates = response.getRunDates();
        if (dates != null) {
            if (dates.length == 0) {
                System.out.println("No dates returned (array length = 0)");
            }
            for (int i = 0; i < dates.length; ++i) {
                Date responseDate = dates[i].getRunDate();
                System.out.println(formatter.format(responseDate));
            }
        }
        System.out.println("Returned objects:" + dates.length);
        System.out.println("Skipped objects:" + response.getSkipped());
        System.out.println();
    }

    private static class TestSchedulable
    implements ISchedulable {
        private EventStatus m_status;
        private ISchedule m_schedule;

        public TestSchedulable(ISchedule schedule, EventStatus x) {
            this.m_schedule = schedule;
            this.m_status = x;
        }

        @Override
        public Date getNextExecution() {
            return null;
        }

        @Override
        public Event getNextExecute(Date date) {
            Date resultDate = this.m_schedule.getNextExecute(date);
            Event srd = null;
            if (resultDate != null) {
                srd = new Event(EventStatus.SCHEDULED, EventId.valueOf("1234"));
                srd.setRequestedStartDate(resultDate);
                srd.setPriority(new Integer(3));
                srd.setSchedulable(this);
            }
            return srd;
        }

        @Override
        public Event getNextExecuteInclusive(Date date) {
            Date resultDate = this.m_schedule.getNextExecuteInclusive(date);
            Event srd = null;
            if (resultDate != null) {
                srd = new Event(EventStatus.SCHEDULED, EventId.valueOf("1234"));
                srd.setRequestedStartDate(resultDate);
                srd.setPriority(new Integer(3));
                srd.setSchedulable(this);
            }
            return srd;
        }

        @Override
        public void runTask() {
        }

        @Override
        public ISchedulableId getId() {
            return null;
        }
    }
}

