/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import noticecast.debug.Debug;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulerQueue;
import noticecast.scheduling.core.QueueFactory;
import noticecast.scheduling.core.SchedulerQueueException;

public final class Scheduler
implements Runnable {
    private static int startCount = 0;
    private ISchedulerQueue m_SchedulerQueue;
    private Thread m_schedulerThread;
    private volatile boolean m_schedulerRunning = false;
    private boolean m_logging = false;
    private static Scheduler m_scheduler = new Scheduler();
    private Long m_pollInterval;
    private Object runLock = new Object();

    private Scheduler() {
        this.m_SchedulerQueue = QueueFactory.instance().createQueue();
        this.m_pollInterval = this.m_SchedulerQueue.getPollInterval();
    }

    public static Scheduler getInstance() {
        return m_scheduler;
    }

    public synchronized void startScheduler() {
        if (this.m_schedulerRunning) {
            return;
        }
        this.m_schedulerRunning = true;
        if (this.m_schedulerThread == null || !this.m_schedulerThread.isAlive()) {
            this.m_schedulerThread = new Thread((Runnable)this, "EMS.Scheduler");
            this.m_schedulerThread.start();
        }
        String msg = "Scheduler.startScheduler() called [count: " + ++startCount + "]";
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, null, (Object[])new String[]{msg});
    }

    public synchronized void stopScheduler() {
        this.m_schedulerRunning = false;
        for (int counter = 7; this.m_schedulerThread != null && counter > 0; --counter) {
            String msg = "Scheduler.stopScheduler(): the scheduler thread has not died yet";
            if (!this.m_schedulerThread.isInterrupted()) {
                this.m_schedulerThread.interrupt();
            }
            try {
                this.wait(2000L);
            }
            catch (InterruptedException ex) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)ex);
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{msg});
            }
            if (this.m_schedulerThread.isAlive()) continue;
            this.m_schedulerThread = null;
        }
        if (this.m_schedulerThread == null) {
            String msg = "SCHEDULER_STOPPED";
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, null, (Object[])new String[]{msg});
        } else {
            String msg = "Failed to stop the scheduler, although it is flagged as stopped.";
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, null, (Object[])new String[]{msg});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ISchedulable schedulable, Date date) {
        String msg = "Scheduler - adding job to queue [ID:" + schedulable.getId() + "]";
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(msg);
        ISchedulerQueue iSchedulerQueue = this.m_SchedulerQueue;
        synchronized (iSchedulerQueue) {
            try {
                this.m_SchedulerQueue.beginTransaction();
                this.remove(schedulable);
                IQueueEntry entry = QueueFactory.instance().createQueueEntry(schedulable, date);
                this.insertIntoSchedulerQueue(entry);
            }
            catch (SchedulerQueueException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)((Object)e));
            }
            finally {
                try {
                    this.m_SchedulerQueue.endTransaction();
                }
                catch (SchedulerQueueException e) {
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoSchedulerQueue(IQueueEntry entry) {
        if (this.m_SchedulerQueue.addToQueue(entry)) {
            Object object = this.runLock;
            synchronized (object) {
                this.runLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ISchedulable schedulable) {
        String msg = "Scheduler - removing job from queue [ID:" + schedulable.getId() + "]";
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(msg);
        IQueueEntry entry = QueueFactory.instance().createQueueEntry(schedulable, null);
        boolean removed = this.m_SchedulerQueue.remove(entry);
        if (removed) {
            Object object = this.runLock;
            synchronized (object) {
                this.runLock.notify();
            }
        }
        return removed;
    }

    public boolean removeAll() {
        String msg = "Scheduler - removing all jobs from queue";
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(msg);
        return this.m_SchedulerQueue.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_schedulerRunning) {
            long waitTime = this.runTasks();
            if (waitTime == Long.MAX_VALUE) {
                waitTime = 0L;
            }
            try {
                Object object = this.runLock;
                synchronized (object) {
                    this.runLock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                if (Debug.debug) {
                    System.out.println(e);
                }
                String msg = "INTERRUPTED_EXCEPTION IN SCHEDULER RUN";
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{msg});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runTasks() {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"Scheduler.runTasks");
        try {
            long delay = Long.MAX_VALUE;
            do {
                ISchedulerQueue iSchedulerQueue = this.m_SchedulerQueue;
                synchronized (iSchedulerQueue) {
                    block21: {
                        IQueueEntry first = this.m_SchedulerQueue.getFirstEntry();
                        delay = Long.MAX_VALUE;
                        if (first != null) {
                            delay = first.getDate().getTime() - new Date().getTime();
                        }
                        if (delay != Long.MAX_VALUE && delay <= 0L) {
                            this.m_SchedulerQueue.beginTransaction();
                            try {
                                ISchedulable schedulable;
                                if (!this.m_SchedulerQueue.remove(first) || (schedulable = first.getSchedulable()) == null) break block21;
                                try {
                                    schedulable.runTask();
                                }
                                catch (Throwable e) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    pw.write("Scheduler - error calling runTask: " + e.getLocalizedMessage());
                                    e.printStackTrace(pw);
                                    pw.flush();
                                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, null, (Object[])new String[]{sw.toString()});
                                    pw.close();
                                }
                                Date newDate = schedulable.getNextExecution();
                                if (newDate != null) {
                                    first.setDate(newDate);
                                    this.insertIntoSchedulerQueue(first);
                                }
                            }
                            finally {
                                this.m_SchedulerQueue.endTransaction();
                            }
                        }
                    }
                }
            } while (delay != Long.MAX_VALUE && delay <= 0L);
            if (this.m_pollInterval != null && (delay == Long.MAX_VALUE || this.m_pollInterval < delay)) {
                delay = this.m_pollInterval;
            }
            long l = delay;
            return l;
        }
        catch (SchedulerQueueException ex) {
            long l = 15000L;
            return l;
        }
        catch (Throwable ex) {
            if (Debug.debug) {
                System.out.println(ex);
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(ex);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, ex);
            long l = 30000L;
            return l;
        }
        finally {
            zipiTimer.stopAndClear();
        }
    }

    private void logSchedulingEvent(IQueueEntry entry, Date earliest, Date nextDate) {
        StringBuffer buff = new StringBuffer();
        buff.append("ISchedulableId: ");
        buff.append(entry.getSchedulableId());
        buff.append(" Earliest Date: ");
        buff.append("m_formatter.format(earliest)");
        buff.append(" Current Date: ");
        buff.append("m_formatter.format(new Date())");
        if (nextDate != null) {
            buff.append(" Next Date: ");
            buff.append("m_formatter.format(nextDate)");
        }
        String msg = buff.toString();
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, null, (Object[])new String[]{msg});
    }

    public void setlogging(boolean status) {
        this.m_logging = status;
    }

    public boolean getLogging() {
        return this.m_logging;
    }

    public Collection schedulerQueueContents() throws SchedulerQueueException {
        return this.m_SchedulerQueue.schedulerQueueContents();
    }

    public Collection schedulerQueueContents(Date endDate) throws SchedulerQueueException {
        return this.m_SchedulerQueue.schedulerQueueContents(endDate);
    }

    public Collection schedulerQueueContents(String[] tenantIDs, Date endDate) throws SchedulerQueueException {
        return this.m_SchedulerQueue.schedulerQueueContents(tenantIDs, endDate);
    }

    public boolean initialiseQueueOnRestart() {
        return QueueFactory.instance().initializeOnRestart();
    }

    public synchronized boolean isSchedulerThreadActive() {
        boolean result = false;
        if (this.m_schedulerThread != null && this.m_schedulerThread.isAlive()) {
            result = true;
        }
        return result;
    }
}

