/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core.memoryqueue;

import java.util.Date;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;

public class QueueEntryImpl
implements IQueueEntry {
    static final long serialVersionUID = 70009003L;
    private ISchedulable m_schedulable;
    private Date m_date;

    public QueueEntryImpl(ISchedulable schedulable, Date date) {
        this.m_schedulable = schedulable;
        this.m_date = date;
    }

    @Override
    public Date getDate() {
        return this.m_date;
    }

    @Override
    public void setDate(Date date) {
        this.m_date = date;
    }

    @Override
    public ISchedulable getSchedulable() {
        return this.m_schedulable;
    }

    public int compareTo(Object obj) {
        IQueueEntry entry = (IQueueEntry)obj;
        int cmp = this.getDate().compareTo(entry.getDate());
        if (cmp == 0) {
            ISchedulableId objId = ((IQueueEntry)obj).getSchedulable().getId();
            cmp = objId.compareTo(this.getSchedulable().getId());
        }
        return cmp;
    }

    @Override
    public ISchedulableId getSchedulableId() {
        return this.m_schedulable.getId();
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof IQueueEntry) {
            IQueueEntry entry = (IQueueEntry)object;
            ISchedulable schedulable = entry.getSchedulable();
            ISchedulableId schedulableId = schedulable.getId();
            ISchedulableId thisSchedulableId = this.m_schedulable.getId();
            equals = schedulableId.equals(thisSchedulableId);
        }
        return equals;
    }
}

