/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core.memoryqueue;

import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import java.util.TreeSet;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.core.ISchedulerQueue;
import noticecast.scheduling.core.SchedulerQueueException;
import noticecast.scheduling.core.memoryqueue.QueueEntryImpl;

public class SchedulerQueue
implements ISchedulerQueue {
    private TreeSet m_queue = new TreeSet();
    private TreeMap m_sortedIds = new TreeMap();

    @Override
    public synchronized boolean addToQueue(IQueueEntry entry) {
        boolean insertedAtFrontOfQueue = false;
        if (entry == null) {
            return insertedAtFrontOfQueue;
        }
        this.m_queue.add(entry);
        ISchedulableId oid = entry.getSchedulable().getId();
        this.m_sortedIds.put(oid, entry);
        if (entry.equals(this.m_queue.first())) {
            insertedAtFrontOfQueue = true;
        }
        return insertedAtFrontOfQueue;
    }

    @Override
    public IQueueEntry getFirstEntry() {
        return this.m_queue.isEmpty() ? null : (IQueueEntry)this.m_queue.first();
    }

    @Override
    public synchronized boolean remove(IQueueEntry toRemove) {
        boolean removedFromFrontOfQueue = false;
        if (toRemove == null) {
            return removedFromFrontOfQueue;
        }
        ISchedulableId toRemoveId = toRemove.getSchedulableId();
        IQueueEntry entry = (IQueueEntry)this.m_sortedIds.remove(toRemoveId);
        if (entry != null) {
            Object firtsObj = this.m_queue.first();
            if (entry.equals(firtsObj)) {
                removedFromFrontOfQueue = true;
            }
            this.m_queue.remove(entry);
        }
        return removedFromFrontOfQueue;
    }

    @Override
    public boolean removeAll() {
        this.m_queue.clear();
        this.m_sortedIds.clear();
        return true;
    }

    @Override
    public Collection schedulerQueueContents() {
        return (Collection)this.m_queue.clone();
    }

    @Override
    public Collection schedulerQueueContents(Date endDate) {
        Date date = new Date(endDate.getTime() + 1L);
        TreeSet queueCopy = (TreeSet)this.m_queue.clone();
        return queueCopy.headSet(new QueueEntryImpl(null, date));
    }

    @Override
    public Collection schedulerQueueContents(String[] tenantIDs, Date endDate) {
        return this.schedulerQueueContents(endDate);
    }

    @Override
    public void beginTransaction() throws SchedulerQueueException {
    }

    @Override
    public void endTransaction() throws SchedulerQueueException {
    }

    @Override
    public Long getPollInterval() {
        return null;
    }

    @Override
    public void setPollInterval(Long pollInterval) {
        throw new UnsupportedOperationException("The memory queue setPollInterval is not supported");
    }
}

