/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core.persistqueue;

import java.util.Date;
import noticecast.debug.Debug;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.IQueueFactory;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulerQueue;
import noticecast.scheduling.core.persistqueue.PersistableSchedulerQueue;
import noticecast.scheduling.core.persistqueue.PersistableSchedulerQueueEntry;
import noticecast.services.RepositoryServicesImpl;

public class PersistQueueFactory
implements IQueueFactory {
    private static final transient String LOAD_ON_START = "scheduler.queue.loadonstart";

    @Override
    public ISchedulerQueue createQueue() {
        return PersistableSchedulerQueue.instance();
    }

    @Override
    public IQueueEntry createQueueEntry(ISchedulable schedulable, Date date) {
        return new PersistableSchedulerQueueEntry(schedulable.getId(), date);
    }

    @Override
    public boolean initializeOnRestart() {
        boolean loadOnStart;
        block3: {
            loadOnStart = false;
            try {
                IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
                String load = pm.getProperty(LOAD_ON_START);
                if (load != null && load.equalsIgnoreCase("true") && pm.updateProperty(LOAD_ON_START, load, "false")) {
                    loadOnStart = true;
                }
            }
            catch (PersistManagerException ex) {
                if (!Debug.debug) break block3;
                ex.printStackTrace(System.err);
            }
        }
        return loadOnStart;
    }
}

